/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Constants;
import com.iscobol.gui.client.swing.GridCell;
import com.iscobol.gui.client.swing.GridConstant;
import com.iscobol.gui.client.swing.GridModel;
import com.iscobol.gui.client.swing.GridViewS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class GridModelSorter
extends AbstractTableModel
implements TableModelListener,
GridModel,
GridConstant,
Constants {
    protected GridModel tableModel;
    public static final int SORT_DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int SORT_ASCENDING = 1;
    private Row[] viewerToModel;
    private int[] modelToViewer;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private List sortingColumns = new ArrayList();
    private GridViewS parent;
    private String sortdata;
    private String internalsortdata;
    private boolean onlyrepaint = false;
    private int sendbegincolumnsorttypes = -1;
    public static final int SORT_ELEM_LEN_NUM_COL = 4;
    public static final int SORT_ELEM_DATA = 6;

    public GridModelSorter(GridViewS p, GridModel tm) {
        this.parent = p;
        this.mouseListener = new MouseHandler();
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this);
        }
        this.tableModel = tm;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    private synchronized void clearSortingState() {
        this.viewerToModel = null;
        this.modelToViewer = null;
    }

    public GridModel getTableModel() {
        return this.tableModel;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void removemouseListener() {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
        }
    }

    public void addmouseListener() {
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
        }
    }

    public void setTableHeader(JTableHeader tableHeader) {
        this.tableHeader = tableHeader;
    }

    private OrderingType getOrderingType(int column) {
        OrderingType Return2 = null;
        OrderingType ot = null;
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            ot = (OrderingType)this.sortingColumns.get(i);
            if (ot.column != column) continue;
            Return2 = ot;
        }
        return Return2;
    }

    public int getSortingStatus(int column) {
        int Return2 = 0;
        OrderingType ot = this.getOrderingType(column);
        if (ot != null) {
            Return2 = ot.mode;
        }
        return Return2;
    }

    public boolean sortingStatusChanged() {
        return this.sortingStatusChanged(false);
    }

    public boolean sortingStatusChanged(boolean force) {
        boolean Return2 = false;
        if (force || this.sortingColumns != null && this.sortingColumns.size() > 0) {
            Return2 = true;
            this.clearSortingState();
            this.fireTableDataChanged();
            if (this.tableHeader != null) {
                this.tableHeader.repaint();
            }
        }
        return Return2;
    }

    public void setSortingStatus(int column, int status) {
        OrderingType ot = this.getOrderingType(column);
        if (ot != null) {
            this.sortingColumns.remove(ot);
        }
        if (status != 0) {
            this.sortingColumns.add(new OrderingType(column, status));
        }
        this.sortingStatusChanged(true);
        if (this.sortingColumns != null && this.sortingColumns.size() == 0 && this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        OrderingType ot = this.getOrderingType(column);
        if (ot == null) {
            return null;
        }
        return new SortStateIcon(ot.mode == -1, size);
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    private Row[] getViewerToModel() {
        int tableModelRowCount = this.tableModel.getRowCount();
        if (this.viewerToModel == null || this.viewerToModel.length != tableModelRowCount) {
            this.viewerToModel = new Row[tableModelRowCount];
            for (int row = 0; row < tableModelRowCount; ++row) {
                this.viewerToModel[row] = new Row(this.tableModel.convertRowIndexToModel(row));
            }
            if (this.sortingColumns.size() > 0) {
                Arrays.sort(this.viewerToModel);
            }
        }
        return this.viewerToModel;
    }

    private synchronized int modelIndex(int viewerIndex) {
        Row rw;
        int Return2 = viewerIndex;
        Row[] vtom = this.getViewerToModel();
        if (vtom != null && vtom.length > viewerIndex && (rw = vtom[viewerIndex]) != null) {
            Return2 = rw.modelIndex;
        }
        return Return2;
    }

    private synchronized int[] getModelToViewer() {
        if (this.modelToViewer == null) {
            int n = this.getViewerToModel().length;
            this.modelToViewer = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToViewer[this.modelIndex((int)i)] = i;
            }
        }
        return this.modelToViewer;
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        int Return2 = this.tableModel == null ? 0 : this.tableModel.getColumnCount();
        return Return2;
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(row, column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.tableModel.getValueAt(row, column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.tableModel.setValueAt(aValue, row, column);
        this.sortingStatusChanged();
    }

    public Icon getColumnSortIcon(int col, int sz) {
        return this.getHeaderRendererIcon(col, sz);
    }

    public ImageIcon getColumnSortImage(int col) {
        OrderingType ot = this.getOrderingType(col);
        if (ot == null) {
            return this.parent.getSortNoneIcon();
        }
        if (ot.mode == -1) {
            return this.parent.getSortDownIcon();
        }
        if (ot.mode == 1) {
            return this.parent.getSortUpIcon();
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.sortingColumns.size() == 0) {
            if (!this.onlyrepaint) {
                this.clearSortingState();
            }
            this.fireTableChanged(e);
        } else if (e.getFirstRow() == -1) {
            if (!this.onlyrepaint) {
                this.cancelSorting();
            }
            this.fireTableChanged(e);
        } else if (e.getFirstRow() == e.getLastRow() && e.getColumn() != -1 && this.getSortingStatus(e.getColumn()) == 0 && this.modelToViewer != null) {
            this.fireTableChanged(new TableModelEvent(this, this.getModelToViewer()[e.getFirstRow()], this.getModelToViewer()[e.getFirstRow()], e.getColumn(), e.getType()));
        } else {
            if (!this.onlyrepaint) {
                this.clearSortingState();
            }
            this.fireTableChanged(e);
        }
    }

    public void sendBeginSort(int column, boolean iscontroldown, boolean isshiftdown) {
        this.sendBeginSort(column, iscontroldown, isshiftdown, null);
    }

    private void sendBeginSort(int column, boolean iscontroldown, boolean isshiftdown, GridViewS.DataType dt) {
        int status = this.getSortingStatus(column);
        if (dt != null && dt.isSortType() && dt.getStartOrdering() == -1) {
            status = status == 0 ? -1 : (status == -1 ? 1 : 0);
        } else {
            status += isshiftdown ? -1 : 1;
            status = (status + 4) % 3 - 1;
        }
        this.sendBeginSort(column, status, iscontroldown, dt);
    }

    public void sendBeginSort(int column, int status, boolean iscontroldown, GridViewS.DataType dt) {
        this.parent.getJTable().backupselection();
        if (!iscontroldown) {
            this.cancelSorting();
        }
        this.buildSortData(column, status);
        if (dt != null && dt.isSortType()) {
            this.sendbegincolumnsorttypes = column;
            this.parent.sendRet(16437, column, this.sendOrderMode(status), new Integer(column));
        } else {
            this.parent.sendRet(16437, 0, this.sendOrderMode(status), new Integer(column));
        }
    }

    @Override
    public void fireTableRowsInserted(int start, int end) {
        if (this.parent.prop_MASS_UPDATE == 0 && start >= 0 && end >= 0) {
            this.getTableModel().fireTableRowsInserted(start, end);
            if (!this.sortingStatusChanged()) {
                super.fireTableRowsInserted(start, end);
            }
        }
    }

    @Override
    public void fireTableRowsDeleted(int start, int end) {
        if (this.parent.prop_MASS_UPDATE == 0 && start >= 0 && end >= 0 && this.getRowCount() >= 0 && start <= this.getRowCount() && end <= this.getRowCount()) {
            super.fireTableRowsDeleted(start, end);
        }
    }

    @Override
    public void fireTableRowsUpdated(int start, int end, boolean clear) {
        boolean saveonly = this.onlyrepaint;
        if (!clear) {
            this.onlyrepaint = true;
        }
        if (this.parent.prop_MASS_UPDATE == 0 && start >= 0 && end >= 0) {
            this.tableModel.fireTableRowsUpdated(start, end);
        }
        if (clear) {
            this.sortingStatusChanged();
        }
        this.onlyrepaint = saveonly;
    }

    @Override
    public void fireTableRowsUpdated(int start, int end) {
        if (this.parent.prop_MASS_UPDATE == 0 && start >= 0 && end >= 0) {
            this.tableModel.fireTableRowsUpdated(start, end);
        }
        this.sortingStatusChanged();
    }

    @Override
    public void fireTableCellRepaint(int row, int col) {
        if (this.parent.prop_MASS_UPDATE == 0) {
            this.onlyrepaint = true;
            this.tableModel.fireTableCellUpdated(row, col);
            this.onlyrepaint = false;
        }
    }

    @Override
    public void fireTableCellUpdated(int row, int col) {
        if (this.parent.prop_MASS_UPDATE == 0) {
            this.tableModel.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public void fireTableStructureChanged() {
        if (this.parent.prop_MASS_UPDATE == 0) {
            this.parent.getDataModel().fireTableStructureChanged();
            if (this.parent.getDataModel() != this.tableModel && this.tableModel != null) {
                this.tableModel.fireTableStructureChanged();
            }
            if (this.parent.rowHeader != null) {
                ((GridModel)this.parent.rowHeader.getModel()).fireTableStructureChanged();
            }
        }
        this.sortingStatusChanged();
    }

    @Override
    public void fireTableDataChanged() {
        if (this.parent.prop_MASS_UPDATE == 0) {
            super.fireTableDataChanged();
            if (this.parent.rowHeader != null) {
                ((GridModel)this.parent.rowHeader.getModel()).fireTableDataChanged();
                this.parent.reloadRowHeight(this.parent.rowHeader);
                this.parent.rowHeader.repaint();
                Rectangle rect = this.parent.getJTable().getVisibleRect();
                this.parent.rowHeader.scrollRectToVisible(rect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int convertRowIndexToModel(int r) {
        int Return2 = r;
        if (!this.parent.useModelStandard()) {
            Vector vector = this.parent.gridarray;
            synchronized (vector) {
                if (this.sortingColumns.size() > 0 && this.tableModel.getRowCount() > 0) {
                    Return2 = this.modelIndex(r);
                } else if (this.sortingColumns.size() == 0) {
                    Return2 = this.tableModel.convertRowIndexToModel(Return2);
                }
            }
        }
        if (this.sendbegincolumnsorttypes >= 0) {
            this.parent.sendRet(17034, this.sendbegincolumnsorttypes, this.parent.getLastRow() - 1, new Integer(this.sendbegincolumnsorttypes));
        }
        this.sendbegincolumnsorttypes = -1;
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int convertRowIndexToView(int r) {
        if (this.parent.useModelStandard()) {
            return r;
        }
        int Return2 = r;
        Vector vector = this.parent.gridarray;
        synchronized (vector) {
            if (this.sortingColumns.size() == 0) {
                Return2 = this.tableModel.convertRowIndexToView(Return2);
            } else if (this.sortingColumns.size() > 0 && this.tableModel.getRowCount() > 0) {
                int i = 0;
                if (this.getViewerToModel() != null) {
                    int n = this.getViewerToModel().length;
                    for (i = 0; i < n && this.viewerToModel[i].modelIndex != Return2; ++i) {
                    }
                    if (i < n) {
                        Return2 = i;
                    }
                }
            }
        }
        return Return2;
    }

    @Override
    public int convertColumnIndexToModel(int r) {
        return this.tableModel.convertColumnIndexToModel(r);
    }

    @Override
    public int convertColumnIndexToView(int r) {
        return this.tableModel.convertColumnIndexToView(r);
    }

    @Override
    public boolean isColumnHide(int col) {
        boolean Return2 = this.tableModel.isColumnHide(col);
        return Return2;
    }

    @Override
    public boolean isRowHide(int row) {
        int r = this.convertRowIndexToModel(row);
        boolean Return2 = this.tableModel.isRowHide(r);
        return Return2;
    }

    private int sendOrderMode(int mode) {
        if (mode == -1) {
            return 2;
        }
        if (mode == 1) {
            return 1;
        }
        return 0;
    }

    private int receiveOrderMode(int mode) {
        if (mode == 2) {
            return -1;
        }
        if (mode == 1) {
            return 1;
        }
        return 0;
    }

    private char getOrderMode(int mode) {
        if (mode == -1) {
            return '2';
        }
        if (mode == 1) {
            return '1';
        }
        return '0';
    }

    private int getOrderMode(char mode) {
        if (mode == '2') {
            return -1;
        }
        if (mode == '1') {
            return 1;
        }
        return 0;
    }

    private char getDataType(int column) {
        return '1';
    }

    private void writeelemsd(char[] sortarray, int priority, int column, int status) {
        String strcolnum = new Integer(priority).toString();
        while (strcolnum.length() < 4) {
            strcolnum = "0".concat(strcolnum);
        }
        for (int idxelem = 0; idxelem < 4; ++idxelem) {
            sortarray[column * 6 + idxelem] = strcolnum.charAt(idxelem);
            sortarray[column * 6 + 4] = this.getOrderMode(status);
            sortarray[column * 6 + 4 + 1] = this.getDataType(column);
        }
    }

    private void buildSortData(int column, int status) {
        OrderingType ot2 = null;
        char[] sortarray = null;
        sortarray = this.initializeSortData(this.parent.getDataColumnSize());
        String tmp = "";
        boolean maxlencolnum = false;
        int priority = 1;
        boolean found = false;
        for (OrderingType ot2 : this.sortingColumns) {
            if (ot2.column != column) {
                this.writeelemsd(sortarray, priority++, ot2.column, ot2.mode);
                continue;
            }
            found = true;
            this.writeelemsd(sortarray, priority++, column, status);
        }
        if (!found) {
            this.writeelemsd(sortarray, priority, column, status);
        }
        this.internalsortdata = new String(sortarray);
    }

    public void setSortData(String sd) {
        Object ot = null;
        int idx = 0;
        int status = 0;
        int numcol = this.parent.getDataColumnSize();
        int idxelem = 0;
        String tmp = "";
        boolean error = false;
        int priority = -1;
        boolean i = false;
        OrderingType[] arrayord = new OrderingType[numcol];
        this.sortingColumns.clear();
        if (sd == null || sd.length() == 0) {
            this.sortdata = sd;
            return;
        }
        idxelem = sd.length() / 6;
        for (idx = 0; idx < numcol && idx < idxelem; ++idx) {
            tmp = sd.substring(idx * 6, idx * 6 + 4);
            priority = -1;
            error = false;
            try {
                if (tmp != null) {
                    priority = (int)Float.parseFloat(tmp);
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
            if (priority < 1 || priority > numcol || (status = this.getOrderMode(sd.charAt(idx * 6 + 4))) == 0) continue;
            arrayord[priority - 1] = new OrderingType(idx, status);
        }
        for (idx = 0; idx < numcol; ++idx) {
            if (arrayord[idx] != null) {
                this.sortingColumns.add(arrayord[idx]);
            }
            arrayord[idx] = null;
        }
        this.sortdata = sd;
    }

    private String verifyFill(String sd, int numcol) {
        if (sd != null) {
            while (sd.length() < numcol * 6) {
                sd = sd + "0";
            }
        }
        return sd;
    }

    private char[] initializeSortData(int numcol) {
        int idx = 0;
        int idxelem = 0;
        char[] sortarray = null;
        if (numcol > 0) {
            sortarray = new char[numcol * 6];
            for (idx = 0; idx < numcol; ++idx) {
                for (idxelem = idx * 6; idxelem < 6 * (idx + 1); ++idxelem) {
                    sortarray[idxelem++] = 48;
                }
            }
        }
        return sortarray;
    }

    public String getSortData() {
        if (this.internalsortdata == null) {
            this.internalsortdata = this.sortdata != null ? new String(this.sortdata) : new String(this.initializeSortData(this.parent.getDataColumnSize()));
        }
        this.internalsortdata = this.verifyFill(this.internalsortdata, this.parent.getDataColumnSize());
        return this.internalsortdata;
    }

    public void goSortData() {
        if (this.sortdata != null && this.sortdata.trim().length() > 0 && !this.sortdata.equals(this.internalsortdata)) {
            this.internalsortdata = new String(this.sortdata);
            this.sortingStatusChanged();
        }
    }

    public void goBeginSort(Integer isactionOrColumn, int status) {
        if (isactionOrColumn == null) {
            this.goSortData();
        } else {
            int column = isactionOrColumn;
            this.setSortingStatus(column, this.receiveOrderMode(status));
        }
    }

    private void debug(int status) {
        System.out.println(" status [" + status + "]");
        for (OrderingType ot : this.sortingColumns) {
            System.out.println(" col [" + ot.column + "] type [" + ot.mode + "]");
        }
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public boolean hasSortingColumns() {
        return this.sortingColumns.size() > 0;
    }

    private static class OrderingType {
        private int column;
        private int mode;

        public OrderingType(int column, int mode) {
            this.column = column;
            this.mode = mode;
        }
    }

    private static class SortStateIcon
    implements Icon {
        private boolean descending;
        private int size;

        public SortStateIcon(boolean desc, int sz) {
            this.descending = desc;
            this.size = sz;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = this.size / 2;
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2 || !((GridModelSorter)GridModelSorter.this).parent.finishentryok) {
                e.consume();
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 || !((GridModelSorter)GridModelSorter.this).parent.finishentryok) {
                e.consume();
                return;
            }
            if (SwingUtilities.isRightMouseButton(e) && GridModelSorter.this.parent.getHeadingMenuPopup() == 1) {
                return;
            }
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int viewerColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = GridModelSorter.this.convertColumnIndexToModel(viewerColumn);
            if (column != -1) {
                int numrow = GridModelSorter.this.parent.getNumRowFromPixel(e.getY(), true);
                if (numrow == GridModelSorter.this.parent.getNumColHeadings() && GridModelSorter.this.parent.getShowFilterType3() >= 0) {
                    return;
                }
                int whereclick = -1;
                whereclick = GridModelSorter.this.parent.mousePressedOverBitmapOrFilterIcon(e, numrow, column, GridModelSorter.this.parent.getJTable(), numrow, true);
                if (whereclick == 2) {
                    return;
                }
                GridViewS.DataType dt = GridModelSorter.this.parent.getSortType(column);
                if (!(dt == null || dt.isSortType() && dt.getTypeEditFieldValue() == 12)) {
                    if (dt != null && dt.isSortType()) {
                        GridModelSorter.this.sendBeginSort(column, e.isControlDown(), e.isShiftDown(), dt);
                    } else {
                        GridModelSorter.this.sendBeginSort(column, e.isControlDown(), e.isShiftDown());
                    }
                }
            }
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int getIndex() {
            return this.modelIndex;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o).modelIndex;
            int Return2 = 0;
            OrderingType ot2 = null;
            GridCell o1 = null;
            GridCell o2 = null;
            for (OrderingType ot2 : GridModelSorter.this.sortingColumns) {
                o1 = (GridCell)GridModelSorter.this.tableModel.getValueAt(row1, ot2.column);
                Return2 = o1.compare(o2 = (GridCell)GridModelSorter.this.tableModel.getValueAt(row2, ot2.column), ot2.column);
                if (Return2 == 0) continue;
                int n = Return2 = ot2.mode == -1 ? -Return2 : Return2;
                break;
            }
            if (o1 != null && (o1.getText() == null || o1.getText() != null && o1.getText().length() == 0) && GridModelSorter.this.parent.getNumRows() == -1 && row1 == GridModelSorter.this.parent.getLastRow() - GridModelSorter.this.parent.getNumColHeadings()) {
                Return2 = ot2.mode == 1 ? -Return2 : Return2;
            } else if (o2 != null && (o2.getText() == null || o2.getText() != null && o2.getText().length() == 0) && GridModelSorter.this.parent.getNumRows() == -1 && row2 == GridModelSorter.this.parent.getLastRow() - GridModelSorter.this.parent.getNumColHeadings()) {
                Return2 = ot2.mode == 1 ? -Return2 : Return2;
            }
            return Return2;
        }
    }
}

