/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.swing.GridCell;
import com.iscobol.gui.client.swing.GridConstant;
import com.iscobol.gui.client.swing.IsTextIcon;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

class GUIGridCell
extends JLabel
implements GridConstant {
    private int colWidth = -1;
    private int colDivWidth = -1;
    private int rowHeight = -1;
    private int rowDivHeight = -1;
    private float separation;
    private boolean textInHtml;
    private int extraMargin = 2;
    private int extraMarginLRtext = 2;
    private int extraMarginLRboth = 2;
    private int extraMarginTBboth = 2;
    private Insets skip;
    private boolean dotted;
    private boolean tiled;
    GridCell agc = null;
    private ImageIcon vertIcon = null;
    private int columnheadingslayout = 4;
    private int horTextPos = 2;
    private int vertTextPos = 3;
    private int horAlign = -1;
    private int vertAlign = -1;
    private int vertRotation = 2;
    private boolean vertical;
    private ImageIcon filterableIcon = null;
    private ImageIcon sortIcon;
    private Color defaultMatchingTextColorBackground;
    private Color matchingTextColorBackground = this.defaultMatchingTextColorBackground = new Color(255, 215, 50);
    private Color matchingTextColorForeground = null;
    private int matcherstart = -1;
    private int matcherend = -1;
    private String tmatcher;
    private Matcher matcher;

    public void setSkip(Insets skip, boolean dotted, boolean tiled) {
        this.skip = skip;
        this.dotted = dotted;
        this.tiled = tiled;
    }

    public void initialize() {
        this.horTextPos = 2;
        this.vertTextPos = 0;
        this.horAlign = -1;
        this.vertAlign = -1;
        this.colWidth = -1;
        this.colDivWidth = -1;
        this.rowHeight = -1;
        this.rowDivHeight = -1;
        this.agc = null;
        this.separation = 0.0f;
        this.textInHtml = false;
        this.skip = null;
        this.dotted = false;
        this.tiled = false;
        this.matcherstart = -1;
        this.matcherend = -1;
        this.tmatcher = "";
        this.matcher = null;
        this.filterableIcon = null;
    }

    public void setRowDim(int rh, int rhd) {
        this.rowHeight = rh;
        this.rowDivHeight = rhd;
    }

    public void setCell(GridCell val) {
        this.agc = val;
    }

    public void setCol(int cw, int cw1) {
        this.colWidth = cw;
        this.colDivWidth = cw1;
    }

    public void setColumnHeadingsLayout(int chl, String align, int bt, boolean centeredheadings) {
        this.columnheadingslayout = chl;
        this.setHorizontalTextPosition(bt);
        this.horAlign = 10;
        this.setVerticalTextPosition(bt);
        this.setVerticalAlignment(0);
        if (this.columnheadingslayout > 0) {
            if ((this.columnheadingslayout & 8) == 8) {
                this.horAlign = 2;
            } else if ((this.columnheadingslayout & 0x10) == 16) {
                this.horAlign = 4;
            } else {
                this.setHorizontalAlignment(this.horAlign);
            }
            this.setVerticalAttribute();
        } else {
            if (centeredheadings) {
                this.setHorizontalAlignment(0);
            }
            if (align != null) {
                if (!centeredheadings) {
                    if (align.startsWith("R") || align.startsWith("r")) {
                        this.setHorizontalAlignment(4);
                    } else if (align.startsWith("L") || align.startsWith("l")) {
                        this.setHorizontalAlignment(2);
                    } else if (align.startsWith("C") || align.startsWith("c")) {
                        this.setHorizontalAlignment(0);
                    }
                }
                if (align.startsWith("H") || align.startsWith("h")) {
                    if (centeredheadings) {
                        this.setHorizontalAlignment(0);
                    }
                    this.setTextInHtml(true);
                }
            }
        }
    }

    @Override
    public void setHorizontalTextPosition(int htp) {
        if ((this.columnheadingslayout & 0) == 0) {
            if (htp == 0) {
                htp = 4;
            } else if (htp == 1) {
                htp = 2;
            }
            super.setHorizontalTextPosition(htp);
            if (htp == 2 || htp == 4) {
                this.horTextPos = htp;
            }
        }
    }

    @Override
    public void setVerticalTextPosition(int vtp) {
        if ((this.columnheadingslayout & 3) > 0) {
            if (vtp == 0) {
                vtp = 3;
            } else if (vtp == 1) {
                vtp = 1;
            }
            super.setVerticalTextPosition(vtp);
            if (vtp == 1 || vtp == 3) {
                this.vertTextPos = vtp;
            }
        }
    }

    public void setVerticalAttribute() {
        if ((this.columnheadingslayout & 3) > 0) {
            this.horTextPos = 0;
            this.vertical = true;
            if ((this.columnheadingslayout & 2) == 2) {
                this.vertRotation = 4;
            }
        }
        if ((this.columnheadingslayout & 0x40) == 64) {
            this.setVerticalAlignment(3);
        }
        if ((this.columnheadingslayout & 0x20) == 32) {
            this.setVerticalAlignment(1);
        }
    }

    @Override
    public void setHorizontalAlignment(int ha) {
        super.setHorizontalAlignment(ha);
        if (ha == 2 || ha == 4 || ha == 0) {
            this.horAlign = ha;
        }
    }

    @Override
    public void setVerticalAlignment(int va) {
        super.setVerticalAlignment(va);
        if (va == 1 || va == 3 || va == 0) {
            this.vertAlign = va;
        }
    }

    public void setSeparation(float s) {
        this.separation = s;
    }

    @Override
    public void paintComponent(Graphics g) {
        Toolkit tk;
        Map map;
        int textWidth = 0;
        int textHeight = 0;
        int colHeight = 0;
        int spH = 0;
        int spW = 0;
        int textX = 0;
        int textY = 0;
        int imageWidth = 0;
        int imageHeight = 0;
        int imageY = 0;
        int imageX = 0;
        int fillrect = -1;
        IsTextIcon ti = null;
        int spaceFix = 5;
        int imageWidthfilter = 0;
        int imageHeightfilter = 0;
        int imageYfilter = 0;
        if (this.textInHtml) {
            Graphics g1 = g;
            Rectangle bb = this.getBounds();
            this.colWidth = (int)bb.getWidth();
            colHeight = (int)bb.getHeight();
            int offsetX = 0;
            int htmlwidth = 0;
            if (this.sortIcon != null) {
                g.drawImage(this.sortIcon.getImage(), this.colWidth - this.sortIcon.getIconWidth() - 4, colHeight / 2 - this.sortIcon.getIconHeight() / 2, this);
                htmlwidth = this.sortIcon.getIconWidth() + 4;
            }
            if (this.filterableIcon != null) {
                imageWidthfilter = this.filterableIcon.getIconWidth();
                imageHeightfilter = this.filterableIcon.getIconHeight();
                imageYfilter = colHeight / 2;
                g.drawImage(this.filterableIcon.getImage(), 2, imageYfilter -= imageHeightfilter / 2, this);
                if (this.agc != null) {
                    this.agc.setFilterableImageCoord(0, 0, imageWidthfilter * 2, colHeight);
                }
                imageX += imageWidthfilter;
                offsetX += imageWidthfilter + 2;
                htmlwidth += imageWidthfilter + 2;
            }
            if (offsetX > 0 || htmlwidth > 0) {
                Rectangle cbr = g.getClipBounds();
                g1 = g.create(cbr.x + offsetX, cbr.y, cbr.width - htmlwidth, cbr.height);
            }
            super.paintComponent(g1);
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (AbstractGuiFactoryImpl.getFontHandlingProp() != 3 && (map = (Map)(tk = Toolkit.getDefaultToolkit()).getDesktopProperty("awt.font.desktophints")) != null) {
            g2.addRenderingHints(map);
        }
        Rectangle bb = this.getBounds();
        this.colWidth = (int)bb.getWidth();
        colHeight = (int)bb.getHeight();
        if (this.agc != null && this.agc.getFont() != null) {
            textHeight = this.agc.getFont().getHeight();
            if (this.getText() != null) {
                textWidth = this.agc.getFont().computeScreenWidth(this.getText());
            }
        } else if (this.getText() != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            textHeight = fm.getAscent() + fm.getDescent();
            textWidth = SwingUtilities.computeStringWidth(fm, this.getText());
        }
        if (this.vertical && this.getText() != null) {
            ti = new IsTextIcon(this, this.getText(), this.vertRotation);
            textWidth = ti.getIconWidth();
            textHeight = ti.getIconHeight();
        }
        if (this.getIcon() != null) {
            imageWidth = this.getIcon().getIconWidth();
            imageHeight = this.getIcon().getIconHeight();
            imageY = (this.rowHeight - imageHeight) / 2;
            if (imageY < 0) {
                imageY = 0;
            }
            if ((imageX = (this.colWidth - imageWidth) / 2) < 0) {
                imageX = 0;
            }
            if (this.vertical) {
                switch (this.horAlign) {
                    case 2: {
                        if (this.getText() != null && textWidth > imageWidth) {
                            imageX = (textWidth - imageWidth) / 2;
                            imageX += this.extraMargin;
                            break;
                        }
                        imageX = this.extraMargin;
                        break;
                    }
                    case 4: {
                        imageX = this.colWidth - imageWidth;
                        if (this.getText() != null && textWidth > imageWidth) {
                            imageX -= (textWidth - imageWidth) / 2;
                        }
                        imageX -= this.extraMargin;
                        break;
                    }
                    default: {
                        imageX = this.colWidth / 2;
                        imageX -= imageWidth / 2;
                        break;
                    }
                }
            } else {
                switch (this.vertAlign) {
                    case 1: {
                        if (this.getText() != null && textHeight > imageHeight) {
                            imageY = (textHeight - imageHeight) / 2;
                            break;
                        }
                        imageY = this.extraMargin;
                        break;
                    }
                    case 3: {
                        imageY = colHeight - imageHeight;
                        if (this.getText() != null && textHeight > imageHeight) {
                            imageY -= (textHeight - imageHeight) / 2;
                            imageY += this.extraMargin;
                            break;
                        }
                        imageY -= this.extraMargin;
                        break;
                    }
                    default: {
                        imageY = colHeight / 2;
                        imageY -= imageHeight / 2;
                    }
                }
            }
        }
        if (this.sortIcon != null) {
            g.drawImage(this.sortIcon.getImage(), this.colWidth - this.sortIcon.getIconWidth() - 2, colHeight / 2 - this.sortIcon.getIconHeight() / 2, this);
        }
        if (this.filterableIcon != null) {
            imageWidthfilter = this.filterableIcon.getIconWidth();
            imageHeightfilter = this.filterableIcon.getIconHeight();
            imageYfilter = colHeight / 2;
            g.drawImage(this.filterableIcon.getImage(), 2, imageYfilter -= imageHeightfilter / 2, this);
            if (this.agc != null) {
                this.agc.setFilterableImageCoord(0, 0, imageWidthfilter * 2, colHeight);
            }
            imageX += imageWidthfilter;
        }
        if (this.getText() != null) {
            int h = 0;
            boolean w = false;
            if (this.vertical) {
                switch (this.horAlign) {
                    case 2: {
                        textX = this.getIcon() != null && imageWidth > textWidth ? (textX += (imageWidth - textWidth) / 2) : (textX += -this.extraMargin);
                        textX += this.extraMarginLRboth;
                        break;
                    }
                    case 4: {
                        textX = this.getIcon() != null && imageWidth > textWidth ? this.colWidth - textWidth - (imageWidth - textWidth) / 2 : this.colWidth - textWidth + this.extraMargin;
                        textX -= this.extraMarginLRboth;
                        break;
                    }
                    default: {
                        textX = this.colWidth / 2;
                        textX -= textWidth / 2;
                        break;
                    }
                }
            } else {
                if (this.agc != null && this.agc.getFont() != null) {
                    textWidth = this.agc.getFont().computeScreenWidth(this.getText());
                    h = this.agc.getFont().getDescent() - this.agc.getFont().getAscent();
                } else {
                    textWidth = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.getText());
                    h = this.getFontMetrics(this.getFont()).getDescent() - this.getFontMetrics(this.getFont()).getAscent();
                }
                if (h < 0) {
                    h *= -1;
                }
                switch (this.vertAlign) {
                    case 1: {
                        if (this.getIcon() != null && imageHeight > textHeight) {
                            textY = imageHeight / 2 + h / 2;
                            break;
                        }
                        textY = this.extraMargin + h;
                        break;
                    }
                    case 3: {
                        if (this.getIcon() != null && imageHeight > textHeight) {
                            textY = this.rowHeight - imageHeight / 2 + h / 2 - this.extraMargin;
                            break;
                        }
                        textY = this.rowHeight - h / 2 + 2 * this.extraMargin;
                        break;
                    }
                    default: {
                        textY = this.rowHeight / 2;
                        textY += h / 2;
                    }
                }
            }
        }
        if (this.getText() != null && this.getText().length() > 0 && this.getIcon() != null) {
            if (this.vertical) {
                spaceFix = 0;
                spW = (colHeight - imageHeight - textHeight - spaceFix) / 2;
                if (this.vertTextPos == 3) {
                    if (this.vertAlign == 1) {
                        textY = this.extraMargin;
                        imageY = 2 * spaceFix + textHeight;
                    } else if (this.vertAlign == 3) {
                        textY = colHeight - imageHeight - textHeight - 2 * spaceFix;
                        imageY = colHeight - imageHeight;
                    } else if (this.vertAlign == 0) {
                        textY = spW;
                        imageY = spW + spaceFix + textHeight;
                    } else {
                        textY = this.extraMargin;
                        imageY = this.extraMargin + spaceFix + textHeight;
                    }
                    textY -= this.extraMarginTBboth;
                } else if (this.vertTextPos == 1) {
                    if (this.vertAlign == 1) {
                        imageY = this.extraMargin;
                        textY = spaceFix + imageHeight;
                    } else if (this.vertAlign == 3) {
                        imageY = colHeight - imageHeight - textHeight - spaceFix - this.extraMargin;
                        textY = colHeight - textHeight - spaceFix;
                    } else if (this.vertAlign == 0) {
                        imageY = spW;
                        textY = spW + this.extraMargin + imageHeight;
                    } else {
                        imageY = this.extraMargin;
                        textY = this.extraMargin + spaceFix + imageHeight;
                    }
                    textY += this.extraMarginTBboth;
                    imageY += this.extraMarginTBboth;
                } else if (this.vertTextPos == 0) {
                    // empty if block
                }
            } else {
                spH = (this.colWidth - imageWidth - textWidth - spaceFix) / 2;
                if (this.horTextPos == 2) {
                    if (this.horAlign == 2) {
                        textX = this.extraMargin;
                        imageX = this.extraMargin + spaceFix + textWidth;
                    } else if (this.horAlign == 4) {
                        textX = this.colWidth - spaceFix - textWidth - imageWidth - this.extraMargin;
                        imageX = this.colWidth - imageWidth - this.extraMargin;
                    } else if (this.horAlign == 0) {
                        textX = spH;
                        imageX = spH + spaceFix + textWidth;
                    } else {
                        textX = this.extraMargin;
                        imageX = this.extraMargin + spaceFix + textWidth;
                    }
                    if (this.filterableIcon != null) {
                        textX += imageWidthfilter;
                    }
                } else if (this.horTextPos == 4) {
                    if (this.horAlign == 2) {
                        imageX = this.extraMargin;
                        textX = this.extraMargin + imageWidth + spaceFix;
                    } else if (this.horAlign == 4) {
                        imageX = this.colWidth - spaceFix - imageWidth - (textWidth -= this.colDivWidth) - this.extraMargin;
                        textX = this.colWidth - textWidth - this.extraMargin;
                    } else if (this.horAlign == 0) {
                        imageX = spH;
                        textX = spH + spaceFix + imageWidth;
                        if (this.separation > 0.0f) {
                            imageX = (int)((float)imageX - this.separation);
                        }
                    } else {
                        imageX = this.extraMargin;
                        textX = this.extraMargin + imageWidth + spaceFix;
                    }
                }
            }
            if (this.agc != null) {
                this.agc.setImageCoord(imageX, imageY, imageWidth, imageHeight);
            }
            g.drawImage(((ImageIcon)this.getIcon()).getImage(), imageX, imageY, this);
            if (this.vertical) {
                ti.paintIcon(this, g, textX, textY);
            } else {
                String t = this.getText();
                if (this.horAlign == 0 && t != null && this.separation > 0.0f) {
                    textX = (int)((float)textX - this.separation);
                }
                if (textX <= 0) {
                    textX = 2;
                }
                this.printMatcher(g, t, textX, textY, bb);
            }
        } else if (this.getIcon() != null) {
            if (this.vertical) {
                if (this.vertAlign == 1) {
                    imageY = this.extraMargin;
                } else if (this.vertAlign == 3) {
                    imageY = colHeight - imageHeight;
                    imageY -= this.extraMargin;
                } else if (this.vertAlign == 0) {
                    imageY = (colHeight - imageHeight) / 2;
                }
            } else if (this.horAlign == 2 || this.horAlign == -1) {
                imageX = this.extraMargin;
            } else if (this.horAlign == 4) {
                imageX = this.colWidth - imageWidth - this.extraMargin;
            } else if (this.horAlign == 0) {
                imageX = (this.colWidth - imageWidth) / 2;
            }
            g.drawImage(((ImageIcon)this.getIcon()).getImage(), imageX, imageY, this);
            if (this.agc != null) {
                this.agc.setImageCoord(imageX, imageY, imageWidth, imageHeight);
            }
        } else if (this.getText() != null) {
            if (this.vertical) {
                if (this.vertAlign == 1) {
                    textY = 0;
                } else if (this.vertAlign == 3) {
                    textY = colHeight - textHeight;
                } else if (this.vertAlign == 0) {
                    textY = (colHeight - textHeight) / 2;
                }
                ti.paintIcon(this, g, textX, textY);
            } else {
                if (this.separation > 0.0f) {
                    this.colWidth = (int)((float)this.colWidth - this.separation);
                }
                if (this.horAlign == 2) {
                    textX = this.extraMargin;
                    if (this.filterableIcon != null) {
                        textX += imageWidthfilter;
                    }
                } else if (this.horAlign == 4) {
                    textX = this.colWidth - (textWidth -= this.colDivWidth) - this.extraMargin;
                } else if (this.horAlign == 0) {
                    textX = (this.colWidth - textWidth) / 2;
                }
                String t = this.getText();
                if (textX <= 0) {
                    textX = 2;
                    if (this.filterableIcon != null) {
                        textX += imageWidthfilter;
                    }
                }
                this.printMatcher(g, t, textX, textY, bb);
                if (this.agc != null) {
                    this.agc.setImageCoord(0, 0, 0, 0);
                }
                if (t != null && t.length() > 0 && this.separation > 0.0f && (this.horAlign == -1 || this.horAlign == 2)) {
                    fillrect = (int)(bb.getWidth() - (double)this.separation + (double)textX);
                    int starty = 0;
                    int length = (int)this.separation;
                    if (this.skip != null) {
                        if (this.dotted) {
                            length -= this.skip.left + this.skip.right + 2;
                            bb.height -= this.skip.top + this.skip.bottom + 2;
                            starty = this.skip.top + 1;
                        } else if (this.tiled) {
                            fillrect -= this.skip.right - 1;
                            length -= this.skip.right - 1;
                            bb.height -= this.skip.top - 1 + this.skip.bottom - 2;
                            starty = this.skip.top - 1;
                        } else {
                            length -= this.skip.right + textX;
                            bb.height -= this.skip.top + this.skip.bottom;
                            starty = this.skip.top;
                        }
                    }
                    g.setColor(this.getParent().getBackground());
                    g.fillRect(fillrect, starty, length, bb.height);
                }
            }
        }
    }

    public void oosetText(String t) {
        this.setTextGUI(t);
    }

    public String setTextGUI(String t) {
        String ok = t;
        if (t != null) {
            if (this.horAlign == 2) {
                ok = t.trim();
            } else if (this.horAlign == 4) {
                ok = ScreenUtility.rightTrim(t);
                ok = ok.trim();
            } else if (this.horAlign == 0) {
                ok = ScreenUtility.rightTrim(t);
                ok = ok.trim();
            }
        }
        super.setText(ok);
        return ok;
    }

    public static String getTextGUI(String t, int horAlign) {
        String ok = t;
        if (t != null) {
            if (horAlign == 2) {
                ok = t.trim();
            } else if (horAlign == 4) {
                ok = ScreenUtility.rightTrim(t);
                ok = ok.trim();
            } else if (horAlign == 0) {
                ok = ScreenUtility.rightTrim(t);
                ok = ok.trim();
            }
        }
        return ok;
    }

    public void setTextInHtml(boolean b) {
        this.textInHtml = b;
    }

    public boolean getTextInHtml() {
        return this.textInHtml;
    }

    public boolean isMultiLine(String tmp, LocalFontCmp f) {
        Object lfc = null;
        boolean Return2 = false;
        if (tmp.indexOf(10) > -1) {
            Return2 = true;
        } else if (f != null) {
            Return2 = f.computeScreenWidth(tmp) > this.colWidth && tmp.indexOf(32) > -1;
        }
        return Return2;
    }

    public void setExtraMargin(boolean b) {
        if (b) {
            this.extraMargin = 2;
        }
    }

    public void setFilterableIcon(ImageIcon fi) {
        this.filterableIcon = fi;
    }

    @Override
    public void setIcon(Icon i) {
        super.setIcon(i);
    }

    public void setmatcheridx(Matcher matcher, int matcherstart, int matcherend, String tmatcher) {
        this.matcher = matcher;
        if (matcher == null) {
            this.matcherstart = matcherstart;
            this.matcherend = matcherend;
            this.tmatcher = tmatcher;
        }
    }

    public int getmatcherstart() {
        return this.matcherstart;
    }

    public int getmatcherend() {
        return this.matcherend;
    }

    public String getmatchert() {
        return this.tmatcher;
    }

    private void printMatcher(Graphics g, String t, int textX, int textY, Rectangle bb) {
        int ofsmatchstart = -1;
        int ofsmatchend = -1;
        if (t != null && t.length() > 0) {
            if (this.matcher != null) {
                this.matcher.reset(t);
                if (this.matcher.find()) {
                    this.matcherstart = this.matcher.start();
                    this.matcherend = this.matcher.end();
                    this.tmatcher = this.matcher.group();
                }
            }
            if (this.matcherstart >= 0 && this.matcherend > 0 && this.matcherend > this.matcherstart && this.matcherend <= t.length() && this.matcherend - this.matcherstart > 0) {
                Color savec = g.getColor();
                String t0 = "";
                String t1 = "";
                String t2 = "";
                try {
                    t0 = t.substring(0, this.matcherstart);
                    t1 = t.substring(this.matcherstart, this.matcherend);
                    t2 = t.substring(this.matcherend, t.length());
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                FontMetrics fm = this.getFontMetrics(this.getFont());
                ofsmatchstart = SwingUtilities.computeStringWidth(fm, t0);
                ofsmatchend = SwingUtilities.computeStringWidth(fm, this.tmatcher);
                g.drawString(t0, textX, textY);
                g.setColor(this.matchingTextColorBackground);
                g.fillRect(textX + ofsmatchstart, 0, ofsmatchend, bb.height);
                if (this.matchingTextColorForeground != null) {
                    g.setColor(this.matchingTextColorForeground);
                } else {
                    g.setColor(savec);
                }
                g.drawString(t1, textX + ofsmatchstart, textY);
                g.setColor(savec);
                g.drawString(t2, textX + ofsmatchstart + ofsmatchend, textY);
            } else {
                g.drawString(t, textX, textY);
            }
        } else {
            g.drawString(t, textX, textY);
        }
    }

    public void setSortIcon(ImageIcon sortIcon) {
        this.sortIcon = sortIcon;
    }

    public void setMatchingTextColorBackground(Color matchingTextColorBackground) {
        this.matchingTextColorBackground = matchingTextColorBackground;
        if (matchingTextColorBackground == null) {
            matchingTextColorBackground = this.defaultMatchingTextColorBackground;
        }
    }

    public void setMatchingTextColorForeground(Color matchingTextColorForeground) {
        this.matchingTextColorForeground = matchingTextColorForeground;
    }
}

