/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.PicobolTextEvent;
import com.iscobol.gui.PicobolTextListener;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.spellchecker.Span;
import com.iscobol.gui.client.spellchecker.SpellChecker;
import com.iscobol.gui.client.swing.EditableTextField;
import com.iscobol.gui.client.swing.FromToTransferHandler;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.MsgBoxEvent;
import com.iscobol.gui.client.swing.MsgBoxListener;
import com.iscobol.gui.client.swing.OutDragListener;
import com.iscobol.gui.client.swing.PicobolMenuElement;
import com.iscobol.gui.client.swing.PicobolPopupMenu;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.rts.Factory;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.im.InputMethodRequests;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class EntryField
extends JComponent
implements EditableTextField {
    private static final long serialVersionUID = 1L;
    public static final int MASK_FORMAT_TYPE = 0;
    public static final int NUMBER_FORMAT_TYPE = 1;
    public static final int DATE_FORMAT_TYPE = 2;
    private static final int ICON_GAP = 1;
    private static final int ICON_TEXT_GAP = 1;
    private final UndoManager undoManager = new UndoManager();
    private static String eol = System.getProperty("line.separator", "\n");
    private final UndoableEditListener undoEditListener = e -> this.undoManager.addEdit(e.getEdit());
    private final KeyListener undoKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 90 && ke.isControlDown()) {
                EntryField.this.undo();
            }
            if (ke.getKeyCode() == 89 && ke.isControlDown()) {
                EntryField.this.redo();
            }
        }
    };
    private int upperLowerMethod;
    private int formatType = 0;
    private boolean fireEvents = true;
    private boolean upper;
    private boolean lower;
    private boolean numeric;
    private boolean msgBoxOnError;
    private boolean useTab;
    private boolean useReturn;
    private boolean auto;
    private boolean autoSpin;
    private boolean noWrap;
    private int maxText;
    private String encoding;
    private int maxLines;
    private Color background;
    protected JTextComponent textComponent;
    private JScrollPane textScrollPane;
    private JSpinner spinner;
    private int lastKeyCode;
    private final boolean multiline;
    private boolean secure;
    private final Border defaultBorder;
    private double value;
    private double minVal;
    private double maxVal;
    private boolean increment;
    private SpinnerNumberModel spinnerModel;
    private int[][] lineOffsets;
    private boolean undoListenerInstalled;
    private MyDocument textDocument;
    private DefaultFormatter formatter;
    private GuiFactoryImpl gf;
    private Color readOnlyBackground;
    private Color readOnlyForeground;
    private Color disabledBackground;
    private Color disabledForeground;
    private Vector<PicobolTextListener> textListeners = new Vector();
    private Vector<FocusListener> focusListeners = new Vector();
    private Vector<MouseListener> mouseListeners = new Vector();
    private Vector<KeyListener> keyListeners = new Vector();
    private Icon icon;
    private Icon iconDisabled;
    private Icon iconTrailing;
    private Icon iconTrailingDisabled;
    private Icon iconRollover;
    private Icon iconTrailingRollover;
    private MouseAdapter iconMouseListener;
    private String[] iconHint = new String[2];
    private boolean[] iconMouseOver = new boolean[2];
    private Border[] border;
    private Insets borderInsets;
    private Insets margins = new Insets(0, 1, 0, 0);
    private Rectangle[] iconBounds = new Rectangle[2];
    private String placeholder;
    private Color placeholderColor;
    private String spellChecking;
    private Span[] spellCheckingSpans;
    private MyTimer spellCheckingTimer = new MyTimer(500);
    private String toolTipText;
    private Cursor textCmpCursor;
    private Cursor defCursor = Cursor.getDefaultCursor();
    private boolean defaultShortcutsEnabled = true;
    private char[] acceptedControlChars;
    private boolean maxTextBytes = true;
    private FromToTransferHandler ftth = null;
    private String inputFilter;
    private MsgBoxListener msgboxlistener = null;

    private static boolean isDigit(char c) {
        return Character.isDigit(c) || c == '-' || c == '+' || c == '.' || c == ',' || c == ' ' || c == '/';
    }

    public EntryField(GuiFactoryImpl gf, String text, int rows, int cols) {
        this(gf, true, false, false, text, rows, cols, 0, null, '\u0000', '\u0000');
    }

    public EntryField(GuiFactoryImpl gf, boolean autoSpin) {
        this(gf, false, true, autoSpin, null, 0, 0, 0, null, '\u0000', '\u0000');
    }

    public EntryField(GuiFactoryImpl gf) {
        this(gf, false, false, false, null, 0, 0, 0, null, '\u0000', '\u0000');
    }

    public EntryField(GuiFactoryImpl gf, int formatType, String formatString, char fillChar) {
        this(gf, false, false, false, null, 0, 0, formatType, formatString, fillChar, '\u0000');
    }

    public EntryField(GuiFactoryImpl gf, char echoChar) {
        this(gf, false, false, false, null, 0, 0, 0, null, '\u0000', echoChar);
    }

    private EntryField(GuiFactoryImpl gf, boolean isMultiline, boolean isSpinner, final boolean autoSpin, String text, int rows, int cols, int formatType, String formatString, char fillChar, char echoChar) {
        this.gf = gf;
        this.multiline = isMultiline;
        this.setLayout(new GridLayout(0, 1));
        if (this.multiline) {
            this.textComponent = new MultiLineEntryFieldComponent(this, text, rows, cols);
            this.textScrollPane = new JScrollPane(this.textComponent, 21, 31);
            this.textScrollPane.setFocusable(false);
            this.textScrollPane.getVerticalScrollBar().setFocusable(false);
            this.textScrollPane.getHorizontalScrollBar().setFocusable(false);
            this.add(this.textScrollPane);
        } else if (formatString != null) {
            this.textComponent = new FormattedEntryFieldComponent(this);
            ((FormattedEntryFieldComponent)this.textComponent).setFocusLostBehavior(0);
            this.add(this.textComponent);
            this.setFormatType(formatType);
            this.setFormatString(formatString);
            this.setFillChar(fillChar);
        } else if (echoChar > '\u0000') {
            this.textComponent = new PasswordFieldComponent(this, cols);
            ((PasswordFieldComponent)this.textComponent).setEchoChar(echoChar);
            this.add(this.textComponent);
            this.secure = true;
        } else {
            this.textComponent = new SingleLineEntryFieldComponent(this, cols);
            if (isSpinner) {
                this.createSpinner();
                this.add(this.spinner);
                this.setAutoSpin(autoSpin);
            } else {
                this.add(this.textComponent);
            }
        }
        this.textComponent.setToolTipText("");
        this.msgBoxOnError = this.gf.getCsProperty().get("iscobol.gui.ef.ext_message", false);
        this.textDocument = new MyDocument(this);
        this.textComponent.setDocument(this.textDocument);
        this.textDocument.addDocumentListener(new DocumentListener(){

            private void handleEvent(DocumentEvent e, int cp, boolean isinsert) {
                String txt = EntryField.this.getText();
                if (EntryField.this.fireEvents && ((PicobolWidget)((Object)EntryField.this.textComponent)).getActiveAccept() && !EntryField.this.textListeners.isEmpty()) {
                    PicobolTextEvent event;
                    if (EntryField.this.formatter == null || !(EntryField.this.formatter instanceof MaskFormatter) || isinsert) {
                        event = new PicobolTextEvent(EntryField.this.textComponent, 2199, cp);
                        for (PicobolTextListener l : EntryField.this.textListeners) {
                            l.textChanged(event);
                        }
                    }
                    if ((EntryField.this.formatter == null || EntryField.this.formatter instanceof NumberFormatter) && EntryField.this.maxText > 0 && EntryField.this.textDocument.length(txt) >= EntryField.this.maxText && EntryField.this.auto) {
                        event = new PicobolTextEvent(EntryField.this.textComponent, 2202);
                        for (PicobolTextListener l : EntryField.this.textListeners) {
                            l.inputTerminated(event);
                        }
                    }
                }
                if (EntryField.this.spinner != null) {
                    try {
                        Double i = new Double(txt.replace(',', '.'));
                        if (autoSpin) {
                            i = new Double(Math.round(i));
                        }
                        EntryField.this.value = i;
                        EntryField.this.spinner.setValue(i);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (EntryField.this.spellChecking != null && EntryField.this.spellChecking.length() > 0 && SpellChecker.isSupported() && (EntryField.this.textComponent instanceof SingleLineEntryFieldComponent || EntryField.this.textComponent instanceof MultiLineEntryFieldComponent)) {
                    EntryField.this.spellCheckingTimer.restart(new Runnable(){

                        @Override
                        public void run() {
                            EntryField.this.spellCheck();
                        }
                    });
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleEvent(e, e.getOffset() + e.getLength(), true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (EntryField.this.lastKeyCode == 8 || EntryField.this.lastKeyCode == 127 || !EntryField.this.hasSelection()) {
                    this.handleEvent(e, Math.max(0, e.getOffset() - e.getLength() + 1), false);
                }
            }
        });
        this.textCmpCursor = this.textComponent.getCursor();
        super.setBorder(null);
        this.defaultBorder = this.spinner != null ? this.spinner.getBorder() : (this.textScrollPane != null ? this.textScrollPane.getBorder() : this.textComponent.getBorder());
        this.iconMouseListener = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!EntryField.this.iconsAllowed()) {
                    return;
                }
                boolean repaint = EntryField.this.iconMouseOver[0] || EntryField.this.iconMouseOver[1];
                ((EntryField)EntryField.this).iconMouseOver[0] = false;
                ((EntryField)EntryField.this).iconMouseOver[1] = false;
                EntryField.this.textComponent.setCursor(EntryField.this.textCmpCursor);
                if (repaint) {
                    EntryField.this.textComponent.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!EntryField.this.iconsAllowed()) {
                    return;
                }
                boolean repaint = false;
                if (EntryField.this.textComponent.isEnabled()) {
                    for (int i = 0; i < EntryField.this.iconBounds.length; ++i) {
                        boolean tmp = EntryField.this.iconMouseOver[i];
                        ((EntryField)EntryField.this).iconMouseOver[i] = EntryField.this.iconBounds[i] != null && EntryField.this.iconBounds[i].contains(e.getPoint());
                        repaint |= tmp != EntryField.this.iconMouseOver[i];
                    }
                }
                if (EntryField.this.iconMouseOver[0] || EntryField.this.iconMouseOver[1]) {
                    EntryField.this.textComponent.setCursor(EntryField.this.defCursor);
                } else {
                    EntryField.this.textComponent.setCursor(EntryField.this.textCmpCursor);
                }
                if (repaint) {
                    EntryField.this.textComponent.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!EntryField.this.iconsAllowed()) {
                    return;
                }
                if (EntryField.this.textComponent.isEnabled()) {
                    for (int i = 0; i < EntryField.this.iconBounds.length; ++i) {
                        PicobolTextEvent event;
                        if (EntryField.this.iconBounds[i] == null || !EntryField.this.iconBounds[i].contains(e.getPoint())) continue;
                        if (e.getClickCount() <= 1) {
                            event = new PicobolTextEvent(EntryField.this.textComponent, 2203, i);
                            for (PicobolTextListener l : EntryField.this.textListeners) {
                                l.iconClicked(event);
                            }
                            continue;
                        }
                        event = new PicobolTextEvent(EntryField.this.textComponent, 2204, i);
                        for (PicobolTextListener l : EntryField.this.textListeners) {
                            l.iconDoubleClicked(event);
                        }
                    }
                }
            }
        };
        this.textComponent.addMouseListener(this.iconMouseListener);
        this.textComponent.addMouseMotionListener(this.iconMouseListener);
    }

    private void createSpinner() {
        this.spinnerModel = new SpinnerNumberModel(new Double("0"), null, null, new Double("1"));
        this.spinner = new JSpinner(this.spinnerModel){
            private static final long serialVersionUID = 1L;
            private Double lastVal;
            {
                this.lastVal = new Double("0");
            }

            @Override
            protected void fireStateChanged() {
                int compareResult;
                Double val = (Double)EntryField.this.spinner.getValue();
                if (EntryField.this.autoSpin) {
                    val = new Double(Math.round(val));
                }
                if (val != EntryField.this.value && (compareResult = val.compareTo(this.lastVal)) != 0) {
                    if (compareResult > 0) {
                        if (!EntryField.this.areMaxMinValueSet() || EntryField.this.value < EntryField.this.maxVal) {
                            if (!EntryField.this.textListeners.isEmpty()) {
                                PicobolTextEvent event = new PicobolTextEvent(EntryField.this.textComponent, 2200);
                                for (PicobolTextListener l : EntryField.this.textListeners) {
                                    l.valueIncrementing(event);
                                }
                            }
                            EntryField.this.increment = true;
                        }
                    } else if (!EntryField.this.areMaxMinValueSet() || EntryField.this.value > EntryField.this.minVal) {
                        if (!EntryField.this.textListeners.isEmpty()) {
                            PicobolTextEvent event = new PicobolTextEvent(EntryField.this.textComponent, 2201);
                            for (PicobolTextListener l : EntryField.this.textListeners) {
                                l.valueDecrementing(event);
                            }
                        }
                        EntryField.this.increment = false;
                    }
                }
                this.lastVal = val;
            }
        };
        this.spinner.setFocusable(false);
        this.spinner.setEditor(this.textComponent);
        SwingUtilities.replaceUIActionMap(this.spinner, null);
    }

    public Border getDefaultBorder() {
        return this.defaultBorder;
    }

    public void addTextListener(PicobolTextListener l) {
        if (!this.textListeners.contains(l)) {
            this.textListeners.addElement(l);
        }
    }

    public void removeTextListener(PicobolTextListener l) {
        this.textListeners.removeElement(l);
    }

    private boolean areMaxMinValueSet() {
        return this.maxVal != 0.0 || this.minVal != 0.0;
    }

    public void setUpper(boolean b) {
        this.upper = b;
        if (b) {
            this.lower = !b;
        }
    }

    public void setLower(boolean b) {
        this.lower = b;
        if (b) {
            this.upper = !b;
        }
    }

    public void setNumeric(boolean b) {
        this.numeric = b;
    }

    public void setUseTab(boolean b) {
        this.useTab = b;
    }

    public void setReadOnly(boolean readOnly, final boolean updateCursor) {
        if (this.textComponent.isEditable() == !readOnly && !updateCursor) {
            return;
        }
        final boolean editable = !readOnly;
        new IsguiWorker(true){

            @Override
            public void launch() {
                EntryField.this.textComponent.setEditable(editable);
                if (updateCursor) {
                    EntryField.this.textCmpCursor = EntryField.this.textComponent.getCursor();
                }
            }
        }.start();
    }

    public void setMaxText(int mt) {
        this.maxText = mt;
        if (this.formatter != null && this.formatter instanceof MaskFormatter) {
            ((FormattedEntryFieldComponent)this.textComponent).setMaxText();
        }
    }

    public int getMaxText() {
        return this.maxText;
    }

    void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    void setMaxTextBytes(boolean maxTextBytes) {
        this.maxTextBytes = maxTextBytes;
    }

    public void setMaxLines(int l) {
        this.maxLines = l;
    }

    public void setAuto(boolean b) {
        this.auto = b;
    }

    public void setAutoSpin(boolean b) {
        this.autoSpin = b;
    }

    public boolean isUpper() {
        return this.upper;
    }

    public boolean isLower() {
        return this.lower;
    }

    public void setUseReturn(boolean ur) {
        this.useReturn = ur;
    }

    public boolean getUseReturn() {
        return this.useReturn;
    }

    public boolean useReturn() {
        return this.useReturn;
    }

    public boolean useTab() {
        return this.useTab;
    }

    @Override
    public boolean hasSelection() {
        return this.textComponent.getSelectionStart() != this.textComponent.getSelectionEnd();
    }

    @Override
    public void setToolTipText(String tt) {
        this.toolTipText = tt;
        this.textComponent.setToolTipText(this.toolTipText != null ? this.toolTipText : "");
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.revalidate();
    }

    public void setSecure(boolean b, char echoChar) {
        JTextField oldComponent;
        if (this.multiline || this.formatter != null || this.secure == b) {
            return;
        }
        this.secure = b;
        if (this.secure) {
            oldComponent = (SingleLineEntryFieldComponent)this.textComponent;
            this.textComponent = new PasswordFieldComponent(this, oldComponent.getColumns());
        } else {
            oldComponent = (PasswordFieldComponent)this.textComponent;
            this.textComponent = new SingleLineEntryFieldComponent(this, oldComponent.getColumns());
        }
        this.setTextComponentAttributes(oldComponent);
        if (this.secure) {
            ((PasswordFieldComponent)this.textComponent).setEchoChar(echoChar);
        }
        this.remove(oldComponent);
        this.add(this.textComponent);
        this.doLayout();
    }

    private void setTextComponentAttributes(JTextField oldComponent) {
        this.textComponent.setDocument(this.textDocument);
        this.textComponent.setBackground(oldComponent.getBackground());
        this.textComponent.setForeground(oldComponent.getForeground());
        this.textComponent.setBorder(oldComponent.getBorder());
        this.textComponent.setCaretPosition(oldComponent.getCaretPosition());
        this.textComponent.setEnabled(oldComponent.isEnabled());
        this.textComponent.setFocusable(oldComponent.isFocusable());
        this.textComponent.setFont(oldComponent.getFont());
        ((JTextField)this.textComponent).setHorizontalAlignment(oldComponent.getHorizontalAlignment());
        this.textComponent.setSelectedTextColor(oldComponent.getSelectedTextColor());
        this.textComponent.setSelectionColor(oldComponent.getSelectionColor());
        this.textComponent.setDragEnabled(oldComponent.getDragEnabled());
        this.textComponent.setEditable(oldComponent.isEditable());
        this.textComponent.setText(oldComponent.getText());
        this.textComponent.setToolTipText(oldComponent.getToolTipText());
        if (!this.defaultShortcutsEnabled) {
            RemoteBaseGUIControl.disableDefaultShortcuts(this.textComponent.getKeymap());
        }
        if (this.undoListenerInstalled) {
            oldComponent.getDocument().removeUndoableEditListener(this.undoEditListener);
            oldComponent.removeKeyListener(this.undoKeyListener);
            this.textComponent.getDocument().addUndoableEditListener(this.undoEditListener);
            this.textComponent.addKeyListener(this.undoKeyListener);
        }
        for (FocusListener focusListener : this.focusListeners) {
            this.textComponent.addFocusListener(focusListener);
        }
        for (KeyListener keyListener : this.keyListeners) {
            this.textComponent.addKeyListener(keyListener);
        }
        for (MouseListener mouseListener : this.mouseListeners) {
            this.textComponent.addMouseListener(mouseListener);
        }
        if (this.iconMouseListener != null) {
            oldComponent.removeMouseListener(this.iconMouseListener);
            oldComponent.removeMouseMotionListener(this.iconMouseListener);
            this.textComponent.addMouseListener(this.iconMouseListener);
            this.textComponent.addMouseMotionListener(this.iconMouseListener);
        }
    }

    private void intPaste() {
        if (!this.textComponent.isEditable()) {
            return;
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(this);
        try {
            String clipString = (String)clipData.getTransferData(DataFlavor.stringFlavor);
            if (this.hasSelection()) {
                this.textComponent.replaceSelection(clipString);
            } else {
                this.textComponent.getDocument().insertString(this.textComponent.getCaretPosition(), clipString, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getText() {
        if (this.multiline) {
            return ((MultiLineEntryFieldComponent)this.textComponent).getText();
        }
        if (this.formatter != null) {
            try {
                ((FormattedEntryFieldComponent)this.textComponent).commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Object v = ((FormattedEntryFieldComponent)this.textComponent).getValue();
            if (v != null) {
                return v.toString();
            }
            return "";
        }
        if (this.textComponent instanceof PasswordFieldComponent) {
            return ((PasswordFieldComponent)this.textComponent).GetText();
        }
        return ((SingleLineEntryFieldComponent)this.textComponent).GetText();
    }

    public boolean isEditValid() {
        if (this.formatter == null) {
            return true;
        }
        try {
            ((FormattedEntryFieldComponent)this.textComponent).commitEdit();
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public int getCaretPosition() {
        return this.textComponent.getCaretPosition();
    }

    public String getSelectedText() {
        String Return2 = this.textComponent.getSelectedText();
        if (Return2 != null) {
            return Return2;
        }
        return "";
    }

    public int getSelectionStart() {
        return this.textComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textComponent.getSelectionEnd();
    }

    @Override
    public void selectAll() {
        this.textComponent.selectAll();
    }

    public void setText(String t) {
        if (this.formatter == null) {
            this.textComponent.setText(t);
        } else {
            ((FormattedEntryFieldComponent)this.textComponent).setValue(t);
        }
    }

    public void setAllText(String t) {
        if (this.formatter == null) {
            this.textDocument.setAllText(t, true);
        } else {
            boolean ok = false;
            while (!ok) {
                try {
                    switch (this.formatType) {
                        default: {
                            this.formatter.valueToString(t);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.formatter.stringToValue(t);
                        }
                    }
                    ok = true;
                }
                catch (ParseException ex) {
                    int offs = ex.getErrorOffset();
                    if (offs < t.length()) {
                        t = t.substring(0, offs) + t.substring(offs + 1);
                        continue;
                    }
                    ok = true;
                }
            }
            ((FormattedEntryFieldComponent)this.textComponent).setValue(t);
        }
    }

    @Override
    public void copy() {
        this.textComponent.copy();
    }

    @Override
    public void cut() {
        if (this.textComponent.isEditable()) {
            this.textComponent.cut();
        }
    }

    @Override
    public void paste() {
        this.intPaste();
    }

    public void select(int begin, int length) {
        this.textComponent.select(begin, length);
    }

    void setMargins(Insets margins, boolean update) {
        Insets insets = this.margins = margins != null ? margins : new Insets(0, 0, 0, 0);
        if (!this.multiline) {
            this.margins.bottom = 0;
            this.margins.top = 0;
        }
        if (update) {
            Border b = this.border != null ? this.border[0] : null;
            this.intSetBorder(this.textComponent, b);
        }
    }

    @Override
    public void replaceSelection(String newText) {
        this.textComponent.replaceSelection(newText);
    }

    public void setCaretPosition(int p) {
        this.textComponent.setCaretPosition(p);
    }

    @Override
    public void setBackground(Color bg) {
        this.background = bg;
        if (this.textComponent == null) {
            super.setBackground(bg);
        } else {
            if (this.textScrollPane != null) {
                this.textScrollPane.setBackground(bg);
                this.textScrollPane.setViewportBorder(BorderFactory.createMatteBorder(this.margins.top, this.margins.left, this.margins.bottom, this.margins.right, bg));
            }
            this.textComponent.setBackground(bg);
        }
    }

    @Override
    public Color getBackground() {
        if (this.textComponent == null || !this.textComponent.isBackgroundSet()) {
            return super.getBackground();
        }
        return this.textComponent.getBackground();
    }

    @Override
    public void setForeground(Color fg) {
        if (this.textComponent == null) {
            super.setForeground(fg);
        } else {
            this.textComponent.setForeground(fg);
        }
    }

    @Override
    public Color getForeground() {
        if (this.textComponent == null || !this.textComponent.isForegroundSet()) {
            return super.getForeground();
        }
        return this.textComponent.getForeground();
    }

    @Override
    public void setEnabled(boolean e) {
        this.textComponent.setEnabled(e);
        if (this.textScrollPane != null) {
            this.textScrollPane.setEnabled(e);
        }
        if (this.spinner != null) {
            this.spinner.setEnabled(e);
        }
        this.redrawIcon();
    }

    @Override
    public boolean isEditable() {
        return this.textComponent.isEditable();
    }

    @Override
    public boolean isEnabled() {
        return this.textComponent.isEnabled();
    }

    @Override
    public void setFont(Font f) {
        if (this.textComponent == null) {
            super.setFont(f);
        } else {
            this.textComponent.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        if (this.textComponent == null || !this.textComponent.isFontSet()) {
            return super.getFont();
        }
        return this.textComponent.getFont();
    }

    @Override
    public void addKeyListener(KeyListener l) {
        if (this.textComponent == null) {
            super.addKeyListener(l);
        } else {
            this.textComponent.addKeyListener(l);
            this.keyListeners.addElement(l);
        }
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        this.textComponent.removeKeyListener(l);
        this.keyListeners.removeElement(l);
    }

    @Override
    public void addFocusListener(FocusListener l) {
        if (this.textComponent == null) {
            super.addFocusListener(l);
        } else {
            this.textComponent.addFocusListener(l);
            this.focusListeners.addElement(l);
        }
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        this.textComponent.removeFocusListener(l);
        this.focusListeners.removeElement(l);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.textComponent == null) {
            super.addMouseListener(l);
        } else {
            this.textComponent.addMouseListener(l);
            this.mouseListeners.addElement(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.textComponent.removeMouseListener(l);
        this.mouseListeners.removeElement(l);
    }

    @Override
    public void setFocusable(boolean b) {
        this.textComponent.setFocusable(b);
    }

    @Override
    public void requestFocus() {
        this.textComponent.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textComponent.requestFocusInWindow();
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v) {
            if (this.textComponent.isEditable() && !this.undoListenerInstalled) {
                this.textComponent.getDocument().addUndoableEditListener(this.undoEditListener);
                this.textComponent.addKeyListener(this.undoKeyListener);
                this.undoListenerInstalled = true;
            }
            if (this.multiline && !this.textComponent.isEditable()) {
                this.textComponent.setFocusTraversalKeys(1, Collections.EMPTY_SET);
                this.textComponent.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            }
            this.doLayout();
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.textScrollPane != null) {
            this.textScrollPane.doLayout();
        }
        if (this.spinner != null) {
            this.spinner.doLayout();
        }
    }

    public void updateValue() {
        if (this.spinner != null) {
            this.value = this.increment ? (this.value += 1.0) : (this.value -= 1.0);
            String txt = "";
            txt = Math.ceil(this.value) == this.value ? txt + (long)this.value : txt + this.value;
            this.setText(txt);
        }
    }

    public void setMaxValue(int max) {
        this.maxVal = max;
    }

    public void setMinValue(int min) {
        this.minVal = min;
    }

    public void setHorizontalAlignment(int ha) {
        if (!this.multiline) {
            ((JTextField)this.textComponent).setHorizontalAlignment(ha);
        }
    }

    public void addVerticalScrollBar() {
        int v;
        if (this.textScrollPane != null && (v = this.textScrollPane.getVerticalScrollBarPolicy()) != 22) {
            this.textScrollPane.setVerticalScrollBarPolicy(22);
        }
    }

    public int getLineCount() {
        if (this.multiline) {
            return ((MultiLineEntryFieldComponent)this.textComponent).getLineCount();
        }
        return 1;
    }

    private int getLineCount(boolean updateOffsets) {
        if (this.multiline) {
            return ((MultiLineEntryFieldComponent)this.textComponent).getLineCount(updateOffsets);
        }
        return 1;
    }

    public int getLineStartOffset(int idx) {
        if (this.multiline) {
            try {
                return ((MultiLineEntryFieldComponent)this.textComponent).getLineStartOffset(idx);
            }
            catch (BadLocationException e) {
                return 0;
            }
        }
        return 0;
    }

    public int getLineEndOffset(int idx) {
        if (this.multiline) {
            try {
                return ((MultiLineEntryFieldComponent)this.textComponent).getLineEndOffset(idx);
            }
            catch (BadLocationException e) {
                return this.getText().length();
            }
        }
        return this.getText().length();
    }

    public int[][] getLineOffsets() {
        if (this.multiline) {
            return ((MultiLineEntryFieldComponent)this.textComponent).getLineOffsets();
        }
        return new int[][]{{0, this.getText().length()}};
    }

    public void setFormatType(int fType) {
        if (this.textComponent instanceof FormattedEntryFieldComponent) {
            this.formatType = fType;
            switch (this.formatType) {
                case 1: {
                    this.formatter = new NumberFormatter();
                    break;
                }
                case 2: {
                    this.formatter = new DateFormatter();
                    break;
                }
                default: {
                    this.formatter = new MaskFormatter();
                    ((MaskFormatter)this.formatter).setValueContainsLiteralCharacters(false);
                }
            }
            ((FormattedEntryFieldComponent)this.textComponent).setFormatterFactory(new DefaultFormatterFactory(this.formatter));
        }
    }

    public void setPlaceholder(String ph) {
        this.placeholder = ph;
        this.textComponent.repaint();
    }

    public void setPlaceholderColor(Color placeholderColor) {
        this.placeholderColor = placeholderColor;
        this.textComponent.repaint();
    }

    public int getFormatType() {
        return this.formatType;
    }

    public void setFormatString(String s) {
        if (this.formatter == null) {
            return;
        }
        FormattedEntryFieldComponent efc = (FormattedEntryFieldComponent)this.textComponent;
        switch (this.formatType) {
            case 1: {
                ((NumberFormatter)this.formatter).setFormat(new DecimalFormat(s));
                break;
            }
            case 2: {
                ((DateFormatter)this.formatter).setFormat(new SimpleDateFormat(s));
                break;
            }
            default: {
                efc.setMask(s);
            }
        }
        efc.setValue(efc.getValue());
    }

    public String getFormatString() {
        if (this.formatter == null) {
            return null;
        }
        switch (this.formatType) {
            case 1: {
                return ((DecimalFormat)((NumberFormatter)this.formatter).getFormat()).toPattern();
            }
            case 2: {
                return ((SimpleDateFormat)((DateFormatter)this.formatter).getFormat()).toPattern();
            }
        }
        return ((MaskFormatter)this.formatter).getMask();
    }

    public void setFillChar(char c) {
        if (this.formatter != null && this.formatter instanceof MaskFormatter) {
            ((MaskFormatter)this.formatter).setPlaceholderCharacter(c);
        }
    }

    public char getFillChar() {
        if (this.formatter != null && this.formatter instanceof MaskFormatter) {
            return ((MaskFormatter)this.formatter).getPlaceholderCharacter();
        }
        return '\u0000';
    }

    @Override
    public void setBorder(Border b) {
        this.border = new Border[]{b};
        if (this.textComponent == null) {
            super.setBorder(b);
        } else if (this.spinner != null) {
            if (b != null) {
                if (b instanceof MatteBorder) {
                    super.setBorder(null);
                    if (this.textScrollPane != null) {
                        this.textScrollPane.setBorder(null);
                    }
                    if (this.textComponent != null) {
                        this.textComponent.setBorder(b);
                    }
                    this.spinner.setBorder(null);
                } else {
                    this.spinner.setBorder(b);
                }
            } else {
                this.intSetBorder(this.spinner, b);
            }
        } else if (this.textScrollPane != null) {
            this.intSetBorder(this.textScrollPane, b);
        } else {
            this.intSetBorder(this.textComponent, b);
            this.redrawIcon();
        }
    }

    private void intSetBorder(JComponent comp, Border b) {
        Border b2;
        if (this.multiline) {
            Color bg = this.background != null ? this.background : this.gf.getRemotePalette().getColor(15);
            b2 = BorderFactory.createMatteBorder(this.margins.top, this.margins.left, this.margins.bottom, this.margins.right, bg);
        } else {
            b2 = BorderFactory.createEmptyBorder(this.margins.top, this.margins.left, this.margins.bottom, this.margins.right);
        }
        if (b == null) {
            comp.setBorder(b2);
        } else if (this.multiline) {
            comp.setBorder(b);
            if (this.textScrollPane != null) {
                this.textScrollPane.setViewportBorder(b2);
            }
        } else {
            comp.setBorder(BorderFactory.createCompoundBorder(b, b2));
        }
    }

    @Override
    public Border getBorder() {
        if (this.textComponent == null) {
            return super.getBorder();
        }
        if (this.border != null) {
            return this.border[0];
        }
        if (this.spinner != null) {
            return this.spinner.getBorder();
        }
        if (this.textScrollPane != null) {
            return this.textScrollPane.getBorder();
        }
        return this.textComponent.getBorder();
    }

    private boolean intProcessEvent(AWTEvent e, boolean activate) {
        MenuElement[] selPath = MenuSelectionManager.defaultManager().getSelectedPath();
        if (e instanceof KeyEvent && selPath != null && selPath.length > 0 && selPath[0] instanceof PicobolPopupMenu) {
            e.setSource(selPath[selPath.length - 1]);
            ((PicobolMenuElement)((Object)selPath[selPath.length - 1])).processEvent((KeyEvent)e);
            return false;
        }
        switch (e.getID()) {
            case 1004: {
                if (this.textComponent.getCaret() != null && !this.textComponent.isEditable()) {
                    this.textComponent.getCaret().setVisible(true);
                    this.textComponent.getCaret().setSelectionVisible(true);
                }
                return true;
            }
            case 1005: {
                if (this.textComponent.getCaret() != null && !this.textComponent.isEditable()) {
                    this.textComponent.getCaret().setVisible(false);
                    this.textComponent.getCaret().setSelectionVisible(false);
                }
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: {
                return true;
            }
            case 400: {
                KeyEvent ke = (KeyEvent)e;
                RemoteBaseGUIControl.checkControlCharacter(ke, this.acceptedControlChars, this.textComponent);
                this.gf.getRemoteVirtualKeyboard().mapKey(ke, this.lastKeyCode);
                return true;
            }
            case 401: {
                this.lastKeyCode = ((KeyEvent)e).getKeyCode();
                return true;
            }
        }
        return activate;
    }

    @Override
    public void undo() {
        if (this.undoManager.canUndo()) {
            try {
                this.undoManager.undo();
            }
            catch (CannotUndoException cue) {
                System.err.println(cue);
            }
        }
    }

    @Override
    public void redo() {
        if (this.undoManager.canRedo()) {
            try {
                this.undoManager.redo();
            }
            catch (CannotRedoException cre) {
                System.err.println(cre);
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.textComponent.getInputMethodRequests();
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
        this.textComponent.repaint();
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color disabledForeground) {
        this.disabledForeground = disabledForeground;
        this.textComponent.repaint();
    }

    public Color getReadOnlyBackground() {
        return this.readOnlyBackground;
    }

    public void setReadOnlyBackground(Color readOnlyBackground) {
        this.readOnlyBackground = readOnlyBackground;
        this.textComponent.repaint();
    }

    public Color getReadOnlyForeground() {
        return this.readOnlyForeground;
    }

    public void setReadOnlyForeground(Color readOnlyForeground) {
        this.readOnlyForeground = readOnlyForeground;
        this.textComponent.repaint();
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        if (this.textComponent != null) {
            this.textComponent.setComponentOrientation(o);
        }
    }

    @Override
    public void setName(String s) {
        if (this.textComponent != null) {
            this.textComponent.setName(s);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (this.icon != icon) {
            this.icon = icon;
            this.redrawIcon();
        }
    }

    public Icon getIconDisabled() {
        return this.iconDisabled;
    }

    public void setIconDisabled(Icon iconDisabled) {
        if (this.iconDisabled != iconDisabled) {
            this.iconDisabled = iconDisabled;
            this.redrawIcon();
        }
    }

    public Icon getIconTrailing() {
        return this.iconTrailing;
    }

    public void setIconTrailing(Icon iconTrailing) {
        if (this.iconTrailing != iconTrailing) {
            this.iconTrailing = iconTrailing;
            this.redrawIcon();
        }
    }

    public Icon getIconTrailingDisabled() {
        return this.iconTrailingDisabled;
    }

    public void setIconTrailingDisabled(Icon iconTrailingDisabled) {
        if (this.iconTrailingDisabled != iconTrailingDisabled) {
            this.iconTrailingDisabled = iconTrailingDisabled;
            this.redrawIcon();
        }
    }

    public Icon getIconRollover() {
        return this.iconRollover;
    }

    public void setIconRollover(Icon iconRollover) {
        this.iconRollover = iconRollover;
    }

    public Icon getIconTrailingRollover() {
        return this.iconTrailingRollover;
    }

    public void setIconTrailingRollover(Icon iconTrailingRollover) {
        this.iconTrailingRollover = iconTrailingRollover;
    }

    public String getIconHint() {
        return this.iconHint[0];
    }

    public void setIconHint(String iconHint) {
        this.iconHint[0] = iconHint;
    }

    public String getIconTrailingHint() {
        return this.iconHint[1];
    }

    public void setIconTrailingHint(String iconTrailingHint) {
        this.iconHint[1] = iconTrailingHint;
    }

    private Icon[] getIcons() {
        Icon rightIcon;
        Icon leftIcon;
        if (this.textComponent.isEnabled()) {
            leftIcon = this.iconMouseOver[0] ? (this.iconRollover != null ? this.iconRollover : this.icon) : this.icon;
            rightIcon = this.iconMouseOver[1] ? (this.iconTrailingRollover != null ? this.iconTrailingRollover : this.iconTrailing) : this.iconTrailing;
        } else {
            leftIcon = this.iconDisabled != null ? this.iconDisabled : this.icon;
            rightIcon = this.iconTrailingDisabled != null ? this.iconTrailingDisabled : this.iconTrailing;
        }
        return new Icon[]{leftIcon, rightIcon};
    }

    private boolean iconsAllowed() {
        return this.spinner == null && !(this.textComponent instanceof MultiLineEntryFieldComponent);
    }

    private void redrawIcon() {
        if (!this.iconsAllowed()) {
            return;
        }
        Icon[] icon = this.getIcons();
        Insets m = new Insets(this.margins.top, this.margins.left, this.margins.bottom, this.margins.right);
        this.borderInsets = this.getBorderInsets();
        if (this.getBorder() != null) {
            this.borderInsets = this.getBorder().getBorderInsets(this);
        }
        if (icon[0] != null) {
            m.left = this.borderInsets.left + icon[0].getIconWidth() + 1;
        }
        if (icon[1] != null) {
            m.right = this.borderInsets.right + icon[1].getIconWidth() + 1;
        }
        if (this.border == null) {
            this.textComponent.setBorder(BorderFactory.createEmptyBorder(m.top, m.left, m.bottom, m.right));
        } else {
            this.textComponent.setBorder(BorderFactory.createCompoundBorder(this.border[0], BorderFactory.createEmptyBorder(m.top, m.left, m.bottom, m.right)));
        }
        this.textComponent.repaint();
    }

    private Insets getBorderInsets() {
        if (this.border != null && this.border[0] != null) {
            JTextField tf = new JTextField();
            tf.setBorder(this.border[0]);
            return this.border[0].getBorderInsets(tf);
        }
        return new Insets(0, 0, 0, 0);
    }

    private void intPaintComponent(JTextComponent tc, Graphics g1) {
        if (this.iconsAllowed()) {
            int x;
            int y;
            int iconHeight;
            int iconWidth;
            Icon[] icon;
            if (this.borderInsets == null) {
                this.borderInsets = this.getBorderInsets();
            }
            if ((icon = this.getIcons())[0] != null) {
                iconWidth = icon[0].getIconWidth();
                iconHeight = icon[0].getIconHeight();
                y = (tc.getHeight() - iconHeight) / 2;
                x = this.borderInsets.left + 1;
                icon[0].paintIcon(tc, g1, x, y);
                this.iconBounds[0] = new Rectangle(x, y, iconWidth, iconHeight);
            } else {
                this.iconBounds[0] = null;
            }
            if (icon[1] != null) {
                iconWidth = icon[1].getIconWidth();
                iconHeight = icon[1].getIconHeight();
                y = (tc.getHeight() - iconHeight) / 2;
                x = tc.getWidth() - this.borderInsets.right - 1 - iconWidth;
                icon[1].paintIcon(tc, g1, x, y);
                this.iconBounds[1] = new Rectangle(x, y, iconWidth, iconHeight);
            } else {
                this.iconBounds[1] = null;
            }
        }
        if (this.placeholder != null && this.placeholder.length() > 0 && tc.getText().length() == 0) {
            Graphics2D g = (Graphics2D)g1;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.placeholderColor != null ? this.placeholderColor : tc.getDisabledTextColor());
            int offsh = tc.getInsets().left;
            if (this.textComponent instanceof JTextField) {
                FontMetrics fm = g1.getFontMetrics();
                int lenplaceholder = fm.stringWidth(this.placeholder);
                if (((JTextField)this.textComponent).getHorizontalAlignment() == 2) {
                    offsh = tc.getInsets().left;
                } else if (((JTextField)this.textComponent).getHorizontalAlignment() == 0) {
                    offsh = tc.getWidth() / 2 - lenplaceholder / 2;
                } else if (((JTextField)this.textComponent).getHorizontalAlignment() == 4) {
                    offsh = tc.getWidth() - tc.getInsets().right - lenplaceholder;
                }
            }
            g.drawString(this.placeholder, offsh, g1.getFontMetrics().getMaxAscent() + tc.getInsets().top);
        }
    }

    public String getSpellChecking() {
        return this.spellChecking;
    }

    private String intGetToolTipText(MouseEvent e, boolean spellCheckToolTip) {
        if (spellCheckToolTip && this.spellChecking != null && this.spellChecking.length() > 0 && this.spellCheckingSpans != null && this.spellCheckingSpans.length > 0 && SpellChecker.isSupported()) {
            int offset = this.textComponent.viewToModel(e.getPoint());
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.spellCheckingSpans.length; ++j) {
                Span s = this.spellCheckingSpans[j];
                if (offset < s.getStart() || offset >= s.getEnd()) continue;
                sb = new StringBuilder();
                sb.append("<html><b>");
                sb.append(s.getMessage());
                sb.append("</b>:<br>");
                sb.append(s.getDescription());
                List repl = s.getReplacements();
                if (!repl.isEmpty()) {
                    sb.append("<br><br><b>");
                    sb.append(Factory.getSysMsg("ef_spell_checking_correction"));
                    sb.append("</b>:<br>");
                    int i = 0;
                    ListIterator lit2 = repl.listIterator();
                    while (lit2.hasNext()) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(lit2.next());
                        ++i;
                    }
                }
                sb.append("</html>");
                break;
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        for (int i = 0; i < this.iconBounds.length; ++i) {
            if (this.iconBounds[i] == null || !this.iconBounds[i].contains(e.getPoint()) || this.iconHint[i] == null || this.iconHint[i].length() <= 0) continue;
            return this.iconHint[i];
        }
        if (this.toolTipText != null && this.toolTipText.length() > 0) {
            return this.toolTipText;
        }
        return null;
    }

    public void setSpellChecking(String spellChecking) {
        String newVal;
        String oldVal = this.spellChecking;
        if (oldVal == null) {
            oldVal = "";
        }
        if ((newVal = spellChecking) == null) {
            newVal = "";
        }
        if (!oldVal.equals(newVal)) {
            this.spellChecking = spellChecking;
            if (this.spellChecking.length() > 0 && SpellChecker.isSupported() && (this.textComponent instanceof SingleLineEntryFieldComponent || this.textComponent instanceof MultiLineEntryFieldComponent)) {
                this.spellCheckingTimer.restart(() -> this.spellCheck());
            } else {
                this.removeHighlights();
            }
        }
    }

    private void removeHighlights() {
        for (Highlighter.Highlight hl : this.textComponent.getHighlighter().getHighlights()) {
            if (!(hl.getPainter() instanceof SpellcheckerHighlightPainter)) continue;
            this.textComponent.getHighlighter().removeHighlight(hl);
        }
    }

    private void updateHighlights() {
        this.removeHighlights();
        Highlighter h = this.textComponent.getHighlighter();
        for (int i = 0; i < this.spellCheckingSpans.length; ++i) {
            Span span = this.spellCheckingSpans[i];
            if (span.getStart() == span.getEnd()) continue;
            try {
                if (span.getStart() >= span.getEnd()) continue;
                Color underlineColor = SpellChecker.MISSPELLING == span.getLocQualityIssueType() ? Color.red : Color.blue;
                SpellcheckerHighlightPainter painter = new SpellcheckerHighlightPainter(null, underlineColor);
                h.addHighlight(span.getStart(), span.getEnd(), painter);
                continue;
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void spellCheck() {
        try {
            this.spellCheckingSpans = SpellChecker.check(this.textComponent.getText(), this.spellChecking);
            SwingUtilities.invokeLater(() -> this.updateHighlights());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setSpellCheckingDelay(int d) {
        this.spellCheckingTimer.setDelay(d);
    }

    public int getSpellCheckingDelay() {
        return this.spellCheckingTimer.getDelay();
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean noWrap) {
        this.noWrap = noWrap;
        if (this.multiline) {
            ((MultiLineEntryFieldComponent)this.textComponent).setLineWrap(!this.noWrap);
            this.textScrollPane.setHorizontalScrollBarPolicy(this.noWrap ? 30 : 31);
        }
    }

    public int getUpperLowerMethod() {
        return this.upperLowerMethod;
    }

    public void setUpperLowerMethod(int upperLowerMethod) {
        this.upperLowerMethod = upperLowerMethod;
    }

    public boolean isDefaultShortcutsEnabled() {
        return this.defaultShortcutsEnabled;
    }

    public void setDefaultShortcutsEnabled(boolean b) {
        if (this.defaultShortcutsEnabled != b) {
            this.defaultShortcutsEnabled = b;
            if (!this.defaultShortcutsEnabled) {
                RemoteBaseGUIControl.disableDefaultShortcuts(this.textComponent.getKeymap());
            }
        }
    }

    protected void setAcceptedControlCharacters(String s) {
        this.acceptedControlChars = s != null ? s.toCharArray() : null;
    }

    private boolean checkReplaceSelection(String content) {
        return !("\t".equals(content) && !this.useTab || "\n".equals(content) && !this.useReturn) && this.checkNumeric(content);
    }

    private boolean checkNumeric(String str) {
        if (this.numeric && str.length() > 0 && !EntryField.isDigit(str.charAt(0))) {
            if (this.msgBoxOnError && this.msgboxlistener != null) {
                this.msgboxlistener.sendMsgBox(new MsgBoxEvent(this, Factory.getSysMsg("ef_error_number"), ""));
            }
            return false;
        }
        return true;
    }

    public JComponent getDragDropComponent() {
        return this.textComponent;
    }

    public void setDragComponent(OutDragListener odlistener) {
        if (this.textComponent != null) {
            if (odlistener != null) {
                this.textComponent.setDropMode(DropMode.INSERT);
                this.textComponent.setDragEnabled(true);
                this.ftth = new FromToTransferHandler(odlistener, 1);
                this.textComponent.setTransferHandler(this.ftth);
            } else {
                this.textComponent.setDragEnabled(false);
                if (this.ftth != null) {
                    this.textComponent.setTransferHandler(null);
                }
            }
        }
    }

    private static boolean hasInputFilter(EntryField parent) {
        return parent.inputFilter != null && parent.inputFilter.length() > 0;
    }

    public void setInputFilter(String ifstr) {
        if (this.inputFilter == null || !this.inputFilter.equals(ifstr)) {
            this.inputFilter = ifstr;
        }
    }

    private static boolean charInInputFilter(EntryField parent, char comp) {
        boolean Return2 = false;
        Pattern regexif = null;
        try {
            regexif = Pattern.compile(parent.inputFilter);
        }
        catch (PatternSyntaxException pse) {
            return Return2;
        }
        Matcher matcherif = regexif.matcher("");
        matcherif.reset(String.valueOf(comp));
        Return2 = matcherif.find();
        return Return2;
    }

    private static String checkInInputFilter(EntryField parent, String str) {
        String Return2 = "";
        if (str != null && str.length() > 0 && EntryField.hasInputFilter(parent)) {
            for (int i = 0; i < str.length(); ++i) {
                char comp = str.charAt(i);
                if (!EntryField.charInInputFilter(parent, comp)) continue;
                Return2 = Return2 + comp;
            }
        } else {
            Return2 = str;
        }
        return Return2;
    }

    public void setMsgBoxListener(MsgBoxListener msgboxlistener) {
        this.msgboxlistener = msgboxlistener;
    }

    static /* synthetic */ int[][] access$102(EntryField x0, int[][] x1) {
        x0.lineOffsets = x1;
        return x1;
    }

    private static class MyDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private int byteLength;
        EntryField parent;

        MyDocument(EntryField parent) {
            this.parent = parent;
        }

        int length() {
            return this.parent != null && this.parent.encoding != null && this.parent.maxTextBytes ? this.byteLength : this.getLength();
        }

        int length(String str) {
            try {
                return this.parent != null && this.parent.encoding != null && this.parent.maxTextBytes ? str.getBytes(this.parent.encoding).length : str.length();
            }
            catch (Exception e) {
                return str.length();
            }
        }

        String cut(String str, int len) {
            if (this.parent != null && this.parent.encoding != null && this.parent.maxTextBytes) {
                int i;
                int bLen = 0;
                for (i = 0; i < str.length(); ++i) {
                    try {
                        bLen += Character.toString(str.charAt(i)).getBytes(this.parent.encoding).length;
                    }
                    catch (Exception e) {
                        ++bLen;
                    }
                    if (bLen > len) break;
                }
                return str.substring(0, i);
            }
            return str.substring(0, len);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (this.parent != null) {
                this.parent.fireEvents = true;
                if (this.parent.encoding != null && this.parent.maxTextBytes) {
                    try {
                        this.byteLength -= this.getText(offs, len).getBytes(this.parent.encoding).length;
                    }
                    catch (Exception e) {
                        this.byteLength -= len;
                    }
                }
            }
            super.remove(offs, len);
        }

        public void setAllText(String t, boolean checkMaxLines) {
            this.parent.fireEvents = false;
            if (this.parent.undoListenerInstalled) {
                this.removeUndoableEditListener(this.parent.undoEditListener);
            }
            try {
                int endOffs;
                t = EntryField.checkInInputFilter(this.parent, t);
                if (this.parent.upper) {
                    t = Factory.toUpperCase(t, this.parent.upperLowerMethod);
                } else if (this.parent.lower) {
                    t = Factory.toLowerCase(t, this.parent.upperLowerMethod);
                }
                super.remove(0, this.getLength());
                super.insertString(0, t, null);
                if (checkMaxLines && this.parent.maxLines > 0 && this.parent.getLineCount(true) > this.parent.maxLines && (endOffs = this.parent.lineOffsets[this.parent.maxLines - 1][1]) < t.length()) {
                    t = t.substring(0, endOffs);
                    super.remove(0, this.getLength());
                    super.insertString(0, t, null);
                }
                if (this.parent.encoding != null && this.parent.maxTextBytes) {
                    try {
                        this.byteLength = t.getBytes(this.parent.encoding).length;
                    }
                    catch (Exception e) {
                        this.byteLength = t.length();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.parent.undoListenerInstalled) {
                this.addUndoableEditListener(this.parent.undoEditListener);
            }
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.parent != null) {
                if (this.parent.formatter == null) {
                    this.myinsertString(offs, str, a);
                } else {
                    if (this.parent.encoding != null && this.parent.maxTextBytes) {
                        try {
                            this.byteLength += str.getBytes(this.parent.encoding).length;
                        }
                        catch (Exception e) {
                            this.byteLength += str.length();
                        }
                    }
                    super.insertString(offs, str, a);
                }
            } else {
                super.insertString(offs, str, a);
            }
        }

        private void myinsertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (!this.parent.checkNumeric(str)) {
                return;
            }
            str = ((EntryFieldComponent)((Object)this.parent.textComponent)).check(str);
            if (this.parent.multiline && !eol.equals("\n")) {
                String tmptxt = this.parent.textComponent.getText();
                if (offs - 1 >= 0 && tmptxt.lastIndexOf(eol) == offs - 1) {
                    --offs;
                }
            }
            if (str == null) {
                Toolkit.getDefaultToolkit().beep();
                throw new BadLocationException(str, offs);
            }
            str = EntryField.checkInInputFilter(this.parent, str);
            if (this.parent.upper) {
                str = Factory.toUpperCase(str, this.parent.upperLowerMethod);
            } else if (this.parent.lower) {
                str = Factory.toLowerCase(str, this.parent.upperLowerMethod);
            }
            if (this.parent.multiline && this.parent.maxLines > 0) {
                this.parent.fireEvents = false;
                if (this.parent.undoListenerInstalled) {
                    this.removeUndoableEditListener(this.parent.undoEditListener);
                }
                super.insertString(offs, str, a);
                int n = this.parent.getLineCount();
                super.remove(offs, str.length());
                this.parent.fireEvents = true;
                if (this.parent.undoListenerInstalled) {
                    this.addUndoableEditListener(this.parent.undoEditListener);
                }
                if (n > this.parent.maxLines) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    super.insertString(offs, str, a);
                    if (this.parent.encoding != null && this.parent.maxTextBytes) {
                        try {
                            this.byteLength += str.getBytes(this.parent.encoding).length;
                        }
                        catch (Exception ex) {
                            this.byteLength += str.length();
                        }
                    }
                }
            } else {
                this.parent.fireEvents = true;
                if (this.parent.encoding != null && this.parent.maxTextBytes) {
                    try {
                        this.byteLength += str.getBytes(this.parent.encoding).length;
                    }
                    catch (Exception ex) {
                        this.byteLength += str.length();
                    }
                }
                super.insertString(offs, str, a);
            }
        }
    }

    private static class FormattedEntryFieldComponent
    extends JFormattedTextField
    implements PicobolWidget,
    EntryFieldComponent {
        private static final long serialVersionUID = 1L;
        private static final char DIGIT_KEY = '#';
        private static final char LITERAL_KEY = '\'';
        private static final char UPPERCASE_KEY = 'U';
        private static final char LOWERCASE_KEY = 'L';
        private static final char ALPHA_NUMERIC_KEY = 'A';
        private static final char CHARACTER_KEY = '?';
        private static final char ANYTHING_KEY = '*';
        private static final char HEX_KEY = 'H';
        private boolean activate;
        private int idxlasteditchar = -1;
        EntryField parent;

        FormattedEntryFieldComponent(EntryField parent) {
            this.parent = parent;
        }

        @Override
        public void setFormatter(JFormattedTextField.AbstractFormatter f) {
            if (this.parent != null && this.parent.undoListenerInstalled) {
                this.getDocument().removeUndoableEditListener(this.parent.undoEditListener);
            }
            try {
                super.setFormatter(f);
            }
            catch (Exception exception) {
            }
            finally {
                if (this.parent != null && this.parent.undoListenerInstalled) {
                    this.getDocument().addUndoableEditListener(this.parent.undoEditListener);
                }
            }
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            return this.parent.intGetToolTipText(e, false);
        }

        @Override
        public void cut() {
            if (this.isEditable()) {
                super.cut();
            }
        }

        @Override
        public void paste() {
            if (this.parent != null) {
                this.parent.intPaste();
            } else {
                super.paste();
            }
        }

        @Override
        public String check(String str) {
            return str;
        }

        @Override
        protected void processEvent(AWTEvent e) {
            if (this.parent == null || this.parent.intProcessEvent(e, this.activate)) {
                super.processEvent(e);
            }
        }

        @Override
        public boolean getActiveAccept() {
            return this.activate;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public Color getBackground() {
            if (this.parent != null) {
                return this.mygetBackground();
            }
            return super.getBackground();
        }

        private Color mygetBackground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getBackground();
                }
                if (this.parent.getReadOnlyBackground() != null) {
                    return this.parent.getReadOnlyBackground();
                }
                return super.getBackground();
            }
            if (this.parent.getDisabledBackground() != null) {
                return this.parent.getDisabledBackground();
            }
            return super.getBackground();
        }

        @Override
        public Color getForeground() {
            if (this.parent != null) {
                return this.mygetForeground();
            }
            return super.getForeground();
        }

        private Color mygetForeground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getForeground();
                }
                if (this.parent.getReadOnlyForeground() != null) {
                    return this.parent.getReadOnlyForeground();
                }
                return super.getForeground();
            }
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getForeground();
        }

        @Override
        public Color getDisabledTextColor() {
            if (this.parent != null) {
                return this.mygetDisabledTextColor();
            }
            return super.getDisabledTextColor();
        }

        private Color mygetDisabledTextColor() {
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getDisabledTextColor();
        }

        @Override
        public void setActiveAccept(boolean b) {
            this.activate = b;
        }

        @Override
        public void asyncProcessEvent(AWTEvent e) {
        }

        @Override
        public void setSelfAct(boolean b) {
        }

        @Override
        public void replaceSelection(String content) {
            if (this.parent != null) {
                if (this.parent.checkReplaceSelection(content)) {
                    super.replaceSelection(content);
                    if (this.parent.auto && this.parent.formatter instanceof MaskFormatter && this.getCaretPosition() > this.idxlasteditchar && this.getSelectedText() == null) {
                        PicobolTextEvent event = new PicobolTextEvent(this.parent.textComponent, 2202);
                        for (PicobolTextListener l : this.parent.textListeners) {
                            l.inputTerminated(event);
                        }
                    }
                }
            } else {
                super.replaceSelection(content);
            }
        }

        public void setMaxText() {
            String mask = ((MaskFormatter)this.parent.formatter).getMask();
            if (mask != null) {
                int maxCounter = mask.length();
                this.idxlasteditchar = -1;
                for (int counter = 0; counter < this.parent.maxText && counter < maxCounter; ++counter) {
                    if (mask.charAt(counter) != '#' && mask.charAt(counter) != '\'' && mask.charAt(counter) != 'U' && mask.charAt(counter) != 'L' && mask.charAt(counter) != 'A' && mask.charAt(counter) != '?' && mask.charAt(counter) != '*' && mask.charAt(counter) != 'H') continue;
                    this.idxlasteditchar = counter;
                }
            }
        }

        public void setMask(String mask) {
            try {
                ((MaskFormatter)this.parent.formatter).setMask(mask);
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            if (mask != null) {
                int maxCounter = mask.length();
                this.idxlasteditchar = -1;
                for (int counter = maxCounter - 1; this.idxlasteditchar == -1 && counter >= 0; --counter) {
                    if (mask.charAt(counter) != '#' && mask.charAt(counter) != '\'' && mask.charAt(counter) != 'U' && mask.charAt(counter) != 'L' && mask.charAt(counter) != 'A' && mask.charAt(counter) != '?' && mask.charAt(counter) != '*' && mask.charAt(counter) != 'H') continue;
                    this.idxlasteditchar = counter;
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g1) {
            super.paintComponent(g1);
            this.parent.intPaintComponent(this, g1);
        }
    }

    private static class PasswordFieldComponent
    extends JPasswordField
    implements PicobolWidget,
    EntryFieldComponent {
        private static final long serialVersionUID = 1L;
        private boolean activate;
        EntryField parent;

        public PasswordFieldComponent(EntryField parent, int cols) {
            super(cols);
            this.enableInputMethods(true);
            this.parent = parent;
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            return this.parent.intGetToolTipText(e, false);
        }

        @Override
        public Color getDisabledTextColor() {
            if (this.parent != null) {
                return this.mygetDisabledTextColor();
            }
            return super.getDisabledTextColor();
        }

        private Color mygetDisabledTextColor() {
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getDisabledTextColor();
        }

        @Override
        public Color getBackground() {
            if (this.parent != null) {
                return this.mygetBackground();
            }
            return super.getBackground();
        }

        private Color mygetBackground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getBackground();
                }
                if (this.parent.getReadOnlyBackground() != null) {
                    return this.parent.getReadOnlyBackground();
                }
                return super.getBackground();
            }
            if (this.parent.getDisabledBackground() != null) {
                return this.parent.getDisabledBackground();
            }
            return super.getBackground();
        }

        @Override
        public Color getForeground() {
            if (this.parent != null) {
                return this.mygetForeground();
            }
            return super.getForeground();
        }

        private Color mygetForeground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getForeground();
                }
                if (this.parent.getReadOnlyForeground() != null) {
                    return this.parent.getReadOnlyForeground();
                }
                return super.getForeground();
            }
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getForeground();
        }

        @Override
        public String check(String str) {
            int diff;
            MyDocument doc = (MyDocument)this.getDocument();
            int len = doc.length();
            int strLen = doc.length(str);
            if (strLen == 0) {
                return str;
            }
            char c = str.charAt(0);
            if (c == '\t' && !this.parent.useTab || c == '\n' && !this.parent.useReturn) {
                return null;
            }
            if (this.parent.numeric && !EntryField.isDigit(c)) {
                return null;
            }
            if (this.parent.hasSelection()) {
                return str;
            }
            if (this.parent.maxText > 0 && (diff = len + strLen - this.parent.maxText) > 0 && (diff >= strLen || (str = doc.cut(str, strLen - diff)).length() == 0)) {
                return null;
            }
            return str;
        }

        @Override
        protected void processEvent(AWTEvent e) {
            if (this.parent == null || this.parent.intProcessEvent(e, this.activate)) {
                super.processEvent(e);
            }
        }

        private String GetText() {
            return ((JTextComponent)this).getText();
        }

        @Override
        public void replaceSelection(String content) {
            if (this.parent == null || this.parent.checkReplaceSelection(content)) {
                super.replaceSelection(content);
            }
        }

        @Override
        public void paste() {
            if (this.parent != null) {
                this.parent.intPaste();
            } else {
                super.paste();
            }
        }

        @Override
        public boolean getActiveAccept() {
            return this.activate;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void setActiveAccept(boolean b) {
            this.activate = b;
        }

        @Override
        public void asyncProcessEvent(AWTEvent e) {
        }

        @Override
        public void setSelfAct(boolean b) {
        }

        @Override
        protected void paintComponent(Graphics g1) {
            super.paintComponent(g1);
            this.parent.intPaintComponent(this, g1);
        }
    }

    private static class SingleLineEntryFieldComponent
    extends JTextField
    implements PicobolWidget,
    EntryFieldComponent {
        private static final long serialVersionUID = 1L;
        private boolean activate;
        EntryField parent;

        public SingleLineEntryFieldComponent(EntryField parent, int cols) {
            super(cols);
            this.enableInputMethods(true);
            this.parent = parent;
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(border);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            return this.parent.intGetToolTipText(e, this.parent.spinner == null);
        }

        @Override
        public Color getDisabledTextColor() {
            if (this.parent != null) {
                return this.mygetDisabledTextColor();
            }
            return super.getDisabledTextColor();
        }

        private Color mygetDisabledTextColor() {
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getDisabledTextColor();
        }

        @Override
        public Color getBackground() {
            if (this.parent != null) {
                return this.mygetBackground();
            }
            return super.getBackground();
        }

        private Color mygetBackground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getBackground();
                }
                if (this.parent.getReadOnlyBackground() != null) {
                    return this.parent.getReadOnlyBackground();
                }
                return super.getBackground();
            }
            if (this.parent.getDisabledBackground() != null) {
                return this.parent.getDisabledBackground();
            }
            return super.getBackground();
        }

        @Override
        public Color getForeground() {
            if (this.parent != null) {
                return this.mygetForeground();
            }
            return super.getForeground();
        }

        private Color mygetForeground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getForeground();
                }
                if (this.parent.getReadOnlyForeground() != null) {
                    return this.parent.getReadOnlyForeground();
                }
                return super.getForeground();
            }
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getForeground();
        }

        @Override
        public String check(String str) {
            int diff;
            MyDocument doc = (MyDocument)this.getDocument();
            int len = doc.length();
            int strLen = doc.length(str);
            if (strLen == 0) {
                return str;
            }
            char c = str.charAt(0);
            if (c == '\t' && !this.parent.useTab || c == '\n' && !this.parent.useReturn) {
                return null;
            }
            int idx = -1;
            idx = str.indexOf(13);
            if (idx >= 0 || (idx = str.indexOf(10)) >= 0) {
                str = str.substring(0, idx);
                strLen = doc.length(str);
            }
            if (this.parent.numeric && !EntryField.isDigit(c)) {
                return null;
            }
            if (this.parent.hasSelection()) {
                return str;
            }
            if (this.parent.maxText > 0 && (diff = len + strLen - this.parent.maxText) > 0 && (diff >= strLen || (str = doc.cut(str, strLen - diff)).length() == 0)) {
                return null;
            }
            return str;
        }

        @Override
        protected void processEvent(AWTEvent e) {
            if (this.parent == null || this.parent.intProcessEvent(e, this.activate)) {
                super.processEvent(e);
            }
        }

        private String GetText() {
            return this.getText();
        }

        @Override
        public void replaceSelection(String content) {
            if (this.parent == null || this.parent.checkReplaceSelection(content)) {
                super.replaceSelection(content);
            }
        }

        @Override
        public void paste() {
            if (this.parent != null) {
                this.parent.intPaste();
            } else {
                super.paste();
            }
        }

        @Override
        public void cut() {
            if (this.isEditable()) {
                super.cut();
            }
        }

        @Override
        public boolean getActiveAccept() {
            return this.activate;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void setActiveAccept(boolean b) {
            this.activate = b;
        }

        @Override
        public void asyncProcessEvent(AWTEvent e) {
        }

        @Override
        public void setSelfAct(boolean b) {
        }

        @Override
        protected void paintComponent(Graphics g1) {
            try {
                super.paintComponent(g1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.parent.intPaintComponent(this, g1);
        }
    }

    private static class MultiLineEntryFieldComponent
    extends JTextArea
    implements PicobolWidget,
    EntryFieldComponent {
        private static final long serialVersionUID = 1L;
        private boolean activate;
        EntryField parent;
        private boolean usereturntmp = false;

        public MultiLineEntryFieldComponent(EntryField parent, String text, int rows, int cols) {
            super(text, rows, cols);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.parent = parent;
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            if (this.parent != null && this.parent.maxLines > 0 && this.getLineCount(true) > this.parent.maxLines) {
                String t = this.getText();
                int endOffs = this.parent.lineOffsets[this.parent.maxLines - 1][1];
                if (endOffs < t.length()) {
                    t = t.substring(0, endOffs);
                    this.parent.textDocument.setAllText(t, false);
                }
            }
        }

        @Override
        public void replaceSelection(String content) {
            if (this.parent == null || this.parent.checkReplaceSelection(content)) {
                super.replaceSelection(content);
            }
        }

        @Override
        public String check(String str) {
            int diff;
            MyDocument doc = (MyDocument)this.getDocument();
            int strLen = doc.length(str);
            if (strLen == 0) {
                return str;
            }
            char c = str.charAt(0);
            if (c == '\t' && !this.parent.useTab || c == '\n' && !this.parent.useReturn) {
                return null;
            }
            if (this.parent.numeric && !Character.isDigit(c) && c != '\n') {
                return null;
            }
            if (this.parent.hasSelection()) {
                return str;
            }
            int len = doc.getLength();
            if (this.parent.maxText > 0 && (diff = len + strLen - this.parent.maxText) > 0 && (diff >= strLen || (str = doc.cut(str, strLen - diff)).length() == 0)) {
                return null;
            }
            return str;
        }

        @Override
        protected void processEvent(AWTEvent e) {
            boolean go = false;
            if (this.parent == null || this.parent.intProcessEvent(e, this.activate)) {
                KeyEvent ke;
                if (e instanceof KeyEvent && (ke = (KeyEvent)e).getID() == 401 && ke.getKeyCode() == 10 && ke.isControlDown() && !this.parent.useReturn) {
                    this.usereturntmp = true;
                    this.parent.useReturn = true;
                    char newchar = '\n';
                    long when = System.currentTimeMillis();
                    super.processEvent(new KeyEvent((Component)e.getSource(), 401, System.currentTimeMillis(), 0, ke.getKeyCode(), newchar));
                    this.usereturntmp = false;
                    this.parent.useReturn = false;
                    return;
                }
                super.processEvent(e);
            }
        }

        @Override
        public void cut() {
            if (this.isEditable()) {
                super.cut();
            }
        }

        @Override
        public void paste() {
            if (this.parent != null) {
                this.parent.intPaste();
            } else {
                super.paste();
            }
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            return this.parent.intGetToolTipText(e, true);
        }

        @Override
        public boolean getActiveAccept() {
            return this.activate;
        }

        @Override
        public boolean getSelfAct() {
            return false;
        }

        @Override
        public void setActiveAccept(boolean b) {
            this.activate = b;
        }

        @Override
        public void asyncProcessEvent(AWTEvent e) {
        }

        @Override
        public void setSelfAct(boolean b) {
        }

        @Override
        public int getLineCount() {
            return this.getLineCount(false);
        }

        @Override
        public Color getBackground() {
            if (this.parent != null) {
                return this.mygetBackground();
            }
            return super.getBackground();
        }

        private Color mygetBackground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getBackground();
                }
                if (this.parent.getReadOnlyBackground() != null) {
                    return this.parent.getReadOnlyBackground();
                }
                if (this.parent.background != null) {
                    return this.parent.background;
                }
                Color c = UIManager.getColor("TextField.inactiveBackground");
                if (c == null) {
                    c = super.getBackground();
                }
                return c;
            }
            if (this.parent.getDisabledBackground() != null) {
                return this.parent.getDisabledBackground();
            }
            if (this.isEditable()) {
                return super.getBackground();
            }
            if (this.parent.background != null) {
                return this.parent.background;
            }
            Color c = UIManager.getColor("TextField.inactiveBackground");
            if (c == null) {
                c = super.getBackground();
            }
            return c;
        }

        @Override
        public Color getDisabledTextColor() {
            if (this.parent != null) {
                return this.mygetDisabledTextColor();
            }
            return super.getDisabledTextColor();
        }

        private Color mygetDisabledTextColor() {
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getDisabledTextColor();
        }

        @Override
        public Color getForeground() {
            if (this.parent != null) {
                return this.mygetForeground();
            }
            return super.getForeground();
        }

        private Color mygetForeground() {
            if (this.isEnabled()) {
                if (this.isEditable()) {
                    return super.getForeground();
                }
                if (this.parent.getReadOnlyForeground() != null) {
                    return this.parent.getReadOnlyForeground();
                }
                return super.getForeground();
            }
            if (this.parent.getDisabledForeground() != null) {
                return this.parent.getDisabledForeground();
            }
            return super.getForeground();
        }

        private int getLineCount(boolean updateOffsets) {
            Vector<int[]> lines = null;
            if (updateOffsets) {
                lines = new Vector<int[]>();
            }
            int Return2 = 0;
            int offset = 0;
            int len = this.getDocument().getLength();
            int end = 0;
            try {
                while (offset <= len && (end = Utilities.getRowEnd(this, offset)) >= 0) {
                    ++Return2;
                    if (updateOffsets) {
                        lines.addElement(new int[]{offset, end});
                    }
                    offset = end + 1;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (updateOffsets) {
                EntryField.access$102(this.parent, new int[Return2][2]);
                lines.toArray((T[])this.parent.lineOffsets);
                if (Return2 > 0) {
                    int[] nArray = this.parent.lineOffsets[Return2 - 1];
                    nArray[1] = nArray[1] + 1;
                }
            }
            return Return2;
        }

        @Override
        public int getLineStartOffset(int idx) throws BadLocationException {
            if (this.parent != null) {
                int nLines = this.getLineCount(true);
                if (idx < nLines) {
                    return this.parent.lineOffsets[idx][0];
                }
                return -1;
            }
            return super.getLineStartOffset(idx);
        }

        @Override
        public int getLineEndOffset(int idx) throws BadLocationException {
            if (this.parent != null) {
                int nLines = this.getLineCount(true);
                if (idx < nLines) {
                    return this.parent.lineOffsets[idx][1];
                }
                return -1;
            }
            return super.getLineEndOffset(idx);
        }

        public int[][] getLineOffsets() {
            this.getLineCount(true);
            return this.parent.lineOffsets;
        }

        @Override
        protected void paintComponent(Graphics g1) {
            super.paintComponent(g1);
            this.parent.intPaintComponent(this, g1);
        }
    }

    private static class MyTimer
    extends Timer {
        private static final long serialVersionUID = 1L;
        Runnable run;

        MyTimer(int delay) {
            super(delay, null);
            this.setRepeats(false);
            this.addActionListener(e -> {
                if (this.run != null) {
                    this.run.run();
                }
            });
        }

        void restart(Runnable run) {
            this.run = run;
            super.restart();
        }
    }

    private static class SpellcheckerHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private static final BasicStroke OO_STROKE1 = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{3.0f, 5.0f}, 2.0f);
        private static final BasicStroke OO_STROKE2 = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{1.0f, 3.0f}, 3.0f);
        private static final BasicStroke OO_STROKE3 = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{3.0f, 5.0f}, 6.0f);
        private static final BasicStroke ZIGZAG_STROKE1 = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
        private final Color underlineColor;
        private final Color backgroundColor;

        SpellcheckerHighlightPainter(Color backgroundColor, Color underlineColor) {
            super(backgroundColor);
            this.backgroundColor = backgroundColor;
            this.underlineColor = underlineColor;
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Rectangle rect;
            if (this.backgroundColor != null) {
                super.paintLayer(g, offs0, offs1, bounds, c, view);
            }
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                rect = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    rect = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
                catch (BadLocationException e) {
                    rect = null;
                }
            }
            if (rect != null) {
                Color color = this.underlineColor;
                if (color == null) {
                    g.setColor(c.getSelectionColor());
                } else {
                    g.setColor(color);
                }
                rect.width = Math.max(rect.width, 1);
                int descent = c.getFontMetrics(c.getFont()).getDescent();
                if (descent > 3) {
                    this.drawCurvedLine(g, rect);
                } else if (descent > 2) {
                    this.drawCurvedLine(g, rect);
                } else {
                    this.drawLine(g, rect);
                }
            }
            return rect;
        }

        private void drawCurvedLine(Graphics g, Rectangle rect) {
            int x1 = rect.x;
            int x2 = rect.x + rect.width;
            int y = rect.y + rect.height;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(OO_STROKE1);
            g2.drawLine(x1, y - 1, x2, y - 1);
            g2.setStroke(OO_STROKE2);
            g2.drawLine(x1, y - 2, x2, y - 2);
            g2.setStroke(OO_STROKE3);
            g2.drawLine(x1, y - 3, x2, y - 3);
        }

        private void drawLine(Graphics g, Rectangle rect) {
            int x1 = rect.x;
            int x2 = rect.x + rect.width;
            int y = rect.y + rect.height;
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(ZIGZAG_STROKE1);
            g2.drawLine(x1, y - 1, x2, y - 1);
        }
    }

    private static interface EntryFieldComponent {
        public String check(String var1);
    }
}

