/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Component;
import charva.awt.Toolkit;
import charva.awt.Window;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charvax.swing.JLabel;
import com.iscobol.gui.client.charva.BorderedFrame;
import com.iscobol.gui.client.charva.RemoteDisplayWindow;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.ListIterator;

public class KeyboardBufferQueue {
    private LinkedList keyboardQueue = new LinkedList();
    private boolean isActive = true;
    private boolean inputStatus;
    private int lastCursorX;
    private int lastCursorY;
    private boolean rightButtonDown;
    private boolean leftButtonDown;
    private boolean middleButtonDown;
    private static volatile KeyboardBufferQueue instance = null;

    private native int myreadKey();

    private KeyboardBufferQueue() {
    }

    public static synchronized KeyboardBufferQueue getInstance() {
        if (instance == null) {
            instance = new KeyboardBufferQueue();
        }
        return instance;
    }

    public synchronized boolean isEmpty() {
        return this.keyboardQueue.size() == 0;
    }

    public void enable(BorderedFrame.MyWindow w) {
        this.isActive = true;
    }

    public synchronized void disable() {
        this.isActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventObject dispatchEvent(EventObject e, BorderedFrame.MyWindow w) {
        EventObject Return2 = e;
        if (e instanceof MouseEvent) {
            MouseEvent em = (MouseEvent)e;
            this.lastCursorX = em.getX();
            this.lastCursorY = em.getY();
            switch (em.getID()) {
                case 100: {
                    int modifiers = em.getModifiers();
                    if (modifiers == 1) {
                        this.leftButtonDown = true;
                        break;
                    }
                    if (modifiers == 2) {
                        this.middleButtonDown = true;
                        break;
                    }
                    if (modifiers != 3) break;
                    this.rightButtonDown = true;
                    break;
                }
                case 101: {
                    int modifiers = em.getModifiers();
                    if (modifiers == 1) {
                        this.leftButtonDown = false;
                        break;
                    }
                    if (modifiers == 2) {
                        this.middleButtonDown = false;
                        break;
                    }
                    if (modifiers != 3) break;
                    this.rightButtonDown = false;
                    break;
                }
                case 102: {
                    break;
                }
            }
            if (!this.isActive && (em.getID() == 100 || em.getID() == 102 && em.getClickCount() <= 1)) {
                Return2 = null;
            }
        } else if (!this.isActive && e instanceof KeyEvent) {
            LinkedList linkedList = this.keyboardQueue;
            synchronized (linkedList) {
                if (((KeyEvent)e).getID() == 1) {
                    this.inputStatus = true;
                }
                this.keyboardQueue.add(e);
                Return2 = null;
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repostBufEvents(String t) {
        LinkedList linkedList = this.keyboardQueue;
        synchronized (linkedList) {
            this.inputStatus = false;
            if (!this.keyboardQueue.isEmpty()) {
                if (!this.isActive) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
                KeyEvent key = null;
                Toolkit tkit = Toolkit.getDefaultToolkit();
                key = (KeyEvent)this.keyboardQueue.getFirst();
                Window sourcewin = tkit.getTopWindow();
                if (key != null) {
                    if (sourcewin != null && sourcewin.getCurrentFocus() != null) {
                        tkit.fireKeystroke(key.getKeyCode());
                    }
                    this.keyboardQueue.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyEvent popKeyEvent(RemoteDisplayWindow dw) {
        KeyEvent Return2 = null;
        Toolkit _term = Toolkit.getDefaultToolkit();
        if (dw != null && dw.getMainWindow() != null) {
            dw.getMainWindow().getCharTerminal().drawCaretOn();
        }
        LinkedList linkedList = this.keyboardQueue;
        synchronized (linkedList) {
            while (Return2 == null) {
                if (!this.keyboardQueue.isEmpty()) {
                    Return2 = (KeyEvent)this.keyboardQueue.getFirst();
                    if (Return2 == null) continue;
                    this.keyboardQueue.remove(0);
                    continue;
                }
                Return2 = this.mycheckforkeystroke();
            }
        }
        if (dw != null && dw.getMainWindow() != null) {
            dw.getMainWindow().getCharTerminal().drawCaretOff();
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getInputStatus(boolean onlyChar) {
        LinkedList linkedList = this.keyboardQueue;
        synchronized (linkedList) {
            if (this.inputStatus) {
                if (onlyChar) {
                    if (this.keyboardQueue.size() > 0) {
                        ListIterator lit = this.keyboardQueue.listIterator();
                        while (lit.hasNext()) {
                            KeyEvent ke = (KeyEvent)lit.next();
                            if (ke.getID() != 1) continue;
                            return true;
                        }
                    }
                    return false;
                }
                return this.keyboardQueue.size() > 0;
            }
            return false;
        }
    }

    public KeyEvent mycheckforkeystroke() {
        KeyEvent Return2 = null;
        int key = this.myreadKey();
        if (key == -1) {
            return null;
        }
        if (key == 10 || key == 13) {
            key = 343;
        } else if (key == 8) {
            key = 263;
        }
        if (key != 409) {
            int id = -1;
            id = Toolkit.isActionKey((int)key) ? 2 : 1;
            Return2 = new KeyEvent(key, id, (Component)new JLabel());
        }
        return Return2;
    }

    public int getLastCursorX() {
        return this.lastCursorX;
    }

    public int getLastCursorY() {
        return this.lastCursorY;
    }

    public boolean getInputStatus() {
        return this.inputStatus;
    }

    public boolean isLeftButtonDown() {
        return this.leftButtonDown;
    }

    public boolean isRightButtonDown() {
        return this.rightButtonDown;
    }

    public boolean isMiddleButtonDown() {
        return this.middleButtonDown;
    }

    public void enableInputStatus() {
        this.disable();
    }
}

