/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.extfh3;

import com.iscobol.extfh.EXTFH;
import com.iscobol.extfh3.ExtfhBase;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicOutput;
import com.iscobol.rts.ICobolVar;
import java.io.File;

public class ExtfhOutput
extends ExtfhBase
implements DynamicOutput {
    private int openMode = 0;
    boolean stripTrailingSpace;

    public ExtfhOutput() {
        super(new byte[216]);
    }

    private int tailTrim(byte[] buf, int maxLen) {
        int i;
        for (i = maxLen - 1; i >= 0 && buf[i] == 32; --i) {
        }
        if (++i < this.minRecordSize && (i = this.minRecordSize) > maxLen) {
            i = maxLen;
        }
        return i;
    }

    @Override
    public int open(String f, int lckt, int maxRec, int minRec, boolean binary, boolean append, boolean lineSeq, boolean optional, boolean assignExt) {
        this.stripTrailingSpace = Config.getProperty(".extfh.keep_trailing_spaces", true);
        this.stripTrailingSpace = !this.stripTrailingSpace;
        this.setPath(f.getBytes());
        if (lineSeq) {
            this.FCD_ORGANIZATION.set(0);
        } else {
            this.FCD_ORGANIZATION.set(1);
        }
        this.FCD_ACCESS_MODE.set(0);
        this.FCD_OPEN_MODE.set(128);
        this.FCD_NAME_LENGTH.set(this.pathLen);
        this.FCD_LOCK_MODE.set(0);
        this.setLock(lckt);
        this.FCD_FILE_FORMAT.set(0);
        this.FCD_MAX_REC_LENGTH.set(maxRec);
        if (minRec == maxRec) {
            this.FCD_RECORDING_MODE.set(0);
        } else {
            this.FCD_RECORDING_MODE.set(1);
        }
        if (!this.stripTrailingSpace) {
            this.FCD_RECORDING_MODE.set(0);
        }
        this.FCD_MIN_REC_LENGTH.set(minRec);
        this.FCD_DATA_COMPRESS.set(0);
        this.FCD_LOCKTYPES.set(0);
        if (append) {
            this.FCD_OTHER_FLAGS.set((optional ? 0 : 32) | (assignExt ? 16 : 0));
            EXTFH.extfh('\ufa03', this.XFHFCD.getMemory(), null, 0, 0, this.path, null);
        } else {
            this.FCD_OTHER_FLAGS.set(assignExt ? 16 : 0);
            EXTFH.extfh('\ufa01', this.XFHFCD.getMemory(), null, 0, 0, this.path, null);
        }
        int Return2 = this.mapError();
        if (Return2 == 1) {
            this.openMode = append ? 6 : 2;
            this.maxRecordSize = maxRec;
            this.minRecordSize = minRec;
        }
        return Return2;
    }

    @Override
    public int remove(File f) {
        byte[] name = f.getPath().getBytes();
        this.FCD_ORGANIZATION.set(3);
        this.FCD_NAME_LENGTH.set(name.length);
        this.FCD_FILE_FORMAT.set(0);
        new EXTFH();
        EXTFH.extfh('\ufaf8', this.XFHFCD.getMemory(), null, 0, 0, name, null);
        return this.mapError();
    }

    @Override
    public void setMinRecSize(int minRec) {
        this.minRecordSize = minRec;
        this.FCD_MIN_REC_LENGTH.set(this.minRecordSize);
    }

    @Override
    public int write(ICobolVar cv, int len, boolean strip) {
        return this.writeAdvancing(0, 0, cv, len, strip ? 0 : 2);
    }

    @Override
    public int write(int c) {
        return this.writeAdvancing(0, 0, new byte[]{(byte)c}, 1, 1);
    }

    @Override
    public int writeAdvancing(int kind, int lines, ICobolVar cv, int len, int opts) {
        return this.writeAdvancing(kind, lines, cv.getBytes(), len, opts);
    }

    private int writeAdvancing(int kind, int lines, byte[] buff, int len, int opts) {
        boolean strip;
        int n = len = len < buff.length ? len : buff.length;
        opts = this.stripTrailingSpace ? (opts &= 0xFFFFFFFD) : (opts |= 2);
        boolean bl = strip = (opts & 2) == 0;
        if (strip) {
            len = this.tailTrim(buff, len);
            this.FCD_CURRENT_REC_LEN.set(len);
        } else {
            this.FCD_CURRENT_REC_LEN.set(len);
        }
        switch (kind) {
            default: {
                this.FCD_LINE_COUNT.set(0);
                EXTFH.extfh('\ufaf3', this.XFHFCD.getMemory(), buff, 0, len, this.path, null);
                break;
            }
            case 1: {
                this.FCD_LINE_COUNT.set(lines);
                EXTFH.extfh('\ufae2', this.XFHFCD.getMemory(), buff, 0, len, this.path, null);
                break;
            }
            case 2: {
                this.FCD_LINE_COUNT.set(lines);
                EXTFH.extfh('\ufae1', this.XFHFCD.getMemory(), buff, 0, len, this.path, null);
                break;
            }
            case 3: {
                this.FCD_LINE_COUNT.set(0);
                EXTFH.extfh('\ufae6', this.XFHFCD.getMemory(), buff, 0, len, this.path, null);
                break;
            }
            case 4: {
                this.FCD_LINE_COUNT.set(0);
                EXTFH.extfh('\ufae5', this.XFHFCD.getMemory(), buff, 0, len, this.path, null);
            }
        }
        return this.mapError();
    }

    @Override
    public int flush() {
        return 1;
    }

    @Override
    public int close() {
        if (this.openMode != 0) {
            EXTFH.extfh('\ufa80', this.XFHFCD.getMemory(), null, 0, 0, this.path, null);
            this.openMode = 0;
            return this.mapError();
        }
        return 1;
    }
}

