/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.eleritec;

import com.iscobol.docking.eleritec.CursorProvider;
import com.iscobol.docking.eleritec.Dockable;
import com.iscobol.docking.eleritec.DockableComponentWrapper;
import com.iscobol.docking.eleritec.DockingPort;
import com.iscobol.docking.eleritec.ResourceManager;
import com.iscobol.docking.eleritec.RootSwingContainer;
import com.iscobol.docking.eleritec.UndockCursor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class DockingManager
extends JPanel {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final HashMap GLASSPANES_BY_ROOT_CONTAINER = new HashMap();
    private static final HashMap DEFAULT_CURSOR_IMAGES = DockingManager.createCursorImages();
    private static final Image EMPTY_IMAGE = ResourceManager.createImage("resources/images/emptyIcon.gif");
    private static final WeakHashMap CACHED_DRAG_INITIATORS_BY_COMPONENT = new WeakHashMap();
    private static final int DROP_FAIL = 0;
    private static final int DROP_SUCCESS = 1;
    private static final int DROP_UNDOCK = 2;
    private Dockable dockableImpl;
    private Component currentMouseoverComponent;
    private Point mouseLocation;
    private Point mouseOffsetFromDragSource;
    private boolean mouseOutOfBounds;
    private RootSwingContainer rootContainer;
    private DragEventManager dragEventManger;
    private Image currentMouseImage;
    private Dimension dragSourceSize;
    private Component cachedGlassPane;
    private String currentDockingRegion;
    private EventListener[] cachedListeners;
    private Point lastMouse;
    private UndockCursor undockWin;
    private Point mouseDragged;

    private DockingManager(RootSwingContainer root) {
        super(null);
        this.rootContainer = root;
        this.setOpaque(false);
        this.setBorder(null);
        this.mouseOffsetFromDragSource = new Point();
        this.setCursor(ResourceManager.createCursor("resources/images/emptyIcon.gif", new Point(8, 8), "Empty"));
        this.dragEventManger = new DragEventManager();
        this.addMouseListener(this.dragEventManger);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.getInsets();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintComponentImpl(g);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(null);
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
    }

    @Override
    public Component add(Component comp, int index) {
        return null;
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
    }

    @Override
    public void add(Component comp, Object constraints) {
    }

    @Override
    public Component add(Component comp) {
        return null;
    }

    @Override
    public Component add(String name, Component comp) {
        return null;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        super.setLayout(null);
    }

    private static HashMap createCursorImages() {
        HashMap<String, Image> map = new HashMap<String, Image>();
        map.put("NORTH", ResourceManager.createImage("resources/images/upArrow.gif"));
        map.put("SOUTH", ResourceManager.createImage("resources/images/downArrow.gif"));
        map.put("EAST", ResourceManager.createImage("resources/images/rightArrow.gif"));
        map.put("WEST", ResourceManager.createImage("resources/images/leftArrow.gif"));
        map.put("CENTER", ResourceManager.createImage("resources/images/stacked.gif"));
        map.put("UNKNOWN", ResourceManager.createImage("resources/images/notAllowed.gif"));
        map.put("EMPTY", EMPTY_IMAGE);
        return map;
    }

    private Frame getFrame() {
        Container Return2 = this;
        while (!(Return2 instanceof Frame)) {
            Return2 = Return2.getParent();
        }
        return (Frame)Return2;
    }

    private static DockingManager getDockingManager(Component c) {
        if (c == null) {
            return null;
        }
        RootSwingContainer root = RootSwingContainer.getRootContainer(c);
        if (root == null) {
            return null;
        }
        DockingManager mgr = (DockingManager)GLASSPANES_BY_ROOT_CONTAINER.get(root.getRootContainer());
        if (mgr == null) {
            mgr = new DockingManager(root);
            GLASSPANES_BY_ROOT_CONTAINER.put(root.getRootContainer(), mgr);
        }
        return mgr;
    }

    public static void startDrag(Component c, Point mousePosition) {
        DockingManager.startDrag(c, mousePosition, null);
    }

    public static void startDrag(Component c, Point mousePosition, String tabTitle) {
        DockingManager.startDrag(c, mousePosition, tabTitle, false);
    }

    public static void startDrag(Component c, Point mousePosition, String tabTitle, boolean allowResize) {
        if (mousePosition == null) {
            return;
        }
        DockableComponentWrapper initiator = DockableComponentWrapper.create(c, tabTitle, allowResize);
        if (initiator != null) {
            DockingManager.startDrag(initiator, mousePosition);
        }
    }

    public static void startDrag(Dockable dockable, Point mousePoint) {
        if (dockable == null) {
            return;
        }
        Component c = dockable.getInitiator();
        if (c == null || dockable.getDockable() == null) {
            return;
        }
        DockingManager mgr = DockingManager.getDockingManager(c);
        if (mgr != null) {
            mgr.startDragImpl(dockable, mousePoint);
        }
    }

    public static void stopDrag(Component c) {
        DockableComponentWrapper init = DockableComponentWrapper.create(c, null, false);
        if (init != null) {
            DockingManager.stopDrag(init);
        }
    }

    public static void stopDrag(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        DockingManager mgr = DockingManager.getDockingManager(dockable.getDockable());
        if (mgr != null) {
            mgr.stopDragImpl(dockable);
        }
    }

    private static DockingPortCursorPane createDockingPortCursorProxy(DockingPort port) {
        DockingPortCursorPane mainPane = new DockingPortCursorPane(port, "CENTER");
        Insets insets = port.getDockingInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        mainPane.createNorthRegion(insets.top);
        mainPane.createSouthRegion(insets.bottom);
        mainPane.createEastRegion(insets.right);
        mainPane.createWestRegion(insets.left);
        return mainPane;
    }

    private Image getCursorImageForRegion(String region) {
        CursorProvider provider;
        Image image;
        if (region == null) {
            region = "UNKNOWN";
        }
        Image image2 = image = (provider = this.dockableImpl.getCursorProvider()) == null ? null : this.getCursorFromProvider(provider, region);
        if (image == null) {
            image = (Image)DEFAULT_CURSOR_IMAGES.get(region);
        }
        if (image == null) {
            return this.getCursorImageForRegion("UNKNOWN");
        }
        return image;
    }

    private Image getCursorFromProvider(CursorProvider provider, String region) {
        if ("NORTH".equals(region)) {
            return provider.getNorthImage();
        }
        if ("SOUTH".equals(region)) {
            return provider.getSouthImage();
        }
        if ("EAST".equals(region)) {
            return provider.getEastImage();
        }
        if ("WEST".equals(region)) {
            return provider.getWestImage();
        }
        if ("CENTER".equals(region)) {
            return provider.getCenterImage();
        }
        return provider.getDisallowedImage();
    }

    public static void registerDockable(Component evtSrc, String desc, boolean allowResize) {
        if (evtSrc == null) {
            return;
        }
        DockableComponentWrapper init = DockableComponentWrapper.create(evtSrc, desc, allowResize);
        DockingManager.registerDockable(init);
    }

    public static void registerDockable(Dockable init) {
        if (init == null || init.getDockable() == null || init.getInitiator() == null) {
            return;
        }
        DragInitiationListener listener = DockingManager.getInitiationListener(init);
        if (listener == null) {
            listener = new DragInitiationListener();
            listener.setInitiator(init);
            init.getInitiator().addMouseMotionListener(listener);
        }
        CACHED_DRAG_INITIATORS_BY_COMPONENT.put(init.getDockable(), init);
    }

    private static Dockable getDragInitiator(Component c) {
        if (c == null) {
            return null;
        }
        Dockable initiator = (Dockable)CACHED_DRAG_INITIATORS_BY_COMPONENT.get(c);
        if (initiator == null) {
            initiator = DockableComponentWrapper.create(c, null, false);
            CACHED_DRAG_INITIATORS_BY_COMPONENT.put(c, initiator);
        }
        return initiator;
    }

    private static DragInitiationListener getInitiationListener(Dockable init) {
        EventListener[] listeners = init.getInitiator().getListeners(MouseMotionListener.class);
        if (listeners == null || listeners.length == 0) {
            return null;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof DragInitiationListener)) continue;
            return (DragInitiationListener)listeners[i];
        }
        return null;
    }

    public static void setDockingResizablePolicy(Component c, boolean resizable) {
        Dockable init = DockingManager.getDragInitiator(c);
        DockingManager.setDockingResizablePolicy(init, resizable);
    }

    public static void setDockingResizablePolicy(Dockable dockable, boolean resizable) {
        if (dockable != null) {
            dockable.setDockedLayoutResizable(resizable);
        }
    }

    public static void setDockingDescription(Component c, String desc) {
        Dockable init = DockingManager.getDragInitiator(c);
        DockingManager.setDockingDescription(init, desc);
    }

    public static void setDockingDescription(Dockable dockable, String desc) {
        if (dockable != null) {
            dockable.setDockableDesc(desc);
        }
    }

    private void startDragImpl(Dockable initiator, Point mousePoint) {
        this.removeAll();
        this.dockableImpl = initiator;
        this.cachedGlassPane = this.rootContainer.getGlassPane();
        this.rootContainer.setGlassPane(this);
        Component dragSrc = this.dockableImpl.getDockable();
        this.dragSourceSize = dragSrc.getSize();
        this.initMouseCursorOffset(mousePoint);
        this.determineMouseLocationBasedOnDragSource(mousePoint);
        this.currentDockingRegion = null;
        this.lastMouse = null;
        this.initializeListenerCaching();
        this.dockableImpl.getInitiator().addMouseMotionListener(this.dragEventManger);
        this.dockableImpl.getInitiator().addMouseListener(this.dragEventManger);
        this.setVisible(true);
        this.manageCursor();
    }

    private void stopDragImpl(Dockable init) {
        if (this.dockableImpl == null || init == null || this.dockableImpl.getDockable() != init.getDockable()) {
            return;
        }
        int docked = this.dropComponent();
        Dockable tmpReference = this.dockableImpl;
        Component dragSrc = this.dockableImpl.getDockable();
        this.dockableImpl.getInitiator().removeMouseMotionListener(this.dragEventManger);
        this.dockableImpl.getInitiator().removeMouseListener(this.dragEventManger);
        this.restoreCachedListeners();
        DragInitiationListener initiator = DockingManager.getInitiationListener(this.dockableImpl);
        if (initiator != null) {
            initiator.setEnabled(true);
        }
        this.dockableImpl = null;
        this.setVisible(false);
        this.rootContainer.setGlassPane(this.cachedGlassPane);
        this.cachedGlassPane = null;
        if (docked == 1) {
            DockingPort port = ((DockingPortCursorPane)this.currentMouseoverComponent).dockingPort;
            port.dockingComplete(this.currentDockingRegion);
            tmpReference.dockingCompleted(port);
        } else if (docked == 2) {
            tmpReference.undock(this.mouseDragged);
        } else {
            tmpReference.dockingCanceled();
        }
        this.currentDockingRegion = null;
    }

    private void paintComponentImpl(Graphics g) {
        if (this.currentDockingRegion == null) {
            this.resolveMouseCursorRegion();
        }
        if (!this.mouseOutOfBounds) {
            g.drawImage(this.currentMouseImage, this.mouseLocation.x - 8, this.mouseLocation.y - 8, null, null);
        }
    }

    private void initializeListenerCaching() {
        if (!this.dockableImpl.mouseMotionListenersBlockedWhileDragging()) {
            return;
        }
        Component initiator = this.dockableImpl.getInitiator();
        this.cachedListeners = initiator.getListeners(MouseMotionListener.class);
        if (this.cachedListeners != null) {
            for (int i = 0; i < this.cachedListeners.length; ++i) {
                initiator.removeMouseMotionListener((MouseMotionListener)this.cachedListeners[i]);
            }
        }
    }

    private void restoreCachedListeners() {
        if (this.cachedListeners == null) {
            return;
        }
        Component initiator = this.dockableImpl.getInitiator();
        for (int i = 0; i < this.cachedListeners.length; ++i) {
            initiator.addMouseMotionListener((MouseMotionListener)this.cachedListeners[i]);
        }
        this.cachedListeners = null;
    }

    private void determineMouseLocationBasedOnDragSource(Point dragSourcePoint) {
        if (this.mouseLocation != null) {
            if (this.lastMouse == null) {
                this.lastMouse = (Point)this.mouseLocation.clone();
            } else {
                this.lastMouse.setLocation(this.mouseLocation);
            }
        }
        this.mouseLocation = SwingUtilities.convertPoint(this.dockableImpl.getInitiator(), dragSourcePoint, this);
    }

    private Component resolveCurrentMouseoverComponent() {
        return SwingUtilities.getDeepestComponentAt(this, this.mouseLocation.x, this.mouseLocation.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageCursor() {
        try {
            if (this.mouseOutOfBounds) {
                this.currentMouseoverComponent = null;
                return;
            }
            this.currentMouseoverComponent = this.resolveCurrentMouseoverComponent();
            if (this.currentMouseoverComponent != this) {
                return;
            }
            DockingPort port = this.resolveDockingPortComponent();
            if (port == null) {
                return;
            }
            Component dockingCmp = (Component)((Object)port);
            Point proxyLoc = SwingUtilities.convertPoint(dockingCmp.getParent(), dockingCmp.getLocation(), this);
            Dimension proxySize = dockingCmp.getSize();
            DockingPortCursorPane proxy = DockingManager.createDockingPortCursorProxy(port);
            super.add(proxy);
            proxy.setBounds(proxyLoc.x, proxyLoc.y, proxySize.width, proxySize.height);
            this.revalidate();
            this.resolveCurrentMouseoverComponent();
        }
        finally {
            this.resolveMouseCursorRegion();
            if (this.lastMouse == null) {
                this.repaint();
            } else {
                this.repaintRect();
            }
        }
    }

    private void repaintRect() {
        int minX = Math.min(this.lastMouse.x, this.mouseLocation.x);
        int minY = Math.min(this.lastMouse.y, this.mouseLocation.y);
        int maxX = Math.max(this.lastMouse.x, this.mouseLocation.x);
        int maxY = Math.max(this.lastMouse.y, this.mouseLocation.y);
        int w = this.dragSourceSize.width + maxX - minX;
        int h = this.dragSourceSize.height + maxY - minY;
        this.repaint(minX - this.mouseOffsetFromDragSource.x - 10, minY - this.mouseOffsetFromDragSource.y - 10, w + 20, h + 20);
    }

    private void resolveMouseCursorRegion() {
        if (this.mouseOutOfBounds) {
            this.currentDockingRegion = "UNKNOWN";
            this.currentMouseImage = EMPTY_IMAGE;
            return;
        }
        if (this.currentMouseoverComponent == this || this.currentMouseoverComponent == null) {
            this.currentDockingRegion = "UNKNOWN";
            this.currentMouseImage = this.getCursorImageForRegion(this.currentDockingRegion);
            return;
        }
        DockingPortCursorPane proxy = (DockingPortCursorPane)this.currentMouseoverComponent;
        this.currentDockingRegion = proxy.region;
        if (!proxy.dockingPort.allowsDocking(this.currentDockingRegion)) {
            this.currentDockingRegion = "UNKNOWN";
        } else if (proxy.dockingPort.getDockedComponent() == this.dockableImpl.getDockable()) {
            this.currentDockingRegion = "UNKNOWN";
        }
        this.currentMouseImage = this.getCursorImageForRegion(this.currentDockingRegion);
    }

    private DockingPort resolveDockingPortComponent() {
        return this.resolveDockingPortComponent(this.mouseLocation, this.rootContainer);
    }

    private DockingPort resolveDockingPortComponent(Point mouseLoc, RootSwingContainer root) {
        Point loc = SwingUtilities.convertPoint(this, mouseLoc, root.getContentPane());
        Component deepestComponent = SwingUtilities.getDeepestComponentAt(root.getContentPane(), loc.x, loc.y);
        if (deepestComponent == null) {
            return null;
        }
        if (deepestComponent instanceof DockingPort) {
            return (DockingPort)((Object)deepestComponent);
        }
        return (DockingPort)((Object)SwingUtilities.getAncestorOfClass(DockingPort.class, deepestComponent));
    }

    private int dropComponent() {
        DockingPort resolvedTarget;
        Component wFocus;
        Component root;
        if (this.undockWin != null) {
            this.undockWin.dispose();
            this.undockWin = null;
            return 2;
        }
        if ("UNKNOWN".equals(this.currentDockingRegion)) {
            return 0;
        }
        if (!(this.currentMouseoverComponent instanceof DockingPortCursorPane)) {
            return 0;
        }
        DockingPort target = ((DockingPortCursorPane)this.currentMouseoverComponent).dockingPort;
        Component docked = target.getDockedComponent();
        Component dragSrc = this.dockableImpl.getDockable();
        if (dragSrc == docked) {
            return 0;
        }
        for (root = this.rootContainer.getRootContainer(); root != null && !(root instanceof Window); root = root.getParent()) {
        }
        if (root != null) {
            Component c0;
            for (c0 = wFocus = ((Window)root).getFocusOwner(); c0 != null && c0 != dragSrc; c0 = c0.getParent()) {
            }
            if (c0 != dragSrc) {
                wFocus = null;
            }
        } else {
            wFocus = null;
        }
        Container parent = dragSrc.getParent();
        if (parent != null) {
            DockingPort oldPort = this.getParentDockingPort(dragSrc);
            if (oldPort != null) {
                oldPort.undock(dragSrc);
            } else {
                parent.remove(dragSrc);
            }
            this.revalidateComponent(this.rootContainer.getContentPane());
        }
        if ((resolvedTarget = this.resolveDockingPortComponent()) != target) {
            target = resolvedTarget;
            ((DockingPortCursorPane)this.currentMouseoverComponent).dockingPort = target;
        }
        boolean ret = target.dock(dragSrc, this.dockableImpl.getDockableDesc(), this.currentDockingRegion, this.dockableImpl.isDockedLayoutResizable());
        this.revalidateComponent((Component)((Object)target));
        if (wFocus != null) {
            wFocus.requestFocus();
        }
        return ret ? 1 : 0;
    }

    private DockingPort getParentDockingPort(Component comp) {
        DockingPort port = (DockingPort)((Object)SwingUtilities.getAncestorOfClass(DockingPort.class, comp));
        if (port == null) {
            return null;
        }
        return port.hasDockedChild(comp) ? port : null;
    }

    private void revalidateComponent(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).revalidate();
        }
    }

    private void initMouseCursorOffset(Point mouseRelativeToDragSource) {
        boolean conversionNeeded;
        boolean bl = conversionNeeded = this.dockableImpl.getInitiator() != this.dockableImpl.getDockable();
        if (conversionNeeded) {
            mouseRelativeToDragSource = SwingUtilities.convertPoint(this.dockableImpl.getInitiator(), mouseRelativeToDragSource, this.dockableImpl.getDockable());
        }
        this.mouseOffsetFromDragSource.x = mouseRelativeToDragSource.x;
        this.mouseOffsetFromDragSource.y = mouseRelativeToDragSource.y;
    }

    private static class DragInitiationListener
    extends MouseMotionAdapter {
        private boolean enabled;
        private Dockable initiator;

        private DragInitiationListener() {
            this.setEnabled(true);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.enabled && this.initiator != null && this.initiator.isDockingEnabled()) {
                this.setEnabled(false);
                DockingManager.startDrag(this.initiator, e.getPoint());
            }
        }

        private void setInitiator(Dockable init) {
            this.initiator = init;
        }

        private void setEnabled(boolean b) {
            this.enabled = b;
        }
    }

    private static class DockingPortCursorPane
    extends JPanel {
        private String region;
        private DockingPort dockingPort;

        private DockingPortCursorPane(DockingPort port, String cursorRegion) {
            super(null);
            this.setOpaque(false);
            this.region = cursorRegion;
            this.dockingPort = port;
            if ("CENTER".equals(this.region)) {
                this.setLayout(new BorderLayout(0, 0));
            }
        }

        private void createNorthRegion(int height) {
            this.createRegion(height, "NORTH", "North");
        }

        private void createSouthRegion(int height) {
            this.createRegion(height, "SOUTH", "South");
        }

        private void createEastRegion(int width) {
            this.createRegion(width, "EAST", "East");
        }

        private void createWestRegion(int width) {
            this.createRegion(width, "WEST", "West");
        }

        private void createRegion(int dim, String cursorRegion, String layoutRegion) {
            DockingPortCursorPane pane = new DockingPortCursorPane(this.dockingPort, cursorRegion);
            Dimension d = pane.getPreferredSize();
            pane.setPreferredSize(new Dimension(dim, dim));
            super.add((Component)pane, layoutRegion);
        }
    }

    private class DragEventManager
    extends MouseAdapter
    implements MouseMotionListener {
        private DragEventManager() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DockingManager.this.determineMouseLocationBasedOnDragSource(e.getPoint());
            if (DockingManager.this.undockWin != null) {
                DockingManager.this.mouseDragged = e.getPoint();
                SwingUtilities.convertPointToScreen(DockingManager.this.mouseDragged, (Component)e.getSource());
                DockingManager.this.undockWin.setLocation(((DockingManager)DockingManager.this).mouseDragged.x + 1, ((DockingManager)DockingManager.this).mouseDragged.y + 1);
            }
            DockingManager.this.manageCursor();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            DockingManager.this.mouseOutOfBounds = false;
            if (DockingManager.this.undockWin != null) {
                DockingManager.this.undockWin.dispose();
                DockingManager.this.undockWin = null;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DockingManager.this.mouseOutOfBounds = true;
            Component dragSrc = DockingManager.this.dockableImpl.getDockable();
            DockingManager.this.undockWin = new UndockCursor(DockingManager.this.getFrame(), dragSrc.getName());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DockingManager.this.stopDragImpl(DockingManager.this.dockableImpl);
        }
    }
}

