/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.concurrent.ConcurrentHashMap;

public class LMResize
implements LayoutManager2 {
    private Dimension origContainerSize;
    private ConcurrentHashMap<Component, LMResizeData> constraintsTable = new ConcurrentHashMap();
    private int currContainerWidth;
    private int currContainerHeight;
    private int hMargin;
    private int vMargin;
    private int hPad;
    private int vPad;
    private boolean noMinX = true;
    private boolean noMinY = true;

    public LMResize() {
    }

    public LMResize(int hMargin, int vMargin, int hPad, int vPad) {
        this(hMargin, vMargin, hPad, vPad, true, true);
    }

    public LMResize(int hMargin, int vMargin, int hPad, int vPad, boolean noMinX, boolean noMinY) {
        this.hMargin = hMargin;
        this.vMargin = vMargin;
        this.hPad = hPad;
        this.vPad = vPad;
        this.noMinX = noMinX;
        this.noMinY = noMinY;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraintsTable.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component[] comps = parent.getComponents();
        int maxW = 0;
        int maxH = 0;
        for (int i = 0; i < comps.length; ++i) {
            Rectangle bds = comps[i].getBounds();
            maxW = Math.max(maxW, bds.x + bds.width);
            maxH = Math.max(maxH, bds.y + bds.height);
        }
        Dimension Return2 = new Dimension(maxW + this.hMargin, maxH + this.vMargin);
        return Return2;
    }

    private int getNewWidth(Rectangle origBounds) {
        return origBounds.width + this.currContainerWidth - this.origContainerSize.width;
    }

    private int getNewHeight(Rectangle origBounds) {
        return origBounds.height + this.currContainerHeight - this.origContainerSize.height;
    }

    private int getNewX(Rectangle origBounds) {
        return origBounds.x + this.currContainerWidth - this.origContainerSize.width;
    }

    private int getNewY(Rectangle origBounds) {
        return origBounds.y + this.currContainerHeight - this.origContainerSize.height;
    }

    private void setOriginalContainerSize(Dimension d) {
        if (d != null && d.width > 0 && d.height > 0) {
            this.origContainerSize = d;
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.origContainerSize == null) {
            this.setOriginalContainerSize(parent.getSize());
            return;
        }
        Dimension currContainerSize = parent.getSize();
        this.currContainerWidth = currContainerSize.width;
        this.currContainerHeight = currContainerSize.height;
        for (Component comp : this.constraintsTable.keySet()) {
            LMResizeData lData = this.constraintsTable.get(comp);
            Rectangle currCompBounds = comp.getBounds();
            int newWidth = (lData.action & 1) == 1 ? (this.noMinX ? this.getNewWidth(lData.origBounds) : Math.max(lData.origBounds.width, this.getNewWidth(lData.origBounds))) : currCompBounds.width;
            int newHeight = (lData.action & 4) == 4 ? (this.noMinY ? this.getNewHeight(lData.origBounds) : Math.max(lData.origBounds.height, this.getNewHeight(lData.origBounds))) : currCompBounds.height;
            int newX = (lData.action & 2) == 2 ? (this.noMinX ? this.getNewX(lData.origBounds) : Math.max(lData.origBounds.x, this.getNewX(lData.origBounds))) : currCompBounds.x;
            int newY = (lData.action & 8) == 8 ? (this.noMinY ? this.getNewY(lData.origBounds) : Math.max(lData.origBounds.y, this.getNewY(lData.origBounds))) : currCompBounds.y;
            if (newWidth == currCompBounds.width && newHeight == currCompBounds.height && newX == currCompBounds.x && newY == currCompBounds.y) continue;
            comp.setBounds(newX, newY, newWidth, newHeight);
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            constraints = new LMResizeData(0);
        }
        if (!(constraints instanceof LMResizeData)) {
            throw new IllegalArgumentException("LMResizeData object required.");
        }
        ((LMResizeData)constraints).origBounds = comp.getBounds();
        this.constraintsTable.put(comp, (LMResizeData)constraints);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    static int getRight(Component c) {
        Rectangle r = c.getBounds();
        return r.x + r.width;
    }

    static int getBottom(Component c) {
        Rectangle r = c.getBounds();
        return r.y + r.height;
    }

    static int getTop(Component c) {
        return c.getLocation().y;
    }

    static int getLeft(Component c) {
        return c.getLocation().x;
    }

    Dimension getPreferredSize(Component c) {
        Dimension d = c.getPreferredSize();
        d.width += this.hPad;
        d.height += this.vPad;
        return d;
    }
}

