/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DisplayVariableDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JTextField variableTxt;
    private JTextField moduleTxt;
    private JTextField propertyTxt;
    private JCheckBox treeChk;
    private JCheckBox hexChk;
    private JButton ok;
    private JButton close;

    public DisplayVariableDialog(JFrame parent, String title, String def, String defmodule, boolean showInWatchedVar) {
        super(parent, title, true);
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        this.treeChk = new JCheckBox("Show in Watched Variables");
        this.treeChk.setMnemonic('v');
        if (showInWatchedVar) {
            this.treeChk.setSelected(true);
            this.treeChk.setEnabled(false);
        }
        Dimension d = layout.getPreferredSize(this.treeChk);
        this.treeChk.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(this.treeChk);
        LMResize varPanelLayout = new LMResize(5, 5, 5, 0);
        JPanel varPanel = new JPanel(varPanelLayout);
        varPanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.hexChk = new JCheckBox("Hexadecimal");
        this.hexChk.setSelected(Settings.getHexOption());
        this.hexChk.setMnemonic('h');
        d = varPanelLayout.getPreferredSize(this.hexChk);
        this.hexChk.setBounds(10, 10, d.width, d.height);
        varPanel.add(this.hexChk);
        JLabel variableLbl = new JLabel("Variable name:");
        d = varPanelLayout.getPreferredSize(variableLbl);
        variableLbl.setBounds(LMResize.getLeft(this.hexChk), LMResize.getBottom(this.hexChk) + 15, d.width, d.height);
        varPanel.add(variableLbl);
        this.variableTxt = new JTextField(30);
        this.variableTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.variableTxt));
        JLabel moduleLbl = new JLabel("Method/Program name:");
        d = varPanelLayout.getPreferredSize(moduleLbl);
        moduleLbl.setBounds(LMResize.getLeft(variableLbl), LMResize.getBottom(variableLbl) + 15, d.width, d.height);
        varPanel.add(moduleLbl);
        this.moduleTxt = new JTextField(30);
        this.moduleTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.moduleTxt));
        this.moduleTxt.setBounds(LMResize.getRight(moduleLbl) + 5, LMResize.getTop(moduleLbl), 200, this.moduleTxt.getPreferredSize().height);
        varPanel.add((Component)this.moduleTxt, new LMResizeData(1));
        this.variableTxt.setBounds(LMResize.getLeft(this.moduleTxt), LMResize.getTop(variableLbl), 200, this.variableTxt.getPreferredSize().height);
        varPanel.add((Component)this.variableTxt, new LMResizeData(1));
        if (def != null) {
            this.variableTxt.setText(def);
            this.variableTxt.select(0, def.length());
        }
        if (defmodule != null) {
            this.moduleTxt.setText(defmodule);
        }
        JLabel propertyLbl = new JLabel("Property name:");
        d = varPanelLayout.getPreferredSize(propertyLbl);
        propertyLbl.setBounds(LMResize.getLeft(moduleLbl), LMResize.getBottom(moduleLbl) + 15, d.width, d.height);
        varPanel.add(propertyLbl);
        this.propertyTxt = new JTextField();
        this.propertyTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.propertyTxt));
        this.propertyTxt.setBounds(LMResize.getLeft(this.moduleTxt), LMResize.getTop(propertyLbl), 200, this.propertyTxt.getPreferredSize().height);
        varPanel.add((Component)this.propertyTxt, new LMResizeData(1));
        d = varPanelLayout.preferredLayoutSize(varPanel);
        varPanel.setBounds(LMResize.getLeft(this.treeChk), LMResize.getBottom(this.treeChk) + 15, d.width, d.height);
        this.getContentPane().add((Component)varPanel, new LMResizeData(1));
        this.ok = new JButton("OK");
        this.ok.setMnemonic('o');
        this.ok.addActionListener(e -> {
            this.makeString();
            this.closeDialog();
        });
        this.close = new JButton("Close");
        this.close.setMnemonic('c');
        this.close.addActionListener(e -> this.closeDialog());
        this.treeChk.setHorizontalTextPosition(4);
        d = layout.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(varPanel) - d.width + 5, LMResize.getBottom(varPanel) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.ok.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.ok, new LMResizeData(10));
        this.pack();
        DisplayVariableDialog.setFirstFocusedComponent(this.variableTxt);
        this.setDefaultButton(this.ok);
    }

    private void makeString() {
        String var = this.variableTxt.getText();
        if (var.length() > 0) {
            String prop;
            this.commandString = "display";
            if (this.treeChk.isSelected()) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-tree";
            }
            if (this.hexChk.isSelected()) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-x";
            }
            if (this.moduleTxt.getText().length() > 0) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "-c";
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + this.moduleTxt.getText();
            }
            this.commandString = this.commandString + " ";
            this.commandString = this.commandString + var;
            if (this.propertyTxt != null && (prop = this.propertyTxt.getText()).length() > 0) {
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + "property";
                this.commandString = this.commandString + " ";
                this.commandString = this.commandString + prop;
            }
        } else {
            this.commandString = null;
        }
    }
}

