/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;

public class DebugFrame
extends JFrame {
    private static final long serialVersionUID = 123L;
    private KeyEventPostProcessor keyEventPostProcessor;
    private boolean keyEventPostProcessorAdded;
    private Rectangle lastBounds;
    private JButton defaultButton;
    private JFrame owner;

    public DebugFrame(JFrame owner, String title) {
        super(title);
        this.owner = owner;
        this.keyEventPostProcessor = e -> {
            if (e.getID() == 401 && e.getKeyCode() == 27) {
                this.closeFrame();
            }
            return false;
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DebugFrame.this.closeFrame();
            }
        });
    }

    public Rectangle getLastBounds() {
        return this.lastBounds;
    }

    public void closeFrame() {
        this.lastBounds = this.getBounds();
        this.dispose();
        this.removeKeyEventPostProcessor();
    }

    public void openDialog(Rectangle bounds) {
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        if (bounds != null) {
            this.setBounds(bounds);
        } else {
            this.setLocationRelativeTo(this.owner);
        }
        this.addKeyEventPostProcessor();
        super.setVisible(true);
    }

    protected void setDefaultButton(JButton btn) {
        this.defaultButton = btn;
    }

    protected void addKeyEventPostProcessor() {
        if (!this.keyEventPostProcessorAdded) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.keyEventPostProcessor);
            this.keyEventPostProcessorAdded = true;
        }
    }

    protected void removeKeyEventPostProcessor() {
        if (this.keyEventPostProcessorAdded) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.keyEventPostProcessor);
            this.keyEventPostProcessorAdded = false;
        }
    }
}

