/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class CustomizeCommandsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private JTable commandTable;
    private DefaultTableModel commandTableModel;
    private static final String[][] commandNames = new String[][]{{"b0", "debugger.commands.alias.b0"}, {"break", "debugger.commands.alias.break"}, {"clear", "debugger.commands.alias.clear"}, {"continue", "debugger.commands.alias.continue"}, {"display", "debugger.commands.alias.display"}, {"env", "debugger.commands.alias.env"}, {"exit", "debugger.commands.alias.exit"}, {"f", "debugger.commands.alias.f"}, {"fb", "debugger.commands.alias.fb"}, {"ff", "debugger.commands.alias.ff"}, {"ft", "debugger.commands.alias.ft"}, {"gc", "debugger.commands.alias.gc"}, {"help", "debugger.commands.alias.help"}, {"infostack", "debugger.commands.alias.infostack"}, {"jump", "debugger.commands.alias.jump"}, {"length", "debugger.commands.alias.length"}, {"let", "debugger.commands.alias.let"}, {"line", "debugger.commands.alias.line"}, {"list", "debugger.commands.alias.list"}, {"m0", "debugger.commands.alias.m0"}, {"memory", "debugger.commands.alias.memory"}, {"monitor", "debugger.commands.alias.monitor"}, {"offset", "debugger.commands.alias.offset"}, {"next", "debugger.commands.alias.next"}, {"outpar", "debugger.commands.alias.outpar"}, {"outprog", "debugger.commands.alias.outprog"}, {"pause", "debugger.commands.alias.pause"}, {"prog", "debugger.commands.alias.prog"}, {"quit", "debugger.commands.alias.quit"}, {"readsession", "debugger.commands.alias.readsession"}, {"run", "debugger.commands.alias.run"}, {"step", "debugger.commands.alias.step"}, {"stoff", "debugger.commands.alias.stoff"}, {"ston", "debugger.commands.alias.ston"}, {"thread", "debugger.commands.alias.thread"}, {"to", "debugger.commands.alias.to"}, {"troff", "debugger.commands.alias.troff"}, {"tron", "debugger.commands.alias.tron"}, {"unmonitor", "debugger.commands.alias.unmonitor"}, {"w0", "debugger.commands.alias.w0"}, {"wb", "debugger.commands.alias.wb"}, {"writesession", "debugger.commands.alias.writesession"}, {"wt", "debugger.commands.alias.wt"}, {"w@", "debugger.commands.alias.w@"}};

    public CustomizeCommandsDialog(JFrame parent, String title) {
        super(parent, title, true);
    }

    @Override
    protected void createContents(JPanel mainPanel) {
        this.commandTableModel = new DefaultTableModel();
        this.commandTableModel.addColumn("Command");
        this.commandTableModel.addColumn("Alias");
        for (int i = 0; i < commandNames.length; ++i) {
            this.commandTableModel.addRow(new Object[]{commandNames[i][0], Settings.getCommandAlias(commandNames[i][1])});
        }
        this.commandTable = new JTable(this.commandTableModel){
            MyTableEditor editor;

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 1) {
                    if (this.editor == null) {
                        JTextField tf = new JTextField();
                        tf.setBorder(null);
                        this.editor = new MyTableEditor(tf);
                    }
                    return this.editor;
                }
                return null;
            }
        };
        this.commandTable.setShowGrid(true);
        this.commandTable.setFont(this.getFont().deriveFont(13.0f));
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)new JScrollPane(this.commandTable), "Center");
    }

    @Override
    protected void performApply() {
        for (int i = 0; i < this.commandTable.getRowCount(); ++i) {
            Settings.setCommandAlias(commandNames[i][1], (String)this.commandTable.getValueAt(i, 1));
        }
        super.performApply();
    }

    private class MyTableEditor
    extends DefaultCellEditor {
        public MyTableEditor(JTextField tf) {
            super(tf);
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            char[] c = tf.getText().toCharArray();
            boolean ok = true;
            if (c.length == 0) {
                ok = false;
            }
            for (int i = 0; i < c.length && ok; ++i) {
                if (Character.isLetterOrDigit(c[i])) continue;
                ok = false;
            }
            if (ok) {
                this.fireEditingStopped();
                CustomizeCommandsDialog.this.setDirty(true);
            }
            return ok;
        }
    }
}

