/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IVariableCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LetCommand
implements DebugCommand,
IVariableCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 6;
    public static final String SHORT_DESCRIPTION = " : assign new value to variable";
    public static final String STRING_ID = "let";
    public static final String HELP_PAGE = "let.html";
    public static final String USAGE = " usage:" + eol + "   let [" + "-x" + "] [-c class-name[:>method-name]] variable-name = value" + eol + "or let [-c class-name[:>method-name]] control-name|control-handle|window-handle " + "prop" + "|" + "property" + " property-name = property-value" + eol + "or let " + "-env" + " env-name = value";
    private VarName varname;
    private String propertyName;
    private String envName;
    private boolean hexadecimal;
    private String value;
    private String className;

    public LetCommand() {
    }

    public LetCommand(VarName vn, String className, boolean hex, String val) {
        this.varname = vn;
        this.hexadecimal = hex;
        this.value = val;
        this.className = className;
    }

    public LetCommand(VarName vn, String className, String propName, String val) {
        this.varname = vn;
        this.propertyName = propName;
        this.value = val;
        this.className = className;
    }

    public LetCommand(String envName, String val) {
        this.envName = envName;
        this.value = val;
    }

    public String getEnvName() {
        return this.envName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean acceptAsHex() {
        return this.hexadecimal;
    }

    public String getNewValue() {
        return this.value;
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.varname != null);
        if (this.varname != null) {
            this.varname.writeExternal(out);
        }
        RtsUtil.writeUTFOptmz(this.propertyName, out);
        RtsUtil.writeUTFOptmz(this.envName, out);
        out.writeBoolean(this.hexadecimal);
        RtsUtil.writeUTF(this.value, out);
        RtsUtil.writeUTFOptmz(this.className, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.varname = new VarName();
            this.varname.readExternal(in);
        } else {
            this.varname = new VarName();
        }
        this.propertyName = RtsUtil.readUTFOptmz(in);
        this.envName = RtsUtil.readUTFOptmz(in);
        this.hexadecimal = in.readBoolean();
        this.value = RtsUtil.readUTF(in);
        this.className = RtsUtil.readUTFOptmz(in);
    }
}

