/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DirectoryCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 46;
    public static final String SHORT_DESCRIPTION = " : Add specified directory to front of 'debug.code_prefix'";
    public static final String STRING_ID = "directory";
    public static final String HELP_PAGE = "directory.html";
    public static final String USAGE = "usage:" + eol + "   directory dirname" + eol + "or directory (show path)";
    private String dirname;

    public DirectoryCommand() {
    }

    public DirectoryCommand(String dirname) {
        this.dirname = dirname;
    }

    public String getDirectory() {
        return this.dirname;
    }

    @Override
    public int getId() {
        return 46;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.dirname, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.dirname = RtsUtil.readUTFOptmz(in);
    }
}

