/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Child;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.ErrorResponse;
import com.iscobol.debugger.RawTextResponse;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Vector;

public class OutputChild
extends Child
implements Runnable {
    private PrintStream out;
    private DataInput in;
    private Vector<DebugResponse> responseQueue = new Vector();
    private boolean alive;
    private String remoteEncoding;

    public OutputChild(InputStream in, PrintStream out) {
        this.in = new DataInputStream(in);
        this.out = out;
        this.alive = true;
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.t.start();
    }

    private PrintStream getOut() {
        return this.out != null ? this.out : System.out;
    }

    @Override
    public void run() {
        Config.markNoIscobolRuntimeThread();
        try {
            int protocolVersion = this.in.readInt();
            if ((long)protocolVersion != 1000006L) {
                throw new RuntimeException("Debugger protocol incompatibility: local = 1000006, remote = " + protocolVersion);
            }
            this.remoteEncoding = RtsUtil.readUTFOptmz(this.in);
            block7: while (!this.isStopped()) {
                int respId = this.in.readInt();
                switch (respId) {
                    case 1: {
                        DebugResponse resp = new DebugResponse();
                        resp.readExternal(this.in);
                        this.setResponse(resp);
                        continue block7;
                    }
                    case 2: {
                        ErrorResponse er = new ErrorResponse();
                        er.readExternal(this.in);
                        System.err.println(er.getErrorMessage());
                        continue block7;
                    }
                    case 3: {
                        RawTextResponse rtr = new RawTextResponse();
                        rtr.readExternal(this.in);
                        this.getOut().println(rtr.getRawText());
                        continue block7;
                    }
                }
                throw new RuntimeException("Invalid response");
            }
        }
        catch (IOException ex) {
            this.setResponse(new DebugResponse(103, ""));
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.responseQueue.addElement(new DebugResponse(103, ""));
        this.notifyAll();
    }

    private synchronized void setResponse(DebugResponse resp) {
        this.responseQueue.addElement(resp);
        this.notifyAll();
    }

    public synchronized DebugResponse getResponse(int blockingMode) {
        if (this.responseQueue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        while (true) {
            int size = this.responseQueue.size();
            for (int i = 0; i < size; ++i) {
                DebugResponse Return2 = this.responseQueue.elementAt(i);
                if (Return2.getFirstBlockMode() != blockingMode && blockingMode >= 0) continue;
                this.responseQueue.removeElementAt(i);
                return Return2;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    String getRemoteEncoding() {
        return this.remoteEncoding;
    }
}

