/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.rts.Base64;
import com.iscobol.rts.SMAPReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.InflaterInputStream;

public class DebugSMAPReader
extends SMAPReader {
    private Vector<DebugCopyFile> copyFiles;
    private Vector<DebugLine> dbgLines;
    private Vector<DebugParagraph> dbgParagraphs;
    private String sourceFileName;
    private String[] fileSeparator;
    private String[][] _78levels;
    private String[] compilerProps;
    private byte[] listingInfos;

    public DebugSMAPReader(InputStream in, String debugInfoStr) throws IOException {
        super(in, debugInfoStr == null);
        if (debugInfoStr != null) {
            int f = this.newFormat;
            if (f == 0) {
                this.initVectors();
                this.newFormat = 6;
                this.compilerProps = new String[]{"iscobol.compiler.debug.replaced_source=0"};
            }
            byte[] b = Base64.decode(debugInfoStr.getBytes("utf-8"));
            DataInputStream dIn = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(b)));
            this.initDebugInfo(dIn);
            this.readCopyStmts(dIn);
            if (f == 0) {
                TreeSet<FileObj> ts = new TreeSet<FileObj>();
                class FileObj
                implements Comparable<FileObj> {
                    final int index;
                    final String name;

                    FileObj(int i, String n) {
                        this.index = i;
                        this.name = n;
                    }

                    @Override
                    public int compareTo(FileObj o) {
                        return this.index - o.index;
                    }
                }
                ts.add(new FileObj(0, this.sourceFileName));
                for (String[] ss : this.getCopyStatements()) {
                    this.copyFiles.addElement(new DebugCopyFile(ss[0], Integer.parseInt(ss[1]), ss[2]));
                    ts.add(new FileObj(Integer.parseInt(ss[4]), ss[2]));
                }
                Vector<String> fileNames = this.getFileNames();
                for (FileObj fo : ts) {
                    fileNames.addElement(fo.name);
                }
            } else {
                this.getCopyStatements().clear();
            }
            this.timestamp = dIn.readLong();
            dIn.close();
        }
    }

    @Override
    protected void buildOld2(DataInputStream dIn) throws IOException {
        super.buildOld2(dIn);
        this.buildExt(dIn, null);
    }

    @Override
    protected void buildExt(DataInputStream dIn, DataInputStream dIn0) throws IOException {
        DataInputStream d = dIn0 != null ? dIn0 : dIn;
        boolean hasInfo = d.readBoolean();
        if (!hasInfo) {
            return;
        }
        if (this.newFormat < 5) {
            this.timestamp = d.readLong();
        }
        this.initVectors();
        for (String[] ss : this.getCopyStatements()) {
            this.copyFiles.addElement(new DebugCopyFile(ss[0], Integer.parseInt(ss[1]), ss[2]));
        }
        if (this.newFormat < 6) {
            this.initDebugInfo(d);
        }
        if (this.newFormat >= 4) {
            this.compilerProps = new String[d.readInt()];
            for (int j = 0; j < this.compilerProps.length; ++j) {
                this.compilerProps[j] = d.readUTF();
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[8192];
        int r = dIn.read(b);
        while (r > 0) {
            baos.write(b, 0, r);
            r = dIn.read(b);
        }
        this.listingInfos = baos.toByteArray();
    }

    private void initDebugInfo(DataInputStream d) throws IOException {
        int i;
        this.fileSeparator = new String[]{d.readUTF(), d.readUTF()};
        if (this.newFormat < 6) {
            int repCount = d.readInt();
            for (i = 0; i < repCount; ++i) {
                d.readByte();
                d.readUTF();
                d.readUTF();
            }
        }
        int stmtCount = d.readInt();
        for (i = 0; i < stmtCount; ++i) {
            this.dbgLines.addElement(new DebugLine(d.readInt(), d.readShort(), d.readInt(), d.readBoolean()));
        }
        int parCount = d.readInt();
        for (int i2 = 0; i2 < parCount; ++i2) {
            this.dbgParagraphs.add(new DebugParagraph(d.readUTF(), d.readUTF(), d.readInt(), d.readShort(), d.readBoolean(), d.readInt(), d.readBoolean()));
        }
        this.sourceFileName = d.readUTF();
        int constCount = d.readInt();
        this._78levels = new String[constCount][2];
        for (int i3 = 0; i3 < constCount; ++i3) {
            this._78levels[i3][0] = d.readUTF();
            this._78levels[i3][1] = d.readUTF();
        }
    }

    public String[] getCompilerProps() {
        return this.compilerProps;
    }

    public Vector<DebugCopyFile> getCopyFiles() {
        return this.copyFiles;
    }

    public Vector<DebugLine> getDbgLines() {
        return this.dbgLines;
    }

    public Vector<DebugParagraph> getDbgParagraphs() {
        return this.dbgParagraphs;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String[] getFileSeparator() {
        return this.fileSeparator;
    }

    public byte[] getListingInfos() {
        return this.listingInfos;
    }

    public String[][] get_78Levels() {
        return this._78levels;
    }

    private void initVectors() {
        this.copyFiles = new Vector();
        this.dbgLines = new Vector();
        this.dbgParagraphs = new Vector();
    }
}

