/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.Expression;
import com.iscobol.interfaces.debugger.IBreakpoint;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;

public class Breakpoint
implements IBreakpoint,
DataExternalizable {
    private static final long serialVersionUID = 1000006L;
    private int lineNumber;
    private String cobolFile;
    private int cobolFileIndex;
    private String paragraph;
    private String progName;
    private Expression condition;
    private boolean enabled = true;
    private boolean programBreakpoint;
    private String methodName;
    private boolean fromCobolRef;

    public Breakpoint() {
    }

    public Breakpoint(CobolRef ref) {
        this.lineNumber = ref.lineNo();
        this.cobolFile = ref.filename();
        this.progName = ref.progname();
        this.setFileIndex(ref.getFileIndex());
        this.fromCobolRef = true;
    }

    public Breakpoint(int line, String file, int fileIndex, String prog, boolean enabled) {
        this.lineNumber = line;
        this.cobolFile = file;
        this.progName = prog;
        this.enabled = enabled;
        this.setFileIndex(fileIndex);
    }

    public Breakpoint(int line, String file, int fileIndex, String prog, Expression cond, boolean enabled) {
        this.lineNumber = line;
        this.cobolFile = file;
        this.progName = prog;
        this.enabled = enabled;
        this.setFileIndex(fileIndex);
        this.condition = cond;
    }

    public Breakpoint(String paragraph, String file, String prog, boolean enabled) {
        this.paragraph = paragraph;
        this.cobolFile = file;
        this.progName = prog;
        this.enabled = enabled;
    }

    public Breakpoint(String paragraph, String file, String prog, Expression cond, boolean enabled) {
        this(paragraph, 0, file, 0, prog, cond, enabled);
    }

    public Breakpoint(String paragraph, int lineNumber, String file, int fileIndex, String prog, Expression cond, boolean enabled) {
        this.paragraph = paragraph;
        this.lineNumber = lineNumber;
        this.cobolFile = file;
        this.progName = prog;
        this.enabled = enabled;
        this.setFileIndex(fileIndex);
        this.condition = cond;
    }

    private void setFileIndex(int fi) {
        this.cobolFileIndex = fi;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    @Override
    public String getParagraph() {
        return this.paragraph;
    }

    @Override
    public String getFile() {
        return this.cobolFile;
    }

    @Override
    public String getProgram() {
        return this.progName;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean en) {
        this.enabled = en;
    }

    @Override
    public int getFileIndex() {
        return this.cobolFileIndex;
    }

    public boolean isProgramBreakpoint() {
        return this.programBreakpoint;
    }

    public void setProgramBreakpoint(boolean programBreakpoint) {
        this.programBreakpoint = programBreakpoint;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String n) {
        this.methodName = n;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Breakpoint)) {
            return false;
        }
        Breakpoint bp = (Breakpoint)other;
        if (!(this.fromCobolRef || bp.fromCobolRef || this.paragraph == null && bp.paragraph == null)) {
            if (this.paragraph == null || bp.paragraph == null) {
                return false;
            }
            if (!this.paragraph.equalsIgnoreCase(bp.paragraph)) {
                return false;
            }
        } else if (this.lineNumber != bp.lineNumber) {
            return false;
        }
        if (!Breakpoint.getBasename(this.cobolFile).equalsIgnoreCase(Breakpoint.getBasename(bp.cobolFile))) {
            return false;
        }
        if (this.cobolFileIndex != bp.cobolFileIndex && this.cobolFileIndex >= 0 && bp.cobolFileIndex >= 0) {
            return false;
        }
        if (this.progName == null || bp.progName == null) {
            return true;
        }
        return this.progName.equals(bp.progName);
    }

    private static String getBasename(String f) {
        if (f == null) {
            return f;
        }
        return new File(f).getName();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.programBreakpoint) {
            ret.append("[program: " + this.progName);
        } else if (this.methodName != null) {
            ret.append("[method: " + this.methodName);
        } else {
            if (this.lineNumber > 0) {
                ret.append("[line: " + this.lineNumber);
            } else {
                ret.append("[paragraph: " + this.paragraph);
            }
            ret.append(", file: " + this.cobolFile);
            if (this.cobolFileIndex > 0) {
                ret.append(", index: " + this.cobolFileIndex);
            }
        }
        if (this.condition != null) {
            ret.append(". ").append("when");
            if (this.condition.isEnvProperty()) {
                ret.append(" ").append("-env");
            } else if (this.condition.isHex()) {
                ret.append(" ").append("-x");
            }
            ret.append(" ");
            ret.append(this.condition);
        }
        ret.append("]");
        return ret.toString();
    }

    @Override
    public String getDebugCommand() {
        StringBuffer Return2 = new StringBuffer();
        if (this.programBreakpoint) {
            Return2.append("b0");
            if (!this.enabled) {
                Return2.append(" -d ");
            }
            Return2.append(" " + this.progName);
        } else if (this.methodName != null) {
            Return2.append("m0");
            if (!this.enabled) {
                Return2.append(" -d ");
            }
            Return2.append(" " + this.methodName);
        } else {
            Return2.append("break");
            if (!this.enabled) {
                Return2.append(" -d ");
            }
            if (this.paragraph != null) {
                Return2.append(" " + this.paragraph);
            } else {
                Return2.append(" " + this.lineNumber);
            }
            Return2.append(" \"" + this.cobolFile + "\"");
            if (this.cobolFileIndex >= 0) {
                Return2.append(" -fi " + this.cobolFileIndex);
            }
            if (this.progName != null) {
                Return2.append(" " + this.progName);
            }
            if (this.condition != null) {
                Return2.append(" ").append("when");
                if (this.condition.isEnvProperty()) {
                    Return2.append(" ").append("-env");
                } else if (this.condition.isHex()) {
                    Return2.append(" ").append("-x");
                }
                Return2.append(" ").append(this.condition);
            }
        }
        return Return2.toString();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.lineNumber);
        RtsUtil.writeUTFOptmz(this.cobolFile, out);
        out.writeInt(this.cobolFileIndex);
        RtsUtil.writeUTFOptmz(this.paragraph, out);
        RtsUtil.writeUTFOptmz(this.progName, out);
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.programBreakpoint);
        RtsUtil.writeUTFOptmz(this.methodName, out);
        out.writeBoolean(this.condition != null);
        if (this.condition != null) {
            this.condition.writeExternal(out);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.lineNumber = in.readInt();
        this.cobolFile = RtsUtil.readUTFOptmz(in);
        this.cobolFileIndex = in.readInt();
        this.paragraph = RtsUtil.readUTFOptmz(in);
        this.progName = RtsUtil.readUTFOptmz(in);
        this.enabled = in.readBoolean();
        this.programBreakpoint = in.readBoolean();
        this.methodName = RtsUtil.readUTFOptmz(in);
        if (in.readBoolean()) {
            this.condition = new Expression();
            this.condition.readExternal(in);
        } else {
            this.condition = null;
        }
    }
}

