/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.StandardPhases;
import com.iscobol.compiler.phases.Phases;
import com.iscobol.compiler.phases.PhasesFactory;
import com.iscobol.compiler.remote.FileData;
import com.iscobol.compiler.remote.InputData;
import com.iscobol.compiler.remote.OutputData;
import com.iscobol.compiler.remote.PPFileOutput;
import com.iscobol.compiler.remote.PccRunnable;
import com.iscobol.compiler.remote.RemoteBridgeFile;
import com.iscobol.compiler.remote.RemoteErrors;
import com.iscobol.compiler.remote.RemoteFile;
import com.iscobol.compiler.remote.RemoteFileFinder;
import com.iscobol.compiler.remote.XmlParseException;
import com.iscobol.compiler.remote.server.PreProcessor;
import com.iscobol.compiler.remote.server.RemoteCompilerClassLoader;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.remote.IRemoteCompiler;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RemoteCompiler
implements IRemoteCompiler {
    static RemoteCompiler instance;
    private static Hashtable serverCallbackHandlers;
    private ArrayList preProcessors = new ArrayList();
    private int portNumber = 11999;
    private String hostName;
    private String outputFolder;
    private String deploymentFolder;
    private File outputFolderFile;
    private boolean cleanOutputFolderWhenExit = true;
    private PccRunnable ipcc;
    private boolean ide;

    public RemoteCompiler(Element element) throws XmlParseException {
        this(element, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RemoteCompiler(Element element, PccRunnable ipcc) throws XmlParseException {
        this.ipcc = ipcc;
        if (element != null) {
            String a;
            String s = element.getAttribute("hostName");
            if (s != null && s.length() > 0) {
                this.hostName = s;
            }
            try {
                this.portNumber = Integer.parseInt(element.getAttribute("portNumber"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.cleanOutputFolderWhenExit = Boolean.valueOf(element.getAttribute("cleanOutputFolderWhenExit"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputFolder = element.getAttribute("outputFolder");
            if (this.outputFolder != null && this.outputFolder.length() > 0) {
                this.outputFolderFile = new File(this.outputFolder);
                if (!this.outputFolderFile.exists()) throw new XmlParseException("Invalid output folder: '" + this.outputFolder + "'");
                if (!this.outputFolderFile.isDirectory()) {
                    throw new XmlParseException("Invalid output folder: '" + this.outputFolder + "'");
                }
            } else {
                this.outputFolderFile = new File(System.getProperty("java.io.tmpdir"));
            }
            this.outputFolderFile = new File(this.outputFolderFile.getAbsolutePath() + "/iscobol-remote-compiler-" + this.portNumber);
            if (!this.outputFolderFile.exists()) {
                this.outputFolderFile.mkdir();
            }
            if ((a = element.getAttribute("deploymentFolder")) != null && a.length() > 0) {
                this.deploymentFolder = a;
                File f = new File(this.deploymentFolder);
                if (!f.exists()) throw new XmlParseException("Invalid deployment folder: '" + this.deploymentFolder + "'");
                if (!f.isDirectory()) {
                    throw new XmlParseException("Invalid deployment folder: '" + this.deploymentFolder + "'");
                }
            }
            NodeList nl = element.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1 || !n.getNodeName().equals("preProcessor")) continue;
                this.preProcessors.add(new PreProcessor((Element)n));
            }
            return;
        }
        this.cleanOutputFolderWhenExit = true;
        this.outputFolderFile = new File(System.getProperty("java.io.tmpdir"));
        if (this.outputFolderFile.exists()) return;
        this.outputFolderFile.mkdir();
    }

    public static void addServerCallbackHandler(int sessionId, IServerCallbackHandler scbh) {
        Integer I2 = new Integer(sessionId);
        if (!serverCallbackHandlers.containsKey(I2)) {
            serverCallbackHandlers.put(I2, scbh);
        }
    }

    public static void removeServerCallbackHandler(int sessionId, IServerCallbackHandler scbh) {
        serverCallbackHandlers.remove(new Integer(sessionId));
    }

    public static void dispatchBrokenConnection(int sessionId) {
        IServerCallbackHandler scbh = (IServerCallbackHandler)serverCallbackHandlers.get(new Integer(sessionId));
        if (scbh != null) {
            scbh.brokenConnection();
        }
    }

    public static RemoteCompiler getInstance() {
        if (instance == null) {
            RemoteCompiler.createNewInstance();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNewInstance() {
        boolean ide = Config.getProperty("iscobol.as.ide", false);
        File remoteConfFile = new File(Config.getProperty(".remotecompiler.conf", System.getProperty("user.home") + "/remoteCompiler.xml"));
        Element remoteCompilerElem = null;
        if (!ide || remoteConfFile.exists() && remoteConfFile.isFile() && remoteConfFile.canRead()) {
            DocumentBuilder builder;
            block31: {
                DocumentBuilderFactory factory = RtsUtil.newDocumentBuilderFactory();
                builder = null;
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    if (ide) break block31;
                    System.exit(-2);
                }
            }
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(new FileInputStream(remoteConfFile));
                Document document = builder.parse(new InputSource(reader));
                remoteCompilerElem = document.getDocumentElement();
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found: " + remoteConfFile);
                if (!ide) {
                    System.exit(-3);
                }
            }
            catch (SAXException e) {
                e.printStackTrace();
                if (!ide) {
                    System.exit(-4);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!ide) {
                    System.exit(-5);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        PccRunnable ipcc = new PccRunnable(){

            @Override
            public Pcc run(String filename, String outDir, OptionList ol, Phases phases, Errors err, Reader reader, boolean generateCode, FileFinder fFinder) throws ErrorInCompilationException {
                return Pcc.run(filename, outDir, ol, phases, err, reader, generateCode, fFinder);
            }
        };
        try {
            instance = new RemoteCompiler(remoteCompilerElem, ipcc);
        }
        catch (XmlParseException e) {
            e.printStackTrace();
            if (ide) {
                try {
                    instance = new RemoteCompiler(null, ipcc);
                }
                catch (XmlParseException xmlParseException) {}
            }
            System.exit(-6);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (RemoteCompiler.getInstance() != null) {
                RemoteCompiler.getInstance().deleteOutputFolder();
            }
        }));
    }

    @Override
    public boolean getCleanOutputFolderWhenExit() {
        return this.cleanOutputFolderWhenExit;
    }

    @Override
    public String getDeploymentFolder() {
        return this.deploymentFolder;
    }

    @Override
    public String getOutputFolder() {
        return this.outputFolder;
    }

    public PreProcessor[] getPreProcessors() {
        PreProcessor[] Return2 = new PreProcessor[this.preProcessors.size()];
        this.preProcessors.toArray(Return2);
        return Return2;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public PreProcessor getPreProcessor(String name) {
        PreProcessor Return2 = null;
        for (int i = 0; i < this.preProcessors.size() && Return2 == null; ++i) {
            PreProcessor p = (PreProcessor)this.preProcessors.get(i);
            if (!p.getName().equals(name)) continue;
            Return2 = p;
        }
        return Return2;
    }

    static void deleteFile(File f) {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                RemoteCompiler.deleteFile(files[i]);
            }
        }
        f.delete();
    }

    public void deleteOutputFolder() {
        if (this.outputFolderFile != null && this.cleanOutputFolderWhenExit) {
            RemoteCompiler.deleteFile(this.outputFolderFile);
        }
    }

    static File genFile(RemoteFile file, File parentDir) throws IOException {
        File path = new File(file.getPath());
        String newDirPath = parentDir.getAbsolutePath() + "/";
        if (path.isAbsolute()) {
            newDirPath = newDirPath + path.getName();
        } else if (path.getParentFile() != null) {
            newDirPath = newDirPath + "/" + path.getParentFile().getPath();
        }
        File newDir = new File(newDirPath);
        newDir.mkdirs();
        File newFile = new File(newDirPath + "/" + path.getName());
        FileOutputStream fos = new FileOutputStream(newFile);
        fos.write(file.getContent());
        fos.close();
        return newFile;
    }

    public static RemoteFile createRemoteFile(String filename, String path) throws IOException {
        return RemoteCompiler.createRemoteFile(filename, path, -1);
    }

    public static RemoteFile createRemoteFile(String filename, String path, int type) throws IOException {
        File file = new File(filename);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            in.close();
            return type >= 0 ? new RemoteBridgeFile(bytes, path, type) : new RemoteFile(bytes, path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(InputData input, OutputData output, int sessionId) throws IOException, ErrorInCompilationException {
        PreProcessor[] pps;
        Hashtable co;
        File trsDir;
        File errDir;
        File srcDir;
        File outDir = new File(this.outputFolderFile.getAbsolutePath() + "/" + sessionId);
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        if (!(srcDir = new File(outDir.getAbsolutePath() + "/" + "src")).exists()) {
            srcDir.mkdir();
        }
        RemoteFile[] copyBooks = input.getCopyBooks();
        for (int i = 0; i < copyBooks.length; ++i) {
            try {
                RemoteCompiler.genFile(copyBooks[i], srcDir);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        RemoteFile[] inputFiles = input.getInputFiles();
        String[] inputFileNames = new String[inputFiles.length];
        for (int i = 0; i < inputFiles.length; ++i) {
            try {
                inputFileNames[i] = RemoteCompiler.genFile(inputFiles[i], srcDir).getAbsolutePath();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        File lstDir = new File(outDir.getAbsolutePath() + "/" + "lst");
        if (!lstDir.exists()) {
            lstDir.mkdir();
        }
        if (!(errDir = new File(outDir.getAbsolutePath() + "/" + "err")).exists()) {
            errDir.mkdir();
        }
        if (!(trsDir = new File(outDir.getAbsolutePath() + "/" + "trs")).exists()) {
            trsDir.mkdir();
        }
        String trsPath = trsDir.getAbsolutePath();
        File clsDir = new File(outDir.getAbsolutePath() + "/" + "cls");
        if (!clsDir.exists()) {
            clsDir.mkdir();
        }
        OptionList ol = null;
        String od = ".";
        if (input.getCompile() && (co = input.getCompileOptions()) != null && co.size() > 0) {
            ArrayList<String> al = new ArrayList<String>();
            Iterator it = co.keySet().iterator();
            while (it.hasNext()) {
                String k = it.next().toString();
                if (k.equals("-sp=")) continue;
                if (k.equals("-od=")) {
                    od = (String)co.get(k);
                    continue;
                }
                if (k.equals("-ze")) continue;
                if (k.equals("-lf") || k.equals("-lo=")) {
                    al.add("-lf");
                    continue;
                }
                if (k.equals("-ef") || k.equals("-eo=")) {
                    al.add("-ef");
                    continue;
                }
                al.add(k + co.get(k));
            }
            al.add("-sp=" + srcDir.getAbsolutePath());
            al.add("-od=" + clsDir.getAbsolutePath() + File.separator);
            String[] options = new String[al.size()];
            al.toArray(options);
            ol = new OptionList(options);
        } else {
            ol = new OptionList(new String[0]);
        }
        String[] ppNames = input.getPreProcessorsNames();
        if (ppNames.length > 0) {
            pps = new PreProcessor[ppNames.length];
            for (int i = 0; i < pps.length; ++i) {
                if (ppNames[i].equalsIgnoreCase("ALL")) {
                    pps = new PreProcessor[this.preProcessors.size()];
                    this.preProcessors.toArray(pps);
                    break;
                }
                if (ppNames[i].equalsIgnoreCase("NONE")) {
                    pps = new PreProcessor[]{};
                    input.setCompile(true);
                    break;
                }
                pps[i] = this.getPreProcessor(ppNames[i]);
                if (pps[i] != null) continue;
                output.setStdErr("PreProcessor not found: '" + ppNames[i] + "'");
                output.setExitCode(-1);
                return;
            }
        } else {
            pps = new PreProcessor[this.preProcessors.size()];
            this.preProcessors.toArray(pps);
        }
        StringBuffer out = new StringBuffer();
        StringBuffer err = new StringBuffer();
        ArrayList<PPFileOutput> compileUnits = new ArrayList<PPFileOutput>();
        HashMap<String, PPFileOutput> cuMap = new HashMap<String, PPFileOutput>();
        RemoteFileFinder fileFinder = new RemoteFileFinder(srcDir);
        StandardPhases phases = (StandardPhases)PhasesFactory.create(ol);
        ClassLoader ctxCl = Thread.currentThread().getContextClassLoader();
        RemoteCompilerClassLoader rcCl = RemoteCompilerClassLoader.getInstance();
        if (rcCl != null) {
            Thread.currentThread().setContextClassLoader(rcCl);
        }
        try {
            for (int i = 0; i < inputFileNames.length; ++i) {
                File iscobolErrFile;
                File iscobolListFile;
                String inputFileName = inputFiles[i].getPath();
                File inputFileDir = srcDir;
                PPFileOutput cu = new PPFileOutput(inputFiles[i].getPath());
                fileFinder.setCompileUnit(cu);
                compileUnits.add(cu);
                String translatedFileName = null;
                for (int j = 0; j < pps.length; ++j) {
                    FileData fd = new FileData();
                    fd.setInputFile(inputFileName);
                    boolean isLast = j == pps.length - 1;
                    fd.setListing(input.getListing() && isLast);
                    fd.setError(input.getError() && isLast);
                    pps[j].compile(fd, inputFileDir, lstDir, errDir, trsDir, sessionId);
                    out.append(fd.getStdOut());
                    err.append(fd.getStdErr());
                    int exitCode = fd.getExitCode();
                    if (exitCode == 0) {
                        if (isLast) {
                            translatedFileName = new File(fd.getOutputFile()).getAbsolutePath();
                            cu.setTranslatedFile(RemoteCompiler.createRemoteFile(fd.getOutputFile(), fd.getOutputFile().substring(trsPath.length() + 1)));
                            if (input.getListing() && fd.getListingFile() != null) {
                                cu.setListingFile(RemoteCompiler.createRemoteFile(fd.getListingFile(), fd.getListingFile().substring(lstDir.getAbsolutePath().length() + 1)));
                            }
                            if (!input.getError() || fd.getErrorFile() == null) continue;
                            cu.setErrorFile(RemoteCompiler.createRemoteFile(fd.getErrorFile(), fd.getErrorFile().substring(errDir.getAbsolutePath().length() + 1)));
                            continue;
                        }
                        inputFileName = fd.getOutputFile().substring(trsPath.length() + 1);
                        inputFileDir = trsDir;
                        continue;
                    }
                    output.setExitCode(exitCode);
                    break;
                }
                if (translatedFileName == null) {
                    translatedFileName = inputFileNames[i];
                }
                if (!input.getCompile() || this.ipcc == null) continue;
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                PrintStream stdOut = new PrintStream(bOut);
                ByteArrayOutputStream bErr = new ByteArrayOutputStream();
                PrintStream stdErr = new PrintStream(bErr);
                PrintStream systemOut = System.out;
                PrintStream systemErr = System.err;
                System.setOut(stdOut);
                System.setErr(stdErr);
                RemoteErrors errs = new RemoteErrors(outDir, input.getShowMessagesOnSysErr());
                errs.setVerbose(ol.getOption("-verbose") != null);
                Pcc pcc = null;
                try {
                    pcc = this.ipcc.run(translatedFileName, clsDir.getAbsolutePath() + File.separator, (OptionList)ol.clone(), phases, errs, null, true, fileFinder);
                }
                catch (ErrorInCompilationException ecex) {
                    pcc = ecex.pcc;
                }
                catch (Exception ecex) {
                    // empty catch block
                }
                if (pcc != null) {
                    String[] entries = pcc.getEasyDBProgramsNames();
                    String iOutDir = clsDir.getAbsolutePath() + File.separator;
                    for (String e : entries) {
                        cu.addBridgeFile((RemoteBridgeFile)RemoteCompiler.createRemoteFile(e, e.substring(trsPath.length() + 1), 1));
                        ol.restoreProperties();
                        OptionList ol0 = (OptionList)ol.clone();
                        ol0.addOption("#ef");
                        ol0.addOption("#st");
                        ol0.addOption("#eo=");
                        ol0.addOption("#lf");
                        ol0.addOption("#lo=");
                        ol0.addOption("#cp");
                        Pcc pcc0 = null;
                        try {
                            pcc0 = this.ipcc.run(e, iOutDir, ol0, phases, errs, null, true, fileFinder);
                            if (pcc0 == null || pcc0.getClassName() == null) continue;
                            cuMap.put(pcc0.getProgName(), cu);
                        }
                        catch (ErrorInCompilationException ecex) {
                            pcc0 = ecex.pcc;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                System.setOut(systemOut);
                System.setErr(systemErr);
                out.append(bOut.toString());
                err.append(bErr.toString());
                stdOut.close();
                stdErr.close();
                if (pcc == null || pcc.getClassName() == null) continue;
                cuMap.put(pcc.getProgName(), cu);
                cu.setErrors(errs);
                cu.setCopyFileNames(pcc.getCopyFilesNames());
                cu.setFullClassName(pcc.getFullClassName());
                String basefilename = translatedFileName;
                int idx = basefilename.lastIndexOf(46);
                if (idx >= 0) {
                    basefilename = basefilename.substring(0, idx);
                }
                if ((iscobolListFile = new File(basefilename + ".list")).exists()) {
                    String filePath = iscobolListFile.getAbsolutePath();
                    cu.setIscobolListingFile(RemoteCompiler.createRemoteFile(filePath, filePath.substring(trsPath.length() + 1)));
                    iscobolListFile.delete();
                }
                if (!(iscobolErrFile = new File(basefilename + ".err")).exists()) continue;
                String filePath = iscobolErrFile.getAbsolutePath();
                cu.setIscobolErrorFile(RemoteCompiler.createRemoteFile(filePath, filePath.substring(trsPath.length() + 1)));
                iscobolErrFile.delete();
            }
            if (ol.getOption("-jj") == null || ol.getOption("-jc") != null) {
                ByteArrayOutputStream bErr = new ByteArrayOutputStream();
                PrintStream stdErr = new PrintStream(bErr);
                PrintStream systemErr = System.err;
                System.setErr(stdErr);
                Errors errs = new Errors(ol.getOption("-xmsgfmt="));
                errs.setVerbose(ol.getOption("-verbose") != null);
                Pcc.generateBinaryCode(ol, errs, phases, outDir.getPath());
                stdErr.close();
                err.append(bErr.toString());
                System.setErr(systemErr);
                Map<File, Map> compileDatas = phases.getPccToBeCompiled();
                for (Map map : compileDatas.values()) {
                    String programName = (String)map.get("programName");
                    PPFileOutput cu = (PPFileOutput)cuMap.get(programName);
                    File javaFile = new File(programName);
                    if (javaFile.exists()) {
                        String absPath = javaFile.getAbsolutePath();
                        String relPath = absPath.substring(clsDir.getAbsolutePath().length() + 1);
                        if (this.ide) {
                            RemoteCompiler.copyToDeploymentFolder(od, javaFile, relPath);
                        } else {
                            cu.addJavaFile(RemoteCompiler.createRemoteFile(absPath, relPath));
                            if (this.deploymentFolder != null) {
                                this.copyToDeploymentFolder(javaFile, relPath);
                            }
                        }
                        javaFile.delete();
                    }
                    final String classFileName = new File(programName.substring(0, programName.length() - 5)).getName();
                    File[] classes = clsDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".class") && name.startsWith(classFileName);
                        }
                    });
                    RemoteFile[] clsFiles = new RemoteFile[classes.length];
                    for (int c = 0; c < classes.length; ++c) {
                        String absPath = classes[c].getAbsolutePath();
                        String relPath = absPath.substring(clsDir.getAbsolutePath().length() + 1);
                        clsFiles[c] = RemoteCompiler.createRemoteFile(absPath, relPath);
                        if (this.ide) {
                            RemoteCompiler.copyToDeploymentFolder(od, classes[c], relPath);
                        } else if (this.deploymentFolder != null) {
                            this.copyToDeploymentFolder(classes[c], relPath);
                        }
                        classes[c].delete();
                    }
                    if (this.ide) continue;
                    cu.setClassFiles(clsFiles);
                }
            }
            PPFileOutput[] ppfo = compileUnits.toArray(new PPFileOutput[compileUnits.size()]);
            output.setPreProcessorFilesOutput(ppfo);
            output.setStdErr(err.toString());
            output.setStdOut(out.toString());
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxCl);
        }
    }

    private void copyToDeploymentFolder(File src, String path) throws IOException {
        RemoteCompiler.copyToDeploymentFolder(this.deploymentFolder, src, path);
    }

    private static void copyToDeploymentFolder(String fld, File src, String path) throws IOException {
        String filepath = fld;
        int idx = path.lastIndexOf(File.separator);
        if (idx >= 0 && (path = path.substring(0, idx)) != null && path.length() > 0) {
            filepath = filepath + File.separator + path;
        }
        new File(filepath).mkdirs();
        filepath = filepath + File.separator + src.getName();
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(filepath);
        byte[] b = new byte[in.available()];
        in.read(b);
        out.write(b);
        in.close();
        out.close();
    }

    public boolean isIde() {
        return this.ide;
    }

    public void setIde(boolean ide) {
        this.ide = ide;
    }

    static {
        serverCallbackHandlers = new Hashtable();
    }
}

