/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote;

import com.iscobol.compiler.Errors;
import com.iscobol.compiler.remote.RemoteError;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoteErrors
extends Errors
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private boolean printErrorMessage;
    private transient File outDir;

    public RemoteErrors() {
    }

    public RemoteErrors(File outDir, boolean printErrorMessage) {
        this.printErrorMessage = printErrorMessage;
        this.outDir = outDir;
    }

    @Override
    protected void addMessage(int num, int s, int lineNum, int offset, String msg, String other, String file) {
        int idx;
        if (this.printErrorMessage) {
            System.err.println(msg);
        }
        if (this.outDir != null) {
            File p;
            File f = new File(file);
            StringBuffer buff = new StringBuffer(f.getName());
            for (p = f.getParentFile(); p != null && !p.equals(this.outDir); p = p.getParentFile()) {
                buff.insert(0, p.getName() + "/");
            }
            if (p != null) {
                file = buff.toString();
            }
        }
        if ((idx = msg.indexOf("; file = ")) >= 0) {
            msg = msg.substring(0, idx);
        }
        this.allMessages.addElement(new RemoteError(num, s, lineNum, offset, file, msg, other));
    }

    @Override
    public boolean printEndMessage() {
        if (this.printErrorMessage) {
            int i = this.getUnitErrorCount(1);
            int w = this.getUnitErrorCount(2);
            int re = this.getUnitErrorCount(3);
            int se = this.getUnitErrorCount(4);
            boolean v = this.isVerbose();
            if (v || i > 0 || w > 0 || re > 0 || se > 0) {
                System.err.println(errorDesc.get(new Integer(100000)));
                if (v || i > 0) {
                    System.err.println(errorDesc.get(new Integer(100001)) + " - " + this.info);
                }
                if (v || w > 0) {
                    System.err.println(errorDesc.get(new Integer(100002)) + " - " + this.warning);
                }
                if (v || re > 0) {
                    System.err.println(errorDesc.get(new Integer(100003)) + " - " + this.rErrors);
                }
                if (v || se > 0) {
                    System.err.println(errorDesc.get(new Integer(100004)) + " - " + this.sErrors);
                }
            }
        }
        return this.sErrors > 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.allMessages.size());
        for (Object msg : this.allMessages) {
            ((RemoteError)msg).writeExternal(out);
        }
        out.writeInt(this.info);
        out.writeInt(this.warning);
        out.writeInt(this.rErrors);
        out.writeInt(this.sErrors);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.allMessages.clear();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            RemoteError e = new RemoteError();
            e.readExternal(in);
            this.allMessages.addElement(e);
        }
        this.info = in.readInt();
        this.warning = in.readInt();
        this.rErrors = in.readInt();
        this.sErrors = in.readInt();
    }
}

