/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.html;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EmbeddedStatement;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.html.SubstitutionMarker;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.LinkedList;

public class Exec
extends EmbeddedStatement
implements CobolToken,
ErrorsNumbers {
    private static Pcc lastPcc;
    private final ArrayList code = new ArrayList();
    private final ArrayList lines;

    public Exec(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk;
        if (lastPcc != this.pc.getRoot()) {
            lastPcc = this.pc.getRoot();
            if (this.pc.getOption("-cp") != null) {
                this.pc.addImport("import com.iscobol.rts.HTTPHandler;");
            }
        }
        if ((tk = this.tm.getToken()).getToknum() != 10002) {
            throw new UnexpectedTokenException(tk, this.error);
        }
        LinkedList ll = p.getExternalExecLines();
        int idx = tk.longValue();
        if (ll == null || ll.size() <= idx) {
            throw new UnexpectedTokenException(tk, this.error);
        }
        this.lines = (ArrayList)ll.get(idx);
        while ((tk = this.tm.getToken()).getToknum() != 432) {
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = (String)this.lines.get(i);
            if (line.matches("^[ \t]*(?i)copy[ \t]*\".*\"[. \t]*$")) {
                int end;
                int beg = line.indexOf(34);
                String name = line.substring(beg + 1, end = line.lastIndexOf(34));
                File file = PreProcessor.findFile(name, this.tm.getOptionList());
                if (file == null) {
                    throw new GeneralErrorException(3, 4, this.keyWord, name, this.error);
                }
                StringBuffer out = new StringBuffer();
                try {
                    String ln;
                    LineNumberReader rd = new LineNumberReader(new FileReader(file));
                    while ((ln = rd.readLine()) != null) {
                        this.processLine(ln);
                    }
                    continue;
                }
                catch (IOException ex) {
                    throw new GeneralErrorException(61, 4, this.keyWord, ex.toString(), this.error);
                }
            }
            this.processLine(line);
        }
    }

    private void processLine(String line) throws GeneralErrorException {
        int len = line.length();
        StringBuffer outline = new StringBuffer();
        block4: for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            switch (c) {
                case ':': {
                    if (i > 0 && (Character.isLetter(line.charAt(i - 1)) || i + 1 == len || !SubstitutionMarker.isValidChar(line.charAt(i + 1)))) {
                        outline.append(':');
                        continue block4;
                    }
                    SubstitutionMarker sm = SubstitutionMarker.get(this.keyWord, this.pc, line, i + 1);
                    if (sm != null) {
                        sm.check(this.pc, this.error);
                        this.code.add(outline.toString());
                        outline.delete(0, outline.length());
                        this.code.add(sm);
                        i = sm.getNextCharPos() - 1;
                        continue block4;
                    }
                    outline.append(':');
                    continue block4;
                }
                case '\"': 
                case '\\': {
                    outline.append('\\');
                }
                default: {
                    outline.append(c);
                }
            }
        }
        outline.append("\\n");
        this.code.add(outline);
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        this.getCodeDebug(Return2);
        int nElem = this.code.size();
        for (int i = 0; i < nElem; ++i) {
            Object obj = this.code.get(i);
            Return2.append("      HTTPHandler.cgiDisplay (");
            if (obj instanceof Token) {
                Return2.append("\"");
                Return2.append(((Token)obj).getCode());
                Return2.append("\");");
            } else if (obj instanceof SubstitutionMarker) {
                Return2.append(((SubstitutionMarker)obj).getCode());
                Return2.append(");");
            } else {
                Return2.append('\"');
                Return2.append(obj.toString());
                Return2.append("\");");
            }
            Return2.append(eol);
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }
}

