/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ControlsType;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GUIControl;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MSVariableGenerator;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.UnsupportedFeatureException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IDataSection;
import com.iscobol.interfaces.compiler.IVariableDeclarationScreen;
import com.iscobol.rts.Config;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class VariableDeclarationScreen
extends VariableDeclaration
implements CobolToken,
ErrorsNumbers,
ControlsType,
IVariableDeclarationScreen {
    public static final Map<Integer, String> gui_defaults_prop_names;
    boolean hasGraphicalControl;
    boolean hasCharacterAttribute;
    int position;
    GUIControl guictl;
    int graphicControlType = -1;
    VariableDeclarationScreen previousVDS;
    Token keyWord;
    boolean occurslevel1;
    boolean occurslevel2;
    boolean isdisplaygroupheader;
    Vector isdisplayparentorig;
    boolean guiWd2UnsupportedLog;
    VariableDeclarationList attrVariables = new VariableDeclarationList();
    Token tksave = null;
    boolean haveeol = false;

    public VariableDeclarationScreen(Pcc p, TokenManager t, Errors err, Token kw) throws GeneralErrorException, EndOfProgramException {
        super(t);
        this.keyWord = kw;
        this.pc = p;
        this.error = err;
        this.tm = t;
        this.parent = null;
        this.level = 1;
        this.guiWd2UnsupportedLog = this.pc.getOption("-wd2") != null;
        this.level01_49Header((short)3);
    }

    public VariableDeclarationScreen(Pcc p, TokenManager t, Errors err, VariableDeclarationScreen pr, VariableDeclarationScreen precVar, boolean occl1, boolean occl2, IDataSection parentSec) throws GeneralErrorException, EndOfProgramException {
        this(p, t, err, pr, occl1, occl2, parentSec);
        this.previousVDS = precVar;
        if (precVar != null) {
            this.keyWord = precVar.keyWord;
        }
    }

    public VariableDeclarationScreen(Pcc p, TokenManager t, Errors err, VariableDeclarationScreen pr, boolean occl1, boolean occl2, IDataSection parentSec) throws GeneralErrorException, EndOfProgramException {
        super(t);
        this.pc = p;
        this.error = err;
        this.tm = t;
        this.parent = pr;
        this.setParentSection(parentSec);
        this.occurslevel1 = occl1;
        this.occurslevel2 = occl2;
        if (pr != null) {
            this.keyWord = pr.keyWord;
        }
        this.guiWd2UnsupportedLog = this.pc.getOption("-wd2") != null;
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10002) {
            throw new GeneralErrorException(27, 4, tk, tk.getWord(), this.error);
        }
        this.level = Integer.parseInt(tk.getWord());
        if (this.level >= 1 && this.level <= 49) {
            if (this.parent == null && this.level != 1) {
                throw new GeneralErrorException(27, 4, tk, tk.getWord(), this.error);
            }
            Token ret = this.level01_49Header((short)1);
            this.tm.ungetToken();
            tk = this.tm.getToken();
            if (ret != null) {
                throw new UnexpectedTokenException(ret, this.error);
            }
            if (tk.getToknum() != 10006) {
                throw new UnexpectedTokenException(tk, this.error);
            }
        } else if (this.level == 78) {
            this.level78(tk);
        } else {
            throw new GeneralErrorException(27, 4, tk, tk.getWord(), this.error);
        }
        if (this.phisicLen == 0) {
            this.usageDisplay();
        }
        this.dimension = 0;
        VariableDeclaration v = this;
        while (v != null) {
            if (v.occursMin > 0) {
                ++this.dimension;
            }
            v = v.parent;
        }
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    private Token remgetToken(Token tk) throws GeneralErrorException, EndOfProgramException {
        return this.tm.remgetToken(tk);
    }

    boolean isGroupVar() {
        return this.guictl == null || this.guictl.getGraphicControlType() < 0 && (this.guictl.sa == null || this.guictl.sa.getHeaderType(this.picture, 1) == 0);
    }

    private void checkOccurs() throws GeneralErrorException, EndOfProgramException {
        Token tk;
        TokenManager.Marker mk = this.tm.getMarker();
        this.tm.setMarker(mk);
        while ((tk = this.tm.getToken()).getToknum() != 10006) {
            if (tk.getToknum() != 608) continue;
            if (!this.occurslevel1) {
                this.occurslevel1 = true;
            } else if (!this.occurslevel2) {
                this.occurslevel2 = true;
            } else {
                throw new GeneralErrorException(127, 4, tk, tk.getWord() + " in SCREEN-SECTION ", this.error);
            }
            if (this.guictl == null || this.guictl.sa == null) break;
            this.guictl.sa.occurslevel1 = this.occurslevel1;
            this.guictl.sa.occurslevel2 = this.occurslevel2;
            break;
        }
        this.tm.rewindToMarker(mk);
    }

    private Token level01_49Header(short kind) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        this.tksave = tk = this.tm.getToken();
        Token Return2 = null;
        this.name = tk;
        if (this.parent != null && !((VariableDeclarationScreen)this.parent).isGroupVar()) {
            ((VariableDeclarationScreen)this.parent).isdisplaygroupheader = true;
            if (this.isdisplayparentorig == null) {
                this.isdisplayparentorig = new Vector();
            }
            while ((VariableDeclarationScreen)this.parent.parent != null && !((VariableDeclarationScreen)this.parent).isGroupVar()) {
                this.isdisplayparentorig.addElement(this.parent);
                this.parent = this.parent.parent;
            }
        }
        if (tk.getToknum() == 10009 || tk.getToknum() == 553 || tk.getToknum() == 508 || tk.getToknum() == 486) {
            this.name = tk;
        } else {
            this.tm.ungetToken();
            this.name = tk = new Token(486, "FILLER", tk.getFLN(), tk.getOffset(), tk.getFileName());
        }
        if (tk.getToknum() == 486) {
            this.isFiller = true;
        }
        this.guictl = new GUIControl(this.pc, this.tm, this.error, this.name, null, this.occurslevel1, this.occurslevel2, kind, this);
        if ((VariableDeclarationScreen)this.parent != null && ((VariableDeclarationScreen)this.parent).guictl.sa != null) {
            this.guictl.sa = ((VariableDeclarationScreen)this.parent).guictl.sa.getClone(this.pc, this.tm, this.error);
            this.guictl.sa.occurslevel1 = this.occurslevel1;
            this.guictl.sa.occurslevel2 = this.occurslevel2;
        }
        this.checkOccurs();
        this.graphicControlType = this.guictl.loadGraphicalControl(tk, this.parent, this.tm);
        if (this.graphicControlType == -1) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009 || tk.getToknum() == 553 || tk.getToknum() == 508) {
                if (GUIControl.globalPropertyWords.contains(tk.getWord())) {
                    this.tm.ungetToken();
                } else {
                    this.graphicControlType = this.guictl.loadGraphicalControl(tk, this.parent, this.tm);
                    if (this.graphicControlType >= 0) {
                        this.tm.ungetToken();
                    } else {
                        Return2 = tk;
                    }
                    tk = this.remgetToken(tk);
                }
            } else {
                this.tm.ungetToken();
            }
        } else {
            this.tm.ungetToken();
        }
        if (this.guictl.sa != null) {
            this.guictl.sa.gct = this.graphicControlType;
        }
        if (this.graphicControlType >= 0) {
            this.hasGraphicalControl = true;
            String propName = gui_defaults_prop_names.get(this.graphicControlType);
            String str = Config.getProperty(propName, null);
            if (str != null) {
                this.tm.putTokens(str, tk);
            }
        }
        tk = this.tm.getToken();
        if (Return2 != null) {
            return Return2;
        }
        return this.level01_49(tk, kind);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token level01_49(Token tk, short kind) throws GeneralErrorException {
        int position = 0;
        boolean loop = true;
        Token Return2 = null;
        boolean alreadyfoundtitle = false;
        try {
            int childLevel;
            while (tk.getToknum() != 10006 && loop) {
                if (this.guictl == null || !this.guictl.tokenIsAttrScreen(tk, this.tm)) {
                    this.tm.ungetToken();
                    tk = this.tm.getToken();
                    switch (tk.getToknum()) {
                        case 323: {
                            this.hasCharacterAttribute = true;
                            break;
                        }
                        case 506: {
                            break;
                        }
                        case 608: {
                            this.occurs(tk);
                            if (this.getIndexes() == null) break;
                            throw new GeneralErrorException(115, 4, this.name, "INDEXED", this.error);
                        }
                        case 633: 
                        case 634: {
                            switch (this.graphicControlType) {
                                case 9: 
                                case 11: 
                                case 13: 
                                case 18: {
                                    throw new UnsupportedFeatureException(tk, this.error);
                                }
                            }
                            if (this.picture != null) {
                                throw new UnexpectedTokenException(tk, this.error);
                            }
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 545) {
                                this.tm.ungetToken();
                            }
                            this.picture(tk);
                            break;
                        }
                        case 509: {
                            tk = this.tm.getToken();
                            if (tk.getToknum() == 545) {
                                tk = this.tm.getToken();
                            }
                            if (tk.getToknum() != 593) {
                                throw new GeneralErrorException(29, 4, this.name, "GROUP-USAGE", this.error);
                            }
                            this.isNational = true;
                            break;
                        }
                        case 408: {
                            if (kind == 1) {
                                if (this.usage(tk)) break;
                                throw new GeneralErrorException(29, 4, tk, "USAGE", this.error);
                            }
                            this.tm.ungetToken();
                            loop = false;
                            break;
                        }
                        case 797: {
                            tk = this.tm.getToken();
                            if (tk.getToknum() == 545) {
                                tk = this.tm.getToken();
                            }
                            if (tk.getToknum() != 408) {
                                throw new GeneralErrorException(29, 4, tk, "USAGE", this.error);
                            }
                            if (this.usage(tk)) break;
                            throw new GeneralErrorException(29, 4, tk, "USAGE", this.error);
                        }
                        case 304: {
                            int i;
                            int ungetnum = 1;
                            tk = this.tm.getToken();
                            if (tk.getToknum() == 810) {
                                tk = this.tm.getToken();
                                ++ungetnum;
                            }
                            ++ungetnum;
                            if (tk.isFigurativeZero()) {
                                for (i = 0; i < ungetnum; ++i) {
                                    this.tm.ungetToken();
                                }
                                tk = this.tm.getToken();
                                if (this.afterPictureOptions(tk)) break;
                                Return2 = tk;
                                this.tm.ungetToken();
                                loop = false;
                                break;
                            }
                            for (i = 0; i < ungetnum; ++i) {
                                this.tm.ungetToken();
                            }
                            break;
                        }
                        case 556: 
                        case 724: 
                        case 776: {
                            if (this.afterPictureOptions(tk)) break;
                            Return2 = tk;
                            this.tm.ungetToken();
                            loop = false;
                            break;
                        }
                        default: {
                            if (kind != 3 && !alreadyfoundtitle && this.graphicControlType >= 0 && (alreadyfoundtitle || this.graphicControlType < 0 || (alreadyfoundtitle = this.guictl.tokenIsTitleVar(this.tm, tk)))) break;
                            Return2 = tk;
                            loop = false;
                            this.tm.ungetToken();
                            break;
                        }
                    }
                } else {
                    this.tm.ungetToken();
                }
                if (!loop) continue;
                tk = this.tm.getToken();
            }
            boolean isDot = false;
            if (tk.getToknum() == 10006) {
                isDot = true;
            }
            if (this.picture != null) {
                while ((tk = this.tm.getToken()).getToknum() == 10002 && ((childLevel = Integer.parseInt(tk.getWord())) == 66 || childLevel == 88)) {
                    isDot = false;
                    this.tm.ungetToken();
                    VariableDeclarationScreen v = new VariableDeclarationScreen(this.pc, this.tm, this.error, this, this.occurslevel1, this.occurslevel2, this.getParentSection());
                    if (v.getHasCharacterAttribute()) continue;
                    this.children.addItem(v);
                }
                this.tm.ungetToken();
            } else {
                VariableDeclarationScreen vPrec = null;
                this.phisicLen = 0;
                position = 0;
                while ((tk = this.tm.getToken()).getToknum() == 10002 && (childLevel = Integer.parseInt(tk.getWord())) > this.level) {
                    isDot = false;
                    this.tm.ungetToken();
                    VariableDeclarationScreen v = new VariableDeclarationScreen(this.pc, this.tm, this.error, this, vPrec, this.occurslevel1, this.occurslevel2, this.getParentSection());
                    if (v.getHasCharacterAttribute()) continue;
                    this.children.addItem(v);
                    vPrec = v;
                    v.setPosition(position++);
                    if (v.occursMin != 0) {
                        this.phisicLen += v.phisicLen * (v.occursMax > 0 ? v.occursMax : v.occursMin);
                        continue;
                    }
                    this.phisicLen += v.phisicLen;
                }
                this.tm.ungetToken();
            }
            if (isDot && this.keyWord != null) {
                this.tm.ungetToken();
            }
        }
        catch (EndOfProgramException eope) {
            try {
                this.tm.ungetToken();
                this.tm.ungetToken();
            }
            catch (EndOfProgramException endOfProgramException) {
                // empty catch block
            }
        }
        if (this.guictl != null && this.guictl.graphicControlType == -1 && (this.getScreenCodeType().equalsIgnoreCase("GUITERMINALDISPLAY") || this.getScreenCodeType().equalsIgnoreCase("GUITERMINALACCEPT")) && this.guiWd2UnsupportedLog) {
            String msg = " in SCREEN SECTION";
            if (this.getScreenCodeType().equalsIgnoreCase("GUITERMINALDISPLAY")) {
                msg = msg + " (only for eval JavaScript code)";
            }
            this.error.print(179, 2, this.tksave, "character user interface: " + this.tksave.getWord().toUpperCase() + msg);
        }
        if (this.guictl != null && this.guictl.sa != null && this.guictl.graphicControlType >= 0 && !this.guictl.sa.haveSizeAttribute() && this.guiWd2UnsupportedLog) {
            this.error.print(179, 2, this.tksave, this.tksave.getWord().toUpperCase() + " without SIZE attribute.");
        }
        this.checkPicG();
        return Return2;
    }

    public void loadVars(Hashtable ht) {
        VariableDeclarationScreen vds = null;
        if (this.name != null && this.getName() != null && ht.get(this.getName()) == null) {
            ht.put(this.getName(), this);
        }
        vds = (VariableDeclarationScreen)this.children.getFirst();
        while (vds != null) {
            vds.loadVars(ht);
            vds = (VariableDeclarationScreen)this.children.getNext();
        }
    }

    void check(Verb v) throws GeneralErrorException {
        if (this.guictl != null) {
            this.guictl.check(v);
        }
        VariableDeclarationScreen vds = (VariableDeclarationScreen)this.children.getFirst();
        while (vds != null) {
            vds.check(v);
            vds = (VariableDeclarationScreen)this.children.getNext();
        }
    }

    @Override
    boolean afterPictureOptions(Token tk) throws GeneralErrorException, EndOfProgramException {
        if (this.guictl != null && this.guictl.tokenIsAttrScreen(tk, this.tm)) {
            this.tm.ungetToken();
            return true;
        }
        return super.afterPictureOptions(tk);
    }

    @Override
    public String getCode(boolean foo, StringBuffer dynPart) {
        return this.getCode(dynPart);
    }

    @Override
    public String getCode(boolean foo, StringBuffer dynPart, boolean e) {
        return this.getCode(dynPart);
    }

    @Override
    public String getCode(StringBuffer dynPart) {
        return this.getCode(null, dynPart, false);
    }

    @Override
    public String getCode(StringBuffer dynPart, boolean e) {
        return this.getCode(null, dynPart, e);
    }

    public void getCodeArray(StringBuffer myDynPart) {
        if (this.getProgScreenI() > 0) {
            int saveprogscreen = this.progScreen;
            this.progScreen = 0;
            myDynPart.append("   " + this.getDeclUnivoqueName(false, false) + ".add(" + this.getProgScreenI() + ", ");
            this.progScreen = saveprogscreen;
            if (this.getProgScreenJ() > 0) {
                myDynPart.append(this.getProgScreenJ() + ", ");
            }
            myDynPart.append(this.getDeclUnivoqueName() + ");" + eol);
        }
    }

    @Override
    public void checkPost(Pcc pc) throws GeneralErrorException {
    }

    @Override
    public String getCode(String memBuf, StringBuffer dynPart, boolean e) {
        if (!this.isUsed() && this.pc.getOption("-dx") == null && !this.pc.optionMS) {
            return "";
        }
        StringBuffer Return2 = new StringBuffer();
        StringBuffer myDynPart = new StringBuffer();
        int occurs = this.occursMax > 0 ? this.occursMax : this.occursMin;
        boolean indici = false;
        boolean addI = true;
        String strtmp = "";
        this.haveeol = false;
        if (occurs == 0) {
            occurs = 1;
        } else {
            indici = true;
        }
        if (this.progScreen > 0) {
            ++this.progScreen;
        }
        if (indici) {
            if (this.getProgScreenI() > 0) {
                addI = false;
            } else {
                this.setProgScreenI(1);
            }
        }
        for (int i = 0; i < occurs; ++i) {
            block48: {
                VariableDeclaration vd;
                block47: {
                    if (indici) {
                        if (addI) {
                            this.setProgScreenI(i + 1);
                        } else {
                            this.setProgScreenJ(i + 1);
                        }
                    }
                    if (i == 0 && this.getProgScreenI() == 1 && (this.getProgScreenJ() == 0 || this.getProgScreenJ() == 1)) {
                        VariableDeclarationScreen parentOcc2 = null;
                        VariableDeclarationScreen parentOcc1 = null;
                        int occ2 = 0;
                        int occ1 = 0;
                        parentOcc2 = this.getisInOccurs();
                        if (parentOcc2 != null) {
                            occ2 = parentOcc2.occursMin;
                            parentOcc1 = parentOcc2.getisInOccurs();
                            if (parentOcc1 != null) {
                                occ1 = parentOcc1.occursMin;
                            }
                        }
                        this.putModifier(Return2);
                        Return2.append("BaseGUIControlArray " + this.getDeclUnivoqueName(false, false) + ";" + eol);
                        myDynPart.append("   " + this.getDeclUnivoqueName(false, false) + " = new BaseGUIControlArray(");
                        if (occ1 > 0 && occ2 > 0) {
                            myDynPart.append(occ1 + "," + occ2 + ");" + eol);
                        } else if (occ2 > 0 && occurs > 1) {
                            myDynPart.append(occ2 + "," + occurs + ");" + eol);
                        } else if (occ2 > 0) {
                            myDynPart.append(occ2 + ");" + eol);
                        } else {
                            myDynPart.append(occurs + ");" + eol);
                        }
                    }
                    if (this.graphicControlType == -1) break block47;
                    Return2.append(this.getGraphicalScreenCode(myDynPart));
                    strtmp = this.setEndDeclaration(myDynPart);
                    if (strtmp.length() > 0) {
                        this.haveeol = true;
                    }
                    myDynPart.append(strtmp);
                    this.getCodeArray(myDynPart);
                    if (this.pc.optionMS && occurs <= 1) break block48;
                    vd = this.children.getFirst();
                    while (vd != null) {
                        if (vd.progScreen == 0) {
                            vd.progScreen = this.progScreen;
                        }
                        Return2.append(vd.getCode(myDynPart));
                        vd = this.children.getNext();
                    }
                    if (this.haveeol) break block48;
                    myDynPart.append(";" + eol);
                    break block48;
                }
                vd = null;
                if (this.guictl != null && this.guictl.sa != null && (this.guictl.sa.vFrom != null && (vd = this.guictl.sa.vFrom.getVarDecl()) != null || this.guictl.sa.vUsing != null && (vd = this.guictl.sa.vUsing.getVarDecl()) != null)) {
                    if (this.picture == null && this.isBlank()) {
                        this.setNumeric(vd.isNumeric());
                        this.setPhisicLen(vd.getPhisicLen());
                        StringBuffer tmppic = new StringBuffer();
                        if (vd.isEdited()) {
                            this.picture = vd.picture;
                        } else {
                            if (this.isNumeric()) {
                                tmppic.append("9(");
                            } else {
                                tmppic.append("X(");
                            }
                            tmppic.append(vd.getPhisicLen() + ")");
                            this.picture = tmppic.toString().toCharArray();
                        }
                    } else if (this.pc.getOption("-cnlz") != null) {
                        boolean setPic = false;
                        if (this.picture == null && vd.isNumeric() && !vd.isEdited) {
                            this.setNumeric(true);
                            this.isEdited = true;
                            this.setPhisicLen(vd.getMaxDigits());
                            setPic = true;
                        } else if (this.picture != null && this.isNumeric() && !this.isEdited) {
                            this.isEdited = true;
                            this.setPhisicLen(this.getLogicLen());
                            setPic = true;
                        }
                        if (setPic) {
                            StringBuffer tmppic = new StringBuffer();
                            tmppic.append("9(");
                            tmppic.append(this.getPhisicLen());
                            tmppic.append(")");
                            this.picture = tmppic.toString().toCharArray();
                        }
                    }
                }
                Return2.append(super.getCode(myDynPart));
                this.getCodeArray(myDynPart);
                if (!this.pc.optionMS || occurs > 1) {
                    vd = this.children.getFirst();
                    while (vd != null) {
                        if (vd.progScreen == 0) {
                            vd.progScreen = this.progScreen;
                        }
                        Return2.append(vd.getCode(myDynPart));
                        vd = this.children.getNext();
                    }
                }
            }
            ++this.progScreen;
        }
        --this.progScreen;
        if (indici) {
            if (this.getProgScreenJ() > 0) {
                this.setProgScreenJ(0);
            } else if (this.getProgScreenI() > 0) {
                this.setProgScreenI(0);
            }
        }
        dynPart.append(myDynPart);
        if (this.graphicControlType != -1 && this.guictl != null && this.guictl.sa != null && this.guictl.sa.getObjectRef() != null) {
            VariableDeclaration objvd = this.guictl.sa.getObjectRef().getVarDecl();
            if (this.pc.registerScreenAttrs) {
                String name = this.pc.newScreenName(objvd.getDeclUnivoqueName());
                dynPart.append("      params.set(\"");
                dynPart.append(name);
                dynPart.append("\", ");
                dynPart.append(this.getDeclUnivoqueName());
                dynPart.append(");");
                dynPart.append(eol);
                this.pc.screenObjVars.put(objvd.getUnivoqueName(), "JavaBean " + name);
            } else {
                if (this.pc.optionMS) {
                    dynPart.append("         ");
                    dynPart.append(objvd.getUnivoqueName());
                } else {
                    dynPart.append(objvd.getDeclUnivoqueName());
                }
                dynPart.append(" = " + this.getDeclUnivoqueName() + ";" + eol);
            }
        }
        return Return2.toString();
    }

    @Override
    protected String getDeclUnivoqueName() {
        return this.getDeclUnivoqueName(true, false);
    }

    @Override
    protected String getDeclUnivoqueName(boolean oo) {
        return this.getDeclUnivoqueName(oo, false);
    }

    @Override
    protected String getDeclUnivoqueName(boolean oo, boolean e) {
        String n = this.name.getWord();
        if (this.pc.capitalizeNames) {
            n = MSVariableGenerator.getDeclUnivoqueName(n, 0);
        } else {
            if (Character.isDigit(n.charAt(0))) {
                n = "_" + n;
            }
            n = n.replace('-', Pcc.hyphenRepl);
        }
        if (this.progScreen == 0) {
            if (super.getProg() == 0) {
                if (oo && (this.occurslevel1 || this.occurslevel2)) {
                    return n + "_" + Pcc.identifierSep + "0";
                }
                return n;
            }
            if (oo && (this.occurslevel1 || this.occurslevel2)) {
                return n + "_" + Pcc.identifierSep + "0" + Pcc.identifierSep + super.getProg();
            }
            return n + Pcc.identifierSep + super.getProg();
        }
        if (super.getProg() == 0) {
            if (oo && (this.occurslevel1 || this.occurslevel2)) {
                return n + "_" + Pcc.identifierSep + "0_" + Pcc.identifierSep + this.progScreen;
            }
            return n + "_" + Pcc.identifierSep + this.progScreen;
        }
        if (oo && (this.occurslevel1 || this.occurslevel2)) {
            return n + "_" + Pcc.identifierSep + "0" + Pcc.identifierSep + super.getProg() + "_" + Pcc.identifierSep + this.progScreen;
        }
        return n + Pcc.identifierSep + super.getProg() + "_" + Pcc.identifierSep + this.progScreen;
    }

    public String getGraphicalScreenCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        if (this.name != null && this.guictl != null && (this.picture == null || this.pc.optionMS)) {
            this.putModifier(Return2);
            if (this.graphicControlType == 19) {
                Return2.append("CobolGUIJavaBean ");
            } else {
                Return2.append("BaseGUIControl ");
            }
            Return2.append(this.getDeclUnivoqueName() + ";" + eol);
            dynPart.append(this.getDeclUnivoqueName() + " = ");
        }
        if (this.guictl != null && this.getProgScreenI() > 0) {
            this.guictl.setIndexXY(this.getProgScreenI(), this.getProgScreenJ());
        }
        Return2.append(this.getGraphicalScreenCodeTail(dynPart));
        return Return2.toString();
    }

    public StringBuffer getGraphicalScreenCodeTail(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        if (this.guictl != null && this.picture == null) {
            if (this.graphicControlType == 19) {
                dynPart.append("(CobolGUIJavaBean)");
            }
            dynPart.append(this.guictl.getGraphicalScreenCodeHeader((VariableDeclarationScreen)this.parent, this.getDeclUnivoqueName()));
            dynPart.append(this.guictl.getControlStyleScreenCodeTail(".set"));
            dynPart.append(this.guictl.getGraphicalScreenCodeTail(this.keyWord, ".set"));
        }
        if (this.picture != null) {
            if (this.pc.optionMS) {
                this.setUsed();
                super.getCode(dynPart);
            } else {
                Return2.append(super.getCode(dynPart));
            }
        }
        return Return2;
    }

    @Override
    String getScreenCodeType() {
        StringBuffer Return2 = new StringBuffer();
        if (this.guictl != null) {
            Return2.append(this.guictl.getScreenCodeType(this.keyWord, this.picture, this.getChildren().getItemNum(), this.isdisplaygroupheader).toString());
        }
        return Return2.toString();
    }

    @Override
    public GUIControl getGuiControl() {
        return this.guictl;
    }

    @Override
    public void putOffset(StringBuffer buf) {
        buf.append(",0");
    }

    @Override
    public void putType(StringBuffer buf) {
        buf.append("BaseGUIControl ");
    }

    @Override
    public void putTypeFactory(StringBuffer buf) {
        buf.append("ScrFactory.get" + this.getScreenCodeType() + "(");
        buf.append("\"" + this.getDeclUnivoqueName() + "\"");
        if (this.parent != null) {
            buf.append(", " + this.parent.getDeclUnivoqueName());
        } else {
            buf.append(", null");
        }
        buf.append(", ");
    }

    @Override
    public void putScreenCode(StringBuffer buf) {
        buf.append(")");
        if (this.guictl.graphicControlType == -1) {
            buf.append(".setStyle(\"TEMPORARY\")");
        }
        buf.append(this.guictl.getControlStyleScreenCodeTail(".set"));
        if (this.guictl != null && this.getProgScreenI() > 0) {
            this.guictl.setIndexXY(this.getProgScreenI(), this.getProgScreenJ());
        }
        if ((this.getProgScreenI() > 1 && this.getProgScreenJ() == 0 || this.getProgScreenJ() > 1) && this.guictl.graphicControlType == -1 && this.getScreenCodeType().equalsIgnoreCase("CONTROL")) {
            buf.append(this.guictl.getGraphicalScreenCodeTail(this.keyWord, ".set", false, !this.isOccursClause()));
        } else {
            buf.append(this.guictl.getGraphicalScreenCodeTail(this.keyWord, ".set"));
        }
    }

    public boolean getHasCharacterAttribute() {
        return this.hasCharacterAttribute;
    }

    @Override
    public void resetProgScreen() {
        this.progScreen = 0;
        VariableDeclaration vd = this.children.getFirst();
        while (vd != null) {
            vd.resetProgScreen();
            vd = this.children.getNext();
        }
    }

    @Override
    public void setUsed() {
        this.setUsedAll();
    }

    @Override
    void mySetUsed(boolean updateParent, boolean checkValue) {
        if (!this.usedInProgram) {
            this.usedInProgram = true;
            if (updateParent) {
                if (this.parent != null && !this.parent.isUsed()) {
                    this.parent.mySetUsed(true, false);
                }
                if (this.isdisplayparentorig != null && this.isdisplayparentorig.size() > 0) {
                    Enumeration en = this.isdisplayparentorig.elements();
                    while (en.hasMoreElements()) {
                        VariableDeclaration parentorig = (VariableDeclaration)en.nextElement();
                        if (parentorig == null || parentorig.isUsed()) continue;
                        parentorig.mySetUsed(true, false);
                    }
                }
            }
            VariableDeclaration vd = this.attrVariables.getFirst();
            while (vd != null) {
                vd.mySetUsed(true, true);
                vd = this.attrVariables.getNext();
            }
        }
    }

    @Override
    public String setEndDeclaration(StringBuffer mdp) {
        StringBuffer Return2 = new StringBuffer();
        int lenreturn = mdp.length();
        if (mdp.toString().indexOf(eol, lenreturn - eol.length()) == -1) {
            Return2.append(".endDeclaration()");
            Return2.append(";" + eol);
            this.haveeol = true;
        }
        return Return2.toString();
    }

    private VariableDeclarationScreen getisInOccurs() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.occursMin > 0) {
            return (VariableDeclarationScreen)this.parent;
        }
        return ((VariableDeclarationScreen)this.parent).getisInOccurs();
    }

    private int getProgScreenI() {
        return this.pc.data.screenSec.getProgScreenI();
    }

    private int getProgScreenJ() {
        return this.pc.data.screenSec.getProgScreenJ();
    }

    private void setProgScreenI(int i) {
        this.pc.data.screenSec.setProgScreenI(i);
    }

    private void setProgScreenJ(int j) {
        this.pc.data.screenSec.setProgScreenJ(j);
    }

    static void checkScreenName(VariableDeclaration vd, Token tk, Errors error) throws GeneralErrorException {
        if (vd != null && tk != null && vd instanceof VariableDeclarationScreen) {
            throw new GeneralErrorException(165, 4, tk, tk.getWord(), error);
        }
    }

    @Override
    public int getGraphicControlType() {
        return this.graphicControlType;
    }

    public boolean isControl() {
        switch (this.getGraphicControlType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    @Override
    int getDataMapSize() {
        int len = 0;
        if (this.children.getItemNum() > 0) {
            VariableDeclaration vd = this.children.getFirst();
            while (vd != null) {
                len += vd.getDataMapSize();
                vd = this.children.getNext();
            }
        } else if (this.phisicLen > 0) {
            len = this.phisicLen;
        } else if (this.guictl != null) {
            if (this.guictl.sa.vUsing != null) {
                len = this.guictl.sa.vUsing.getVarDecl().getPhisicLen();
            } else if (this.guictl.sa.vFrom != null) {
                len = this.guictl.sa.vFrom.getVarDecl().getPhisicLen();
            } else if (this.guictl.sa.vTo != null) {
                len = this.guictl.sa.vTo.getVarDecl().getPhisicLen();
            }
        }
        return len;
    }

    @Override
    public String getUnivoqueName(boolean recur) {
        String un = this.getDeclUnivoqueName();
        if (!this.pc.optionMS || this.pc.registerScreenAttrs) {
            return un;
        }
        StringBuffer ret = new StringBuffer();
        ret.append(un);
        VariableDeclaration par = this.parent;
        if (par != null) {
            while (par.parent != null) {
                par = par.parent;
            }
            ret.insert(0, '.');
            ret.insert(0, par.getUnivoqueName(true));
        }
        if (!recur && par == null && this.hasRealChildren()) {
            ret.append(".");
            ret.append(this.getDeclUnivoqueName());
        }
        return ret.toString();
    }

    static {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(11, ".compiler.gui.bar.defaults");
        m.put(13, ".compiler.gui.bitmap.defaults");
        m.put(4, ".compiler.gui.check_box.defaults");
        m.put(8, ".compiler.gui.combo_box.defaults");
        m.put(20, ".compiler.gui.date_entry.defaults");
        m.put(2, ".compiler.gui.entry_field.defaults");
        m.put(9, ".compiler.gui.frame.defaults");
        m.put(12, ".compiler.gui.grid.defaults");
        m.put(19, ".compiler.gui.java_bean.defaults");
        m.put(1, ".compiler.gui.label.defaults");
        m.put(7, ".compiler.gui.list_box.defaults");
        m.put(3, ".compiler.gui.push_button.defaults");
        m.put(5, ".compiler.gui.radio_button.defaults");
        m.put(21, ".compiler.gui.ribbon.defaults");
        m.put(23, ".compiler.gui.iwc_panel.defaults");
        m.put(6, ".compiler.gui.scroll_bar.defaults");
        m.put(18, ".compiler.gui.slider.defaults");
        m.put(17, ".compiler.gui.status_bar.defaults");
        m.put(10, ".compiler.gui.tab_control.defaults");
        m.put(14, ".compiler.gui.tree_view.defaults");
        m.put(15, ".compiler.gui.web_browser.defaults");
        m.put(22, ".compiler.gui.scroll_pane.defaults");
        m.put(24, ".compiler.gui.chips_box.defaults");
        m.put(100, ".compiler.gui.window.defaults");
        m.put(101, ".compiler.gui.tool_bar.defaults");
        gui_defaults_prop_names = Collections.unmodifiableMap(m);
    }
}

