/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.Enumeration;
import java.util.Vector;

public class Unstring
extends Verb
implements CobolToken,
ErrorsNumbers {
    VariableName source;
    Vector delimiters = new Vector();
    Vector destVar = new Vector();
    VariableName ptr_var;
    VariableName tally_var;
    Block overflowBlock;
    Block notOverflowBlock;
    boolean delimited;
    private boolean hasNational;

    public Unstring(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.allowAllLitGen = false;
        Token tk = this.tm.getToken();
        boolean not = false;
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.source = VariableName.get(this.tm, this.error, this.pc);
        if (!(!this.source.getVarDecl().isNumeric() || this.source.hasSubValue() || this.pc.getOption("-cm") != null && this.source.getVarDecl().isEdited())) {
            throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
        }
        this.setHasNational(this.source);
        tk = this.tm.getToken();
        if (tk.getToknum() == 398) {
            VariableName vn;
            this.delimited = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 312) {
                tk = this.tm.getToken();
            }
            if (tk.isFigurativeZero()) {
                tk = Unstring.cloneToken(tk, 10001, "'0'");
            } else if (tk.isFigurativeHighValue() && this.source.getVarDecl().isNational) {
                tk.setNational(true);
            }
            if (tk.getToknum() == 10001) {
                this.delimiters.addElement(tk);
            } else if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                vn = VariableName.get(this.tm, this.error, this.pc);
                if (vn.getVarDecl().isNumeric() && !vn.hasSubValue()) {
                    if (this.pc.getOption("-ca") == null) {
                        throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
                    }
                    if (!vn.getVarDecl().isUsageDisplay()) {
                        throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
                    }
                }
                this.setHasNational(vn);
                this.delimiters.addElement(vn);
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = this.tm.getToken();
            while (tk.getToknum() == 617) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 10001) {
                    this.delimiters.addElement(tk);
                } else if (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    vn = VariableName.get(this.tm, this.error, this.pc);
                    if (vn.getVarDecl().isNumeric()) {
                        throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
                    }
                    this.setHasNational(vn);
                    this.delimiters.addElement(vn);
                } else {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                tk = this.tm.getToken();
            }
        }
        if (tk.getToknum() != 542) {
            throw new ExpectedFoundException(tk, this.error, "'INTO'");
        }
        tk = this.tm.getToken();
        int i = 0;
        while (true) {
            VariableName vn;
            UnstringDestVar udv = new UnstringDestVar();
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                vn = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                if (this.pc.getOption("-cm") == null && (!vn.getVarDecl().isUsageDisplay() || vn.getVarDecl().isEdited())) {
                    throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
                }
            } else {
                if (i != 0) break;
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.setHasNational(vn);
            udv.destVar = vn;
            this.destVar.addElement(udv);
            tk = this.tm.getToken();
            if (tk.getToknum() == 399) {
                if (!this.delimited) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                tk = this.tm.getToken();
                if (tk.getToknum() == 526) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
                this.tm.ungetToken();
                vn = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                if (vn.getVarDecl().isNumeric()) {
                    throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
                }
                this.setHasNational(vn);
                udv.delimDestVar = vn;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 382) {
                tk = this.tm.getToken();
                if (!this.delimited) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                if (tk.getToknum() == 526) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
                this.tm.ungetToken();
                vn = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                if (!vn.getVarDecl().isInteger()) {
                    throw new GeneralErrorException(46, 4, tk, tk.getWord(), this.error);
                }
                this.setHasNational(vn);
                udv.counter = vn;
                tk = this.tm.getToken();
            }
            ++i;
        }
        if (tk.getToknum() == 813 && (tk = this.tm.getToken()).getToknum() != 638) {
            throw new ExpectedFoundException(tk, this.error, "'POINTER'");
        }
        if (tk.getToknum() == 638) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.ptr_var = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            if (!this.ptr_var.getVarDecl().isInteger()) {
                throw new GeneralErrorException(46, 4, tk, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 757) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 526) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.tally_var = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            if (!this.tally_var.getVarDecl().isInteger()) {
                throw new GeneralErrorException(46, 4, tk, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 598 || tk.getToknum() == 613 || tk.getToknum() == 624) {
            boolean on = false;
            if (tk.getToknum() == 598) {
                not = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 613) {
                on = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 624) {
                if (not) {
                    this.notOverflowBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 10);
                } else {
                    this.overflowBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 9);
                }
                tk = this.tm.getToken();
                if (!not && tk.getToknum() == 598) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 613) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 624) {
                        this.notOverflowBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (not) {
                    this.tm.ungetToken();
                }
                if (on) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 452) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.overflowBlock != null) {
            Return2.append("if(");
        } else if (this.notOverflowBlock != null) {
            Return2.append("if(!");
        }
        Return2.append(this.source.getCode());
        Return2.append(".unstring");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            Return2.append("Byte");
        }
        Return2.append("(");
        if (this.delimited) {
            Return2.append(this.getDelimitersCode());
            Return2.append("," + eol + this.parent.getIndent());
        }
        Return2.append(this.getDestinationsCode());
        Return2.append("," + eol + this.parent.getIndent());
        Return2.append(this.ptr_var == null ? "null" : this.ptr_var.getCode());
        Return2.append(" , ");
        Return2.append(this.tally_var == null ? "null" : this.tally_var.getCode());
        Return2.append(",");
        Return2.append(this.pc.getOption("-cudc") != null);
        Return2.append(")");
        if (this.overflowBlock != null || this.notOverflowBlock != null) {
            Return2.append(")");
            if (this.overflowBlock != null) {
                Return2.append(this.overflowBlock.getCode());
                if (this.notOverflowBlock != null) {
                    Return2.append(" else ");
                    Return2.append(this.notOverflowBlock.getCode());
                }
            } else if (this.notOverflowBlock != null) {
                Return2.append(this.notOverflowBlock.getCode());
            }
        } else {
            Return2.append(";");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private String getDestinationsCode() {
        StringBuffer dests = new StringBuffer();
        StringBuffer dlm_dests = new StringBuffer();
        StringBuffer cnt_dests = new StringBuffer();
        dests.append("new CobolVar[] { ");
        if (this.delimited) {
            dlm_dests.append("new CobolVar[] { ");
            cnt_dests.append("new NumericVar[] { ");
        }
        Enumeration e = this.destVar.elements();
        while (e.hasMoreElements()) {
            UnstringDestVar udv = (UnstringDestVar)e.nextElement();
            dests.append(udv.destVar.getCode());
            if (this.delimited) {
                dlm_dests.append(udv.delimDestVar == null ? "null" : udv.delimDestVar.getCode());
                cnt_dests.append(udv.counter == null ? "null" : udv.counter.getCode());
            }
            if (!e.hasMoreElements()) continue;
            dests.append(",");
            if (!this.delimited) continue;
            dlm_dests.append(",");
            cnt_dests.append(",");
        }
        dests.append(" } ");
        if (this.delimited) {
            dlm_dests.append(" } ");
            cnt_dests.append(" } ");
        }
        if (this.delimited) {
            dests.append("," + eol + this.parent.getIndent()).append(dlm_dests.toString()).append("," + eol + this.parent.getIndent()).append(cnt_dests.toString());
        }
        return dests.toString();
    }

    static Token cloneToken(Token tk, int toknum, String word) {
        Token Return2 = new Token(tk);
        Return2.setToknum(toknum);
        Return2.setWord(word);
        Return2.setAll(tk.isAll());
        return Return2;
    }

    private String getDelimitersCode() {
        StringBuffer delims = new StringBuffer();
        StringBuffer isAll = new StringBuffer();
        delims.append("new CobolVar[] { ");
        isAll.append("new boolean[] { ");
        Enumeration e = this.delimiters.elements();
        while (e.hasMoreElements()) {
            CobolToken tk = (CobolToken)e.nextElement();
            if (tk instanceof Token) {
                Token t = (Token)tk;
                isAll.append(t.isAll());
                if (t.isAll()) {
                    t.setAll(false);
                }
                delims.append(this.getCodeLiteral(t));
            } else {
                VariableName vn = (VariableName)tk;
                isAll.append(vn.getNameToken().isAll());
                delims.append(vn.getCode());
            }
            if (!e.hasMoreElements()) continue;
            delims.append(",");
            isAll.append(",");
        }
        delims.append(" } ");
        isAll.append(" } ");
        return delims.append("," + eol + this.parent.getIndent()).append(isAll.toString()).toString();
    }

    public Block getOverflowBlock() {
        return this.overflowBlock;
    }

    public Block getNotOverflowBlock() {
        return this.notOverflowBlock;
    }

    public VariableName getPtrVar() {
        return this.ptr_var;
    }

    public VariableName getTallyVar() {
        return this.tally_var;
    }

    public Vector getDestVars() {
        return this.destVar;
    }

    public Vector getDelimiters() {
        return this.delimiters;
    }

    public VariableName getSource() {
        return this.source;
    }

    public boolean isDelimited() {
        return this.delimited;
    }

    private void setHasNational(VariableName vn) {
        if (!this.hasNational) {
            VariableDeclaration vd = vn.getVarDecl();
            this.hasNational = vd != null && (vd.isNational() || vd.isPicG());
        }
    }

    public class UnstringDestVar {
        VariableName destVar = null;
        VariableName delimDestVar = null;
        VariableName counter = null;

        public VariableName getDestVar() {
            return this.destVar;
        }

        public VariableName getDelimDestVar() {
            return this.delimDestVar;
        }

        public VariableName getCounter() {
            return this.counter;
        }
    }
}

