/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Subtract
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private TokenList numList = new TokenList();
    private VariableNameList varList = new VariableNameList();
    private VariableNameList varFromList = new VariableNameList();
    private VariableNameList varGiving = new VariableNameList();
    private Token tokenFrom;
    private boolean giving;
    private boolean corresponding;
    private boolean corrRounded;
    private OnSizeError ose;

    public Subtract(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 381 || tk.getToknum() == 380) {
            this.subCorr(tk, kw, par, p, t, err);
        } else {
            this.subFrom(tk, kw, par, p, t, err);
        }
    }

    private void subFrom(Token tk, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        VariableName varFrom;
        block34: {
            varFrom = null;
            block11: while (true) {
                switch (tk.getToknum()) {
                    case 10001: {
                        if (!tk.isNull()) break block11;
                        tk.setZero();
                    }
                    case 10002: 
                    case 10017: {
                        this.numList.addItem(tk);
                        varFrom = null;
                        break;
                    }
                    case 10009: {
                        this.tm.ungetToken();
                        varFrom = VariableName.getAny(this.tm, this.error, this.pc);
                        if (varFrom != null && varFrom.isNumeric() && !varFrom.isEdited()) {
                            this.varList.addItem(varFrom);
                            break;
                        }
                        throw new GeneralErrorException(109, 4, varFrom.getNameToken(), varFrom.getName(), this.error);
                    }
                    default: {
                        break block11;
                    }
                }
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 498) {
                block12: while (true) {
                    tk = this.tm.getToken();
                    switch (tk.getToknum()) {
                        case 702: {
                            if (varFrom != null) {
                                varFrom.rounded = true;
                                continue block12;
                            }
                            throw new UnexpectedTokenException(tk, this.error);
                        }
                        case 10001: {
                            if (!tk.isNull()) break block34;
                            tk.setZero();
                        }
                        case 10002: 
                        case 10017: {
                            if (this.tokenFrom != null) {
                                throw new UnexpectedTokenException(tk, this.error);
                            }
                            this.tokenFrom = tk;
                            varFrom = null;
                            continue block12;
                        }
                        case 10009: {
                            this.tm.ungetToken();
                            varFrom = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                            if (varFrom != null && varFrom.isNumeric() && !varFrom.isEdited()) {
                                this.varFromList.addItem(varFrom);
                                continue block12;
                            }
                            throw new GeneralErrorException(109, 4, varFrom.getNameToken(), varFrom.getName(), this.error);
                        }
                    }
                    break;
                }
            } else {
                throw new ExpectedFoundException(tk, this.error, "FROM");
            }
        }
        if (tk.getToknum() == 505) {
            this.giving = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                while (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    varFrom = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
                    if (varFrom == null || !varFrom.isNumeric()) {
                        throw new GeneralErrorException(109, 4, varFrom.getNameToken(), varFrom.getName(), this.error);
                    }
                    this.varGiving.addItem(varFrom);
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 702) continue;
                    varFrom.rounded = true;
                    tk = this.tm.getToken();
                }
                if (this.varFromList.getItemNum() > 1) {
                    throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            if (this.varFromList.getItemNum() > 0) {
                this.varFromList.getFirst().setPropTypeGet();
            }
        } else {
            if (this.tokenFrom != null) {
                throw new GeneralErrorException(17, 4, this.tokenFrom, this.tokenFrom.getWord(), this.error);
            }
            VariableName v = this.varFromList.getFirst();
            while (v != null) {
                v.checkPropTypeSetGet();
                v = this.varFromList.getNext();
            }
        }
        if (!this.giving && varFrom == null || this.varList.getItemNum() + this.numList.getItemNum() < 1) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.ose = new OnSizeError(kw, par, this, p, t, err);
        tk = this.tm.getToken();
        if (tk.getToknum() != 449) {
            this.tm.ungetToken();
        }
    }

    private void subCorr(Token tk, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        VariableName var;
        this.corresponding = true;
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                var = VariableName.get(this.tm, this.error, this.pc);
                if (var != null) {
                    if (var.isSetGetProperty()) {
                        throw new GeneralErrorException(75, 4, var.getNameToken(), var.getNameToken().getWord(), this.error);
                    }
                    this.varList.addItem(var);
                    var.getVarDecl().setUsedAll();
                    break;
                }
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
            default: {
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 498) {
            throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
        }
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10009: {
                this.tm.ungetToken();
                var = VariableName.get(this.tm, this.error, this.pc);
                if (var != null) {
                    this.varFromList.addItem(var);
                    var.getVarDecl().setUsedAll();
                    break;
                }
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
            default: {
                throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
            }
        }
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 702: {
                var.rounded = true;
                this.corrRounded = true;
                break;
            }
            default: {
                this.tm.ungetToken();
            }
        }
        this.ose = new OnSizeError(kw, par, this, p, t, err);
        tk = this.tm.getToken();
        if (tk.getToknum() != 449) {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getInitialEvaluation(boolean couldBeNativeInt) {
        StringBuffer Return2 = new StringBuffer();
        if (couldBeNativeInt) {
            if (this.giving) {
                if (this.varFromList.getItemNum() > 0) {
                    Return2.append(this.varFromList.getFirst().getCode());
                } else {
                    Return2.append(Expression.toNum(this.tokenFrom));
                }
                Return2.append(" - (");
            }
            if (this.varList.getItemNum() > 0) {
                Return2.append(this.varList.getFirst().getCode());
                VariableName vn = this.varList.getNext();
                while (vn != null) {
                    Return2.append(" + ");
                    Return2.append(vn.getCode());
                    vn = this.varList.getNext();
                }
                Token tk = this.numList.getFirst();
                while (tk != null) {
                    Return2.append(" + ");
                    Return2.append(Expression.toNum(tk));
                    tk = this.numList.getNext();
                }
            } else {
                Return2.append(Expression.toNum(this.numList.getFirst()));
                Token tk = this.numList.getNext();
                while (tk != null) {
                    Return2.append(" + ");
                    Return2.append(Expression.toNum(tk));
                    tk = this.numList.getNext();
                }
            }
        } else {
            if (this.giving) {
                if (this.varFromList.getItemNum() > 0) {
                    Return2.append(Compute.getCobolNumCode(this.varFromList.getFirst()));
                } else {
                    Return2.append(this.getCodeLiteral(this.tokenFrom));
                    Return2.append(".num()");
                }
                Return2.append(".subtract(");
            }
            if (this.varList.getItemNum() > 0) {
                Return2.append(Compute.getCobolNumCode(this.varList.getFirst()));
                VariableName vn = this.varList.getNext();
                while (vn != null) {
                    Return2.append(".add(");
                    Return2.append(Compute.getCobolNumCode(vn));
                    Return2.append(")");
                    vn = this.varList.getNext();
                }
                Token tk = this.numList.getFirst();
                while (tk != null) {
                    Return2.append(".add(");
                    Return2.append(this.getCodeLiteral(tk));
                    Return2.append(".num())");
                    tk = this.numList.getNext();
                }
            } else {
                Return2.append(this.getCodeLiteral(this.numList.getFirst()));
                Return2.append(".num()");
                Token tk = this.numList.getNext();
                while (tk != null) {
                    Return2.append(".add(");
                    Return2.append(this.getCodeLiteral(tk));
                    Return2.append(".num())");
                    tk = this.numList.getNext();
                }
            }
        }
        if (this.giving) {
            Return2.append(")");
        }
        return Return2.toString();
    }

    boolean isOptimizable() {
        VariableDeclaration vd;
        if (!this.ose.hasBlocks() && this.varGiving.getItemNum() == 0 && (this.varList.getItemNum() == 0 && this.numList.getItemNum() == 1 && this.numList.getFirst().getToknum() == 10002 || this.varList.getItemNum() == 1 && this.numList.getItemNum() == 0 && (vd = this.varList.getFirst().getVarDecl()).isInteger() && vd.getLogicLen() <= 18)) {
            VariableName vn = this.varFromList.getFirst();
            while (vn != null) {
                vd = vn.getVarDecl();
                if (vn.rounded && vd.getPNumber() != 0 || !vd.isInteger() || vd.getLogicLen() > 18) {
                    return false;
                }
                vn = this.varFromList.getNext();
            }
            return true;
        }
        return false;
    }

    @Override
    void getCodeCorrEach(StringBuffer Return2, String var, VariableDeclaration fvd, String fromVar, VariableDeclaration tvd) {
        Return2.append(fromVar);
        Return2.append(".set(");
        Return2.append(fromVar);
        Return2.append(".num().subtract(");
        Return2.append(var);
        Return2.append(".num()),");
        Return2.append(this.corrRounded);
        if (this.ose.hasBlocks()) {
            Return2.append(",true)|");
        } else {
            Return2.append(",false);");
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.corresponding) {
            this.getCodeDebug(Return2);
            Return2.append(this.ose.getCodeBefore());
            this.getCodeCorresponding(Return2, this.varList.getFirst(), this.varFromList.getFirst(), true);
            if (this.ose.hasBlocks()) {
                Return2.setLength(Return2.length() - 1);
            } else {
                Return2.append(eol);
            }
            Return2.append(this.ose.getCode());
        } else if (this.isOptimizable()) {
            VariableName vf = this.varList.getFirst();
            Token tk = this.numList.getFirst();
            this.getCodeDebug(Return2);
            VariableName vn = this.varFromList.getFirst();
            while (vn != null) {
                Return2.append(this.parent.getIndent());
                Return2.append(vn.getCode());
                Return2.append(".subFromMe(");
                if (tk != null) {
                    Return2.append(tk.getAsLong());
                } else {
                    Return2.append(vf.getCode());
                    Return2.append(".tolong()");
                }
                Return2.append(");");
                Return2.append(eol);
                vn = this.varFromList.getNext();
            }
        } else {
            VariableName vn;
            String initEval;
            int i;
            VariableNameList vlDest = this.varGiving.getItemNum() > 0 ? this.varGiving : this.varFromList;
            boolean couldBeNativeInt = true;
            int n = this.varList.getItemNum();
            for (i = 0; i < n && couldBeNativeInt; couldBeNativeInt &= Expression.couldBeNativeInt(this.varList.getAt(i).getVarDecl()), ++i) {
            }
            if (couldBeNativeInt) {
                if (this.giving) {
                    couldBeNativeInt = this.varFromList.getItemNum() > 0 ? (couldBeNativeInt &= Expression.couldBeNativeInt(this.varFromList.getFirst().getVarDecl())) : (couldBeNativeInt &= Expression.couldBeNativeInt(this.tokenFrom));
                }
                if (couldBeNativeInt) {
                    Token tk;
                    n = this.numList.getItemNum();
                    for (i = 0; i < n && couldBeNativeInt; couldBeNativeInt &= Expression.couldBeNativeInt(tk), ++i) {
                        tk = this.numList.getAt(i);
                    }
                }
            }
            if (vlDest.getItemNum() > 1) {
                initEval = "sub$" + Subtract.getUniqueId();
                Return2.append(this.parent.getIndent());
                if (couldBeNativeInt) {
                    Return2.append("long ");
                } else {
                    Return2.append("CobolNum ");
                }
                Return2.append(initEval);
                Return2.append("=");
                Return2.append(this.getInitialEvaluation(couldBeNativeInt));
                Return2.append(";");
                Return2.append(eol);
            } else {
                initEval = this.getInitialEvaluation(couldBeNativeInt);
            }
            Return2.append(this.parent.getIndent());
            this.getCodeDebug(Return2);
            VariableNameList vlDestPrim = new VariableNameList();
            int i2 = 0;
            while (i2 < vlDest.getItemNum()) {
                vn = vlDest.getAt(i2);
                if (vn.isPrimitive()) {
                    vlDestPrim.addItem(vn);
                    vlDest.deleteCurrent();
                    continue;
                }
                ++i2;
            }
            n = vlDestPrim.getItemNum();
            for (i2 = 0; i2 < n; ++i2) {
                String val;
                vn = vlDestPrim.getAt(i2);
                Return2.append(vn.getCode());
                String t = vn.getType().getName(true);
                Return2.append(" = ");
                if (this.giving) {
                    if (couldBeNativeInt) {
                        Return2.append(Compute.addCast(t, initEval));
                    } else {
                        Return2.append(Compute.getConversionMethod(t, initEval));
                    }
                } else if (Expression.couldBeNativeInt(vn.getVarDecl())) {
                    if (couldBeNativeInt) {
                        val = vn.getCode() + " - (" + initEval + ")";
                        Return2.append(Compute.addCast(t, val));
                    } else {
                        Return2.append(Compute.getConversionMethod(t, "CobolNum.noo((long) " + vn.getCode() + ", 0).subtract(" + initEval + ")"));
                    }
                } else if (couldBeNativeInt) {
                    val = vn.isNumericVar() ? vn.getCode() + ".tolong()" : vn.getCode();
                    val = val + " - " + initEval;
                    Return2.append(Compute.addCast(t, val));
                } else {
                    val = vn.isNumericVar() ? vn.getCode() + ".num()" : "CobolNum.noo((double) " + vn.getCode() + ")";
                    val = val + ".subtract(" + initEval + ")";
                    Return2.append(Compute.getConversionMethod(t, val));
                }
                Return2.append(";");
                if (i2 >= n - 1) continue;
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
            n = vlDest.getItemNum();
            if (n > 0) {
                if (vlDestPrim.getItemNum() > 0) {
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                }
                Return2.append(this.ose.getCodeBefore());
                for (i2 = 0; i2 < n; ++i2) {
                    vn = vlDest.getAt(i2);
                    Return2.append(vn.getCode());
                    Return2.append(".set(");
                    if (this.giving) {
                        Return2.append(initEval);
                        if (couldBeNativeInt) {
                            Return2.append(",0");
                        }
                    } else {
                        Return2.append(vn.getCode());
                        Return2.append(".num().subtract(");
                        if (couldBeNativeInt) {
                            Return2.append("CobolNum.noo(");
                            Return2.append(initEval);
                            Return2.append(",0)");
                        } else {
                            Return2.append(initEval);
                        }
                        Return2.append(")");
                    }
                    Return2.append(",");
                    Return2.append(vn.rounded);
                    Return2.append(",");
                    Return2.append(this.ose.hasBlocks());
                    Return2.append(")");
                    if (i2 >= n - 1) break;
                    Return2.append(this.ose.hasBlocks() ? "|" : ";");
                }
                Return2.append(this.ose.getCode());
            }
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }

    public VariableNameList getVarGiving() {
        return this.varGiving;
    }

    public boolean isCorresponding() {
        return this.corresponding;
    }

    public TokenList getNumList() {
        return this.numList;
    }

    public VariableNameList getVarList() {
        return this.varList;
    }

    public VariableNameList getVarFromList() {
        return this.varFromList;
    }

    public Token getTokenFrom() {
        return this.tokenFrom;
    }
}

