/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class SqlVar
extends SqlStatement {
    static final int SQL_TYPE_NOBIN = 0;
    static final int SQL_TYPE_BINARY = 1;
    VariableName var;
    int sqlType = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlVar(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, par, p, t, err, false);
        Token tk = this.tm.getToken();
        if (tk == null || tk.getToknum() != 10009) throw new GeneralErrorException(15, 4, tk, tk.getWord(), this.error);
        this.ungetSqlToken();
        this.var = VariableName.get(this.tm, this.error, this.pc);
        tk = this.getSqlToken();
        if (tk == null || !tk.getWord().equalsIgnoreCase("IS")) throw new GeneralErrorException(15, 4, tk, tk.getWord(), this.error);
        tk = this.getSqlToken();
        if (tk == null) throw new GeneralErrorException(12, 4, null, "", this.error);
        if (tk.getWord().equalsIgnoreCase("LONG")) {
            tk = this.tm.getToken();
        }
        this.sqlType = tk != null && tk.getWord().equalsIgnoreCase("RAW") || tk.getWord().equalsIgnoreCase("BINARY") ? 1 : 0;
        while ((tk = this.getSqlToken()) != null && tk.getToknum() != 432) {
        }
        this.ungetAllSqlToken();
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.sqlType == 1) {
            Return2.append(this.var.getName().replace('-', Pcc.hyphenRepl) + ".setSqlBinary();" + eol);
        }
        return Return2.toString();
    }
}

