/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class SqlClose
extends SqlStatement {
    private String name;

    public SqlClose(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, par, p, t, err);
        Token tk = this.getSqlToken();
        if (tk.getToknum() == 58) {
            this.cursHndl = this.getHostVariable();
            if (!this.cursHndl.getVarDecl().isHandle()) {
                throw new GeneralErrorException(11, 4, this.cursHndl.getNameToken(), this.cursHndl.getName(), this.error);
            }
        } else {
            this.name = tk.getWord();
            if (!this.pc.checkCursor(this.name)) {
                throw new GeneralErrorException(93, 4, tk, this.name, this.error);
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.name != null) {
            SqlDeclareCursor c = this.pc.getCursor(this.name);
            this.isSqljStat = c.isSqljStat;
            if (c.getPrepStat() != null) {
                this.isSqljStat = false;
            }
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.sqlj && this.isSqljStat) {
            Return2.append(this.parent.getIndent());
            Return2.append("clearSqlca(" + this.pc.sqlca.SQLCA + ");" + eol);
            Return2.append(this.parent.getIndent());
            Return2.append("try {" + eol);
            Return2.append(this.parent.getIndent());
            if (this.name != null) {
                Return2.append("if (" + this.name + " != null)" + eol);
                Return2.append(this.parent.getIndent() + "   ");
                Return2.append(this.name + ".close();");
            } else {
                Return2.append("if (" + this.cursHndl.getCode() + " != null)" + eol);
                Return2.append(this.parent.getIndent() + "   ");
                Return2.append(this.cursHndl.getCode() + ".close();");
            }
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append("else" + eol);
            Return2.append(this.parent.getIndent());
            Return2.append("   throw new SQLException(\"IsCOBOLNotFound\");");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append("}" + eol);
            Return2.append(this.parent.getIndent());
            Return2.append("catch (SQLException e) {" + eol);
            Return2.append(this.parent.getIndent());
            Return2.append("   fillSqlcaSqlj(e, " + this.pc.sqlca.SQLCA + ");" + eol);
            Return2.append(this.parent.getIndent());
            Return2.append("}" + eol);
            Return2.append(this.parent.getIndent());
            Return2.append("Esql.LOG_SQLJ(\"SQLJStat: CLOSE " + this.name + " SQLCODE=\" + " + this.pc.sqlca.SQLCODE + ".toString() + \" SQLERRMC=\" + " + this.pc.sqlca.SQLERRMC + ".toString());" + eol);
        } else {
            Return2.append(this.getReturnCode());
            if (this.name != null) {
                Return2.append(".set(Esql.CLOSE(new Object[] {");
                Return2.append(this.pc.sqlca.SQLCA + ", \"");
                Return2.append(this.name);
                Return2.append("\", null, " + this.getInstanceName());
                Return2.append("}));");
            } else {
                Return2.append(".set(Esql.CLOSE_HNDL(new Object[] {");
                Return2.append(this.pc.sqlca.SQLCA + ", ");
                Return2.append(this.cursHndl.getCode());
                if (this.pc.getOption("-xcsqc") != null) {
                    Return2.append(", " + this.getInstanceName());
                }
                Return2.append("}));");
            }
        }
        Return2.append(eol);
        this.addWhenever(Return2);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    @Override
    public VariableName getCursorHandle() {
        if (this.cursHndl == null) {
            return this.pc.getCursor(this.name).getCursorHandle();
        }
        return this.cursHndl;
    }

    public String getName() {
        return this.name;
    }
}

