/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.LikeFlags;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.SubValueList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class SimpleCondition
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int OP_EQ = 1;
    public static final int OP_NE = 2;
    public static final int OP_GE = 3;
    public static final int OP_LE = 4;
    public static final int OP_GT = 5;
    public static final int OP_LT = 6;
    public static final int OP_C_POSITIVE = 7;
    public static final int OP_C_NEGATIVE = 8;
    public static final int OP_C_ZERO = 9;
    public static final int OP_C_NUMERIC = 10;
    public static final int OP_C_ALPHABETIC = 11;
    public static final int OP_C_ALPHABETIC_UPPER = 12;
    public static final int OP_C_ALPHABETIC_LOWER = 13;
    public static final int OP_C_UNSET = 14;
    public static final int OP_C_CLASS = 15;
    public static final int OP_LIKE = 16;
    public static final int OP_HANDLE = 17;
    public static final int OP_NOT = 128;
    Expression left;
    Expression right;
    int op;
    private boolean isUnaryOp;
    private SpecialNamesClass snc;
    private LikeFlags like;

    public SimpleCondition(Expression lastLeft, boolean not, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.left = lastLeft;
        this.init(new int[]{0}, null, 14, not);
    }

    public SimpleCondition(int[] openPar, Expression lastLeft, int lastOp, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.left = new Expression(openPar, this.keyWord, this.parent, this.pc, this.tm, this.error, true, true);
        this.init(openPar, lastLeft, lastOp, false);
    }

    static boolean isBinaryOperator(Token tk) {
        switch (tk.getToknum()) {
            case 60: 
            case 61: 
            case 62: 
            case 462: 
            case 463: 
            case 471: 
            case 507: 
            case 510: 
            case 560: 
            case 561: 
            case 784: {
                return true;
            }
        }
        return false;
    }

    private void init(int[] openPar, Expression lastLeft, int lastOp, boolean not) throws GeneralErrorException, EndOfProgramException {
        Token lt;
        Token tk;
        if (this.left.getType() == 1 && !this.left.isObjectReference()) {
            return;
        }
        if (this.left.getType() == 0) {
            if (lastLeft != null && lastOp != 0) {
                this.left = lastLeft;
            } else {
                throw new UnexpectedTokenException(this.tm.getToken(), this.error);
            }
        }
        if ((tk = this.tm.getToken()).getToknum() == 545) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 598) {
            not = true;
            tk = this.tm.getToken();
        }
        switch (tk.getToknum()) {
            case 61: 
            case 462: 
            case 463: {
                this.op = 1;
                tk = this.tm.getToken();
                if (tk.getToknum() == 773) break;
                this.tm.ungetToken();
                break;
            }
            case 784: {
                this.op = 2;
                tk = this.tm.getToken();
                if (tk.getToknum() == 773) break;
                this.tm.ungetToken();
                break;
            }
            case 60: 
            case 62: 
            case 471: 
            case 507: 
            case 560: {
                if (tk.getToknum() == 60) {
                    Token tk1 = this.tm.getToken();
                    if (tk1.getToknum() == 62) {
                        this.op = 2;
                        break;
                    }
                    this.tm.ungetToken();
                }
                this.op = tk.getToknum() == 560 || tk.getToknum() == 60 ? 6 : 5;
                tk = this.tm.getToken();
                if (tk.getToknum() == 761) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 617 || tk.getToknum() == 61) {
                    if (tk.getToknum() == 617) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 462 && tk.getToknum() != 61) break;
                    switch (this.op) {
                        case 3: {
                            this.op = 5;
                            break;
                        }
                        case 6: {
                            this.op = 4;
                            break;
                        }
                        case 4: {
                            this.op = 6;
                            break;
                        }
                        case 5: {
                            this.op = 3;
                        }
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 773) break;
                    this.tm.ungetToken();
                    break;
                }
                this.tm.ungetToken();
                break;
            }
            case 642: {
                this.op = 7;
                if (!this.left.isNumeric()) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.isUnaryOp = true;
                break;
            }
            case 594: {
                this.op = 8;
                if (!this.left.isNumeric()) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.isUnaryOp = true;
                break;
            }
            case 603: {
                this.op = 10;
                if (this.left.firstVar == null || this.left.hasOperator) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.isUnaryOp = true;
                break;
            }
            case 266: {
                if (this.left.isNumeric() || this.left.firstVar == null || this.left.hasOperator) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.op = 11;
                this.isUnaryOp = true;
                break;
            }
            case 267: {
                if (this.left.isNumeric() || this.left.firstVar == null || this.left.hasOperator) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.op = 13;
                this.isUnaryOp = true;
                break;
            }
            case 268: {
                if (this.left.isNumeric() || this.left.firstVar == null || this.left.hasOperator) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.op = 12;
                this.isUnaryOp = true;
                break;
            }
            case 561: {
                if (this.left.isNumeric() || this.left.hasOperator) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.like = new LikeFlags(this.tm, this.error, this.pc);
                this.op = 16;
                this.isUnaryOp = false;
                break;
            }
            case 510: {
                if (this.left.getAsVar() == null || !this.left.getAsVar().getVarDecl().isHandle()) {
                    throw new IllegalConditionException(tk, this.error);
                }
                tk = this.tm.getToken();
                if (tk.getToknum() != 609) {
                    this.tm.ungetToken();
                }
                this.op = 17;
                break;
            }
            case 822: {
                this.op = 9;
                if (!this.left.isNumeric()) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.isUnaryOp = true;
                break;
            }
            case 10002: {
                if (tk.isFigurativeZero()) {
                    this.op = 9;
                    if (!this.left.isNumeric()) {
                        throw new IllegalConditionException(tk, this.error);
                    }
                    this.isUnaryOp = true;
                    break;
                }
            }
            case 10009: {
                this.snc = this.pc.getSpecialNamesClass(tk.getCode());
                if (this.snc != null) {
                    if (this.left.isNumeric() || this.left.firstVar == null || this.left.hasOperator) {
                        throw new IllegalConditionException(tk, this.error);
                    }
                    this.op = 15;
                    this.isUnaryOp = true;
                    break;
                }
            }
            default: {
                if (not) {
                    this.op = 1;
                    this.error.print(18, 3, tk, "EQUAL assumed");
                } else {
                    this.op = 14;
                }
                this.tm.ungetToken();
            }
        }
        if (!(this.left.getType() != 4 || this.left.isJavaString() || this.op == 1 || this.op == 2 || (lt = this.left.getAsToken()) != null && lt.isNull())) {
            throw new IllegalConditionException(tk, this.error);
        }
        if (this.op != 14 && !this.isUnaryOp) {
            while ((tk = this.tm.getToken()).getToknum() == 40) {
                openPar[0] = openPar[0] + 1;
            }
            this.tm.ungetToken();
            this.right = new Expression(openPar, this.keyWord, this.parent, this.pc, this.tm, this.error, true, true);
        } else if (this.op == 14 && lastLeft != null && this.left != lastLeft) {
            this.right = this.left;
            this.left = lastLeft;
            this.op = lastOp;
        }
        if (not) {
            this.op |= 0x80;
        }
    }

    boolean isBoolean() {
        return this.left.getType() == 1 && (!this.left.isObjectReference() || this.right == null);
    }

    boolean isFullCondition() {
        return this.isBoolean() || this.op != 14 && this.left != null && (this.isUnaryOp || this.right != null);
    }

    private String getCodeBoolean() {
        return this.left.getCode();
    }

    private String getCodeObject() {
        boolean eq;
        StringBuffer Return2 = new StringBuffer("(");
        switch (this.op) {
            case 1: 
            case 130: {
                eq = true;
                break;
            }
            case 2: 
            case 129: {
                eq = false;
                break;
            }
            default: {
                throw new InternalErrorException("op=" + this.op);
            }
        }
        int lt = this.left.getType();
        int rt = this.right.getType();
        boolean ls = this.left.isJavaString() || lt == 2;
        boolean rs = this.right.isJavaString() || rt == 2;
        boolean ljnw = this.left.isJavaNumericWrapper();
        boolean rjnw = this.right.isJavaNumericWrapper();
        if (ls && rs || ljnw && rt == 3 || lt == 3 && rjnw || ljnw && rjnw) {
            if (!eq) {
                Return2.append("!");
            }
            Return2.append("ExprUtil.eq(");
            Return2.append(this.left.getCode());
            Return2.append(", ");
            Return2.append(this.right.getCode());
            Return2.append("))");
        } else {
            if ((this.left.isPrimitiveWrapper() || this.left.isNull()) && (this.right.isPrimitiveWrapper() || this.right.isNull())) {
                this.left.setObject();
                this.right.setObject();
            }
            Return2.append(this.left.getCode());
            if (eq) {
                Return2.append("==");
            } else {
                Return2.append("!=");
            }
            Return2.append(this.right.getCode());
            Return2.append(")");
        }
        return Return2.toString();
    }

    private static void uDisplayGetCode(int op, StringBuffer Return2) {
        switch (op & 0xFFFFFF7F) {
            case 1: {
                Return2.append(")==0");
                break;
            }
            case 2: {
                Return2.append(")!=0");
                break;
            }
            case 3: {
                Return2.append(")>=0");
                break;
            }
            case 4: {
                Return2.append(")<=0");
                break;
            }
            case 5: {
                Return2.append(")>0");
                break;
            }
            case 6: {
                Return2.append(")<0");
                break;
            }
            default: {
                throw new InternalErrorException("isUDisplayCond op=" + op);
            }
        }
    }

    private static NameAndLen isUDisplayExpr(TokenManager tm, Expression expr) {
        VariableName vn = expr.getAsVar();
        if (vn != null) {
            return NameAndLen.get(vn);
        }
        Token tk = expr.getAsToken();
        if (tk != null) {
            return NameAndLen.get(tm, tk);
        }
        return null;
    }

    static boolean getUDisplayCond(NameAndLen lnal, NameAndLen rnal, int op, StringBuffer code, Alphabet cs) {
        if (lnal != null && rnal != null && (lnal.isNum || rnal.isNum) && (lnal.decimals == rnal.decimals || lnal.name == null || rnal.name == null)) {
            if (lnal.name == null) {
                if (rnal.name == null) {
                    if (lnal.isNum) {
                        if (rnal.isNum) {
                            code.append("(0");
                        } else {
                            code.append("(1");
                        }
                    } else if (rnal.isNum) {
                        code.append("(-1");
                    } else {
                        code.append("(0");
                    }
                    SimpleCondition.uDisplayGetCode(op, code);
                    return true;
                }
                if (lnal.isNum) {
                    code.append("Factory.cmp((byte) " + Token.getEncByte('0') + ",");
                } else {
                    code.append("Factory.cmp((byte) " + Token.getEncByte(' ') + ",");
                }
                code.append(rnal.name);
                code.append(".getMemory(),");
                code.append(rnal.name);
                code.append(".getOffset(),");
                code.append(rnal.len);
                if (cs != null) {
                    code.append(',');
                    code.append(cs.getDeclUnivoqueName());
                }
                SimpleCondition.uDisplayGetCode(op, code);
                return true;
            }
            if (rnal.name == null) {
                code.append("Factory.cmp(");
                code.append(lnal.name);
                code.append(".getMemory(),");
                code.append(lnal.name);
                if (rnal.isNum) {
                    code.append(".getOffset(), (byte) " + Token.getEncByte('0') + ",");
                } else {
                    code.append(".getOffset(), (byte) " + Token.getEncByte(' ') + ",");
                }
                code.append(lnal.len);
                if (cs != null) {
                    code.append(',');
                    code.append(cs.getDeclUnivoqueName());
                }
                SimpleCondition.uDisplayGetCode(op, code);
                return true;
            }
            if (lnal.len == rnal.len) {
                code.append("Factory.cmp(");
                code.append(lnal.name);
                code.append(".getMemory(),");
                code.append(lnal.name);
                code.append(".getOffset(),");
                code.append(rnal.name);
                code.append(".getMemory(),");
                code.append(rnal.name);
                code.append(".getOffset(),");
                code.append(rnal.len);
                if (cs != null) {
                    code.append(',');
                    code.append(cs.getDeclUnivoqueName());
                }
                SimpleCondition.uDisplayGetCode(op, code);
                return true;
            }
        }
        return false;
    }

    static boolean isUDisplayCond(Expression left, int op, Expression right, StringBuffer code, Alphabet cs, TokenManager tm) {
        if (left != null && right != null && !left.hasOperator && !right.hasOperator) {
            return SimpleCondition.getUDisplayCond(SimpleCondition.isUDisplayExpr(tm, left), SimpleCondition.isUDisplayExpr(tm, right), op, code, cs);
        }
        return false;
    }

    private boolean isUDisplayCond(StringBuffer code, Alphabet cs) {
        if (this.left != null && this.right != null && !this.left.hasOperator && !this.right.hasOperator) {
            return SimpleCondition.getUDisplayCond(SimpleCondition.isUDisplayExpr(this.tm, this.left), SimpleCondition.isUDisplayExpr(this.tm, this.right), this.op, code, cs);
        }
        return false;
    }

    private void compareStd(StringBuffer code, String jOp, Alphabet cs) {
        if (this.left.isJavaNumericWrapper() || this.right.isJavaNumericWrapper()) {
            code.append("ExprUtil.cmp(");
            code.append(this.left.getCode());
            code.append(", ");
            code.append(this.right.getCode());
            code.append(")");
        } else {
            code.append(this.left.getCode());
            code.append(".compareTo(");
            code.append(this.right.getCode());
            if (!this.left.isNumeric() && !this.right.isNumeric() && cs != null) {
                code.append("," + cs.getDeclUnivoqueName());
            }
            code.append(")");
        }
        code.append(jOp);
        code.append("0");
    }

    private boolean isXOptimizable(VariableName vn) {
        if (this.pc.optionMS) {
            return false;
        }
        if (vn.getVarDecl().isPic1()) {
            return false;
        }
        SubValueList subValue = vn.getSubValueList();
        if (subValue != null && subValue.isVarLen()) {
            return false;
        }
        return !vn.isNotXOptimizable(true);
    }

    private boolean compare(StringBuffer code, String jOp, Alphabet cs) {
        boolean opEq;
        boolean bl = opEq = jOp.equals("==") || jOp.equals("!=");
        if (this.left.couldBeNative() && this.right.couldBeNative()) {
            code.append(this.left.getCode(true));
            code.append(jOp);
            code.append(this.right.getCode(true));
            return true;
        }
        if (cs == null && this.left.isString() && this.right.isString()) {
            Token ltk = this.left.getAsToken();
            Token rtk = this.right.getAsToken();
            if (ltk != null && (ltk.isAll() || ltk.isNational() || ltk.isResource()) || rtk != null && (rtk.isAll() || rtk.isNational() || rtk.isResource())) {
                this.compareStd(code, jOp, cs);
                return true;
            }
            VariableName lvn = this.left.getAsVar();
            VariableName rvn = this.right.getAsVar();
            if ((lvn == null || this.isXOptimizable(lvn)) && (rvn == null || this.isXOptimizable(rvn))) {
                SubValueList sv;
                String rOffs;
                String rName;
                String lOffs;
                String lName;
                StringBuffer sb;
                int rLen;
                int lLen = lvn != null ? lvn.getVariableLength() : -1;
                int n = rLen = rvn != null ? rvn.getVariableLength() : -1;
                if (lvn != null) {
                    sb = new StringBuffer();
                    lName = lvn.getCode(false, false, false);
                    lvn.getCodeOffset(sb, 0);
                    lOffs = sb.toString();
                } else {
                    lName = this.left.getCode();
                    lOffs = "0";
                }
                if (rvn != null) {
                    sb = new StringBuffer();
                    rName = rvn.getCode(false, false, false);
                    rvn.getCodeOffset(sb, 0);
                    rOffs = sb.toString();
                } else {
                    rName = this.right.getCode();
                    rOffs = "0";
                }
                if (lLen == rLen && lLen != -1) {
                    if (lLen == 1) {
                        String closeBrkt;
                        String openBrkt;
                        if (this.pc.getOption("-xms") != null) {
                            openBrkt = ".get(";
                            closeBrkt = ")";
                        } else {
                            openBrkt = "[";
                            closeBrkt = "]";
                        }
                        if (!opEq) {
                            code.append("(");
                        }
                        code.append(lName);
                        code.append(".getMemory()");
                        code.append(openBrkt);
                        code.append(lOffs);
                        code.append(closeBrkt);
                        if (!opEq) {
                            code.append("&0xff)");
                        }
                        code.append(jOp);
                        if (!opEq) {
                            code.append("(");
                        }
                        code.append(rName);
                        code.append(".getMemory()");
                        code.append(openBrkt);
                        code.append(rOffs);
                        code.append(closeBrkt);
                        if (!opEq) {
                            code.append("&0xff)");
                        }
                        return true;
                    }
                    code.append("Factory.cmp(");
                    code.append(lName);
                    code.append(".getMemory(),");
                    code.append(lOffs);
                    code.append(",");
                    code.append(rName);
                    code.append(".getMemory(),");
                    code.append(rOffs);
                    code.append(",");
                    code.append(lLen);
                    code.append(")");
                    code.append(jOp);
                    code.append("0");
                    return true;
                }
                code.append("Factory.cmp(");
                code.append(lName);
                code.append(".getMemory(),");
                code.append(lOffs);
                code.append(",");
                if (lLen == -1) {
                    if (lvn != null) {
                        if (!lvn.getSubstringLen(code, 0)) {
                            sv = lvn.getSubValueList();
                            code.append(lName);
                            code.append(".length()+1-");
                            code.append(sv.getOffset());
                        }
                    } else {
                        code.append(lName);
                        code.append(".length()");
                    }
                } else {
                    code.append(lLen);
                }
                code.append(",");
                code.append(rName);
                code.append(".getMemory(),");
                code.append(rOffs);
                code.append(",");
                if (rLen == -1) {
                    if (rvn != null) {
                        if (!rvn.getSubstringLen(code, 0)) {
                            sv = rvn.getSubValueList();
                            code.append(rName);
                            code.append(".length()+1-");
                            code.append(sv.getOffset());
                        }
                    } else {
                        code.append(rName);
                        code.append(".length()");
                    }
                } else {
                    code.append(rLen);
                }
                code.append(")");
                code.append(jOp);
                code.append("0");
                return true;
            }
            this.compareStd(code, jOp, cs);
            return true;
        }
        this.compareStd(code, jOp, cs);
        return true;
    }

    @Override
    public String getCode() {
        if (this.isBoolean()) {
            return this.getCodeBoolean();
        }
        if (this.left.getType() == 4) {
            return this.getCodeObject();
        }
        if (this.right != null) {
            switch (this.op) {
                case 1: 
                case 2: 
                case 129: 
                case 130: {
                    if (this.left.isObjectReference() && this.right.isObjectReference()) {
                        return this.getCodeObject();
                    }
                    if ((!this.left.isJavaNumericWrapper() || this.right.getType() != 3) && (this.left.getType() != 3 || !this.right.isJavaNumericWrapper())) break;
                    return this.getCodeObject();
                }
            }
        }
        StringBuffer Return2 = new StringBuffer("(");
        boolean not = (this.op & 0x80) == 128;
        Alphabet cs = null;
        if (this.pc != null) {
            cs = this.pc.getProgramCollatingSeq();
        }
        if (not) {
            Return2.append("!(");
        }
        if (this.pc.getOption("-cudc") != null) {
            StringBuffer save = new StringBuffer(Return2);
            try {
                if (this.isUDisplayCond(Return2, cs)) {
                    Return2.append(")");
                    if (not) {
                        Return2.append(")");
                    }
                    return Return2.toString();
                }
            }
            catch (InternalErrorException ex) {
                Return2 = save;
            }
        }
        switch (this.op & 0xFFFFFF7F) {
            case 1: {
                this.compare(Return2, "==", cs);
                break;
            }
            case 2: {
                this.compare(Return2, "!=", cs);
                break;
            }
            case 3: {
                this.compare(Return2, ">=", cs);
                break;
            }
            case 4: {
                this.compare(Return2, "<=", cs);
                break;
            }
            case 5: {
                this.compare(Return2, ">", cs);
                break;
            }
            case 6: {
                this.compare(Return2, "<", cs);
                break;
            }
            case 7: {
                if (this.left.firstVar == null || this.left.hasOperator) {
                    Return2.append(this.left.getCode());
                } else {
                    Return2.append(this.left.firstVar.getCode());
                }
                Return2.append(".isPositive()");
                break;
            }
            case 8: {
                if (this.left.firstVar == null || this.left.hasOperator) {
                    Return2.append(this.left.getCode());
                } else {
                    Return2.append(this.left.firstVar.getCode());
                }
                Return2.append(".isNegative()");
                break;
            }
            case 9: {
                Return2.append(this.left.getCode());
                Return2.append(".signum()==0");
                break;
            }
            case 10: {
                Return2.append(this.left.firstVar.getCode());
                Return2.append(".isNumeric()");
                break;
            }
            case 11: {
                Return2.append(this.left.firstVar.getCode());
                Return2.append(".isAlphabetic()");
                break;
            }
            case 12: {
                Return2.append(this.left.firstVar.getCode());
                Return2.append(".isAlphabeticUpper()");
                break;
            }
            case 13: {
                Return2.append(this.left.firstVar.getCode());
                Return2.append(".isAlphabeticLower()");
                break;
            }
            case 15: {
                Return2.append(this.snc.getCode(this.left.firstVar));
                break;
            }
            case 16: {
                Return2.append(this.left.getCode());
                Return2.append(".isLike(");
                Return2.append(this.right.getCode());
                Return2.append(",");
                Return2.append(this.like.getCode());
                Return2.append(")");
                break;
            }
            case 17: {
                Return2.append(this.left.firstVar.getCode());
                Return2.append(".getId()==");
                Return2.append(this.right.firstVar.getCode());
                break;
            }
            default: {
                throw new InternalErrorException("op=" + this.op);
            }
        }
        if (not) {
            Return2.append(")");
        }
        Return2.append(")");
        return Return2.toString();
    }

    public String toString() {
        if (this.left != null) {
            if (this.right != null) {
                return this.left.toString() + " & " + this.right.toString();
            }
            return this.left.toString();
        }
        if (this.right != null) {
            return this.right.toString();
        }
        return this.keyWord.getWord();
    }

    public static void check(Verb v, Expression left, int op, Expression right) throws GeneralErrorException {
        Errors error = v.error;
        if (right != null) {
            if (right.isVoid()) {
                throw new IllegalConditionException(v.keyWord, error);
            }
            if (right.getType() == 1 && !right.isObjectReference()) {
                throw new IllegalConditionException(v.keyWord, error);
            }
            if (left.isObjectReference() ^ right.isObjectReference()) {
                Token tkr;
                Token tkl = left.getAsToken();
                if (tkl != null && tkl.isNull()) {
                    if (right.getType() == 3) {
                        left.setNumericType();
                    } else if (right.isObjectReference()) {
                        left.setNull();
                    } else if (right.isString()) {
                        left.setStringType();
                    }
                }
                if ((tkr = right.getAsToken()) != null && tkr.isNull()) {
                    if (left.getType() == 3) {
                        right.setNumericType();
                    } else if (left.isObjectReference()) {
                        right.setNull();
                    } else if (left.isString()) {
                        right.setStringType();
                    }
                }
                if (left.getType() != right.getType()) {
                    boolean e = true;
                    switch (left.getType()) {
                        case 3: 
                        case 5: {
                            switch (right.getType()) {
                                case 3: 
                                case 5: {
                                    e = false;
                                }
                            }
                            break;
                        }
                        case 4: {
                            if (!left.isJavaString() || right.getType() != 2) break;
                            e = false;
                            break;
                        }
                        case 2: {
                            if (!right.isJavaString()) break;
                            e = false;
                        }
                    }
                    if (e) {
                        throw new IllegalConditionException(v.keyWord, error);
                    }
                }
            }
            if (left.getType() != right.getType()) {
                int svrty;
                if (left.getType() == 3) {
                    if (right.getType() == 2 && (svrty = left.setStringType()) != 0) {
                        error.print(svrty == 4 ? 43 : 297, svrty, v.keyWord, v.toString());
                    }
                } else if (left.getType() == 2) {
                    if (right.getType() == 3) {
                        if (op == 16) {
                            throw new IllegalConditionException(v.keyWord, error);
                        }
                        svrty = right.setStringType();
                        if (svrty != 0) {
                            error.print(svrty == 4 ? 43 : 297, svrty, v.keyWord, v.toString());
                        }
                    }
                } else {
                    MyClass ot1 = left.getCType();
                    MyClass ot2 = right.getCType();
                    if (!(op != 1 && op != 2 || ot1 == null || ot2 == null || left.isJavaNumericWrapper() && right.isJavaNumericWrapper() || ot1.isAssignableFrom(ot2) || ot2.isAssignableFrom(ot1))) {
                        throw new IllegalConditionException(v.keyWord, error);
                    }
                }
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        this.left.check();
        if (this.right != null) {
            this.right.check();
            SimpleCondition.check(this, this.left, this.op, this.right);
            if (this.op == 16) {
                this.like.check(this.right.getFirstToken());
            }
        }
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public int getOperator() {
        return this.op;
    }

    public boolean isUnary() {
        return this.isUnaryOp;
    }

    public SpecialNamesClass getSpecialNamesClass() {
        return this.snc;
    }

    static class NameAndLen {
        final String name;
        final int len;
        final boolean isNum;
        final int decimals;

        NameAndLen(String n, int l, boolean in, int d) {
            this.name = n;
            this.len = l;
            this.isNum = in;
            this.decimals = d;
        }

        static NameAndLen get(VariableName vn) {
            VariableDeclaration vd = vn.getVarDecl();
            if (!vn.hasSubValue()) {
                String name;
                if (vd.level == 88) {
                    name = vn.getCode88();
                    vd = vd.parent;
                } else {
                    name = vn.getCode();
                }
                int len = vd.getPhisicLen();
                if (vd.isX()) {
                    return new NameAndLen(name, len, false, 0);
                }
                if (vd.is9Display() && !vd.isSigned()) {
                    return new NameAndLen(name, len, true, vd.getDecimals());
                }
                return null;
            }
            return null;
        }

        static NameAndLen get(TokenManager tm, Token tk) {
            if (tk.getToknum() == 10002) {
                if ("0".equals(tk.getCode())) {
                    return new NameAndLen(null, 0, true, 0);
                }
                return new NameAndLen(tm.getCodeLiteral(tk), tk.getCode().length(), true, 0);
            }
            if (tk.getToknum() == 10001) {
                if (" ".equals(tk.getCode())) {
                    return new NameAndLen(null, 0, false, 0);
                }
                return new NameAndLen(tm.getCodeLiteral(tk), tk.getCode().length(), false, 0);
            }
            return null;
        }
    }
}

