/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.interfaces.compiler.IRepository;

public class Repository
implements CobolToken,
ErrorsNumbers,
IRepository {
    TokenManager tm;
    Errors error;
    VariableDeclarationList allClasses = new VariableDeclarationList();
    VariableDeclarationList allProperties = new VariableDeclarationList();
    private Token firstToken;

    public Repository(Pcc pc, TokenManager t, Errors err, Token firstToken) throws GeneralErrorException, EndOfProgramException {
        this.firstToken = firstToken;
        this.error = err;
        this.tm = t;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10006) {
            block6: while ((tk = this.tm.getToken()).getToknum() != 10006) {
                switch (tk.getToknum()) {
                    case 325: 
                    case 540: {
                        String extClassName;
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 10009) {
                            throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                        }
                        Token intClassName = tk;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 280) {
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 10001) {
                                throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                            }
                            extClassName = tk.getCode();
                        } else {
                            this.tm.ungetToken();
                            extClassName = intClassName.getWord();
                        }
                        if ("com.iscobol.rts.HTTPClient".equals(extClassName) || "com.iscobol.rts.HTTPHandler".equals(extClassName)) {
                            Pcc.checkEIS(tk, err, false);
                        }
                        try {
                            pc.existsClass(extClassName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new MissingClassException(e, tk, this.error);
                        }
                        VariableDeclaration vd = VariableDeclaration.getObject(pc, intClassName, this.tm, extClassName, true);
                        pc.loadVariable(vd);
                        this.allClasses.addItem(vd);
                        continue block6;
                    }
                    case 657: {
                        String extClassName;
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 10009) {
                            throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                        }
                        Token intClassName = tk;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 280) {
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 10001) {
                                throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                            }
                            extClassName = tk.getCode();
                        } else {
                            this.tm.ungetToken();
                            extClassName = intClassName.getWord();
                        }
                        VariableDeclaration vd = VariableDeclaration.getObject(pc, intClassName, this.tm, extClassName, true);
                        vd.efdType = 0;
                        this.allProperties.addItem(vd);
                        continue block6;
                    }
                }
                this.tm.ungetToken();
                return;
            }
        } else {
            throw new UnexpectedTokenException(tk, err);
        }
    }

    @Override
    public VariableDeclarationList getAllClasses() {
        return this.allClasses;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    public VariableDeclarationList getAllProperties() {
        return this.allProperties;
    }
}

