/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GeneralErrorInfo;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Section;
import com.iscobol.compiler.StatementDesc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VaryingAfter;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.io.File;

public class Perform
extends Verb
implements CobolToken,
ErrorsNumbers {
    static final String PERFORM = "perform";
    static final String METHOD_PERFORM = "methodPerform";
    static final String DECLARATIVES = "declaratives";
    private static int uniqueId;
    private LabelName startLabel;
    private LabelName endLabel;
    private Token startName;
    private Token endName;
    private int startNum = -1;
    private int endNum = -1;
    private Token timesTk;
    private VariableName timesVar;
    private Block block;
    boolean testAfter;
    private VerbList afters;
    Condition until;
    private boolean untilExit;
    private boolean isInDeclaratives;
    private String javaMethodName;
    private boolean thread;
    private VariableName threadHandle;
    final boolean optimize;

    public Perform(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.optimize = t.getOptionList().getOption("-dx") == null;
        this.isInDeclaratives = this.pc.inDeclaratives;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 526 && (tk = this.tm.getToken()).getToknum() != 763) {
            throw new ExpectedFoundException(tk, this.error, "'THREAD'");
        }
        if (tk.getToknum() == 763) {
            this.thread = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 510) {
                this.handle();
                tk = this.tm.getToken();
            }
        }
        if (tk.getToknum() == 10009 || tk.getToknum() == 10002) {
            this.startName = tk;
            this.tm.ungetToken();
            if (tk.getToknum() == 10009) {
                this.startLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
                if (this.startLabel != null) {
                    this.startLabel.rewind();
                }
                this.timesVar = VariableName.get(this.tm, this.error, this.pc, true, false);
            } else {
                this.startLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 768 || tk.getToknum() == 767) {
                tk = this.tm.getToken();
                if (tk.getToknum() != 10009 && tk.getToknum() != 10002) {
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
                this.endName = tk;
                this.tm.ungetToken();
                this.endLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
                tk = this.tm.getToken();
            }
            if (this.thread && tk.getToknum() == 510) {
                this.handle();
                tk = this.tm.getToken();
            }
        }
        if (tk.getToknum() == 770) {
            if (this.startName == null || this.endName != null) {
                throw new UnexpectedTokenException(tk, this.error);
            }
            this.tm.ungetToken();
            tk = this.startName;
            this.startName = null;
            this.startLabel = null;
        }
        boolean vry = false;
        if (tk.getToknum() == 10009 || Token.isIntLit(tk)) {
            this.timesTk = tk;
            if (tk.getToknum() == 10009) {
                if (this.startName != null) {
                    this.tm.ungetToken();
                    this.timesVar = VariableName.get(this.tm, this.error, this.pc);
                } else {
                    this.timesVar.check(this.pc);
                }
            }
            if ((tk = this.tm.getToken()).getToknum() != 770) {
                throw new ExpectedFoundException(tk, this.error, "'TIMES'");
            }
        } else {
            if (tk.getToknum() == 813) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 760) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 261) {
                    this.testAfter = true;
                } else if (tk.getToknum() != 299) {
                    throw new ExpectedFoundException(tk, this.error, "'AFTER'");
                }
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 807) {
                this.pc.pushLocalVariables();
                this.varying();
                vry = true;
            } else if (tk.getToknum() == 791) {
                this.until();
            } else {
                this.tm.ungetToken();
            }
        }
        if (this.startName == null) {
            this.parent.parent.enterLoop(this.thread);
            this.block = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, this.testAfter);
            if (vry) {
                this.pc.popLocalVariables();
            }
            this.parent.parent.exitLoop(this.thread);
            tk = this.tm.getToken();
            if (tk.getToknum() != 440) {
                this.error.print(154, 3, tk, "END-PERFORM");
                this.tm.ungetToken();
            }
        }
    }

    public static void resetCounters() {
        uniqueId = 0;
    }

    private void handle() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 526) {
            this.tm.ungetToken();
        }
        this.threadHandle = VariableName.get(this.tm, this.error, this.pc);
        if (this.threadHandle == null) {
            tk = this.tm.getToken();
            throw new UnexpectedTokenException(tk, this.error);
        }
        if (!this.threadHandle.getVarDecl().isValidThreadHandle()) {
            throw new ClauseClashException(tk, this.error, this.threadHandle.getName());
        }
    }

    private void varying() throws GeneralErrorException, EndOfProgramException {
        this.afters = new VerbList();
        this.afters.addItem(new VaryingAfter(this.keyWord, this.parent, this.pc, this.tm, this.error, this.testAfter, this));
        while (this.tm.getToken().getToknum() == 261) {
            this.afters.addItem(new VaryingAfter(this.keyWord, this.parent, this.pc, this.tm, this.error, this.testAfter, this));
        }
        this.tm.ungetToken();
    }

    private void until() throws GeneralErrorException, EndOfProgramException {
        if (this.tm.getToken().getToknum() == 476) {
            this.untilExit = true;
        } else {
            this.tm.ungetToken();
            this.until = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
            if (!this.until.isFullCondition()) {
                throw new IllegalConditionException(this.keyWord, this.error);
            }
        }
    }

    private static GeneralErrorInfo findParagraphs(LabelName startLabel, LabelName endLabel, int[] parNum, boolean inDecl) {
        if (startLabel != null) {
            GeneralErrorInfo Return2 = startLabel.check(inDecl);
            if (Return2 != null) {
                return Return2;
            }
            Paragraph p = startLabel.getParagraph();
            parNum[0] = p.getIdNumber();
            if (p.isSection) {
                p = p.getLastParagraphInSameSection();
                parNum[1] = p.getIdNumber();
            } else {
                parNum[1] = parNum[0];
            }
            if (endLabel != null) {
                Return2 = endLabel.check(inDecl);
                if (Return2 != null) {
                    return Return2;
                }
                p = endLabel.getParagraph();
                if (p.isSection) {
                    p = p.getLastParagraphInSameSection();
                }
                parNum[1] = p.getIdNumber();
            }
        }
        return null;
    }

    static String check(LabelName startLabel, LabelName endLabel, int[] parNum, boolean isInDeclaratives, Pcc pc) throws GeneralErrorException {
        return Perform.check(startLabel, endLabel, parNum, isInDeclaratives, false, pc);
    }

    static String check(LabelName startLabel, LabelName endLabel, int[] parNum, boolean isInDeclaratives, boolean thread, Pcc pc) throws GeneralErrorException {
        GeneralErrorInfo gi;
        String Return2;
        if (isInDeclaratives) {
            Return2 = DECLARATIVES;
            gi = Perform.findParagraphs(startLabel, endLabel, parNum, true);
            if (gi != null && gi.type == 105 && Perform.findParagraphs(startLabel, endLabel, parNum, false) == null) {
                gi = null;
                Return2 = PERFORM;
            }
        } else {
            Return2 = pc instanceof CobolMethod ? (thread ? PERFORM : METHOD_PERFORM) : PERFORM;
            gi = Perform.findParagraphs(startLabel, endLabel, parNum, false);
            if (gi != null && gi.type == 105 && Perform.findParagraphs(startLabel, endLabel, parNum, true) == null) {
                gi = null;
                Return2 = DECLARATIVES;
            }
        }
        if (gi != null) {
            throw new GeneralErrorException(gi);
        }
        return Return2;
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.timesVar != null && this.timesVar.getVarDecl() != null) {
            if (this.timesVar.getVarDecl() instanceof VariableDeclarationScreen) {
                throw new GeneralErrorException(165, 4, this.timesVar.getNameToken(), this.timesVar.getName(), this.error);
            }
            if (!this.timesVar.isInteger()) {
                if (!this.timesVar.isNumericVar() || this.timesVar.isEdited()) {
                    throw new GeneralErrorException(46, 4, this.keyWord, this.timesVar.toString(), this.error);
                }
                this.error.print(46, 2, this.timesVar.getNameToken(), this.timesVar.getName());
            }
        }
        int[] parNum = new int[]{this.getStartNum(), this.getEndNum()};
        this.javaMethodName = Perform.check(this.startLabel, this.endLabel, parNum, this.isInDeclaratives, this.thread, this.pc);
        this.startNum = parNum[0];
        this.endNum = parNum[1];
        if (this.afters != null) {
            VaryingAfter va = (VaryingAfter)this.afters.getLast();
            while (va != null) {
                va.check();
                va = (VaryingAfter)this.afters.getPrevious();
            }
        }
        if (this.until != null) {
            this.until.check();
        }
    }

    static boolean getPerformCode(Pcc pcc, int startNum, int endNum, String myIndent, StringBuffer Return2, String jMethodName, LabelName start, boolean optimize) {
        boolean split;
        int i;
        Paragraph p;
        boolean bigOpt = pcc.getSplitFlag();
        if ((pcc.getOption("-pt0") != null || pcc.getOption("-pt2") != null) && (PERFORM.equals(jMethodName) || DECLARATIVES.equals(jMethodName))) {
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append(jMethodName);
            Return2.append(" (");
            Return2.append(startNum);
            Return2.append(",");
            Return2.append(endNum);
            Return2.append(",");
            Return2.append(++uniqueId);
            Return2.append(");");
            return false;
        }
        boolean declarat = start.isInDeclaratives();
        Return2.append(eol);
        Return2.append(myIndent);
        if (optimize && (PERFORM.equals(jMethodName) || METHOD_PERFORM.equals(jMethodName))) {
            Paragraph fPar = start.getParagraph();
            if (startNum == endNum && !fPar.hasGoto()) {
                if (fPar.hasExitSect()) {
                    Return2.append("try {");
                    Return2.append(eol);
                    Return2.append(myIndent);
                }
                if (bigOpt) {
                    if (pcc instanceof CobolMethod) {
                        Return2.append("$$theMethod$$");
                    } else {
                        Return2.append("$$theProgram$$");
                    }
                    Return2.append(".");
                }
                Return2.append(fPar.getJavaName());
                Return2.append("();");
                if (fPar.hasExitSect()) {
                    Return2.append(eol);
                    Return2.append(myIndent);
                    Return2.append("} catch (ExitSectionException esex) {}");
                }
                return true;
            }
            if (endNum > startNum && fPar.hasGoOnlyNextPar() && !pcc.getParagraphById(endNum, declarat).hasGoto()) {
                int i2;
                boolean hasExitSect = false;
                for (i2 = startNum; i2 < endNum && (p = pcc.getParagraphById(i2, declarat)).hasGoOnlyNextPar(); ++i2) {
                    if (!p.hasExitSect()) continue;
                    hasExitSect = true;
                }
                if (i2 == endNum) {
                    Section curSect;
                    p = pcc.getParagraphById(i2, declarat);
                    if (p.hasExitSect()) {
                        hasExitSect = true;
                    }
                    Return2.append("{");
                    Return2.append(eol);
                    Return2.append(myIndent);
                    if (hasExitSect) {
                        Return2.append("try {");
                        Return2.append(eol);
                        Return2.append(myIndent);
                        curSect = fPar.getSection();
                    } else {
                        curSect = null;
                    }
                    for (i2 = startNum; i2 <= endNum; ++i2) {
                        p = pcc.getParagraphById(i2, declarat);
                        if (hasExitSect && curSect != p.getSection()) {
                            Return2.append("} catch (ExitSectionException esex) {}");
                            Return2.append(eol);
                            Return2.append(myIndent);
                            Return2.append("try {");
                            Return2.append(eol);
                            Return2.append(myIndent);
                            curSect = p.getSection();
                        }
                        if (bigOpt) {
                            if (pcc instanceof CobolMethod) {
                                Return2.append("$$theMethod$$");
                            } else {
                                Return2.append("$$theProgram$$");
                            }
                            Return2.append(".");
                        }
                        Return2.append(p.getJavaName());
                        Return2.append("();");
                        Return2.append(eol);
                        Return2.append(myIndent);
                    }
                    if (hasExitSect) {
                        Return2.append("} catch (ExitSectionException esex) {}");
                        Return2.append(eol);
                        Return2.append(myIndent);
                    }
                    Return2.append("}");
                    Return2.append(eol);
                    return true;
                }
            }
        }
        for (i = startNum; i < endNum && !(p = pcc.getParagraphById(i, declarat)).hasExitSect(); ++i) {
        }
        int from = startNum;
        boolean bl = split = i != endNum;
        if (split) {
            Section curSect = start.getParagraph().getSection();
            Return2.append("{");
            Return2.append(eol);
            Return2.append(myIndent);
            for (i = startNum; i <= endNum; ++i) {
                p = pcc.getParagraphById(i, declarat);
                if (curSect == p.getSection()) continue;
                Return2.append(jMethodName);
                Return2.append(" (");
                Return2.append(from);
                Return2.append(",");
                Return2.append(i - 1);
                Return2.append(");");
                Return2.append(eol);
                Return2.append(myIndent);
                curSect = p.getSection();
                from = i;
            }
        }
        Return2.append(jMethodName);
        Return2.append(" (");
        Return2.append(from);
        Return2.append(",");
        Return2.append(endNum);
        Return2.append(");");
        if (split) {
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("}");
        }
        return false;
    }

    static boolean isEmpty(Pcc pcc, int startNum, int endNum, boolean declarat) {
        Paragraph p;
        int i;
        if (startNum > endNum) {
            return false;
        }
        for (i = startNum; i <= endNum && (p = pcc.getParagraphById(i, declarat)).isEmpty(); ++i) {
        }
        return i > endNum;
    }

    @Override
    protected void getCodeDebug(StringBuffer buff) {
        if (this.startName != null) {
            int fln = this.keyWord.getFLN();
            if (this.keyWord.isLineRepl()) {
                if (fln != this.pc.lastReplLine) {
                    this.pc.lastReplLine = fln;
                } else {
                    fln = -fln;
                }
            }
            if (this.pc.getOption("-d") != null) {
                boolean dx;
                int idx = this.keyWord.getFileIndex();
                boolean bl = dx = this.pc.getOption("-dx") != null;
                if (dx) {
                    buff.append("if(");
                }
                buff.append("Debugger.outlinePerform");
                if (dx) {
                    buff.append("Ext");
                }
                buff.append(" (");
                buff.append(fln);
                buff.append(", \"");
                String fn = this.keyWord.getFileName();
                if (File.separatorChar != '/') {
                    fn = fn.replace(File.separatorChar, '/');
                }
                buff.append(Pcc.escapeString(fn));
                buff.append("\", ");
                buff.append(idx);
                buff.append(", ");
                buff.append(this.getEndNum());
                buff.append(")");
                if (dx) {
                    buff.append(") {");
                } else {
                    buff.append(";");
                }
                buff.append(eol);
                if (this.parent != null) {
                    buff.append(this.parent.getIndent());
                }
                Pcc rootPcc = this.pc;
                while (rootPcc.parent != null && !(rootPcc instanceof CobolProgram)) {
                    rootPcc = rootPcc.parent;
                }
                int parId = 0;
                boolean dec = false;
                if (this.parent != null && this.parent.getParent() != null && this.parent.getParentVerb() == null) {
                    parId = this.parent.getParent().getIdNumber();
                    dec = this.parent.getParent().isDeclaratives();
                }
                rootPcc.addLine(new StatementDesc(idx, fln, parId, dec));
            }
            this.getCodeSMAP(buff, fln, false);
        } else {
            super.getCodeDebug(buff);
        }
    }

    @Override
    public String getCode() {
        VaryingAfter va;
        String idxVar;
        boolean debug;
        String myIndent = this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        String oldPerf = "";
        if (this.getBlock() != null && this.getBlock().getParent() != null) {
            oldPerf = this.getBlock().getParent().getActPerf();
        }
        String namePerf = "_isPerf_" + Perform.getUniqueId();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        boolean bl = debug = this.pc.getOption("-d") != null;
        if (this.thread) {
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("new Monitor (");
            if (this.threadHandle != null) {
                Return2.append(this.threadHandle.getCode());
            } else {
                Return2.append("null");
            }
            Return2.append(", Factory.getCurrentMonitor()) {");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("final Object $this = Factory.peekCall(1);");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("final Object[] $argv = Factory.peekCallParams();");
            Return2.append(eol);
            if (debug) {
                Return2.append(myIndent);
                Return2.append("final Debugger $dbg = Debugger.newThread();");
                Return2.append(eol);
            }
            Return2.append(myIndent);
            Return2.append("   public void launch () {");
            Return2.append(eol);
            Return2.append(myIndent);
            if (debug) {
                Return2.append(myIndent + "Debugger.enterThread($dbg);");
                Return2.append(myIndent);
            }
            Return2.append(eol);
            Return2.append(myIndent).append("try {").append(eol);
            Return2.append(myIndent);
            Return2.append("   Factory.activeCallsPush($this");
            if (this.pc instanceof CobolMethod) {
                Return2.append(" != null ? $this : new com.iscobol.java.IsCobol()");
            }
            Return2.append(", $argv);");
            if (this.getBlock() != null && this.pc.data != null && this.pc.data.tlsSec != null) {
                Return2.append(eol);
                Return2.append(myIndent);
                this.pc.getThreadLocalStorageCode(Return2);
            }
        }
        if (this.getBlock() != null && this.getBlock().getParent() != null) {
            this.getBlock().getParent().setActPerf("");
        }
        if (this.timesTk != null) {
            idxVar = "i$" + Perform.getUniqueId();
            Return2.append(this.parent.getIndent());
            myIndent = myIndent + " ";
            this.setLabel(namePerf, Return2);
            Return2.append("for (long ");
            Return2.append(idxVar);
            Return2.append(" = ");
            if (this.timesVar == null || this.timesVar.getVarDecl() == null) {
                Return2.append(this.timesTk.getAsLong());
            } else {
                Return2.append(this.timesVar.getCode() + ".num().longValue()");
            }
            Return2.append("; ");
            Return2.append(idxVar);
            Return2.append(" > 0; ");
            Return2.append(idxVar);
            Return2.append("--)");
        } else if (this.afters != null) {
            Return2.append(eol);
            this.setLabel(namePerf, Return2);
            va = (VaryingAfter)this.afters.getFirst();
            while (va != null) {
                Return2.append(va.getCodeBefore());
                va = (VaryingAfter)this.afters.getNext();
            }
        } else if (this.until != null) {
            Return2.append(this.parent.getIndent());
            this.setLabel(namePerf, Return2);
            Return2.append("for ( ; ; ) {");
            if (!this.testAfter) {
                Return2.append(this.parent.getIndent());
                Return2.append("if (");
                Return2.append(this.until.getCode());
                Return2.append(") break;");
                Return2.append(eol);
            }
        } else if (this.untilExit) {
            Return2.append(this.parent.getIndent());
            this.setLabel(namePerf, Return2);
            Return2.append("for ( ; ; ) {");
            Return2.append("if (null != null) break;");
            Return2.append(eol);
        } else if (this.startName == null) {
            if (this.thread) {
                Return2.append(eol);
            }
            idxVar = "i$" + Perform.getUniqueId();
            Return2.append(this.parent.getIndent());
            myIndent = myIndent + " ";
            this.setLabel(namePerf, Return2);
            Return2.append("for (int ");
            Return2.append(idxVar);
            Return2.append(" = 0;");
            Return2.append(idxVar);
            Return2.append(" < 1;");
            Return2.append(idxVar);
            Return2.append("++)");
        }
        if (this.startName != null) {
            Perform.getPerformCode(this.pc, this.getStartNum(), this.getEndNum(), myIndent, Return2, this.javaMethodName, this.startLabel, this.optimize);
        } else {
            Return2.append(this.getBlock().getCode());
        }
        Return2.append(eol);
        if (this.afters != null) {
            va = (VaryingAfter)this.afters.getLast();
            while (va != null) {
                Return2.append(va.getCode());
                va = (VaryingAfter)this.afters.getPrevious();
            }
        } else if (this.until != null) {
            if (this.testAfter) {
                Return2.append(this.parent.getIndent());
                Return2.append("if (");
                Return2.append(this.until.getCode());
                Return2.append(") break;");
                Return2.append(eol);
            }
            Return2.append(this.parent.getIndent());
            Return2.append("}");
            Return2.append(eol);
        } else if (this.untilExit) {
            Return2.append(this.parent.getIndent());
            Return2.append("}");
            Return2.append(eol);
        } else if (this.untilExit) {
            Return2.append(this.parent.getIndent());
            Return2.append("}");
            Return2.append(eol);
        }
        if (this.getBlock() != null && this.getBlock().getParent() != null) {
            this.getBlock().getParent().setActPerf(oldPerf);
        }
        if (this.thread) {
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append("Factory.activeCallsPop();");
            Return2.append(eol);
            Return2.append(myIndent).append("} catch(StopRunException srex) {").append(eol);
            Return2.append(myIndent).append("} catch(Throwable ex) { ErrorBox.show(ex); }").append(eol);
            if (debug) {
                Return2.append(myIndent + "Debugger.exitThread();" + eol);
            }
            Return2.append(myIndent);
            Return2.append("   }");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append("}.start();");
            Return2.append(eol);
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private void setLabel(String namePerf, StringBuffer Return2) {
        Return2.append("    ");
        Return2.append(namePerf);
        Return2.append(":   ");
        if (this.getBlock() != null && this.getBlock().getParent() != null) {
            this.getBlock().getParent().setActPerf(" " + namePerf);
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public int getStartNum() {
        return this.startNum;
    }

    public int getEndNum() {
        return this.endNum;
    }

    public Token getTimesToken() {
        return this.timesTk;
    }

    public VariableName getTimesVariable() {
        if (this.timesVar != null && this.timesVar.getVarDecl() != null) {
            return this.timesVar;
        }
        return null;
    }

    public String getJavaMethodName() {
        return this.javaMethodName;
    }

    public boolean isTestAfter() {
        return this.testAfter;
    }

    public Condition getUntil() {
        return this.until;
    }

    public VerbList getAfters() {
        return this.afters;
    }

    public boolean isUntilExit() {
        return this.untilExit;
    }

    public LabelName getStartLabelName() {
        return this.startLabel;
    }

    public LabelName getEndLabelName() {
        return this.endLabel;
    }
}

