/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Accept;
import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.AmbiguousException;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockList;
import com.iscobol.compiler.Call;
import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.ErrorDirective;
import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.ErrorLimitReachedException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExecHandlerIntf;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FindAllMethods;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Goto;
import com.iscobol.compiler.IdentificationDivision;
import com.iscobol.compiler.InlineSetGetProperty;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.MalformedDataNameException;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.MyField;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.NextSentenceBlock;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.ParagraphDesc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.PreProcsChain;
import com.iscobol.compiler.ProcedureDivision;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.ReportVariable;
import com.iscobol.compiler.Repository;
import com.iscobol.compiler.SMAPGenerator;
import com.iscobol.compiler.SQLCA;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SetGetProperty;
import com.iscobol.compiler.SpecialNamesClass;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlWhenever;
import com.iscobol.compiler.StandardPhases;
import com.iscobol.compiler.StatementDesc;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Switch;
import com.iscobol.compiler.SwitchList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import com.iscobol.compiler.Version;
import com.iscobol.compiler.bincode.BinaryCodeGenerator;
import com.iscobol.compiler.bincode.BinaryCodeGeneratorException;
import com.iscobol.compiler.bincode.BinaryCodeGeneratorFactory;
import com.iscobol.compiler.bincode.Callable;
import com.iscobol.compiler.bincode.NoJavaCompilerException;
import com.iscobol.compiler.phases.Phases;
import com.iscobol.compiler.phases.PhasesFactory;
import com.iscobol.compiler.remote.OutputData;
import com.iscobol.compiler.remote.PPFileOutput;
import com.iscobol.compiler.remote.RemoteBridgeFile;
import com.iscobol.compiler.remote.RemoteFileFinder;
import com.iscobol.compiler.remote.client.Client;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.interfaces.compiler.ClassFileFinder;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.IDataSection;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPccExtension5;
import com.iscobol.interfaces.compiler.InvokeNotifier;
import com.iscobol.interfaces.compiler.PreProcessorReaderProvider;
import com.iscobol.interfaces.compiler.ReferencedPccNotifier;
import com.iscobol.interfaces.compiler.VerbNotifier;
import com.iscobol.interfaces.runtime.IEasyDB;
import com.iscobol.rpc.dualrpc.client.NotConnectedException;
import com.iscobol.rts.Base64;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Pcc
implements CobolToken,
ErrorsNumbers,
IPccExtension5 {
    private static final Ctx[] ctxs = new Ctx[]{new Ctx(new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 101, 105, 115, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 52}, new byte[]{20, -67, -102, -123, 24, 19, 52, -22}), new Ctx(new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 109, 111, 98, 105, 108, 101, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 52}, new byte[]{21, -68, -109, -113, 24, 18, 57, -29}), new Ctx(new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 101, 97, 115, 121, 100, 98, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 52}, new byte[]{20, 41, -107, 58, 24, 67, 0, -23}), new Ctx(new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 106, 106, 109, 115, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 52}, new byte[]{-8, -5, 30, 124, 24, 117, 127, -60})};
    private static final byte[] d3 = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 108, 105, 99, 105, 110, 102, 111};
    private static final byte[] d4 = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 101, 120, 112, 105, 114, 101, 100};
    public static final String EVENT_OBJECT_CLASSNAME = "java.util.EventObject";
    public static final String EVENT_SOURCE_CLASSNAME = "com.iscobol.gui.server.CobolGUIJavaBean";
    static final String LOCAL_STORAGE_CLASS_NAME = "_my_loc_stg_";
    static final String LOCAL_STORAGE_FIELD_NAME = "$my_loc_stg$";
    static final String THREAD_LOCAL_STORAGE_CLASS_NAME = "_my_thloc_stg_";
    static final String THREAD_LOCAL_STORAGE_FIELD_NAME = "$my_thloc_stg$";
    static final String OBJECT_IDS = "$objectIds$";
    static final String OBJECT_IDS_DECL = "   private final java.util.Vector<CobolVar> $objectIds$ = new java.util.Vector<CobolVar>();";
    static final String ST_OBJECT_IDS = "$st_objectIds$";
    static final String ST_OBJECT_IDS_DECL = "   private static final java.util.Vector<CobolVar> $st_objectIds$ = new java.util.Vector<CobolVar>();";
    static final String INNER_PREFIX = "inner_";
    static final String CONST_SUFFIX = "_CONST";
    static final int MAX_CONSTANTS_STRING_LENGTH = 65000;
    static final int LINE_BREAK = 500;
    static final int DO_LINE_BREAK = 160;
    static final int MAX_SWITCH_LABELS = 1500;
    static final int DEBUG_MAX_LINES = 2000;
    static final int DEBUG_MAX_PARAGRAPHS = 300;
    static final int DEBUG_MAX_COPYFILES = 100;
    static final int DEBUG_MAX_FILENAMES = 100;
    static final int DEBUG_MAX_REPENTRIES = 100;
    static final String DEBUGGER_HELPER_FIELD_NAME = "debugger$helper";
    static final String DPC_FLAG_NAME = "$isDPC$";
    static final String CS_FLAG_NAME = "$CurrencySign$";
    static final Pcc CLASS_NOT_FOUND = new Pcc();
    private static final int ERR_WRONG_COMMAND_LINE = 5;
    private static String eisCheck;
    public static String TYPES_PACKAGE;
    static int MAX_PARAGRAPHS;
    static int MAX_CONSTANTS;
    protected static String srcDirMain;
    protected static char hyphenRepl;
    protected static char identifierSep;
    private static Map<String, Call> easyLinkStubs;
    private static InvokeNotifier invokeNotifier;
    private static VerbNotifier verbNotifier;
    private static ReferencedPccNotifier referencedPccNotifier;
    private Map<String, Pcc> referencedPccs;
    private CobolProgram theProgram;
    private CobolClass factoryPart;
    private CobolClass objectPart;
    private MyMethod[] myMethods = new MyMethod[0];
    private MyField[] myFields = new MyField[0];
    private Map<String, VariableDeclarationList> allVariables = new HashMap<String, VariableDeclarationList>();
    private Stack<Map<String, VariableDeclaration>> localVariables = new Stack();
    private Map<String, VariableDeclaration> typedefVariables = new HashMap<String, VariableDeclaration>();
    private File edmFile;
    private String className = "";
    private String progName = "";
    private String path = "";
    private String packageName;
    private SwitchList switches;
    private VerbList sqlCursors = new VerbList();
    Vector sqlCursorMethodsCode = new Vector();
    private HashSet sqlDatabase;
    private Stack<Block> blocks = new Stack();
    private final Phases phases;
    protected IdentificationDivision gIdentification;
    protected EnvironmentDivision gEnvironment;
    protected ProcedureDivision procedure;
    protected BlockList allBlocks = new BlockList();
    protected Hashtable calls = new Hashtable();
    protected HashSet<Entry> entryPoints = new HashSet();
    protected Vector statementLines = new Vector();
    protected Vector paragraphNames = new Vector();
    protected Vector variableTargetGoto;
    protected TokenManager tm;
    protected OptionList options;
    private boolean assumeFirstOcc;
    private static boolean jjAndSqlj;
    protected Errors error;
    protected Pcc parent = null;
    protected String outDir;
    protected String sourceDir;
    protected String outName;
    protected String fileName;
    private boolean hasSqlj = false;
    private int progClass;
    int sqlDeclareCursorProg;
    public VariableDeclarationList fixedVars = new VariableDeclarationList();
    private VariableDeclarationList counters = new VariableDeclarationList();
    boolean inDeclaratives;
    boolean inProcedure;
    DataDivision data;
    LinkageSection lks;
    private VariableDeclaration snCrtStatus;
    private VariableDeclaration snCursor;
    private VariableDeclaration snEventStatus;
    private VariableDeclaration snScreenControl;
    private VariableDeclaration snEventObject;
    private VariableDeclaration snEventSource;
    private String[] RTS_IMPORTS;
    private Hashtable serviceBridgeElkNames = new Hashtable();
    private Hashtable serviceBridgeNames = new Hashtable();
    private HashSet<String> finalizeCode = new HashSet();
    private boolean userDefinedFinalize;
    boolean consoleIsCrt;
    boolean useScreen;
    boolean findingMethods;
    String declInput;
    String declOutput;
    String declIO;
    String declExtend;
    String declTransaction;
    SqlWhenever warning;
    SqlWhenever notFound;
    SqlWhenever werror;
    private ArrayList<UseForDebugging> useForDebugging = new ArrayList();
    private Boolean numericSignTrailSep;
    private Hashtable specialNamesClasses = new Hashtable();
    private Hashtable mnemonicSystem = new Hashtable();
    private boolean hasObjectReferences;
    boolean xmlVarsDeclared;
    boolean jsonVarsDeclared;
    private Hashtable session;
    private HashSet imports;
    private Hashtable selAndDecl = new Hashtable();
    private Hashtable snFuncNames = new Hashtable();
    int lastReplLine;
    protected boolean serviceBridgeActivated;
    protected boolean easydbActivated;
    boolean generateObjectIds;
    private Hashtable externalExecs;
    private HashSet externalExecMacros;
    private LinkedList externalExecLines;
    private boolean hasSort;
    private VariableDeclaration self;
    private boolean generateCode;
    private String subsEasyDB;
    private ArrayList<String> scriptList;
    private Hashtable easyDbNames;
    private Hashtable easyDbPrefix;
    public int indCount;
    public HashSet<String> callStubs;
    private String sqljIteratorDeclaration;
    private String sqljResultSetDeclaration;
    private Hashtable<String, String> sqljIterDecl;
    private boolean hasExecSql;
    boolean optionMS;
    boolean capitalizeNames;
    boolean registerScreenAttrs;
    Map<String, String> screenVars;
    HashSet<String> screenNames;
    Map<String, String> screenObjVars;
    Map<String, String> screenProcs;
    SQLCA sqlca;

    String newScreenName(String name) {
        String newName = name;
        int i = 1;
        while (this.screenNames.contains(newName)) {
            newName = name + "_" + i;
            ++i;
        }
        this.screenNames.add(newName);
        return newName;
    }

    public void setHasExecSql() {
        this.hasExecSql = true;
    }

    public boolean hasExecSql() {
        return this.hasExecSql;
    }

    public static String getCopyrightInfo() {
        return Version.getCopyright();
    }

    static void writeFile(byte[] bytes, String filename) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename);
            out.write(bytes);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void removeClasses(String dir, String name, boolean verboseOutput) {
        Pcc.removeClasses(new String[][]{{dir, name}}, verboseOutput);
    }

    private static void removeClasses(String[][] group, boolean verboseOutput) {
        int removedClassesCnt = 0;
        for (String[] c : group) {
            File directory;
            String dir = c[0];
            String name = c[1];
            if (name == null || name.length() <= 0) continue;
            if (dir == null || dir.length() == 0) {
                dir = ".";
            }
            if (!(directory = new File(dir)).isDirectory()) continue;
            File[] items = directory.listFiles();
            String iClsPrfx = name + '$';
            String iConstPrfx = name + CONST_SUFFIX;
            String fullName = name + ".class";
            int minLen = fullName.length();
            for (int i = 0; i < items.length; ++i) {
                String item = items[i].getName();
                int itemLen = item.length();
                if (!(itemLen > minLen && item.startsWith(iClsPrfx) && item.endsWith(".class") || itemLen > minLen && item.startsWith(iConstPrfx) && item.endsWith(".class")) && (itemLen != minLen || !item.equals(fullName))) continue;
                if (items[i].delete()) {
                    ++removedClassesCnt;
                    continue;
                }
                if (!verboseOutput) continue;
                System.err.println("Cannot remove " + item);
            }
        }
        if (verboseOutput) {
            System.err.println("" + removedClassesCnt + " class" + (removedClassesCnt != 1 ? "es" : "") + " removed.");
        }
    }

    public static void main(String[] argv) throws Exception {
        boolean verbose;
        Errors errs;
        String incrFileName;
        String incrAction;
        String origName = Config.markNoIscobolRuntimeThread("PCC");
        if (argv.length < 1) {
            System.err.println("usage: java Pcc -help|[options] source_file");
            System.exit(5);
        }
        OptionList ol = new OptionList(argv);
        Thread.currentThread().setName(origName);
        String defIncrFileName = "incr.iscc";
        String incr = ol.getOption("-incr=");
        boolean clean = false;
        boolean build = false;
        if (incr != null) {
            int idx = incr.indexOf(59);
            if (idx >= 0) {
                incrAction = incr.substring(0, idx).toLowerCase();
                File f = new File(incr.substring(idx + 1));
                incrFileName = f.isDirectory() ? f.getAbsolutePath() + File.separator + "incr.iscc" : f.getAbsolutePath();
            } else {
                incrAction = incr.toLowerCase();
                incrFileName = new File("incr.iscc").getAbsolutePath();
            }
        } else {
            incrAction = null;
            incrFileName = null;
        }
        if (incrAction != null) {
            StringTokenizer stn = new StringTokenizer(incrAction, " ,");
            while (stn.hasMoreTokens()) {
                String tk = stn.nextToken();
                if ("clean".equals(tk)) {
                    clean = true;
                    continue;
                }
                if ("build".equals(tk)) {
                    build = true;
                    continue;
                }
                errs = new Errors(ol.getOption("-xmsgfmt="));
                errs.print(146, 4, 0, 0, ol.getOption("-incr="), null, null);
                System.exit(5);
            }
        }
        File incrFile = incrFileName != null ? new File(incrFileName) : null;
        boolean bl = verbose = ol.getOption("-verbose") != null;
        if (clean) {
            if (incrFile.exists()) {
                incrFile.delete();
                if (verbose) {
                    System.err.println("Removed '" + incrFile + "' file");
                }
            } else if (verbose) {
                System.err.println("'" + incrFile + "' file not found");
            }
            if (!build) {
                System.exit(0);
            }
        }
        if (ol.getOption("-sqlj") != null) {
            if (ol.getOption("-jj") != null) {
                jjAndSqlj = true;
            } else {
                ol.addOption("-jj");
            }
        }
        if (ol.getOption("-helpx") != null) {
            ol.help(true, Pcc.checkJJMS(true));
            System.exit(0);
        } else if (ol.getOption("-help") != null) {
            ol.help(false, Pcc.checkJJMS(true));
            System.exit(0);
        } else if (ol.getOption("-v") != null) {
            StandardPhases.copyright();
        } else if (ol.getOption("-zmf") != null) {
            try {
                for (int i = 0; i < argv.length; ++i) {
                    if (!argv[i].toLowerCase().equals("-zmf")) continue;
                    argv[i] = argv[0];
                    argv[0] = "-zmf";
                    Class<?> nc = Class.forName("com.veryant.cobol.compiler.Compiler");
                    Method method = nc.getMethod("main", String[].class);
                    method.invoke(null, new Object[]{argv});
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
                System.exit(5);
            }
        } else if (ol.hasErrors()) {
            errs = new Errors(ol.getOption("-xmsgfmt="));
            errs.print(ol.getErrorNum(), 4, 0, 0, ol.getErrors(), null, null);
            System.exit(5);
        } else if (ol.hasWarning()) {
            errs = new Errors(ol.getOption("-xmsgfmt="));
            int[] nums = ol.getWarningsNum();
            String[] warns = ol.getWarnings();
            for (int i = 0; i < nums.length; ++i) {
                errs.print(nums[i], 2, 0, 0, warns[i], null, null);
            }
        }
        String outDir = ol.getOption("-od=");
        if (outDir != null && !outDir.endsWith(File.separator)) {
            outDir = outDir + File.separator;
        }
        LinkedHashMap<File, File[]> incrFileInfos = new LinkedHashMap<File, File[]>();
        if (build && incrFile.exists()) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(incrFile)));
                File progName = null;
                Vector<File> relatedFiles = new Vector<File>();
                String line = r.readLine();
                while (line != null) {
                    if (line.startsWith(" ")) {
                        relatedFiles.addElement(new File(line.trim()));
                    } else {
                        if (progName != null) {
                            incrFileInfos.put(progName, relatedFiles.toArray(new File[relatedFiles.size()]));
                            relatedFiles.clear();
                        }
                        progName = new File(line.trim());
                    }
                    line = r.readLine();
                }
                if (progName != null) {
                    incrFileInfos.put(progName, relatedFiles.toArray(new File[relatedFiles.size()]));
                }
                r.close();
            }
            catch (IOException r) {
                // empty catch block
            }
        }
        argv = ol.getArgs();
        int returnCode = 0;
        if (argv[0] != null) {
            boolean stopIfErrorsOccur = argv.length == 1 || ol.getOption("-es") != null;
            Phases phases = PhasesFactory.create(ol);
            if (!Pcc.executeRemoteCompilation(argv, ol, outDir, phases, stopIfErrorsOccur)) {
                Pcc pcc = null;
                HashSet<File> alreadyCompiled = new HashSet<File>();
                String classNameToExecute = null;
                for (int i = 0; i < argv.length; ++i) {
                    String od;
                    File f = new File(argv[i]);
                    if (alreadyCompiled.contains(f)) continue;
                    od = outDir != null ? outDir : ((od = f.getParent()) != null ? od + File.separator : "");
                    if (!Pcc.needsToBeCompiled(f, (File[])incrFileInfos.get(f.getAbsoluteFile()), od)) {
                        if (!verbose) continue;
                        System.err.println("'" + f + "' unchanged since last compilation, no need to recompile");
                        continue;
                    }
                    try {
                        Errors errs2 = new Errors(ol.getOption("-xmsgfmt="));
                        errs2.setVerbose(ol.getOption("-verbose") != null);
                        HashMap<String, Pcc> refPccs = new HashMap<String, Pcc>();
                        pcc = Pcc.run(argv[i], outDir, (OptionList)ol.clone(), phases, errs2, null, true, null, null, refPccs, false, false);
                        if (i == 0 && pcc != null && ol.getOption("-ze") != null) {
                            classNameToExecute = pcc.getFullClassName();
                        }
                        if (pcc == null) continue;
                        if (pcc.referencedPccs != null) {
                            for (Pcc pc : pcc.referencedPccs.values()) {
                                if (pc == CLASS_NOT_FOUND) continue;
                                alreadyCompiled.add(new File(pc.getSourceFileName()));
                                if (!build) continue;
                                Pcc.writeIncrFileInfos(pc, incrFileInfos);
                            }
                        }
                        String[] entries = pcc.getEasyDBProgramsNames();
                        String iOutDir = outDir;
                        if (entries.length > 0) {
                            iOutDir = Pcc.loadOutDir("easydb", outDir, false);
                        }
                        for (int j = 0; j < entries.length; ++j) {
                            ol.restoreProperties();
                            OptionList ol0 = (OptionList)ol.clone();
                            ol0.addOption("#ef");
                            ol0.addOption("#st");
                            ol0.addOption("#eo=");
                            ol0.addOption("#lf");
                            ol0.addOption("#lo=");
                            ol0.addOption("#cp");
                            errs2 = new Errors(ol.getOption("-xmsgfmt="));
                            errs2.setVerbose(ol.getOption("-verbose") != null);
                            Pcc.run(entries[j], iOutDir, ol0, phases, errs2, null, true);
                        }
                        continue;
                    }
                    catch (ErrorInCompilationException _ex) {
                        pcc = _ex.pcc;
                        if (pcc != null && pcc.referencedPccs != null) {
                            for (Pcc pc : pcc.referencedPccs.values()) {
                                if (pc == CLASS_NOT_FOUND) continue;
                                alreadyCompiled.add(new File(pc.getSourceFileName()));
                            }
                        }
                        if (stopIfErrorsOccur) {
                            System.exit(_ex.exitStatus);
                            continue;
                        }
                        returnCode = 4;
                    }
                }
                if (build) {
                    try {
                        PrintStream ps = new PrintStream(incrFile);
                        for (File f : incrFileInfos.keySet()) {
                            ps.println(f.getAbsolutePath());
                            boolean first = true;
                            for (File f0 : (File[])incrFileInfos.get(f)) {
                                if (first) {
                                    ps.println(" " + f0.getPath());
                                    first = false;
                                    continue;
                                }
                                ps.println(" " + f0.getAbsolutePath());
                            }
                        }
                        ps.close();
                    }
                    catch (IOException ps) {
                        // empty catch block
                    }
                }
                if (verbose && ol.getOption("-d") != null) {
                    System.err.println("Debugging Info included");
                }
                if (ol.getOption("-jj") == null || ol.getOption("-jc") != null) {
                    Errors errs3 = new Errors(ol.getOption("-xmsgfmt="));
                    errs3.setVerbose(verbose);
                    returnCode = Pcc.generateBinaryCode(ol, errs3, phases, outDir);
                    if (returnCode == 0 && classNameToExecute != null) {
                        returnCode = Pcc.doExecute(classNameToExecute);
                    }
                }
            }
        } else {
            System.err.println("Missing source_file");
            System.err.println("usage: java Pcc -help|[options] source_file");
            returnCode = 1;
        }
        if (returnCode != 0) {
            System.exit(returnCode);
        }
    }

    private static void writeIncrFileInfos(Pcc pcc, Map<File, File[]> incrFileInfos) {
        Vector<File> files = new Vector<File>();
        String className = pcc.getFullClassName();
        int idx = className.lastIndexOf(46);
        if (idx >= 0) {
            className = className.substring(idx + 1);
        }
        files.add(new File(className));
        Vector allPreProcessors = pcc.tm.pp.getAllPreProcessors();
        for (PreProcessor pp : allPreProcessors) {
            files.add(new File(pp.getFileName()));
        }
        incrFileInfos.put(new File(pcc.getSourceFileName()), files.toArray(new File[files.size()]));
    }

    private static boolean needsToBeCompiled(File fileName, File[] infos, String outDir) {
        long t2;
        if (infos == null) {
            return true;
        }
        File classFile = new File(outDir + infos[0].getPath() + ".class");
        if (!classFile.exists()) {
            return true;
        }
        long t1 = fileName.lastModified();
        if (t1 - (t2 = classFile.lastModified()) > 0L) {
            return true;
        }
        for (int i = 1; i < infos.length; ++i) {
            t1 = infos[i].lastModified();
            if (t1 - t2 <= 0L) continue;
            return true;
        }
        return false;
    }

    public static int generateBinaryCode(OptionList ol, Errors errs, Phases phases, String outDir) {
        int returnCode = 0;
        boolean verbose = ol.getOption("-verbose") != null;
        StandardPhases stdPhases = (StandardPhases)phases;
        List<String[][]> classToBeRemoved = stdPhases.getClassToBeRemoved();
        for (String[][] group : classToBeRemoved) {
            Pcc.removeClasses(group, verbose);
        }
        HashSet<String> sourceUnits = new HashSet<String>();
        ArrayList suList = new ArrayList();
        ArrayList<String> currList = new ArrayList<String>();
        suList.add(currList);
        long MAX_JAVA_SIZE = 50000000L;
        long javaSize = 0L;
        Map<File, Map> pccToBeCompiled = stdPhases.getPccToBeCompiled();
        for (Map compileData : pccToBeCompiled.values()) {
            String string = (String)compileData.get("programName");
            File p = new File(string);
            if (javaSize + p.length() > 50000000L) {
                currList = new ArrayList();
                suList.add(currList);
                javaSize = 0L;
            }
            javaSize += p.length();
            sourceUnits.add(string);
            currList.add(string);
            if (!"true".equals(compileData.get("easyLinkageActivated"))) continue;
            String linkProgName = (String)compileData.get("easyLinkageFileName");
            p = new File(linkProgName);
            if (javaSize + p.length() > 50000000L) {
                currList = new ArrayList();
                suList.add(currList);
                javaSize = 0L;
            }
            javaSize += p.length();
            currList.add(linkProgName);
            String[] entries = (String[])compileData.get("entryPoints");
            String eLnkPrefix = (String)compileData.get("easyLinkageEntryPrefix");
            String parDir = p.getParent();
            for (int i = 0; i < entries.length; ++i) {
                linkProgName = entries[i];
                if (linkProgName.startsWith("\"")) {
                    linkProgName = linkProgName.substring(1, linkProgName.length() - 1);
                }
                linkProgName = eLnkPrefix + linkProgName + ".java";
                if (parDir != null) {
                    linkProgName = parDir + File.separator + linkProgName;
                }
                if (javaSize + (p = new File(linkProgName)).length() > 50000000L) {
                    currList = new ArrayList();
                    suList.add(currList);
                    javaSize = 0L;
                }
                javaSize += p.length();
                currList.add(linkProgName);
            }
        }
        BinaryCodeGenerator binaryCodeGenerator = BinaryCodeGeneratorFactory.create(ol);
        for (List list : suList) {
            if (list.isEmpty()) continue;
            Callable callable = binaryCodeGenerator.getCompilationTask(list.toArray(new String[list.size()]));
            try {
                int rc = (Integer)callable.call();
                if (returnCode == 0) {
                    returnCode = rc;
                }
            }
            catch (NoJavaCompilerException _ex) {
                errs.print(267, 4, 0, 0, null, null, null);
            }
            catch (BinaryCodeGeneratorException _ex) {
                Exception t = _ex.getCause() != null && _ex.getCause() instanceof Exception ? (Exception)_ex.getCause() : _ex;
                errs.print(61, 2, 0, 0, _ex.getMessage(), t, null);
            }
            catch (Exception _ex) {
                _ex.printStackTrace();
                errs.print(61, 2, 0, 0, "Compilation Failed", _ex, null);
            }
            for (String su : list) {
                File javaFile = new File(su);
                String baseName = su.substring(0, su.length() - 5);
                File classFile = new File(baseName + ".class");
                if (!javaFile.exists()) continue;
                if ((ol.getOption("-g") != null || ol.getOption("-d") != null) && classFile.exists() && classFile.lastModified() > javaFile.lastModified() && sourceUnits.contains(su)) {
                    try {
                        new SMAPGenerator(baseName);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        System.err.println("XX--> " + classFile.getPath() + ": SMAP generation failed");
                    }
                }
                if (ol.getOption("-jj") != null) continue;
                javaFile.delete();
            }
        }
        return returnCode;
    }

    private static boolean executeRemoteCompilation(String[] sourceFiles, OptionList ol, String outDir, Phases phases, boolean stopIfErrorsOccur) {
        String remoteHost = Config.getProperty("iscobol.remotecompiler.host", null);
        String preprocNames = Config.getProperty("iscobol.remotecompiler.preprocnames", null);
        String translatedFolder = Config.getProperty("iscobol.remotecompiler.translateddir", null);
        if (remoteHost != null) {
            PPFileOutput[] output = Pcc.executeRemoteCompilation(remoteHost, preprocNames, translatedFolder, sourceFiles, ol);
            if (output != null && output.length > 0) {
                if (outDir == null) {
                    outDir = "." + File.separator;
                }
                for (PPFileOutput ppfo : output) {
                    String sourceFilePath = new File(ppfo.getSourceFileName()).getParent();
                    if (sourceFilePath == null) {
                        sourceFilePath = ".";
                    }
                    String dir = translatedFolder != null ? translatedFolder : sourceFilePath;
                    String fn = ppfo.getTranslatedFile() != null ? ppfo.getTranslatedFile().getPath() : ppfo.getSourceFileName();
                    String filename = new File(fn).getName();
                    try {
                        Errors errs = new Errors(ol.getOption("-xmsgfmt="));
                        errs.setVerbose(ol.getOption("-verbose") != null);
                        Pcc.run(dir + File.separator + filename, outDir, (OptionList)ol.clone(), phases, errs, null, true);
                    }
                    catch (ErrorInCompilationException _ex) {
                        if (!stopIfErrorsOccur) continue;
                        System.exit(_ex.exitStatus);
                    }
                }
                if (ol.getOption("-jj") == null || ol.getOption("-jc") != null) {
                    Errors errs = new Errors(ol.getOption("-xmsgfmt="));
                    errs.setVerbose(ol.getOption("-verbose") != null);
                    Pcc.generateBinaryCode(ol, errs, phases, outDir);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PPFileOutput[] executeRemoteCompilation(String remoteHost, String preprocNames, String translatedFolder, String[] sourceFiles, OptionList ol) {
        String[] ss;
        PPFileOutput[] Return2 = null;
        int remotePort = Config.getProperty(".remotecompiler.port", 11999);
        Client remoteCompilerClient = new Client(remoteHost, remotePort);
        remoteCompilerClient.setCompileOnServer(Config.getProperty(".remotecompiler.compileonserver", false));
        remoteCompilerClient.setCreateErrorFile(Config.getProperty(".remotecompiler.createerrorfiles", false));
        remoteCompilerClient.setCreateListingFile(Config.getProperty(".remotecompiler.createlistingfiles", false));
        remoteCompilerClient.setShowMessagesOnSysErr(true);
        remoteCompilerClient.setSourceFiles(sourceFiles);
        remoteCompilerClient.setOptionList(ol);
        if (preprocNames != null && preprocNames.length() > 0) {
            StringTokenizer stn = new StringTokenizer(preprocNames, ",");
            ss = new String[stn.countTokens()];
            int i = 0;
            while (stn.hasMoreTokens()) {
                String tk = stn.nextToken();
                if (tk.equalsIgnoreCase("ALL")) {
                    ss = new String[]{tk};
                    break;
                }
                if (tk.equalsIgnoreCase("NONE")) {
                    ss = new String[]{tk};
                    remoteCompilerClient.setCompileOnServer(true);
                    break;
                }
                ss[i] = tk;
                ++i;
            }
        } else {
            ss = new String[]{"ALL"};
        }
        remoteCompilerClient.setPreprocessorNames(ss);
        OutputData output = null;
        try {
            remoteCompilerClient.connect();
            remoteCompilerClient.compile();
            output = remoteCompilerClient.getOutput();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                remoteCompilerClient.disconnect();
            }
            catch (NotConnectedException e) {}
        }
        if (output != null) {
            String s = output.getStdOut();
            if (s != null && s.length() > 0) {
                System.out.println(s);
            }
            if ((s = output.getStdErr()) != null && s.length() > 0) {
                System.err.println(output.getStdErr());
            }
            if (output.getExitCode() == 0 && output.getPreProcessorFilesOutput() != null) {
                PPFileOutput[] ppfo = output.getPreProcessorFilesOutput();
                boolean compileOnServer = remoteCompilerClient.getCompileOnServer();
                for (int i = 0; i < ppfo.length; ++i) {
                    String dir;
                    String sourceFilePath = new File(ppfo[i].getSourceFileName()).getParent();
                    if (sourceFilePath == null) {
                        sourceFilePath = ".";
                    }
                    if (ppfo[i].getTranslatedFile() != null) {
                        Pcc.writeFile(ppfo[i].getTranslatedFile().getContent(), (translatedFolder != null ? translatedFolder : sourceFilePath) + File.separator + new File(ppfo[i].getTranslatedFile().getPath()).getName());
                    }
                    if (ppfo[i].getErrorFile() != null) {
                        dir = ol.getOption("-eo=");
                        if (dir == null) {
                            dir = sourceFilePath;
                        }
                        Pcc.writeFile(ppfo[i].getErrorFile().getContent(), dir + File.separator + new File(ppfo[i].getErrorFile().getPath()).getName());
                    }
                    if (ppfo[i].getListingFile() != null) {
                        dir = ol.getOption("-lo=");
                        if (dir == null) {
                            dir = sourceFilePath;
                        }
                        Pcc.writeFile(ppfo[i].getListingFile().getContent(), dir + File.separator + new File(ppfo[i].getListingFile().getPath()));
                    }
                    if (!compileOnServer) continue;
                    if (ppfo[i].getJavaFile() != null) {
                        dir = ol.getOption("-od=");
                        if (dir == null) {
                            dir = sourceFilePath;
                        }
                        Pcc.writeFile(ppfo[i].getJavaFile().getContent(), dir + File.separator + new File(ppfo[i].getJavaFile().getPath()));
                    }
                    if (ppfo[i].getIscobolListingFile() != null) {
                        dir = ol.getOption("-lo=");
                        if (dir == null) {
                            dir = sourceFilePath;
                        }
                        Pcc.writeFile(ppfo[i].getIscobolListingFile().getContent(), dir + File.separator + new File(ppfo[i].getIscobolListingFile().getPath()));
                    }
                    if (ppfo[i].getIscobolErrorFile() != null) {
                        dir = ol.getOption("-eo=");
                        if (dir == null) {
                            dir = sourceFilePath;
                        }
                        Pcc.writeFile(ppfo[i].getIscobolErrorFile().getContent(), dir + File.separator + new File(ppfo[i].getIscobolErrorFile().getPath()));
                    }
                    if (ppfo[i].getClassFiles() == null) continue;
                    for (int idx = 0; idx < ppfo[i].getClassFiles().length; ++idx) {
                        String dir2 = ol.getOption("-od=");
                        if (dir2 == null) {
                            dir2 = sourceFilePath;
                        }
                        Pcc.writeFile(ppfo[i].getClassFiles()[idx].getContent(), dir2 + File.separator + new File(ppfo[i].getClassFiles()[idx].getPath()));
                    }
                }
                if (!compileOnServer) {
                    Return2 = ppfo;
                }
            }
        }
        return Return2;
    }

    @Override
    public Repository getRepository() {
        if (this.getEnvironmentDivision() != null && this.getEnvironmentDivision().getConfigurationSection() != null) {
            return this.getEnvironmentDivision().getConfigurationSection().repository;
        }
        return null;
    }

    @Override
    public DataDivision getDataDivision() {
        return this.data;
    }

    public static InvokeNotifier getInvokeNotifier() {
        return invokeNotifier;
    }

    public static void setInvokeNotifier(InvokeNotifier invokeNotifier) {
        Pcc.invokeNotifier = invokeNotifier;
    }

    public static VerbNotifier getVerbNotifier() {
        return verbNotifier;
    }

    public static void setVerbNotifier(VerbNotifier verbNotifier) {
        Pcc.verbNotifier = verbNotifier;
    }

    public static Pcc analyze(String filename, OptionList ol, Class errorClass, Reader reader) {
        return Pcc.analyze(filename, ol, errorClass, reader, null);
    }

    public static Pcc analyze(String filename, OptionList ol, Class errorClass, Reader reader, FileFinder fFinder) {
        return Pcc.run(filename, null, ol, null, errorClass, reader, false, fFinder);
    }

    public static Pcc analyze(String filename, OptionList ol, Errors err, Reader reader, FileFinder fFinder, PreProcessorReaderProvider isrProvider) {
        Pcc Return2;
        try {
            Return2 = Pcc.run(filename, null, ol, null, err, reader, false, fFinder, isrProvider);
        }
        catch (ErrorInCompilationException e) {
            Return2 = e.pcc;
        }
        return Return2;
    }

    public static Pcc run(String filename, String outDir, OptionList ol, String javac, Class errorClass) {
        return Pcc.run(filename, outDir, ol, javac, errorClass, null, true);
    }

    public static Pcc run(String filename, String outDir, OptionList ol, String javac, Class errorClass, Reader reader, boolean generateCode) {
        return Pcc.run(filename, outDir, ol, javac, errorClass, reader, generateCode, null);
    }

    public static Pcc run(String filename, String outDir, OptionList ol, String javac, Class errorClass, Reader reader, boolean generateCode, FileFinder fFinder) {
        Pcc Return2;
        Errors err;
        if (errorClass != null) {
            try {
                err = (Errors)errorClass.newInstance();
            }
            catch (Exception e) {
                err = new Errors(ol.getOption("-xmsgfmt="));
            }
        } else {
            err = new Errors(ol.getOption("-xmsgfmt="));
        }
        try {
            Return2 = Pcc.run(filename, outDir, ol, javac, err, reader, generateCode, fFinder, null);
        }
        catch (ErrorInCompilationException _ex) {
            Return2 = _ex.pcc;
        }
        return Return2;
    }

    public static Pcc run(String filename, String outDir, OptionList ol, String javac, Errors err, Reader reader, boolean generateCode) throws ErrorInCompilationException {
        return Pcc.run(filename, outDir, ol, javac, err, reader, generateCode, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pcc run(String filename, String outDir, OptionList ol, String javac, Errors err, Reader reader, boolean generateCode, FileFinder fFinder, PreProcessorReaderProvider isrProvider) throws ErrorInCompilationException {
        boolean needToRestoreConfig = javac != null;
        String oldJavac = null;
        if (needToRestoreConfig) {
            String origName = Config.markNoIscobolRuntimeThread();
            oldJavac = Config.getProperty(".compiler.javac", null);
            Config.setProperty(".compiler.javac", javac);
            Thread.currentThread().setName(origName);
        }
        try {
            Phases phases = PhasesFactory.create(ol);
            Pcc pcc = Pcc.run(filename, outDir, ol, phases, err, reader, generateCode, fFinder, isrProvider, null, false, false);
            return pcc;
        }
        finally {
            if (needToRestoreConfig) {
                String origName = Config.markNoIscobolRuntimeThread();
                if (oldJavac != null) {
                    Config.setProperty(".compiler.javac", oldJavac);
                } else {
                    Config.unsetProperty(".compiler.javac");
                }
                Thread.currentThread().setName(origName);
            }
        }
    }

    public static final void resetAllCounters() {
        Accept.resetCounters();
        Block.resetCounters();
        NextSentenceBlock.resetCounters();
        Paragraph.resetCounters();
        Perform.resetCounters();
        ReportVariable.resetCounters();
        VariableDeclaration.resetCounters();
        Verb.resetCounters();
        eisCheck = null;
        MyClass.myclassCache.clear();
        srcDirMain = null;
        easyLinkStubs = new HashMap<String, Call>();
        hyphenRepl = (char)45;
        identifierSep = (char)36;
    }

    String[] getOutddProperty() {
        return this.getOutddProperty(false);
    }

    String[] getOutddProperty(boolean check) {
        String outdd = Config.getProperty(".compiler.outdd", "NOOUTDD");
        String outFile = null;
        int minLen = 0;
        boolean nl = true;
        String[] ss = outdd.split("\\s+");
        String err = null;
        if (ss.length > 0 && !"NOOUTDD".equalsIgnoreCase(ss[0])) {
            String str;
            outFile = "\"" + Pcc.escapeString(ss[0].trim()) + "\"";
            if (ss.length > 1) {
                str = ss[1].trim();
                try {
                    minLen = Integer.parseInt(str);
                }
                catch (NumberFormatException ex) {
                    minLen = -1;
                }
                if (check && minLen < 0) {
                    err = "Size is " + str;
                }
            }
            if (ss.length > 2) {
                str = ss[2].trim().toUpperCase();
                if (check && !"L".equals(str) && !"R".equals(str)) {
                    err = err != null ? err + ", Format is " + str : "Format is " + str;
                }
                boolean bl = nl = !"R".equalsIgnoreCase(str);
            }
            if (err != null) {
                this.error.print(242, 2, 1, 1, err, null, null);
            }
        }
        return new String[]{outFile, Integer.toString(minLen), Boolean.toString(nl)};
    }

    static String getInddProperty() {
        String indd = Config.getProperty(".compiler.indd", "NOINDD");
        String inFile = null;
        if (!"NOINDD".equalsIgnoreCase(indd)) {
            inFile = "\"" + Pcc.escapeString(indd.trim()) + "\"";
        }
        return inFile;
    }

    static String getEasyLinkageFileName(String progName) {
        return Pcc.getEasyLinkageFileName(progName, true, "");
    }

    static String getEasyLinkageFileName(String progName, boolean pref, TokenManager tm) {
        String dir = "";
        if (tm != null && tm.getFileName().contains(File.separator)) {
            dir = tm.getFileName().substring(0, tm.getFileName().lastIndexOf(File.separator));
        }
        return Pcc.getEasyLinkageFileName(progName, pref, dir);
    }

    static String getEasyLinkageFileName(String progName, boolean pref, String sourceDir) {
        if (Config.getProperty(".compiler.easylinkage", false)) {
            File f = new File(Pcc.loadOutDir("easylinkage", sourceDir, true) + File.separator + progName);
            String eLnkPrefix = "";
            if (pref) {
                eLnkPrefix = Config.getProperty(".compiler.easylinkage.prefix", "link").trim();
            }
            if (f.getParent() != null) {
                return f.getParent() + File.separator + eLnkPrefix + f.getName();
            }
            return eLnkPrefix + progName;
        }
        return null;
    }

    boolean isEasyLinkageActivated() {
        return this.theProgram != null && this.theProgram.getDataDivision() != null && (Config.getProperty(".compiler.easylinkage", 0) == 1 || Config.getProperty(".compiler.easylinkage", false) || Config.getProperty(".compiler.easylinkage", 0) == 3) && Config.getProperty(".compiler.easylinkage", 0) != 2;
    }

    boolean isEasyLinkageStubActivated() {
        return this.theProgram != null && this.theProgram.getDataDivision() != null && (Config.getProperty(".compiler.easylinkage", 0) == 2 || Config.getProperty(".compiler.easylinkage", 0) == 3);
    }

    boolean isEasyCallStub() {
        return Config.getProperty(".compiler.easylinkage", 0) == 2 || Config.getProperty(".compiler.easylinkage", 0) == 3;
    }

    @Override
    public String getServiceBridgeName() {
        String operation;
        if (this.theProgram == null || this.theProgram.getProcedureDivision() == null || (operation = this.theProgram.getProcedureDivision().getServiceBridgeOperation()) == null) {
            operation = this.outName;
        }
        return operation;
    }

    public String getServiceBridgeSoapFileName(String sbName) {
        return this.getServiceBridgeFileName(Config.getProperty(".compiler.servicebridge.soap.prefix", "soap").trim(), sbName, "cbl");
    }

    public String getServiceBridgeSoapBeanFileName(String sbName) {
        return this.getServiceBridgeFileName(Config.getProperty(".compiler.servicebridge.bean.prefix", "bean").trim(), sbName, "cbl", ".bean");
    }

    public String getServiceBridgeRestFileName(String sbName) {
        return this.getServiceBridgeFileName(Config.getProperty(".compiler.servicebridge.rest.prefix", "rest").trim(), sbName, "cbl");
    }

    public String getServiceBridgeRestBeanFileName(String sbName) {
        return this.getServiceBridgeFileName(Config.getProperty(".compiler.servicebridge.bean.prefix", "bean").trim(), sbName, "cbl", ".bean");
    }

    public String getServiceBridgeEjbFileName(String sbName) {
        return this.getServiceBridgeFileName(Config.getProperty(".compiler.servicebridge.ejb.prefix", "ejb").trim(), sbName, "cbl");
    }

    private String getServiceBridgeFileName(String prefix, String name, String ext) {
        return this.getServiceBridgeFileName(prefix, name, ext, "");
    }

    private String getServiceBridgeFileName(String prefix, String name, String ext, String bean) {
        String intDir = this.getFileFinder() instanceof RemoteFileFinder && ("cpy".equals(ext) || "wrk".equals(ext)) ? this.sourceDir : Pcc.loadOutDir("servicebridge" + bean, this.sourceDir, true);
        if (intDir.length() > 0) {
            return intDir + prefix + name + "." + ext;
        }
        return this.sourceDir + (this.sourceDir.length() == 0 || this.sourceDir.endsWith(File.separator) ? "" : File.separator) + prefix + name + "." + ext;
    }

    public String getServiceBridgeCopyFileName(String sbName) {
        return this.getServiceBridgeFileName("", sbName, "cpy", ".bean");
    }

    public String getServiceBridgeCopyFileNameWrk(String sbName) {
        return this.getServiceBridgeFileName("", sbName, "wrk", ".bean");
    }

    public String getWsdlFileName() {
        return this.outDir + (this.outDir.length() == 0 || this.outDir.endsWith(File.separator) ? "" : File.separator) + this.outName + ".wsdl";
    }

    boolean isEasyDBActivated() throws GeneralErrorException {
        boolean Return2 = Config.getProperty(".compiler.easydb", false);
        if (Return2) {
            Throwable err = null;
            try {
                Class<?> c = Class.forName("com.iscobol.easydb.EdbiIs");
                Method m = c.getDeclaredMethod("checkLicense", Boolean.TYPE);
                m.setAccessible(true);
                try {
                    m.invoke(null, Boolean.FALSE);
                }
                catch (InvocationTargetException t) {
                    err = t.getCause();
                }
            }
            catch (Throwable ex) {
                err = ex;
            }
            if (err != null) {
                Token tk = new Token(10001, "", 1, 0, this.getSourceFileName());
                throw new GeneralErrorException(61, 4, tk, "DataBase Bridge: " + err, this.error);
            }
        }
        return Return2;
    }

    boolean isServiceBridgeActivated() throws GeneralErrorException {
        boolean Return2 = Config.getProperty(".compiler.servicebridge", false);
        if (Return2) {
            Pcc.checkEIS(new Token(10001, "", 1, 0, this.getSourceFileName()), this.error, false);
        }
        return Return2;
    }

    void makeEasyBridgeRoutines() {
        char save1 = hyphenRepl;
        char save2 = identifierSep;
        hyphenRepl = (char)95;
        identifierSep = (char)36;
        try {
            this.makeEasyBridgeRoutines0();
        }
        finally {
            hyphenRepl = save1;
            identifierSep = save2;
        }
    }

    private void makeEasyBridgeRoutines0() {
        DataDivision data = this.theProgram.getDataDivision();
        String genOpts = this.getEdbiIsOptions();
        String pOpts = this.getEdbiIsOptionsPostgres();
        String mOpts = this.getEdbiIsOptionsMysql();
        String oOpts = this.getEdbiIsOptionsOracle();
        String sOpts = this.getEdbiIsOptionsSqlserver();
        String iOpts = this.getEdbiIsOptionsInformix();
        String allOptions = "";
        String name = "";
        this.subsEasyDB = "";
        try {
            IEasyDB edbiIs = (IEasyDB)Class.forName("com.iscobol.easydb.EasyDBImpl").newInstance();
            if (data != null && data.fileSec != null) {
                FileDescriptor fd;
                ArrayList<String> ol;
                String dbname = "";
                boolean foundDb = false;
                Enumeration it = this.easyDbNames.keys();
                while (it.hasMoreElements()) {
                    dbname = (String)it.nextElement();
                    boolean active = Config.getProperty(".compiler.easydb." + dbname, false);
                    allOptions = genOpts + "-prefix=" + Config.getProperty(".compiler.easydb." + dbname + ".prefix", (String)this.easyDbPrefix.get(dbname)) + ";";
                    if (dbname.equals("postgres")) {
                        allOptions = allOptions + pOpts;
                    } else if (dbname.equals("oracle")) {
                        allOptions = allOptions + oOpts;
                    } else if (dbname.equals("mysql")) {
                        allOptions = allOptions + mOpts;
                    } else if (dbname.equals("sqlserver")) {
                        allOptions = allOptions + sOpts;
                    } else if (dbname.equals("informix")) {
                        allOptions = allOptions + iOpts;
                    }
                    allOptions = dbname.equals("generic") || allOptions.contains("-dml") && this.easyDbNames.get(dbname).equals("-dm") || allOptions.contains("-dsl") && this.easyDbNames.get(dbname).equals("-ds") || allOptions.contains("-dpl") && this.easyDbNames.get(dbname).equals("-dp") ? allOptions.substring(0, allOptions.length() - 1) : allOptions + this.easyDbNames.get(dbname);
                    ol = new ArrayList();
                    String[] stringArray = allOptions.split(";");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String s = stringArray[i];
                        ol.add(s);
                    }
                    String stringArray2 = Pcc.loadOutDir("easydb", this.sourceDir, true);
                    ol.add("-od=" + stringArray2);
                    File fil = new File(stringArray2);
                    if (fil != null && !fil.exists() && !fil.mkdirs()) {
                        System.err.println("Cannot create '" + stringArray2 + "'");
                    }
                    fd = data.fileSec.fdArray.getFirst();
                    while (active && fd != null) {
                        if (fd.sel.organization == 529 || !Config.getProperty(".compiler.easydb.index_only", true)) {
                            foundDb = true;
                            name = fd.fileName.getWord() + ".xml";
                            this.subsEasyDB = this.subsEasyDB + edbiIs.runComp(fd.sel.getEfdCode(), ol.toArray(new String[ol.size()]));
                            if (this.scriptList == null) {
                                this.scriptList = new ArrayList();
                                this.scriptList.addAll(edbiIs.getScriptList());
                            }
                        }
                        fd = data.fileSec.fdArray.getNext();
                    }
                }
                if (!foundDb) {
                    allOptions = genOpts + "-prefix=" + Config.getProperty(".compiler.easydb.generic.prefix", (String)this.easyDbPrefix.get("generic")) + ";";
                    ol = new ArrayList<String>();
                    for (String s : allOptions.split(";")) {
                        ol.add(s);
                    }
                    String string = Pcc.loadOutDir("easydb", this.sourceDir, true);
                    ol.add("-od=" + string);
                    File fil = new File(string);
                    if (fil != null && !fil.exists() && !fil.mkdirs()) {
                        System.err.println("Cannot create '" + string + "'");
                    }
                    fd = data.fileSec.fdArray.getFirst();
                    while (fd != null) {
                        if (fd.sel.organization == 529 || !Config.getProperty(".compiler.easydb.index_only", true)) {
                            name = fd.fileName.getWord() + ".xml";
                            this.subsEasyDB = this.subsEasyDB + edbiIs.runComp(fd.sel.getEfdCode(), ol.toArray(new String[ol.size()]));
                            if (this.scriptList == null) {
                                this.scriptList = new ArrayList();
                                this.scriptList.addAll(edbiIs.getScriptList());
                            }
                        }
                        fd = data.fileSec.fdArray.getNext();
                    }
                }
            }
        }
        catch (Exception _ex) {
            this.error.print(61, 2, 0, 0, "EdbiIs Failed", _ex, name);
        }
    }

    String getEdbiIsOptions() {
        String Return2 = "-cc;-esst;-sl;";
        String tmp = "";
        if (Config.getProperty(".compiler.easydb.defchar", false)) {
            Return2 = Return2 + "-defChar;";
        }
        if (Config.getProperty(".compiler.easydb.isam_eof", false)) {
            Return2 = Return2 + "-i;";
        }
        if (Config.getProperty(".compiler.easydb.julian_routines", null) != null) {
            tmp = Config.getProperty(".compiler.easydb.julian_routines", "A;B");
            if (!tmp.contains(";")) {
                this.error.print(61, 2, 0, 0, "Property .compiler.easydb.julian_routines malformed", null, tmp);
            }
            Return2 = Return2 + "-jcd=" + tmp.substring(0, tmp.indexOf(";"));
            Return2 = Return2 + "-jdc=" + tmp.substring(tmp.indexOf(";") + 1) + ";";
        }
        if (Config.getProperty(".compiler.easydb.max_char_len", 0) != 0) {
            Return2 = Return2 + "-maxCHARlen=" + Config.getProperty(".compiler.easydb.max_char_len", 0) + ";";
        }
        if (Config.getProperty(".compiler.easydb.test_not_numeric", 0) != 0) {
            if (Config.getProperty(".compiler.easydb.test_not_numeric", 0) == 1) {
                Return2 = Return2 + "-n;";
            } else if (Config.getProperty(".compiler.easydb.test_not_numeric", 0) == 2) {
                Return2 = Return2 + "-n;-t;";
            } else {
                this.error.print(61, 2, 0, 0, "Property .compiler.easydb.test_not_numeric malformed", null, "");
            }
        }
        if (Config.getProperty(".compiler.easydb.duplicates_in_order", false)) {
            Return2 = Return2 + "-pdo;";
        }
        if (Config.getProperty(".compiler.easydb.leading_zeros", false)) {
            Return2 = Return2 + "-no;";
        }
        if (Config.getProperty(".compiler.easydb.not_null_columns", false)) {
            Return2 = Return2 + "-nn;";
        }
        if (Config.getProperty(".compiler.easydb.high_values_as_max_val", false)) {
            Return2 = Return2 + "-h;";
        }
        if (Config.getProperty(".compiler.easydb.unlock_all", false)) {
            Return2 = Return2 + "-ua;";
        }
        if (Config.getProperty(".compiler.easydb.no_check", false)) {
            Return2 = Return2 + "-nocheck;";
        }
        if (Config.getProperty(".compiler.easydb.entry_points", false)) {
            Return2 = Return2 + "-entrypoints;";
        }
        if (this.options.getOption("-ca") != null) {
            Return2 = Return2 + "-ca;";
        }
        if (this.options.getOption("-dz") != null) {
            Return2 = Return2 + "-dz;";
        }
        if (this.options.getOption("-dcd") != null) {
            Return2 = Return2 + "-dcd;";
        }
        if (this.options.getOption("-csqq") != null) {
            Return2 = Return2 + "-csqq;";
        }
        if (Config.getProperty(".compiler.easydb.sql", false)) {
            Return2 = Return2 + "-sql;";
        }
        if (Config.getProperty(".compiler.easydb.sql.output", null) != null) {
            Return2 = Return2 + "-os=" + Config.getProperty(".compiler.easydb.sql.output", "") + ";";
        }
        return Return2;
    }

    String getEdbiIsOptionsMysql() {
        String Return2 = "";
        if (Config.getProperty(".compiler.easydb.light_cursors", 0) != 0) {
            if (Config.getProperty(".compiler.easydb.light_cursors", 0) == 1) {
                Return2 = Return2 + "-dmlu;";
            } else if (Config.getProperty(".compiler.easydb.light_cursors", 0) == 2) {
                Return2 = Return2 + "-dmld;";
            } else {
                this.error.print(61, 2, 0, 0, "Property .compiler.easydb.light_cursors malformed", null, "");
            }
        }
        if (Config.getProperty(".compiler.easydb.mysql.oid_name", null) != null) {
            Return2 = Return2 + "-dmoid=" + Config.getProperty(".compiler.easydb.mysql.oid_name", "OID") + ";";
        }
        if (Config.getProperty(".compiler.easydb.mysql.hints", false)) {
            Return2 = Return2 + "-mh;";
        }
        return Return2;
    }

    String getEdbiIsOptionsPostgres() {
        String Return2 = "-Pi;";
        if (Config.getProperty(".compiler.easydb.light_cursors", 0) != 0) {
            if (Config.getProperty(".compiler.easydb.light_cursors", 0) == 1) {
                Return2 = Return2 + "-dplu;";
            } else if (Config.getProperty(".compiler.easydb.light_cursors", 0) == 2) {
                Return2 = Return2 + "-dpld;";
                if (Config.getProperty(".compiler.easydb.postgres.oid_name", null) != null) {
                    Return2 = Return2 + "-dpoid=" + Config.getProperty(".compiler.easydb.postgres.oid_name", "OID") + ";";
                }
            } else {
                this.error.print(61, 2, 0, 0, "Property .compiler.easydb.light_cursors malformed", null, "");
            }
        }
        return Return2;
    }

    String getEdbiIsOptionsOracle() {
        int lck;
        String Return2 = "-ce;";
        if (Config.getProperty(".compiler.easydb.oracle.hints", 0) != 0) {
            if (Config.getProperty(".compiler.easydb.oracle.hints", 0) == 1) {
                Return2 = Return2 + "-oh;";
            } else if (Config.getProperty(".compiler.easydb.oracle.hints", 0) == 2) {
                Return2 = Return2 + "-oho;";
            } else {
                this.error.print(61, 2, 0, 0, "Property .compiler.easydb.oracle.hints malformed", null, "");
            }
        }
        if (Config.getProperty(".compiler.easydb.oracle.index_storage_initial_value", 0) != 0) {
            Return2 = Return2 + "-Oii=" + Config.getProperty(".compiler.easydb.oracle.index_storage_initial_value", 0) + ";";
        }
        if (Config.getProperty(".compiler.easydb.oracle.table_storage_initial_value", 0) != 0) {
            Return2 = Return2 + "-Oit=" + Config.getProperty(".compiler.easydb.oracle.table_storage_initial_value", 0) + ";";
        }
        if (Config.getProperty(".compiler.easydb.oracle.index_storage_next_value", 0) != 0) {
            Return2 = Return2 + "-Oni=" + Config.getProperty(".compiler.easydb.oracle.index_storage_next_value", 0) + ";";
        }
        if (Config.getProperty(".compiler.easydb.oracle.table_storage_next", 0) != 0) {
            Return2 = Return2 + "-Ont=" + Config.getProperty(".compiler.easydb.oracle.table_storage_next_value", 0) + ";";
        }
        if (Config.getProperty(".compiler.easydb.oracle.index_storage_pctincrease_value", 0) != 0) {
            Return2 = Return2 + "-Opi=" + Config.getProperty(".compiler.easydb.oracle.index_storage_pctincrease_value", 0) + ";";
        }
        if (Config.getProperty(".compiler.easydb.oracle.table_storage_pctincreasel_value", 0) != 0) {
            Return2 = Return2 + "-Opt=" + Config.getProperty(".compiler.easydb.oracle.table_storage_pctincrease_value", 0) + ";";
        }
        if (Config.getProperty(".compiler.easydb.oracle.tablespace_index_name", null) != null) {
            Return2 = Return2 + "-Oti=" + Config.getProperty(".compiler.easydb.oracle.tablespace_index_name", 0) + ";";
        }
        if (Config.getProperty(".compiler.easydb.oracle.tablespace_name", null) != null) {
            Return2 = Return2 + "-Otn=" + Config.getProperty(".compiler.easydb.oracle.tablespace_name", 0) + ";";
        }
        if ((lck = Config.getProperty(".compiler.easydb.oracle.wait_for_lock", 0)) == 0) {
            Return2 = Return2 + "-Ow;";
        } else if (lck == 2) {
            Return2 = Return2 + "-Owfl;";
        }
        return Return2;
    }

    String getEdbiIsOptionsSqlserver() {
        String Return2 = "";
        if (Config.getProperty(".compiler.easydb.light_cursors", 0) != 0) {
            if (Config.getProperty(".compiler.easydb.light_cursors", 0) == 1) {
                Return2 = Return2 + "-dslu;";
            } else if (Config.getProperty(".compiler.easydb.light_cursors", 0) == 2) {
                Return2 = Return2 + "-dsld;";
            } else {
                this.error.print(61, 2, 0, 0, "Property .compiler.easydb.light_cursors malformed", null, "");
            }
        }
        if (Config.getProperty(".compiler.easydb.sqlserver.latin1_general_bin", 0) != 0) {
            if (Config.getProperty(".compiler.easydb.sqlserver.latin1_general_bin", 0) == 1) {
                Return2 = Return2 + "-sc;";
            } else if (Config.getProperty(".compiler.easydb.sqlserver.latin1_general_bin", 0) == 2) {
                Return2 = Return2 + "-sco;";
            } else {
                this.error.print(61, 2, 0, 0, "Property .compiler.easydb.sqlserver.hints malformed", null, "");
            }
        }
        if (Config.getProperty(".compiler.easydb.sqlserver.datetime_always", false)) {
            Return2 = Return2 + "-sdt;";
        }
        return Return2;
    }

    String getEdbiIsOptionsInformix() {
        String Return2 = "";
        if (Config.getProperty(".compiler.easydb.informix.dates_as_strings", false)) {
            Return2 = Return2 + "-id;";
        }
        return Return2;
    }

    public void prepareCompileData(StandardPhases phases) {
        File fn = new File(this.getSourceFileName());
        HashMap<String, Object> compileData = phases.getPccToBeCompiled().get(fn);
        if (compileData != null) {
            return;
        }
        compileData = new HashMap<String, Object>();
        phases.getPccToBeCompiled().put(fn, compileData);
        compileData.put("programName", this.progName);
        if (this.theProgram != null) {
            boolean b = this.isEasyLinkageActivated();
            compileData.put("easyLinkageActivated", "" + b);
            if (b) {
                RemoteFileFinder rff = this.getFileFinder() instanceof RemoteFileFinder ? (RemoteFileFinder)this.getFileFinder() : null;
                String elFileName = Pcc.getEasyLinkageFileName(this.getOutNameBase() + ".java", true, this.sourceDir);
                if (rff != null) {
                    try {
                        rff.getCompileUnit().addBridgeFile((RemoteBridgeFile)RemoteCompiler.createRemoteFile(elFileName, elFileName.substring(rff.getSourceDir().length() + 1), 2));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                String parDir = new File(elFileName).getParent();
                compileData.put("easyLinkageFileName", elFileName);
                Entry[] entries = this.theProgram.getEntryPoints();
                if (entries != null && entries.length > 0) {
                    String pfx = Config.getProperty(".compiler.easylinkage.prefix", "link").trim();
                    String[] ep = new String[entries.length];
                    for (int i = 0; i < entries.length; ++i) {
                        ep[i] = entries[i].getName();
                        if (rff == null) continue;
                        String epName = ep[i];
                        if (epName.startsWith("\"")) {
                            epName = epName.substring(1, epName.length() - 1);
                        }
                        epName = pfx + epName + ".java";
                        if (parDir != null) {
                            epName = parDir + File.separator + epName;
                        }
                        try {
                            rff.getCompileUnit().addBridgeFile((RemoteBridgeFile)RemoteCompiler.createRemoteFile(epName, epName.substring(rff.getSourceDir().length() + 1), 2));
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    compileData.put("entryPoints", ep);
                    compileData.put("easyLinkageEntryPrefix", pfx);
                } else {
                    compileData.put("entryPoints", new String[0]);
                }
            }
            this.compileServiceBridgePrograms();
        }
    }

    private void compileServiceBridgePrograms() {
        if (this.theProgram != null && this.theProgram.serviceBridgeActivated) {
            Entry[] entries = this.theProgram.getEntryPoints();
            String type = Config.getProperty(".compiler.servicebridge.type", "SOAP");
            int mulFactor = 1;
            if (type.equalsIgnoreCase("REST") && Config.getProperty(".compiler.servicebridge.bean", "").equalsIgnoreCase("rest") || type.equalsIgnoreCase("SOAP") && Config.getProperty(".compiler.servicebridge.bean", "").equalsIgnoreCase("soap")) {
                mulFactor = 2;
            }
            String[] wsdlProgName = new String[mulFactor * entries.length + mulFactor];
            String sbName = this.getServiceBridgeName();
            if (type.equalsIgnoreCase("SOAP")) {
                wsdlProgName[0] = this.getServiceBridgeSoapFileName(sbName) + ",servicebridge";
                if (Config.getProperty(".compiler.servicebridge.bean", "").equalsIgnoreCase("soap")) {
                    wsdlProgName[1] = this.getServiceBridgeSoapBeanFileName(sbName) + ",servicebridge.bean";
                }
            } else if (type.equalsIgnoreCase("REST")) {
                wsdlProgName[0] = this.getServiceBridgeRestFileName(sbName) + ",servicebridge";
                if (Config.getProperty(".compiler.servicebridge.bean", "").equalsIgnoreCase("rest")) {
                    wsdlProgName[1] = this.getServiceBridgeRestBeanFileName(sbName) + ",servicebridge.bean";
                }
            } else if (type.equalsIgnoreCase("EJB")) {
                wsdlProgName[0] = this.getServiceBridgeEjbFileName(sbName) + ",servicebridge";
            }
            int i = mulFactor;
            for (int j = 0; j < entries.length; ++j) {
                sbName = entries[j].getServiceBridgeValueName();
                if (type.equalsIgnoreCase("SOAP")) {
                    wsdlProgName[i] = this.getServiceBridgeSoapFileName(sbName) + ",servicebridge";
                    if (Config.getProperty(".compiler.servicebridge.bean", "").equalsIgnoreCase("soap")) {
                        wsdlProgName[++i] = this.getServiceBridgeSoapBeanFileName(sbName) + ",servicebridge.bean";
                    }
                } else if (type.equalsIgnoreCase("REST")) {
                    wsdlProgName[i] = this.getServiceBridgeRestFileName(sbName) + ",servicebridge";
                    if (Config.getProperty(".compiler.servicebridge.bean", "").equalsIgnoreCase("rest")) {
                        wsdlProgName[++i] = this.getServiceBridgeRestBeanFileName(sbName) + ",servicebridge.bean";
                    }
                } else if (type.equalsIgnoreCase("EJB")) {
                    wsdlProgName[i] = this.getServiceBridgeEjbFileName(sbName) + ",servicebridge";
                }
                ++i;
            }
            OptionList ol = (OptionList)this.options.clone();
            ol.restoreProperties();
            ol.addOption("#st");
            ol.addOption("#sa");
            ol.addOption("#smat");
            ol.addOption("#xoldsmat");
            ol.addOption("#sf");
            ol.addOption("#ef");
            ol.addOption("#eo=");
            ol.addOption("#lf");
            ol.addOption("#lo=");
            ol.addOption("-st");
            FileFinder ff = this.getFileFinder();
            RemoteFileFinder rff = ff instanceof RemoteFileFinder ? (RemoteFileFinder)ff : null;
            for (i = 0; i < wsdlProgName.length; ++i) {
                String copyDir;
                String iOutDir;
                String[] part = wsdlProgName[i].split(",");
                if (rff != null) {
                    try {
                        rff.getCompileUnit().addBridgeFile((RemoteBridgeFile)RemoteCompiler.createRemoteFile(part[0], part[0].substring(rff.getSourceDir().length() + 1), 3));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    iOutDir = this.outDir;
                    copyDir = rff.getSourceDir();
                } else {
                    iOutDir = Pcc.loadOutDir(part[1], this.outDir, false);
                    copyDir = Pcc.loadOutDir(part[1], this.sourceDir, true);
                }
                try {
                    File f;
                    if (copyDir.length() > 0) {
                        ol.addOption("#sp=");
                        ol.addOption("-sp=" + copyDir);
                    }
                    if (!(f = new File(part[0])).exists()) continue;
                    Pcc.run(part[0], iOutDir, ol, this.phases, this.error, null, true, ff);
                    continue;
                }
                catch (ErrorInCompilationException _ex) {
                    Exception t = _ex.getCause() != null && _ex.getCause() instanceof Exception ? (Exception)_ex.getCause() : _ex;
                    this.error.print(61, 2, 0, 0, _ex.getMessage(), t, part[0]);
                    continue;
                }
                catch (Exception _ex) {
                    if (wsdlProgName[i] != null) {
                        this.error.print(61, 2, 0, 0, "Compilation Failed", _ex, part[0]);
                        continue;
                    }
                    this.error.print(61, 2, 0, 0, "Compilation Failed", _ex, "");
                }
            }
        }
    }

    @Override
    public String[] getEasyDBProgramsNames() {
        if (this.subsEasyDB.length() == 0) {
            return new String[0];
        }
        return this.subsEasyDB.substring(0, this.subsEasyDB.length() - 1).split("!");
    }

    public static Pcc run(String filename, String outDir, OptionList ol, Phases phases, Errors err, Reader reader, boolean generateCode) throws ErrorInCompilationException {
        return Pcc.run(filename, outDir, ol, phases, err, reader, generateCode, null);
    }

    public static Pcc run(String filename, String outDir, OptionList ol, Phases phases, Errors err, Reader reader, boolean generateCode, FileFinder fFinder) throws ErrorInCompilationException {
        return Pcc.run(filename, outDir, ol, phases, err, reader, generateCode, fFinder, null, null, false, false);
    }

    private static Pcc run(String filename, String outDir, OptionList ol, Phases phases, Errors err, Reader reader, boolean generateCode, FileFinder fFinder, PreProcessorReaderProvider isrProvider, Map<String, Pcc> referencedPccs, boolean findingMethods, boolean referenced) throws ErrorInCompilationException {
        if (ol.getOption("-jjms") != null) {
            try {
                Pcc.checkJJMS(false);
            }
            catch (Throwable t) {
                String msg = t.toString();
                err.print(61, 4, 0, 0, "JJMS: " + msg.substring(msg.indexOf(77)), null, filename);
                return null;
            }
        }
        String origName = Config.markNoIscobolRuntimeThread();
        if (generateCode) {
            MAX_PARAGRAPHS = Config.getProperty(".compiler.max_paragraphs", 300);
            MAX_CONSTANTS = Config.getProperty(".compiler.max_constants", 1000);
        }
        boolean lfo_po_option = ol.getOption("-lfo") != null || ol.getOption("-po") != null;
        Pcc pcc = null;
        PreProcessor pp = null;
        try {
            LinkedList extExecLines;
            Hashtable extExecs;
            int maxErrors;
            String name;
            String srcDir;
            File listing = null;
            int lastFileSep = filename.lastIndexOf(File.separator);
            if (lastFileSep >= 0) {
                srcDir = filename.substring(0, lastFileSep + 1);
                name = filename.substring(lastFileSep + 1, filename.length());
            } else {
                srcDir = "";
                name = filename;
            }
            if (srcDirMain == null) {
                srcDirMain = srcDir;
            }
            String dir = outDir == null || outDir.equals("") ? srcDir : outDir;
            int dot = name.lastIndexOf(46);
            if (dot > 0) {
                name = name.substring(0, dot);
            }
            String lstName = null;
            String lstDir = null;
            lstDir = ol.getOption("-lo=");
            if (lstDir != null || lfo_po_option || ol.getOption("-ld") != null || ol.getOption("-la") != null || ol.getOption("-lf") != null) {
                lstName = lstDir == null ? srcDir + name + ".list" : (lstDir.endsWith(File.separator) ? lstDir + name + ".list" : lstDir + File.separator + name + ".list");
                if (lstName.length() == 0 || lstName.equals(filename)) {
                    System.err.println("" + Errors.errorDesc.get(new Integer(116)) + "-lo=");
                    System.exit(5);
                }
                listing = new File(lstName);
            }
            String edm = null;
            String edo = null;
            File edmFile = null;
            edo = ol.getOption("-edo=");
            if (edo != null || ol.getOption("-edm") != null) {
                edm = edo == null ? srcDir + name + ".xml" : (edo.endsWith(File.separator) ? edo + name + ".xml" : edo + File.separator + name + ".xml");
                if (edm.length() == 0 || edm.equals(filename)) {
                    System.err.println("" + Errors.errorDesc.get(new Integer(116)) + "-edo=");
                    System.exit(5);
                }
                edmFile = new File(edm);
            }
            if (Config.getProperty(".expired", true)) {
                System.err.println("\nLicense expired!\n");
            }
            if (reader == null) {
                if (ol.getOption("-verbose") != null) {
                    System.err.println("I --> " + filename);
                }
                if (lstName != null) {
                    System.err.println("List: " + lstName);
                }
            }
            try {
                maxErrors = Integer.parseInt(ol.getOption("-esme="));
            }
            catch (NullPointerException e) {
                maxErrors = 0;
            }
            catch (NumberFormatException e) {
                maxErrors = 0;
            }
            err.setMaxErrors(maxErrors);
            hyphenRepl = ol.getHyphenReplacingChar();
            if (hyphenRepl != '_') {
                identifierSep = (char)100;
            }
            pp = new PreProcessor(filename, dir, ol, err, fFinder, isrProvider);
            pp.setFormat();
            int returnCode = 0;
            Reader stream = reader;
            try {
                extExecs = Pcc.checkExec(ol);
            }
            catch (Exception ex) {
                err.print(146, 4, 0, 0, ex.getMessage(), null, filename);
                extExecs = null;
            }
            if (extExecs != null) {
                ExecHandlerIntf[] eh = new ExecHandlerIntf[extExecs.size()];
                Enumeration it = extExecs.elements();
                int i = 0;
                while (it.hasMoreElements()) {
                    eh[i] = (ExecHandlerIntf)it.nextElement();
                    ++i;
                }
                if (stream == null) {
                    try {
                        stream = new FileReader(filename);
                    }
                    catch (FileNotFoundException ex) {
                        err.print(10, 4, 0, 0, null, null, filename);
                        Pcc pcc2 = pcc;
                        if (pp != null) {
                            pp.closeSource();
                            pp.closeListing();
                        }
                        ol.restoreProperties();
                        Thread.currentThread().setName(origName);
                        return pcc2;
                    }
                }
                extExecLines = new LinkedList();
                stream = new PreProcsChain(eh, ol, extExecLines).init(stream);
            } else {
                extExecLines = null;
            }
            boolean ok = pp.start(stream, listing);
            if (ok) {
                try {
                    pcc = new Pcc(name, srcDir, dir, new TokenManager(pp, ol, err), ol, err, phases);
                    pcc.edmFile = edmFile;
                    if (referencedPccs == null) {
                        referencedPccs = new HashMap<String, Pcc>();
                    }
                    pcc.referencedPccs = referencedPccs;
                    pcc.findingMethods = findingMethods;
                    if (extExecLines != null) {
                        pcc.externalExecLines = extExecLines;
                    }
                    pcc.setGenerateCode(generateCode);
                    boolean execOk = pcc.initExec(extExecs, generateCode);
                    generateCode &= execOk;
                    if (lfo_po_option) {
                        generateCode = false;
                        err.ignoreFurtherErrors();
                    }
                    if (!(ok = pcc.start(generateCode, pp))) {
                        returnCode = 2;
                    }
                }
                catch (ErrorDirective ed) {
                    err.print(112, 4, ed.tk.getFLN(), ed.tk.getOffset(), ed.tk.getWord(), null, ed.tk.getFileName());
                    returnCode = -1;
                }
            } else {
                returnCode = 1;
            }
            if (findingMethods) {
                Pcc ed = pcc;
                return ed;
            }
            Vector errVec = err.getAllMessages();
            if (pcc != null && generateCode) {
                int rc = 0;
                ArrayList<Pcc> refPccs = new ArrayList<Pcc>();
                ArrayList<String> filesToDelete = new ArrayList<String>();
                if (returnCode == 0) {
                    filesToDelete.add(pcc.progName);
                }
                for (Pcc pc : pcc.referencedPccs.values()) {
                    if (pc == CLASS_NOT_FOUND || !pc.findingMethods) continue;
                    pc.findingMethods = false;
                    refPccs.add(pc);
                }
                if (!refPccs.isEmpty()) {
                    for (Pcc pc : refPccs) {
                        String od2;
                        String od;
                        OptionList newOl = (OptionList)ol.clone();
                        newOl.addOption("#jc");
                        newOl.addOption("-jj");
                        String string = od = outDir != null ? outDir : dir;
                        if (referencedPccNotifier != null && (od2 = referencedPccNotifier.getOutputDir(pc)) != null) {
                            od = od2;
                        }
                        try {
                            err.saveErrors();
                            Pcc refPc = Pcc.run(pc.getSourceFileName(), od, newOl, phases, err, null, true, pc.getFileFinder(), pc.tm.pp.getReaderProvider(), pcc.referencedPccs, false, true);
                            if (refPc != null) {
                                filesToDelete.add(refPc.progName);
                            }
                            if (refPc == null || ol.getOption("-jj") != null && ol.getOption("-jc") == null) continue;
                            phases.generateBinaryCode(refPc);
                        }
                        catch (ErrorInCompilationException ex) {
                            returnCode = 3;
                            rc = 3;
                            break;
                        }
                    }
                }
                if (rc != 0) {
                    Iterator<Pcc> iterator = filesToDelete.iterator();
                    while (iterator.hasNext()) {
                        String s = (String)((Object)iterator.next());
                        new File(s).delete();
                    }
                }
            }
            if (!(pcc == null || pcc.optionMS || ol.getOption("-jj") != null && ol.getOption("-jc") == null)) {
                StandardPhases stdPhases = (StandardPhases)phases;
                List<String[][]> classToBeRemoved = stdPhases.getClassToBeRemoved();
                for (Pcc pc : referencedPccs.values()) {
                    if (pc == CLASS_NOT_FOUND || pc == pcc && returnCode != 0) continue;
                    classToBeRemoved.add(new String[][]{{dir, pc.className}});
                }
            }
            if (returnCode == 0 && !lfo_po_option) {
                if (pcc.theProgram != null && pcc.theProgram.easydbActivated && pcc.theProgram.getDataDivision() != null) {
                    pcc.makeEasyBridgeRoutines();
                }
                if (pcc.isEasyLinkageStubActivated()) {
                    pcc.makeEasyLinkageStubRoutines();
                }
            }
            if (ol.getOption("-jj") == null || ol.getOption("-jc") != null) {
                if (!lfo_po_option) {
                    if (returnCode == 0) {
                        returnCode = phases.generateBinaryCode(pcc);
                    } else {
                        for (Pcc pc : referencedPccs.values()) {
                            if (pc.progName == null || pc.progName.length() <= 0) continue;
                            phases.generateBinaryCode(pc);
                        }
                    }
                }
            } else if (returnCode == 0 && generateCode) {
                pcc.compileServiceBridgePrograms();
                String[] entries = pcc.getEasyDBProgramsNames();
                String iOutDir = Pcc.loadOutDir("easydb", outDir, false);
                if (iOutDir.length() == 0) {
                    iOutDir = outDir;
                }
                for (int j = 0; j < entries.length; ++j) {
                    ol.restoreProperties();
                    ol.addOption("#ef");
                    ol.addOption("#st");
                    ol.addOption("#eo=");
                    ol.addOption("#lf");
                    ol.addOption("#lo=");
                    ol.addOption("#cp");
                    err = new Errors(ol.getOption("-xmsgfmt="));
                    err.setVerbose(ol.getOption("-verbose") != null);
                    Pcc.run(entries[j], iOutDir, (OptionList)ol.clone(), phases, err, null, true, pcc.getFileFinder());
                }
            }
            if (returnCode != 0) {
                if (!lfo_po_option) {
                    System.err.println("X --> " + filename + ": compilation failed");
                    returnCode = 4;
                }
                if (pcc != null && ol.getOption("-edc") != null) {
                    Pcc.removeClasses(dir, pcc.className, ol.getOption("-verbose") != null);
                }
            }
            String errName = null;
            String errDir = null;
            OutputStreamWriter errFileWriter = null;
            if (!lfo_po_option && (errDir = ol.getOption("-eo=")) != null || ol.getOption("-ef") != null) {
                errName = errDir == null ? srcDir + name + ".err" : (errDir.endsWith(File.separator) ? errDir + name + ".err" : errDir + File.separator + name + ".err");
                if (errName.length() == 0 || errName.equals(filename)) {
                    System.err.println("" + Errors.errorDesc.get(new Integer(116)) + "-lo=");
                    System.exit(5);
                }
                new File(errName).delete();
                if (err.getTotalErrorCount() > 0) {
                    try {
                        errFileWriter = PreProcessor.newOutputStreamWriter(new File(errName));
                        errFileWriter.write("I --> " + filename + eol);
                        for (int j = 0; j < errVec.size(); ++j) {
                            errFileWriter.write("" + errVec.elementAt(j) + eol);
                        }
                        errFileWriter.close();
                    }
                    catch (Exception _e) {
                        System.err.println(_e);
                    }
                }
            }
            if (returnCode != 0) {
                throw new ErrorInCompilationException(pcc, returnCode);
            }
            Pcc pcc3 = pcc;
            return pcc3;
        }
        catch (ErrorLimitReachedException ex) {
            throw new ErrorInCompilationException(pcc, -1);
        }
        finally {
            if (pp != null) {
                pp.closeSource();
                pp.closeListing();
            }
            ol.restoreProperties();
            Thread.currentThread().setName(origName);
        }
    }

    public Pcc(String name, String srcDir, String dir, TokenManager t, OptionList ol, Errors err, Phases phases) {
        this.snFuncNames.put("C01", "C01");
        this.snFuncNames.put("C02", "C02");
        this.snFuncNames.put("C03", "C03");
        this.snFuncNames.put("C04", "C04");
        this.snFuncNames.put("C05", "C05");
        this.snFuncNames.put("C06", "C06");
        this.snFuncNames.put("C07", "C07");
        this.snFuncNames.put("C08", "C08");
        this.snFuncNames.put("C09", "C09");
        this.snFuncNames.put("C10", "C10");
        this.snFuncNames.put("C11", "C11");
        this.snFuncNames.put("C12", "C12");
        this.snFuncNames.put("CSP", "CSP");
        this.snFuncNames.put("CSP", "CSP");
        this.snFuncNames.put("AFP-5A", "AFP-5A");
        this.subsEasyDB = "";
        this.easyDbNames = new Hashtable();
        this.easyDbNames.put("db2", "-d2");
        this.easyDbNames.put("db2_as400", "-db24");
        this.easyDbNames.put("generic", "");
        this.easyDbNames.put("informix", "-di");
        this.easyDbNames.put("oracle", "-do");
        this.easyDbNames.put("mysql", "-dm");
        this.easyDbNames.put("postgres", "-dp");
        this.easyDbNames.put("sqlserver", "-ds");
        this.easyDbPrefix = new Hashtable();
        this.easyDbPrefix.put("db2", "db2");
        this.easyDbPrefix.put("db2_as400", "d24");
        this.easyDbPrefix.put("generic", "gen");
        this.easyDbPrefix.put("informix", "ifx");
        this.easyDbPrefix.put("oracle", "ora");
        this.easyDbPrefix.put("mysql", "mys");
        this.easyDbPrefix.put("postgres", "pgs");
        this.easyDbPrefix.put("sqlserver", "srv");
        this.callStubs = new HashSet();
        this.sqljIteratorDeclaration = "";
        this.sqljResultSetDeclaration = "";
        this.sqljIterDecl = new Hashtable();
        this.screenVars = new LinkedHashMap<String, String>();
        this.screenNames = new HashSet();
        this.screenObjVars = new LinkedHashMap<String, String>();
        this.screenProcs = new LinkedHashMap<String, String>();
        this.sqlca = new SQLCA();
        this.outName = name;
        this.sourceDir = srcDir;
        this.outDir = dir;
        this.tm = t;
        this.options = ol;
        this.assumeFirstOcc = ol.getOption("-cm") != null || ol.getOption("-cv") != null;
        this.error = err;
        this.phases = phases;
        this.loadConstants();
        try {
            this.tm.getToken();
            this.tm.ungetToken();
        }
        catch (EndOfProgramException endOfProgramException) {
        }
        catch (GeneralErrorException generalErrorException) {
            // empty catch block
        }
        if (this.options.getOption("-xms") == null && this.options.getOption("-cp") == null) {
            TYPES_PACKAGE = "com.iscobol.types";
            this.RTS_IMPORTS = new String[]{"com.iscobol.rts.*"};
        } else {
            TYPES_PACKAGE = "com.iscobol.types_n";
            this.RTS_IMPORTS = new String[]{"com.iscobol.rts.AcceptException", "com.iscobol.rts.CallOverflowException", "com.iscobol.rts.CobValue", "com.iscobol.rts.DisplayException", "com.iscobol.rts.ExprUtil", "com.iscobol.rts.GotoException", "com.iscobol.rts.ICobolVar", "com.iscobol.rts.Memory", "com.iscobol.rts.Monitor", "com.iscobol.rts.StopRunException", "com.iscobol.rts.ThreadException", "com.iscobol.rts_n.*", "com.iscobol.types.CobolNum"};
            if (this.options.getOption("-cp") != null) {
                this.options.addOption("-xms");
                this.options.addOption("-xmsn");
            }
        }
    }

    private Pcc() {
        this.snFuncNames.put("C01", "C01");
        this.snFuncNames.put("C02", "C02");
        this.snFuncNames.put("C03", "C03");
        this.snFuncNames.put("C04", "C04");
        this.snFuncNames.put("C05", "C05");
        this.snFuncNames.put("C06", "C06");
        this.snFuncNames.put("C07", "C07");
        this.snFuncNames.put("C08", "C08");
        this.snFuncNames.put("C09", "C09");
        this.snFuncNames.put("C10", "C10");
        this.snFuncNames.put("C11", "C11");
        this.snFuncNames.put("C12", "C12");
        this.snFuncNames.put("CSP", "CSP");
        this.snFuncNames.put("CSP", "CSP");
        this.snFuncNames.put("AFP-5A", "AFP-5A");
        this.subsEasyDB = "";
        this.easyDbNames = new Hashtable();
        this.easyDbNames.put("db2", "-d2");
        this.easyDbNames.put("db2_as400", "-db24");
        this.easyDbNames.put("generic", "");
        this.easyDbNames.put("informix", "-di");
        this.easyDbNames.put("oracle", "-do");
        this.easyDbNames.put("mysql", "-dm");
        this.easyDbNames.put("postgres", "-dp");
        this.easyDbNames.put("sqlserver", "-ds");
        this.easyDbPrefix = new Hashtable();
        this.easyDbPrefix.put("db2", "db2");
        this.easyDbPrefix.put("db2_as400", "d24");
        this.easyDbPrefix.put("generic", "gen");
        this.easyDbPrefix.put("informix", "ifx");
        this.easyDbPrefix.put("oracle", "ora");
        this.easyDbPrefix.put("mysql", "mys");
        this.easyDbPrefix.put("postgres", "pgs");
        this.easyDbPrefix.put("sqlserver", "srv");
        this.callStubs = new HashSet();
        this.sqljIteratorDeclaration = "";
        this.sqljResultSetDeclaration = "";
        this.sqljIterDecl = new Hashtable();
        this.screenVars = new LinkedHashMap<String, String>();
        this.screenNames = new HashSet();
        this.screenObjVars = new LinkedHashMap<String, String>();
        this.screenProcs = new LinkedHashMap<String, String>();
        this.sqlca = new SQLCA();
        this.phases = null;
    }

    protected Pcc(Pcc p) {
        this(p.outName, p.sourceDir, p.outDir, p.tm, p.options, p.error, p.getPhases());
        this.externalExecs = p.externalExecs;
        this.externalExecMacros = p.externalExecMacros;
        this.externalExecLines = p.externalExecLines;
    }

    public static String[] getVersionCode(boolean debug) {
        String version = "";
        int i = Version.getRelease().indexOf(35);
        if (i > 0) {
            while (++i < Version.getRelease().length() && Character.isDigit(Version.getRelease().charAt(i))) {
                version = version + Version.getRelease().charAt(i);
            }
        }
        if (version.length() == 0) {
            version = "0";
        }
        ArrayList<String> al = new ArrayList<String>(12);
        al.add("/** Added by isCOBOL compiler. */");
        al.add("   public int iscobolVersion () {");
        al.add("      return " + version + ";");
        al.add("   }");
        al.add("/** Added by isCOBOL compiler. */");
        al.add("   public int iscobolRequired () {");
        al.add("      return " + Version.getRequiredVersion() + ";");
        al.add("   }");
        String[] Return2 = new String[al.size()];
        al.toArray(Return2);
        return Return2;
    }

    protected void compFlagsCheck(PrintWriter progFile) {
        if (this.optionMS) {
            progFile.println("   private static final NumConst Num = NumConst.getInstance(" + (this.tm.getDecimalPoint() == ',') + ");");
            progFile.println("   private static final StrConst Str = StrConst.getInstance();");
        }
        if (this.options.getOption("-sddp") != null) {
            progFile.println("/** Added by isCOBOL compiler. */");
            if (!this.getSplitFlag()) {
                progFile.println("   public static final boolean $isDPC$ = Factory.isDPC();");
            }
        }
        if (this.options.getOption("-sdcs") != null) {
            progFile.println("/** Added by isCOBOL compiler. */");
            if (!this.getSplitFlag()) {
                progFile.println("   public static final char $CurrencySign$ = Factory.getCS();");
            }
        }
        if (!this.optionMS || Config.getProperty("iscobol.compiler.jjms.gen_comp_flags", false)) {
            progFile.println("/** Added by isCOBOL compiler. */");
            progFile.println("   public static final String $comp_flags$[] = {");
            progFile.print("      \"" + this.getClassName() + "\"");
            Enumeration en = this.options.getAllKeys();
            while (en.hasMoreElements()) {
                String opt = (String)en.nextElement();
                String val = this.options.getOption(opt);
                if (val != null) {
                    int k = 0;
                    while ((k = val.indexOf(34, k)) >= 0) {
                        val = val.substring(0, k) + '\\' + val.substring(k, val.length());
                        ++k;
                        ++k;
                    }
                    k = 0;
                    while ((k = val.indexOf(92, k)) >= 0) {
                        val = val.substring(0, k) + '\\' + val.substring(k, val.length());
                        ++k;
                        ++k;
                    }
                    opt = opt + val;
                }
                progFile.println(",");
                progFile.print("      \"" + opt + "\"");
            }
            progFile.println(" };");
            if (this.getOption("-sysc") == null) {
                progFile.println("   static {");
                progFile.println("      try {");
                progFile.println("         Factory.checkCompileFlags($comp_flags$);");
                progFile.println("      } catch (NoSuchMethodError e) {}");
                progFile.println("   }");
            }
        }
    }

    protected void writeAlterTargets(PrintWriter progFile) {
        if (this.variableTargetGoto != null) {
            progFile.println("/** Added by isCOBOL compiler. */");
            for (int ii = this.variableTargetGoto.size() - 1; ii >= 0; --ii) {
                Goto go = (Goto)this.variableTargetGoto.get(ii);
                String alterVarName = go.getAlterVarName();
                if (this.isFactory()) {
                    progFile.print("   private static");
                } else {
                    progFile.print("   private");
                }
                progFile.print(" int " + alterVarName);
                if (go.getToNums() != null) {
                    progFile.println(" = " + go.getToNums()[0] + ";");
                    continue;
                }
                progFile.println(";");
            }
        }
    }

    private static Hashtable checkExec(OptionList ol) throws Exception {
        Hashtable<String, ExecHandlerIntf> Return2;
        String execs = ol.getOption("-exec=");
        if (execs != null) {
            Return2 = new Hashtable<String, ExecHandlerIntf>();
            StringTokenizer st = new StringTokenizer(execs, ",");
            while (st.hasMoreTokens()) {
                Object obj;
                execs = st.nextToken();
                String clazz = Pcc.class.getPackage().getName() + "." + execs + ".ExecHandler";
                try {
                    Class<?> c = Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
                    obj = c.newInstance();
                }
                catch (Throwable ex) {
                    throw new Exception("exec=" + execs + "(" + ex + ")");
                }
                if (obj instanceof ExecHandlerIntf) {
                    ExecHandlerIntf eh = (ExecHandlerIntf)obj;
                    Return2.put(execs, eh);
                    continue;
                }
                throw new Exception("exec=" + execs + " (invalid class " + clazz + ")");
            }
        } else {
            Return2 = null;
        }
        return Return2;
    }

    private boolean initExec(Hashtable extExecs, boolean generateCode) {
        boolean Return2 = generateCode;
        if (extExecs != null) {
            this.externalExecMacros = new HashSet();
            this.externalExecs = extExecs;
            Enumeration it = this.externalExecs.elements();
            while (it.hasMoreElements()) {
                ExecHandlerIntf eh = (ExecHandlerIntf)it.nextElement();
                Return2 = eh.init(this, this.tm, generateCode);
                this.externalExecMacros.addAll(eh.getAllMacros());
            }
        }
        return Return2;
    }

    public ExecHandlerIntf getExecHandler(String exec) {
        if (this.externalExecs != null) {
            return (ExecHandlerIntf)this.externalExecs.get(exec);
        }
        return null;
    }

    boolean isExecMacro(Token t) {
        if (this.externalExecMacros != null) {
            return this.externalExecMacros.contains(t.getWord());
        }
        return false;
    }

    String getExecMacro(Token t, TokenManager tm) throws EndOfProgramException, MalformedDataNameException, GeneralErrorException {
        String Return2;
        block1: {
            ExecHandlerIntf eh;
            Return2 = null;
            if (this.externalExecs == null) break block1;
            Enumeration it = this.externalExecs.elements();
            while (it.hasMoreElements() && (Return2 = (eh = (ExecHandlerIntf)it.nextElement()).getMacro(t, tm, this.error)) == null) {
            }
        }
        return Return2;
    }

    public LinkedList getExternalExecLines() {
        return this.externalExecLines;
    }

    boolean getSplitFlag() {
        return this.options.getOption("-big") != null && !this.optionMS && !this.isDefault();
    }

    public boolean isDefault() {
        return false;
    }

    boolean start() {
        return this.start(true);
    }

    boolean start(boolean generateCode) {
        return this.start(generateCode, null);
    }

    boolean start(boolean generateCode, PreProcessor pp) {
        boolean Return2;
        block76: {
            Return2 = true;
            try {
                Token tk = this.tm.getToken();
                if (this.options.getOption("-sqlj") != null && this.options.getOption("-jc") != null) {
                    this.error.print(116, 4, 0, 0, "-sqlj -jc", null, this.tm.getFileName());
                    return false;
                }
                if ("html".equalsIgnoreCase(this.getOption("-exec="))) {
                    Pcc.checkEIS(new Token(10001, "-exec=html", 1, 0, tk.getFileName()), this.error, false);
                }
                if (this.getOption("-wd2") != null || this.getOption("-whttp") != null) {
                    Pcc.checkEIS(new Token(10001, "-wd2", 1, 0, tk.getFileName()), this.error, true);
                }
                try {
                    if (tk.getToknum() == 522 || tk.getToknum() == 521) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 410) {
                            throw new UnexpectedTokenException(tk, this.error);
                        }
                        if (this.tm.getToken().getToknum() != 10006) {
                            this.error.print(188, 3, tk, "'.'");
                            this.tm.ungetToken();
                        }
                    } else {
                        this.tm.ungetToken();
                    }
                    this.gIdentification = new IdentificationDivision(this, this.tm, this.error);
                    if (this.gIdentification.getClassId() != null) {
                        this.className = this.gIdentification.getClassName();
                    }
                }
                catch (GeneralErrorException e) {
                    Return2 = false;
                    this.tm.skipTill(new int[]{458, 388, 705, 651});
                }
                this.referencedPccs.put(this.getFullClassName(), this);
                boolean end = false;
                try {
                    tk = this.tm.getToken();
                }
                catch (EndOfProgramException ex) {
                    if (this.gIdentification != null && this.gIdentification.getClassId() != null) {
                        end = true;
                    }
                    throw ex;
                }
                if (!end) {
                    try {
                        if (tk.getToknum() == 458) {
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 410) {
                                throw new UnexpectedTokenException(tk, this.error);
                            }
                            if (this.tm.getToken().getToknum() != 10006) {
                                this.error.print(188, 3, tk, "'.'");
                                this.tm.ungetToken();
                            }
                        } else {
                            this.tm.ungetToken();
                        }
                        this.gEnvironment = new EnvironmentDivision(this, this.tm, this.error, tk);
                    }
                    catch (GeneralErrorException e) {
                        Return2 = false;
                        this.tm.skipTill(new int[]{388, 705, 651});
                    }
                }
                if (this.gIdentification != null && !(this.gIdentification.getProgramId() != null ^ this.gIdentification.getClassId() != null)) {
                    this.error.print(86, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
                    return false;
                }
                try {
                    if (this.gIdentification != null) {
                        this.gIdentification.doCheck();
                    }
                }
                catch (GeneralErrorException e) {
                    Return2 = false;
                }
                if (this.gIdentification != null && this.gIdentification.getClassId() != null) {
                    ArrayList<DataDivision> data;
                    this.className = this.gIdentification.getClassName();
                    if (this.options.getOption("-pt0") != null || this.options.getOption("-pt2") != null) {
                        this.error.print(116, 4, 0, 0, "-pt0/-pt2 used for OO programs", null, this.tm.getFileName());
                        return false;
                    }
                    TokenManager.Marker mk = this.tm.getMarker();
                    Hashtable constVars = this.tm.pp.getConstVarsClone();
                    this.tm.setMarker(mk);
                    FindAllMethods fam = new FindAllMethods(this);
                    this.tm.pp.setConstVars(constVars);
                    this.tm.rewindToMarker(mk);
                    this.myMethods = fam.getMyMethods();
                    this.myFields = fam.getMyFields();
                    if (this.findingMethods) {
                        return true;
                    }
                    this.factoryPart = new CobolClass(this, null);
                    Return2 = this.factoryPart.start();
                    if (Return2) {
                        if (this.factoryPart.isFactory()) {
                            try {
                                tk = this.tm.getToken();
                            }
                            catch (EndOfProgramException e) {
                                tk = null;
                            }
                            if (tk != null) {
                                if (tk != null && tk.getToknum() == 522 || tk.getToknum() == 521) {
                                    this.tm.ungetToken();
                                    this.objectPart = new CobolClass(this, this.factoryPart);
                                    Return2 = this.objectPart.start();
                                } else {
                                    this.endClass(tk);
                                }
                            }
                        } else {
                            this.objectPart = this.factoryPart;
                            this.factoryPart = null;
                            try {
                                tk = this.tm.getToken();
                            }
                            catch (EndOfProgramException e) {
                                tk = null;
                            }
                            if (tk != null) {
                                if (tk.getToknum() == 522 || tk.getToknum() == 521) {
                                    this.tm.ungetToken();
                                    this.factoryPart = new CobolClass(this, this.factoryPart);
                                    Return2 = this.factoryPart.start();
                                    if (Return2 && !this.factoryPart.isFactory()) {
                                        this.error.print(92, 4, tk, "OBJECT");
                                    }
                                } else {
                                    this.endClass(tk);
                                }
                            }
                        }
                    }
                    if (Return2) {
                        try {
                            this.doCheck();
                        }
                        catch (GeneralErrorException e) {
                            Return2 = false;
                        }
                        try {
                            MyClass c = this.existsClass(this.className);
                            this.gIdentification.checkInterface(c.getMethods(false));
                        }
                        catch (ClassNotFoundException c) {
                        }
                        catch (GeneralErrorException c) {
                            // empty catch block
                        }
                        if (Return2 && generateCode) {
                            this.fileName = this.outName;
                            int i = this.fileName.lastIndexOf(46);
                            if (i > 0) {
                                this.fileName = this.fileName.substring(0, i);
                            } else if (i == 0) {
                                throw new GeneralErrorException(38, 4, 0, 0, this.fileName, this.tm.getFileName(), null, this.error);
                            }
                            this.fileName = this.fileName.replace('-', '_');
                            this.checkClassName(this.fileName);
                            if (!this.error.printEndMessage()) {
                                try {
                                    this.doCode();
                                }
                                catch (GeneralErrorException e) {
                                    return false;
                                }
                            } else {
                                Return2 = false;
                            }
                        } else {
                            this.error.printEndMessage();
                        }
                    } else {
                        this.error.printEndMessage();
                    }
                    if (this.getOption("-ld") != null && pp != null && pp.lst != null) {
                        ArrayList<String> names = new ArrayList<String>();
                        data = new ArrayList();
                        if (this.factoryPart != null) {
                            names.add("FACTORY.");
                            data.add(this.factoryPart.getDataDivision());
                            for (CobolMethod cm : this.factoryPart.getAllMethods()) {
                                names.add("METHOD '" + cm.getMethodDesc() + "'.");
                                data.add(cm.getDataDivision());
                            }
                        }
                        if (this.objectPart != null) {
                            names.add("OBJECT.");
                            data.add(this.objectPart.getDataDivision());
                            for (CobolMethod cm : this.objectPart.getAllMethods()) {
                                names.add("METHOD '" + cm.getMethodDesc() + "'.");
                                data.add(cm.getDataDivision());
                            }
                        }
                        pp.writeDataMap(names.toArray(new String[names.size()]), data.toArray(new DataDivision[data.size()]));
                    }
                    if (this.edmFile != null) {
                        ArrayList<String> names = new ArrayList<String>();
                        data = new ArrayList<DataDivision>();
                        if (this.factoryPart != null) {
                            names.add("factory");
                            data.add(this.factoryPart.getDataDivision());
                            for (CobolMethod cm : this.factoryPart.getAllMethods()) {
                                names.add("method " + cm.getMethodDesc());
                                data.add(cm.getDataDivision());
                            }
                        }
                        if (this.objectPart != null) {
                            names.add("object");
                            data.add(this.objectPart.getDataDivision());
                            for (CobolMethod cm : this.objectPart.getAllMethods()) {
                                names.add("method " + cm.getMethodDesc());
                                data.add(cm.getDataDivision());
                            }
                        }
                        this.writeExtDataMap(names.toArray(new String[names.size()]), data.toArray(new DataDivision[data.size()]));
                    }
                    break block76;
                }
                this.theProgram = new CobolProgram(this, this.gIdentification, this.gEnvironment);
                this.theProgram.referencedPccs = this.referencedPccs;
                Return2 = this.theProgram.start(generateCode);
                if (this.getOption("-ld") != null && pp != null && pp.lst != null) {
                    pp.writeDataMap(new String[1], new DataDivision[]{this.theProgram.getDataDivision()});
                }
                if (this.edmFile != null) {
                    String[] names = new String[]{"program"};
                    DataDivision[] data = new DataDivision[]{this.theProgram.getDataDivision()};
                    this.writeExtDataMap(names, data);
                }
            }
            catch (EndOfProgramException e) {
                this.error.print(12, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
                return false;
            }
            catch (GeneralErrorException e) {
                this.error.printEndMessage();
                return false;
            }
            catch (StackOverflowError e) {
                try {
                    this.tm.ungetToken();
                    Token tk = this.tm.getToken();
                    this.error.print(166, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, tk.getFileName());
                }
                catch (EndOfProgramException ex) {
                    this.error.print(166, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
                }
                catch (GeneralErrorException ex) {
                    this.error.print(166, 4, this.tm.getLineNumber(), 0, null, null, this.tm.getFileName());
                }
                this.error.printEndMessage();
                return false;
            }
        }
        return Return2;
    }

    private final void writeExtDataMap(String[] names, DataDivision[] data) {
        try {
            DocumentBuilderFactory docFact = RtsUtil.newDocumentBuilderFactory();
            DocumentBuilder docBuilder = docFact.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element elem = null;
            Element classElem = null;
            Element partElem = null;
            for (int i = 0; i < names.length; ++i) {
                if ("program".equals(names[i])) {
                    elem = doc.createElement("program");
                    elem.setAttribute("name", this.getClassName());
                    doc.appendChild(elem);
                } else if ("factory".equals(names[i])) {
                    classElem = doc.createElement("class");
                    classElem.setAttribute("name", this.getClassName());
                    doc.appendChild(classElem);
                    partElem = elem = doc.createElement("factory");
                    classElem.appendChild(elem);
                } else if ("object".equals(names[i])) {
                    partElem = elem = doc.createElement("object");
                    if (classElem == null) {
                        classElem = doc.createElement("class");
                        classElem.setAttribute("name", this.getClassName());
                        doc.appendChild(classElem);
                    }
                    classElem.appendChild(elem);
                } else if (names[i].startsWith("method ")) {
                    elem = doc.createElement("method");
                    elem.setAttribute("description", names[i].substring(7));
                    partElem.appendChild(elem);
                }
                data[i].writeExtDataMap(elem);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(this.edmFile);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void endClass(Token tk) throws GeneralErrorException {
        boolean ok = false;
        if (tk != null && tk.getToknum() == 422) {
            try {
                tk = this.tm.getToken();
            }
            catch (EndOfProgramException e) {
                tk = null;
            }
            boolean isIntf = this.gIdentification.isInterface();
            boolean bl = ok = tk != null && (tk.getToknum() == 325 && !isIntf || tk.getToknum() == 540 && isIntf);
        }
        if (!ok) {
            throw new ExpectedFoundException(tk, this.error, "IDENTIFICATION DIVISION");
        }
    }

    private void doCheck() throws GeneralErrorException {
        this.getOutddProperty(true);
        if (this.theProgram != null) {
            this.theProgram.doCheck();
        }
        if (this.factoryPart != null) {
            this.factoryPart.doCheck();
        }
        if (this.objectPart != null) {
            this.objectPart.doCheck();
        }
    }

    protected void checkClassName(String fName) throws GeneralErrorException {
        char[] name = fName.toCharArray();
        for (int i = 0; i < name.length; ++i) {
            if (Character.isJavaIdentifierPart(name[i])) continue;
            throw new GeneralErrorException(38, 4, 0, 0, fName, this.tm.getFileName(), null, this.error);
        }
    }

    public void doCodeForClass() throws GeneralErrorException {
        boolean debug;
        PrintWriter progFile;
        this.path = this.outDir;
        int i = this.className.lastIndexOf(46);
        if (i > 0) {
            this.packageName = this.className.substring(0, i);
            this.className = this.className.substring(i + 1, this.className.length());
        }
        if (!this.className.equals(this.fileName)) {
            this.error.print(this.isInterface() ? 282 : 281, 2, this.gIdentification.getClassId(), this.className);
        }
        try {
            this.progName = this.getOption("-sqlj") != null ? this.path + this.className + ".sqlj" : this.path + this.className + ".java";
            progFile = PreProcessor.newPrintWriter(this.progName);
        }
        catch (IOException ex) {
            throw new GeneralErrorException(39, 4, 0, 0, this.className, this.tm.getFileName(), ex, this.error);
        }
        this.commonHeader(progFile);
        progFile.println(this.gIdentification.getDoc());
        progFile.print(this.tm.getCommentCode(this.gIdentification.getClassId(), ""));
        boolean isIntf = this.gIdentification.isInterface();
        boolean bl = debug = this.getOption("-d") != null;
        if (isIntf) {
            progFile.print("public interface " + this.getClassName());
            if (this.gIdentification.getImplements() != null) {
                progFile.print(" extends " + this.gIdentification.getImplements());
            }
            progFile.println(" {");
        } else {
            progFile.print("public class " + this.getClassName() + " ");
            if (this.getInheritsClass() != null) {
                progFile.print("extends " + this.getInheritsClass() + " ");
            }
            progFile.print("implements com.iscobol.rts.IscobolClass");
            if (this.gIdentification.getImplements() != null) {
                progFile.print("," + this.gIdentification.getImplements());
            }
            if (debug) {
                progFile.print(",IscobolDebugger");
            }
            if (this.getOption("-dx") != null) {
                progFile.print(",IscobolDebuggerExtension");
            }
            progFile.println(" {");
            String[] v = Pcc.getVersionCode(debug);
            for (int ii = 0; ii < v.length; ++ii) {
                progFile.println(v[ii]);
            }
            this.compFlagsCheck(progFile);
            if (this.getHasSort() && this.getOption("-cv") != null) {
                progFile.println("/** Added by isCOBOL compiler. */");
                progFile.println("   private static class SortAbort extends RuntimeException {}");
            }
            if (this.factoryPart != null && this.factoryPart.generateObjectIds) {
                progFile.println(ST_OBJECT_IDS_DECL);
            }
            if (this.objectPart != null && this.objectPart.generateObjectIds) {
                progFile.println(OBJECT_IDS_DECL);
            }
            if (!this.userDefinedFinalize) {
                progFile.println("/** Added by isCOBOL compiler. */");
                Pcc.declareFinalize(progFile, "   ");
                progFile.println(this.getFinalizeCode(this.finalizeCode));
                progFile.println("   }");
            }
            if (this.getOption("-ccmf") != null) {
                progFile.print(Pcc.getCallBridgeMethodsCode());
            }
        }
        this.writeResources(progFile, true);
        String allLit = this.tm.declareAllLiterals(true);
        if (allLit.length() > 0) {
            progFile.println(allLit);
        }
        if (this.factoryPart != null) {
            this.factoryPart.doCode(progFile);
        }
        if (this.objectPart != null) {
            this.objectPart.doCode(progFile);
        }
        if (isIntf) {
            this.writeLiterals(progFile, true);
        } else {
            if (this.getSplitFlag()) {
                if (this.options.getOption("-sddp") != null) {
                    progFile.println("   public static final boolean $isDPC$ = Factory.isDPC();");
                }
                if (this.options.getOption("-sdcs") != null) {
                    progFile.println("   public static final char $CurrencySign$ = Factory.getCS();");
                }
            }
            this.writeLiterals(progFile, true);
            if (this.factoryPart != null) {
                this.factoryPart.writeLiterals(progFile, true);
            }
            if (this.factoryPart != null) {
                this.factoryPart.doCodeUnnamed(progFile);
            }
            if (this.objectPart != null) {
                this.objectPart.doCodeUnnamed(progFile);
            }
        }
        this.writeTrailer(progFile);
        progFile.close();
    }

    private void doCode() throws GeneralErrorException {
        if (this.theProgram != null) {
            this.getPhases().generateSourceCode(this.theProgram);
        } else {
            this.getPhases().generateSourceCode(this);
        }
    }

    public static int doExecute(String fullClassName) {
        try {
            Class<?> aClass = Class.forName(fullClassName);
            Method theMethod = aClass.getMethod("main", String[].class);
            theMethod.invoke(null, new Object[]{new String[0]});
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public Paragraph getDeclParagraph(String name, Paragraph p) {
        return this.getParagraph(name, p, true);
    }

    public Paragraph getParagraph(String name, Paragraph p) {
        return this.getParagraph(name, p, false);
    }

    public Paragraph getParagraph(String name, String section, boolean declarat) {
        if (this.procedure != null) {
            return this.procedure.getParagraph(name, section, declarat);
        }
        return null;
    }

    public Paragraph getParagraphById(int id, boolean declarat) {
        if (this.procedure != null) {
            return this.procedure.getParagraphById(id, declarat);
        }
        return null;
    }

    public Paragraph getParagraph(String name, Paragraph p, boolean declarat) {
        if (this.procedure != null) {
            return this.procedure.getParagraph(name, p, declarat);
        }
        return null;
    }

    public boolean setEntryPoint(Entry en) {
        return this.entryPoints.add(en);
    }

    public void setCall(Token tk) {
        this.calls.put(tk.getWord().toUpperCase(), tk);
    }

    public boolean existsCall(Token tk) {
        return this.calls.containsKey(tk.getWord().toUpperCase());
    }

    void addBlock(Block b) {
        this.allBlocks.addItem(b);
        this.blocks.push(b);
    }

    void popBlock() {
        this.blocks.pop();
    }

    Block getCurrentBlock() {
        return this.blocks.peek();
    }

    public void addLine(StatementDesc l) {
        this.statementLines.addElement(l);
    }

    public void addParagraph(ParagraphDesc p) {
        this.paragraphNames.addElement(p);
    }

    public void addVariableTargetGoto(Goto g) {
        if (this.variableTargetGoto == null) {
            this.variableTargetGoto = new Vector();
        }
        this.variableTargetGoto.add(g);
    }

    public Map<String, VariableDeclarationList> getAllVariables() {
        return this.allVariables;
    }

    @Override
    public Map<String, VariableDeclaration> getTypedefVariables() {
        return this.typedefVariables;
    }

    void putTypedefVar(String name, VariableDeclaration vd) {
        this.typedefVariables.put(name, vd);
    }

    VariableDeclaration getTypedefVar(String name) {
        return this.typedefVariables.get(name);
    }

    final VariableDeclaration getAny(VariableName vn, boolean checkDimensions) throws GeneralErrorException {
        return this.getAny(vn, checkDimensions, false);
    }

    final VariableDeclaration getAny(VariableName vn, boolean checkDimensions, boolean checkUndefined) throws GeneralErrorException {
        return this.getAny(vn, checkDimensions, checkUndefined, null);
    }

    final VariableDeclaration getAny(VariableName vn, boolean checkDimensions, boolean checkUndefined, VariableDeclaration excGrp) throws GeneralErrorException {
        return this.getAny(vn, checkDimensions, checkUndefined, excGrp, false, GetVarOpts.NO_OPTS);
    }

    VariableDeclaration getAny(VariableName vn, boolean checkDimensions, boolean checkUndefined, VariableDeclaration excGrp, boolean onlyGlobal, GetVarOpts opts) throws GeneralErrorException {
        int vnd;
        SetGetProperty sgprop;
        VariableDeclaration Return2 = null;
        if (!this.localVariables.isEmpty() && (Return2 = this.localVariables.peek().get(vn.getName())) != null) {
            return Return2;
        }
        VariableDeclarationList entry = this.allVariables.get(vn.getName());
        if (entry == null) {
            SetGetProperty sgprop2;
            if (this.parent != null) {
                Return2 = this.parent.getAny(vn, checkDimensions, true, excGrp, false, opts);
            }
            if (Return2 == null && (this instanceof CobolMethod || this instanceof CobolProgram) && (sgprop2 = this.checkPropertyName(vn, this.getRoot().getRepository(), opts.propType)) != null) {
                Return2 = new InlineSetGetProperty(sgprop2, opts.v, this, vn.getNameToken(), this.tm);
            }
            if (Return2 != null) {
                return Return2;
            }
            if (checkUndefined) {
                return null;
            }
            throw new UndefinedException(vn.getNameToken(), this.error, vn.getName());
        }
        int cnt = 0;
        VariableDeclaration vd = entry.getFirst();
        while (vd != null) {
            if (!(vd.level <= 0 || !vd.isVar(vn) || onlyGlobal && !vd.isGlobal() || excGrp != null && excGrp.getParentRoot() == vd.getParentRoot())) {
                Return2 = vd;
                ++cnt;
            }
            vd = entry.getNext();
        }
        if (cnt > 1) {
            throw new AmbiguousException(vn.getNameToken(), this.error, vn.getName());
        }
        if (Return2 == null && this.parent != null) {
            Return2 = this.parent.getAny(vn, checkDimensions, true, excGrp, false, opts);
        }
        if (Return2 == null && (this instanceof CobolMethod || this instanceof CobolProgram) && (sgprop = this.checkPropertyName(vn, this.getRoot().getRepository(), opts.propType)) != null) {
            Return2 = new InlineSetGetProperty(sgprop, opts.v, this, vn.getNameToken(), this.tm);
        }
        if (Return2 != null && checkDimensions && !vn.isRecordPosition() && !Return2.checkDimension(vnd = vn.getDimension())) {
            int d;
            if (this.assumeFirstOcc && !Return2.isObjectReference() && (d = Return2.dimension + Return2.getDyDimension() - vnd) > 0) {
                SubscriptList sl = vn.getIndexes();
                if (sl == null) {
                    sl = new SubscriptList();
                }
                for (int i = 0; i < d; ++i) {
                    sl.addItem(Subscript.get("1"));
                }
                vn.setIndexes(sl);
                this.error.print(299, 3, vn.getNameToken(), vn.getNameToken().getWord());
            } else {
                throw new GeneralErrorException(41, 4, vn.getNameToken(), vn.getNameToken().getWord(), this.error);
            }
        }
        if (Return2 != null) {
            Return2.incrCounter();
        }
        return Return2;
    }

    private SetGetProperty checkPropertyName(VariableName vn, Repository rep, int propType) throws GeneralErrorException {
        SetGetProperty Return2;
        VariableName of;
        if (rep != null && (of = vn.getOf()) != null) {
            SetGetProperty prev;
            VariableDeclarationList allProps = rep.getAllProperties();
            VariableDeclaration prop = null;
            VariableDeclaration vd = allProps.getFirst();
            while (vd != null) {
                if (vd.getName().equals(vn.getName())) {
                    prop = vd;
                    break;
                }
                vd = allProps.getNext();
            }
            String propName = prop != null ? prop.getClassName() : vn.getName();
            propName = propName.replace('-', '_').toUpperCase();
            Return2 = of.getOf() != null ? ((prev = this.checkPropertyName(of, rep, 0)) != null ? this.getProperty(of, prev, propName, propType) : null) : this.getProperty(of, null, propName, propType);
        } else {
            Return2 = null;
        }
        return Return2;
    }

    private SetGetProperty getProperty(VariableName of, SetGetProperty prev, String propName, int propType) throws GeneralErrorException {
        boolean isFactory;
        MyClass className;
        MyClass objType = null;
        if (prev != null) {
            className = prev.getType();
            isFactory = false;
        } else {
            Pcc intClass;
            Pcc pcc = intClass = this instanceof CobolMethod ? this.parent.parent : this;
            if (of.getName().equals("SELF")) {
                isFactory = false;
                className = objType = MyClass.getInstance(intClass, 0);
                of.isSelf = true;
            } else if (of.getName().equals("SUPER")) {
                isFactory = false;
                objType = MyClass.getInstance(intClass, 0);
                className = objType.getSuperclass();
                of.isSuper = true;
            } else {
                VariableDeclaration obj = this.getAny(of, false, true, null, false, GetVarOpts.NO_OPTS);
                if (obj != null && obj.getClassName() != null) {
                    try {
                        className = obj.getType();
                    }
                    catch (ClassNotFoundException e) {
                        throw new MissingClassException(obj.getTypeName(), of.getNameToken(), this.error);
                    }
                    isFactory = obj.isFactory();
                    of.varDecl = obj;
                    obj.setUsed();
                } else {
                    return null;
                }
            }
        }
        if (className != null) {
            try {
                MyField field = null;
                try {
                    field = className.getField(propName, false);
                }
                catch (Exception obj) {
                    // empty catch block
                }
                if (field != null && (Modifier.isStatic(field.getModifiers()) || !isFactory)) {
                    return new SetGetProperty(of, objType, field.getType(), propName, propType, true, prev);
                }
                SetGetProperty getProp = null;
                SetGetProperty setProp = null;
                if (propType == 0 || propType == 2) {
                    String getpropName = "get" + propName;
                    for (MyMethod m : className.getMethods(false)) {
                        if (!m.getName().equals(getpropName) || !Modifier.isStatic(m.getModifiers()) && isFactory || "void".equals(m.getReturnType().getName()) || m.getParameterTypes().length != 0) continue;
                        getProp = new SetGetProperty(of, objType, m.getReturnType(), propName, 0, false, prev);
                        break;
                    }
                }
                if (propType == 1 || propType == 2) {
                    String setpropName = "set" + propName;
                    for (MyMethod m : className.getMethods(false)) {
                        if (!m.getName().equals(setpropName) || !Modifier.isStatic(m.getModifiers()) && isFactory || !"void".equals(m.getReturnType().getName()) || m.getParameterTypes().length != 1) continue;
                        setProp = new SetGetProperty(of, objType, m.getParameterTypes()[0], propName, 1, false, prev);
                        break;
                    }
                }
                if (propType == 0) {
                    return getProp;
                }
                if (propType == 1) {
                    return setProp;
                }
                if (getProp != null && setProp != null) {
                    getProp.setPropType(propType);
                    return getProp;
                }
                if (getProp != null) {
                    return getProp;
                }
                return setProp;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getDecimalPointIsComma() {
        return this.tm.getDecimalPointIsComma();
    }

    void debugAllVars() {
        for (VariableDeclarationList entry : this.allVariables.values()) {
            VariableDeclaration v = entry.getFirst();
            while (v != null) {
                System.out.println(v.getUnivoqueName());
                v = entry.getNext();
            }
        }
    }

    public VariableDeclaration getVar(VariableName vn) throws GeneralErrorException {
        return this.getVar(vn, true);
    }

    public VariableDeclaration getVar(VariableName vn, boolean checkDimensions) throws GeneralErrorException {
        return this.getVar(vn, checkDimensions, null);
    }

    public VariableDeclaration getVar(VariableName vn, boolean checkDimensions, VariableDeclaration excGrp) throws GeneralErrorException {
        VariableDeclaration Return2 = this.getAny(vn, checkDimensions, false, excGrp);
        if (Return2 != null && Return2.isObjectReference()) {
            throw new GeneralErrorException(75, 4, vn.getNameToken(), vn.getNameToken().getWord(), this.error);
        }
        return Return2;
    }

    private void loadConstants() {
        Properties p = Config.getAllProperties();
        String propStart = Config.getPrefix() + "compiler.const.";
        int propStartLen = propStart.length();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            if (!k.startsWith(propStart) || k.length() <= propStartLen) continue;
            String v = (String)p.get(k);
            k = k.substring(propStartLen).toUpperCase(Locale.US).replace('_', '-');
            VariableDeclaration vd = VariableDeclaration.getConstant(this, this.tm, k, v);
            this.tm.addConstant(vd);
        }
    }

    public void loadProgVariable(VariableDeclaration v) {
        if (this.parent != null) {
            this.parent.loadProgVariable(v);
        } else {
            this.loadVariable(v);
        }
    }

    public void loadVariable(VariableDeclaration v) {
        VariableNameList indexes;
        VariableDeclarationList children;
        if (v.isTypedef()) {
            return;
        }
        String key = v.getName();
        if (key != null) {
            VariableDeclarationList entry = this.allVariables.get(key);
            if (entry == null) {
                entry = new VariableDeclarationList();
                entry.addItem(v);
                this.allVariables.put(key, entry);
            } else {
                if (!v.isFiller() && this.optionMS) {
                    int fidx = v.getNameToken().getFileIndex();
                    VariableDeclaration v0 = entry.getFirst();
                    while (v0 != null) {
                        if (v0.getNameToken().getFileIndex() == fidx) {
                            Vector allpp = this.getTokenManager().getAllPreProcessors();
                            PreProcessor pp = (PreProcessor)allpp.elementAt(fidx);
                            v.setProg(++pp.vardeclProg);
                            break;
                        }
                        v0 = entry.getNext();
                    }
                } else {
                    v.setProg(entry.getItemNum());
                }
                entry.addItem(v);
            }
        }
        if ((children = v.getChildren()) != null) {
            VariableDeclaration vd = children.getFirst();
            while (vd != null) {
                this.loadVariable(vd);
                vd = children.getNext();
            }
        }
        if ((indexes = v.getAllIndexes()) != null) {
            VariableName vn = indexes.getFirst();
            while (vn != null) {
                this.loadVariable(vn.getVarDecl());
                vn = indexes.getNext();
            }
        }
        if (v.getCapacity() != null) {
            this.loadVariable(v.getCapacity().getVarDecl());
        }
        this.hasObjectReferences |= v.isObjectReference();
    }

    public boolean hasObjectReferences() {
        return this.hasObjectReferences;
    }

    protected void checkPost() throws GeneralErrorException {
        for (VariableDeclarationList entry : this.allVariables.values()) {
            VariableDeclaration v = entry.getFirst();
            while (v != null) {
                v.checkPost(this);
                v = entry.getNext();
            }
        }
    }

    protected void checkUsed() {
        if (this.getOption("-wu") == null) {
            return;
        }
        for (VariableDeclarationList entry : this.allVariables.values()) {
            VariableDeclaration v = entry.getFirst();
            while (v != null) {
                v.checkUsed();
                v = entry.getNext();
            }
        }
    }

    public static String isValidMethodName(String s) {
        char[] Return2 = s.toCharArray();
        for (int i = 0; i < Return2.length; ++i) {
            switch (Return2[i]) {
                case '-': {
                    Return2[i] = hyphenRepl;
                }
            }
            if (!(i == 0 ? !Character.isJavaIdentifierStart(Return2[i]) : !Character.isJavaIdentifierPart(Return2[i]))) continue;
            return null;
        }
        return new String(Return2);
    }

    public static String isValidClassName(String s) {
        char[] Return2 = s.toCharArray();
        block5: for (int i = 0; i < Return2.length; ++i) {
            switch (Return2[i]) {
                case '.': {
                    continue block5;
                }
                case '[': {
                    while (i + 1 < Return2.length) {
                        if (Return2[i++] == '[' && Return2[i++] == ']') continue;
                        return null;
                    }
                    if (i == Return2.length) continue block5;
                    return null;
                }
                case '-': {
                    Return2[i] = hyphenRepl;
                }
                default: {
                    if (!(i == 0 ? !Character.isJavaIdentifierStart(Return2[i]) : !Character.isJavaIdentifierPart(Return2[i]))) continue block5;
                    return null;
                }
            }
        }
        return new String(Return2);
    }

    public boolean isCobolClass() {
        return this.gIdentification != null && this.gIdentification.getClassId() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isThisClass(String s) {
        int b = s.indexOf(91);
        if (b == 0) {
            for (b = 0; b < s.length() && s.charAt(b) == '['; ++b) {
            }
            if (s.charAt(b) != 'L') return false;
            s = s.substring(b + 1, s.length() - 1);
        } else if (b > 0) {
            int i = s.length() - 1;
            while (i > b) {
                if (s.charAt(i--) != ']') {
                    return false;
                }
                if (s.charAt(i--) == '[') continue;
                return false;
            }
            s = s.substring(0, b);
        }
        if (s == null) {
            return false;
        }
        boolean bl = s.equals(this.getFullClassName());
        return bl;
    }

    @Override
    public Errors getErrors() {
        return this.error;
    }

    @Override
    public Vector getCopyFilesNames() {
        return this.tm.getCopyFileNames();
    }

    private static int getDimensions(String s) {
        int b = s.indexOf(91);
        if (b == 0) {
            for (b = 0; b < s.length() && s.charAt(b) == '['; ++b) {
            }
            return b;
        }
        if (b > 0) {
            return (s.length() - b) / 2;
        }
        return 0;
    }

    public MyClass existsClass(String s) throws ClassNotFoundException {
        String className;
        if ("this".equals(s) || this.isThisClass(s)) {
            return MyClass.getInstance(this, Pcc.getDimensions(s));
        }
        if ("super".equals(s)) {
            return MyClass.getInstance(this, 0).getSuperclass();
        }
        if ("byte".equals(s)) {
            return MyClass.getInstance(Byte.TYPE);
        }
        if ("char".equals(s)) {
            return MyClass.getInstance(Character.TYPE);
        }
        if ("short".equals(s)) {
            return MyClass.getInstance(Short.TYPE);
        }
        if ("int".equals(s)) {
            return MyClass.getInstance(Integer.TYPE);
        }
        if ("long".equals(s)) {
            return MyClass.getInstance(Long.TYPE);
        }
        if ("float".equals(s)) {
            return MyClass.getInstance(Float.TYPE);
        }
        if ("double".equals(s)) {
            return MyClass.getInstance(Double.TYPE);
        }
        if ("boolean".equals(s)) {
            return MyClass.getInstance(Boolean.TYPE);
        }
        if ("void".equals(s)) {
            return MyClass.getInstance(Void.TYPE);
        }
        int braces = s.indexOf(91);
        int dim = 0;
        if (braces > 0) {
            className = s.substring(0, braces);
            int len = s.length();
            int i = braces;
            dim = 0;
            while (i < len) {
                if (s.charAt(i++) != '[' || s.charAt(i++) != ']') {
                    throw new ClassNotFoundException(s);
                }
                ++dim;
            }
            if (i != len) {
                throw new ClassNotFoundException(s);
            }
            className = "byte".equals(className) ? "B" : ("char".equals(className) ? "C" : ("short".equals(className) ? "S" : ("int".equals(className) ? "I" : ("long".equals(className) ? "J" : ("float".equals(className) ? "F" : ("double".equals(className) ? "D" : ("boolean".equals(className) ? "Z" : ("void".equals(className) ? "V" : "L" + className + ";"))))))));
            for (i = 0; i < dim; ++i) {
                className = "[" + className;
            }
        } else {
            className = s;
        }
        if (className.equals(this.getFullClassName())) {
            return MyClass.getInstance(this, 0);
        }
        return MyClass.getInstance(className, this);
    }

    @Override
    public IPcc[] getReferencedPccs() {
        ArrayList<Pcc> result = new ArrayList<Pcc>();
        for (Pcc pc : this.referencedPccs.values()) {
            if (pc == this || pc == CLASS_NOT_FOUND) continue;
            result.add(pc);
        }
        return result.toArray(new IPcc[result.size()]);
    }

    Pcc getReferencedPcc(String className) {
        if (this.getOption("-noarcc") != null) {
            return CLASS_NOT_FOUND;
        }
        Map<String, Pcc> refPccs = this.getRoot().referencedPccs;
        Pcc pcc = refPccs.get(className);
        if (pcc == null) {
            String ext = "";
            String fn = this.getSourceFileName();
            int idx = fn.lastIndexOf(46);
            if (idx >= 0 && idx < fn.length()) {
                ext = fn.substring(idx);
            }
            String classFileName = className.replace('.', '/') + ext;
            FileFinder ff = this.getFileFinder();
            File classFile = ff instanceof ClassFileFinder ? ((ClassFileFinder)((Object)ff)).findClassFile(classFileName) : ff.findFile(classFileName);
            if (classFile != null) {
                Errors errs = new Errors(this.options.getOption("-xmsgfmt="));
                OptionList newOl = (OptionList)this.options.clone();
                newOl.addOption("#ef");
                newOl.addOption("#eo=");
                newOl.addOption("#lf");
                newOl.addOption("#lo=");
                try {
                    pcc = Pcc.run(classFile.getPath(), this.outDir, newOl, this.phases, errs, null, false, ff, this.tm.pp.getReaderProvider(), refPccs, true, false);
                }
                catch (ErrorInCompilationException e) {
                    refPccs.put(className, pcc);
                }
            }
            if (pcc == null) {
                pcc = CLASS_NOT_FOUND;
                refPccs.put(className, pcc);
            }
        }
        return pcc;
    }

    public static String escapeString(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"' || chars[i] == '\\') {
                sbuf.append('\\');
            }
            sbuf.append(chars[i]);
        }
        return sbuf.toString();
    }

    public String getOption(String key) {
        return this.options.getOption(key);
    }

    public void addOption(String key) {
        this.options.addOption(key);
    }

    protected String getParaPrefix() {
        return "";
    }

    protected String getVarPrefix() {
        return "";
    }

    protected boolean isFactory() {
        return false;
    }

    public void setProgName(String s) {
        this.progName = s;
    }

    @Override
    public String getProgName() {
        return this.progName;
    }

    protected void setClassName(String s) {
        this.className = s;
    }

    @Override
    public CobolProgram getCobolProgram() {
        return this.theProgram;
    }

    @Override
    public CobolClass getFactoryPart() {
        return this.factoryPart;
    }

    @Override
    public CobolClass getObjectPart() {
        return this.objectPart;
    }

    @Override
    public ProcedureDivision getProcedureDivision() {
        return this.procedure;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public EnvironmentDivision getEnvironmentDivision() {
        return this.gEnvironment;
    }

    public boolean isDebuggingMode() {
        EnvironmentDivision e = this.getEnvironmentDivision();
        return e != null && e.confSec != null && e.confSec.isDebuggingMode();
    }

    public SelectList getSelectList() {
        throw new InternalErrorException("Pcc.getSelectList()");
    }

    public Select getSelect(String fileName) {
        throw new InternalErrorException("Pcc.getSelect(String fileName)");
    }

    public Select getLinageSelect(Token tk, Errors err) throws GeneralErrorException {
        throw new InternalErrorException("Pcc.getLinageSelect()");
    }

    public ReportDescriptor getReport(Token name) throws GeneralErrorException {
        if (this.data != null && this.data.repoSec != null) {
            return this.data.repoSec.getReport(name);
        }
        return null;
    }

    public ReportGroup getDetail(Token name) throws GeneralErrorException {
        if (this.data != null && this.data.repoSec != null) {
            return this.data.repoSec.getDetail(name);
        }
        return null;
    }

    public ReportGroup getReportGroup(Token name) throws GeneralErrorException {
        if (this.data != null && this.data.repoSec != null) {
            return this.data.repoSec.getReportGroup(name);
        }
        return null;
    }

    public Pcc getRoot() {
        Pcc Return2 = this;
        while (!(Return2 instanceof CobolProgram) && Return2.parent != null) {
            Return2 = Return2.parent;
        }
        return Return2;
    }

    public MyMethod[] getMyMethods() {
        return this.myMethods;
    }

    public MyField[] getMyFields() {
        if (this.myFields == null) {
            Vector<MyField> v = new Vector<MyField>();
            if (this.factoryPart != null) {
                Pcc.loadFields(v, this.factoryPart.data, true, true);
            }
            if (this.objectPart != null) {
                Pcc.loadFields(v, this.objectPart.data, false, true);
            }
            this.myFields = v.toArray(new MyField[v.size()]);
        }
        return this.myFields;
    }

    public CobolMethod[] getMethods() {
        int i;
        CobolMethod[] cm1 = null;
        cm1 = this.factoryPart != null ? this.factoryPart.getAllMethods() : new CobolMethod[]{};
        CobolMethod[] cm2 = this.objectPart != null ? this.objectPart.getAllMethods() : new CobolMethod[]{};
        CobolMethod[] Return2 = new CobolMethod[cm1.length + cm2.length];
        for (i = 0; i < cm1.length; ++i) {
            Return2[i] = cm1[i];
        }
        for (int j = 0; j < cm2.length; ++j) {
            Return2[i] = cm2[j];
            ++i;
        }
        return Return2;
    }

    public FileDescriptor getFdByRecord(VariableDeclaration vd) {
        if (this.data != null && this.data.fileSec != null) {
            FileDescriptor fd = this.data.fileSec.fdArray.getFirst();
            while (fd != null) {
                if (fd.hasRecord(vd)) {
                    return fd;
                }
                fd = this.data.fileSec.fdArray.getNext();
            }
        }
        return null;
    }

    public FileDescriptor getFdByReport(String repo) {
        if (this.data != null && this.data.fileSec != null) {
            FileDescriptor fd = this.data.fileSec.fdArray.getFirst();
            while (fd != null) {
                if (fd.hasReport(repo)) {
                    return fd;
                }
                fd = this.data.fileSec.fdArray.getNext();
            }
        }
        return null;
    }

    protected void commonHeader(PrintWriter progFile) {
        boolean debug;
        boolean isIntf = this.isInterface();
        progFile.println("/**");
        progFile.println(" * Program generated by isCobol compiler");
        progFile.println(" * " + Version.getRelease());
        progFile.println(" * " + Pcc.getCopyrightInfo());
        progFile.println(" *");
        progFile.println(" * source file name: " + this.tm.getFileName().replace('\\', '/'));
        progFile.println(" * date generated  : " + new Date());
        progFile.println(" * compiler options: " + this.options.getAll().replace('\\', '/'));
        progFile.println(" */");
        progFile.println("");
        if (this.packageName != null) {
            progFile.println("package " + this.packageName + ";");
            progFile.println("");
        } else if (!isIntf && this.getOption("-sysc") != null) {
            if (this.getOption("-xms") == null && this.getOption("-cp") == null) {
                progFile.println("package com.iscobol.lib;");
            } else {
                progFile.println("package com.iscobol.lib_n;");
            }
        }
        progFile.println("import java.util.*;");
        if (this.RTS_IMPORTS != null) {
            for (int i = 0; i < this.RTS_IMPORTS.length; ++i) {
                progFile.println("import " + this.RTS_IMPORTS[i] + ";");
            }
        }
        progFile.println("import " + TYPES_PACKAGE + ".*;");
        if (this.optionMS) {
            progFile.println("import com.iscobol.java.*;");
            if (this.getOption("-xms") == null && this.getOption("-cp") == null) {
                progFile.println("import com.iscobol.java.generator.*;");
            } else {
                progFile.println("import com.iscobol.java.generator.ScreenGroupParams;");
                progFile.println("import com.iscobol.java.generator_n.*;");
            }
        }
        progFile.println("import com.iscobol.io.*;");
        progFile.println("import com.iscobol.lib.*;");
        progFile.println("import com.iscobol.gui.*;");
        progFile.println("import com.iscobol.gui.server.*;");
        if (this.imports != null) {
            Iterator it = this.imports.iterator();
            while (it.hasNext()) {
                progFile.println(it.next());
            }
        }
        boolean bl = debug = this.getOption("-d") != null;
        if (debug) {
            progFile.println("import com.iscobol.debugger.*;");
        }
        if (this.getOption("-sqlj") != null && this.hasSqlj()) {
            progFile.println("import sqlj.runtime.*;");
            progFile.println("import sqlj.runtime.ref.DefaultContext;");
            progFile.println("import java.sql.*;");
            if (this.getOption("-csdb2") != null || Config.getProperty(".compiler.esql.db2", false)) {
                progFile.println("import com.ibm.db2.jcc.DB2ResultSet;");
                progFile.println("import com.ibm.db2.jcc.DB2Diagnosable;");
                progFile.println("import com.ibm.db2.jcc.DB2Sqlca;");
                progFile.println("import java.math.BigDecimal;");
                progFile.println("");
            } else {
                progFile.println("import java.sql.ResultSet;");
            }
            progFile.println("");
            for (Map.Entry<String, String> m : this.sqljIterDecl.entrySet()) {
                progFile.println(m.getValue() + eol);
            }
            progFile.println("");
        }
    }

    protected void writeResources(PrintWriter progFile, boolean factory) {
        progFile.println(this.tm.declareResources(factory));
    }

    protected int writeLiterals(PrintWriter progFile, boolean factory) {
        int[] constInnerClassCount = new int[1];
        progFile.println(this.tm.declareLiterals(this.getClassName(), this.getSplitFlag() && !this.isCobolClass(), constInnerClassCount, factory));
        return constInnerClassCount[0];
    }

    protected void writeTrailer(PrintWriter progFile) {
        boolean write;
        if (this.isInterface()) {
            write = false;
            for (CobolMethod m : this.getMethods()) {
                if (!m.isDefault() && !m.isStatic()) continue;
                write = true;
                break;
            }
        } else {
            write = true;
        }
        if (write) {
            if (this.getOption("-sqlj") != null && this.hasSqlj() && this.hasExecSql) {
                progFile.println("   private final void setSqljConnection () throws SQLException { ");
                progFile.println("      Connection con = Esql.GET_CONNECTION(new Object[] {" + this.sqlca.SQLCA + "});");
                progFile.println("      try {");
                progFile.println("         ctx" + this.getClassName() + " = new DefaultContext(con);");
                progFile.println("      }");
                progFile.println("      catch (Exception e) {");
                progFile.println("         throw new SQLException(\"Exception automatic connection \" + e.getMessage());");
                progFile.println("      }");
                progFile.println("   }");
                progFile.println(eol);
                progFile.println("   private final void clearSqlca (CobolVar SQLCA) {");
                progFile.println("      " + this.sqlca.SQLCAID + ".set(\"SQLCA\");");
                progFile.println("      " + this.sqlca.SQLWARN + ".set(\"     \");");
                progFile.println("      " + this.sqlca.SQLCABC + ".set(SQLCA.getLength());");
                progFile.println("      " + this.sqlca.SQLCODE + ".set(0);");
                progFile.println("      " + this.sqlca.SQLSTATE + ".set(\"00000\");");
                progFile.println("      " + this.sqlca.SQLERRML + ".set(0);");
                progFile.println("      " + this.sqlca.SQLERRMC + ".set(\"\");");
                progFile.println("      " + this.sqlca.SQLERRMC + ".set(\"\");");
                progFile.println("      for (int i = 1; i <= 6; i++)");
                progFile.println("         " + this.sqlca.SQLERRD + ".at(new int[] {i}).set(0);");
                progFile.println("  }");
                progFile.println("   private final void fillSqlcaSqlj (SQLException sqlex, CobolVar SQLCA) {");
                progFile.println("       if (sqlex == null)");
                progFile.println("          return;");
                progFile.println("       String state = sqlex.getSQLState();");
                progFile.println("       if (state == null)");
                progFile.println("           state = \"XXXXX\";");
                progFile.println("       if (sqlex.getMessage().equals(\"IsCOBOLNotFound\")) {");
                progFile.println("           " + this.sqlca.SQLCODE + ".set (100);");
                progFile.println("           " + this.sqlca.SQLERRMC + ".set (\"Row not found\");");
                progFile.println("           return;");
                progFile.println("       }");
                progFile.println("       else if (sqlex.getMessage().equals(\"IsCOBOLNull\")) {");
                progFile.println("           " + this.sqlca.SQLCODE + ".set (EsqlRuntime.codeNull);");
                progFile.println("           " + this.sqlca.SQLERRMC + ".set (\" \");");
                progFile.println("           return;");
                progFile.println("       }");
                progFile.println("       else if (sqlex.getMessage().equals(\"IsCOBOLNoData\")) {");
                progFile.println("           " + this.sqlca.SQLCODE + ".set (EsqlRuntime.noData);");
                progFile.println("           " + this.sqlca.SQLERRMC + ".set (\"02000\");");
                progFile.println("           return;");
                progFile.println("       }");
                if (this.getOption("-csdb2") != null || Config.getProperty(".compiler.esql.db2", false)) {
                    progFile.println("       DB2Sqlca db2Sqlca = null;");
                    progFile.println("       if (sqlex instanceof DB2Diagnosable)");
                    progFile.println("          db2Sqlca = ((DB2Diagnosable)sqlex).getSqlca();");
                    progFile.println("       if (db2Sqlca != null) {");
                    progFile.println("          " + this.sqlca.SQLCODE + ".set(db2Sqlca.getSqlCode());");
                    progFile.println("          if (db2Sqlca.getSqlErrmc() != null) {");
                    progFile.println("             " + this.sqlca.SQLERRMC + ".set(db2Sqlca.getSqlErrmc());");
                    progFile.println("             if (db2Sqlca.getSqlErrmc().length()  > 0 && ");
                    progFile.println("                 db2Sqlca.getSqlErrmc().length() < 71)");
                    progFile.println("                " + this.sqlca.SQLERRML + ".set(db2Sqlca.getSqlErrmc().length());");
                    progFile.println("             else if (db2Sqlca.getSqlErrmc().length() > 70) ");
                    progFile.println("                " + this.sqlca.SQLERRML + ".set(70);");
                    progFile.println("             else");
                    progFile.println("                " + this.sqlca.SQLERRML + ".set(0);");
                    progFile.println("          }");
                    progFile.println("          else");
                    progFile.println("             " + this.sqlca.SQLERRML + ".set(0);");
                    progFile.println("          " + this.sqlca.SQLERRP + ".set(db2Sqlca.getSqlErrp());");
                    progFile.println("          " + this.sqlca.SQLSTATE + ".set(db2Sqlca.getSqlState());");
                    progFile.println("          " + this.sqlca.SQLERRD + ".at(1).set(db2Sqlca.getSqlErrd()[0]);");
                    progFile.println("          " + this.sqlca.SQLERRD + ".at(2).set(db2Sqlca.getSqlErrd()[1]);");
                    progFile.println("          " + this.sqlca.SQLERRD + ".at(3).set(db2Sqlca.getSqlErrd()[2]);");
                    progFile.println("          " + this.sqlca.SQLERRD + ".at(4).set(db2Sqlca.getSqlErrd()[3]);");
                    progFile.println("          " + this.sqlca.SQLERRD + ".at(5).set(db2Sqlca.getSqlErrd()[4]);");
                    progFile.println("          " + this.sqlca.SQLERRD + ".at(6).set(db2Sqlca.getSqlErrd()[5]);");
                    progFile.println("          " + this.sqlca.SQLWARN0 + ".set(db2Sqlca.getSqlWarn()[0]);");
                    progFile.println("          " + this.sqlca.SQLWARN1 + ".set(db2Sqlca.getSqlWarn()[1]);");
                    progFile.println("          " + this.sqlca.SQLWARN2 + ".set(db2Sqlca.getSqlWarn()[2]);");
                    progFile.println("          " + this.sqlca.SQLWARN3 + ".set(db2Sqlca.getSqlWarn()[3]);");
                    progFile.println("          " + this.sqlca.SQLWARN4 + ".set(db2Sqlca.getSqlWarn()[4]);");
                    progFile.println("          " + this.sqlca.SQLWARN5 + ".set(db2Sqlca.getSqlWarn()[5]);");
                    progFile.println("          " + this.sqlca.SQLWARN6 + ".set(db2Sqlca.getSqlWarn()[6]);");
                    progFile.println("          " + this.sqlca.SQLWARN7 + ".set(db2Sqlca.getSqlWarn()[7]);");
                    progFile.println("          " + this.sqlca.SQLSTATE + ".set(db2Sqlca.getSqlState());");
                    progFile.println("       }");
                    progFile.println("       else {");
                }
                progFile.println("          " + this.sqlca.SQLSTATE + ".set(state);");
                progFile.println("          " + this.sqlca.SQLERRMC + ".set (sqlex.getMessage());");
                progFile.println("          " + this.sqlca.SQLERRML + ".set (sqlex.getMessage().length());");
                progFile.println("          if (sqlex instanceof SQLWarning) {");
                progFile.println("             if (warnings)");
                progFile.println("                " + this.sqlca.SQLCODE + ".set (sqlex.getErrorCode());");
                progFile.println("          else");
                progFile.println("                " + this.sqlca.SQLCODE + ".set (0);");
                progFile.println("          " + this.sqlca.SQLWARN0 + ".set(\"W\");");
                progFile.println("          if (state.charAt(4) == '4')");
                progFile.println("             " + this.sqlca.SQLWARN1 + ".set(\"W\");");
                progFile.println("          } else {");
                progFile.println("             int errCode = sqlex.getErrorCode();");
                progFile.println("             " + this.sqlca.SQLCODE + ".set (errCode);");
                progFile.println("          }");
                progFile.println("       }");
                if (this.getOption("-csdb2") != null || Config.getProperty(".compiler.esql.db2", false)) {
                    progFile.println("  }");
                }
            }
            if (!(this.getSplitFlag() || this.getSNEventObject() == null && this.getSNEventSource() == null)) {
                this.writeBeanCode(progFile);
            }
            try {
                this.writeDebugCode(progFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        progFile.println("}");
    }

    void writeBeanCode(PrintWriter progFile) {
        progFile.print(this.getBeanCode());
    }

    String getBeanCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("   public void setEventObject(");
        Return2.append("java.util.EventObject eo) { ");
        if (this.getSNEventObject() != null) {
            Return2.append(this.getSNEventObject().getUnivoqueName() + " = eo; ");
        }
        Return2.append("}" + eol);
        Return2.append("   public ");
        Return2.append("java.util.EventObject getEventObject() { return ");
        if (this.getSNEventObject() != null) {
            Return2.append(this.getSNEventObject().getUnivoqueName());
        } else {
            Return2.append("null");
        }
        Return2.append("; }" + eol);
        Return2.append("   public void setEventSource(");
        Return2.append("com.iscobol.gui.server.CobolGUIJavaBean es) { ");
        if (this.getSNEventSource() != null) {
            Return2.append(this.getSNEventSource().getUnivoqueName() + " = es; ");
        }
        Return2.append("}" + eol);
        Return2.append("   public ");
        Return2.append("com.iscobol.gui.server.CobolGUIJavaBean getEventSource() { return ");
        if (this.getSNEventSource() != null) {
            Return2.append(this.getSNEventSource().getUnivoqueName());
        } else {
            Return2.append("null");
        }
        Return2.append("; }" + eol);
        return Return2.toString();
    }

    void getConstants(VariableDeclarationList result) {
        DataDivision dd = this.getDataDivision();
        if (dd != null) {
            for (IDataSection ds : new IDataSection[]{dd.getWorkingStorageSection(), dd.getLocalStorageSection(), dd.getThreadLocalStorageSection(), dd.getLinkageSection()}) {
                if (ds == null) continue;
                VariableDeclarationList vdl = (VariableDeclarationList)ds.getVariableDeclarationList();
                VariableDeclaration vd = vdl.getFirst();
                while (vd != null) {
                    Pcc.getConstants(vd, result);
                    vd = vdl.getNext();
                }
            }
        }
    }

    private void writeDebugCode(PrintWriter progFile) throws IOException {
        boolean g;
        boolean d = this.getOption("-d") != null;
        boolean bl = g = this.getOption("-g") != null;
        if (!d && !g) {
            return;
        }
        Vector copyFiles = this.tm.getCopyFiles();
        if (d) {
            boolean isIntf = this.isInterface();
            progFile.println("   static final com.iscobol.rts.IDebuggerHelper debugger$helper = new DebuggerHelper();");
            progFile.println("   public static com.iscobol.rts.IDebuggerHelper get$DebuggerHelper() { return debugger$helper; }");
            if (!isIntf) {
                progFile.println("   static { Debugger.activeRemoteDebugging(); }");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dOut = new DataOutputStream(new DeflaterOutputStream(baos));
            dOut.writeUTF(File.separator);
            dOut.writeUTF(File.pathSeparator);
            Vector stmts = this.statementLines;
            dOut.writeInt(stmts.size());
            for (Object sd : stmts) {
                dOut.writeInt(((StatementDesc)sd).getLineNumber());
                dOut.writeShort(((StatementDesc)sd).getFileIndex());
                dOut.writeInt(((StatementDesc)sd).getParagraphId());
                dOut.writeBoolean(((StatementDesc)sd).isDeclaratives());
            }
            Vector pars = this.paragraphNames;
            dOut.writeInt(pars.size());
            for (ParagraphDesc pd : pars) {
                dOut.writeUTF(pd.getMethod() != null ? pd.getMethod() : "");
                dOut.writeUTF(pd.getLabelName());
                dOut.writeInt(pd.getLineNumber());
                dOut.writeShort(pd.getFileIndex());
                dOut.writeBoolean(pd.isDeclaratives());
                dOut.writeInt(pd.getId());
                dOut.writeBoolean(pd.isSection());
            }
            String sf = this.tm.getFileName();
            if (File.separatorChar != '/') {
                sf = sf.replace(File.separatorChar, '/');
            }
            dOut.writeUTF(sf);
            VariableDeclarationList constants = new VariableDeclarationList();
            if (this instanceof CobolProgram) {
                this.getConstants(constants);
            } else {
                if (this.getFactoryPart() != null) {
                    this.getFactoryPart().getConstants(constants);
                }
                if (this.getObjectPart() != null) {
                    this.getObjectPart().getConstants(constants);
                }
            }
            dOut.writeInt(constants.getItemNum());
            Object vd = constants.getFirst();
            while (vd != null) {
                dOut.writeUTF(((VariableDeclaration)vd).getName());
                String val = ((VariableDeclaration)vd).getValue(false);
                if (((VariableDeclaration)vd).getValueToken().getToknum() == 10001) {
                    val = val.substring(1, val.length() - 1);
                }
                StringBuffer buf = new StringBuffer();
                for (char c : val.toCharArray()) {
                    String h = Integer.toHexString(c).toUpperCase();
                    if (h.length() == 1) {
                        buf.append("0");
                    }
                    buf.append(h);
                }
                dOut.writeUTF(buf.toString());
                vd = constants.getNext();
            }
            dOut.writeInt(copyFiles.size());
            for (CopyBookDesc desc : copyFiles) {
                dOut.writeUTF(desc.getParentName().replace('\\', '/'));
                dOut.writeInt(desc.getParentLineNumber());
                dOut.writeUTF(desc.getName().replace('\\', '/'));
                dOut.writeShort(desc.getParentIndex());
                dOut.writeShort(desc.getIndex());
            }
            dOut.writeLong(System.currentTimeMillis());
            dOut.close();
            byte[] b = baos.toByteArray();
            String b64 = new String(Base64.encode(b), "utf-8");
            progFile.println("   public static final String $debugInfos$ = ");
            int limit = 1000;
            if (b64.length() <= 1000) {
                progFile.println("      \"" + b64 + "\";");
            } else {
                progFile.println("      new StringBuilder()");
                while (true) {
                    progFile.print("         .append(\"");
                    if (b64.length() <= 1000) break;
                    progFile.println(b64.substring(0, 1000) + "\")");
                    b64 = b64.substring(1000);
                }
                progFile.println(b64 + "\")");
                progFile.println("         .toString();");
            }
            if (g) {
                progFile.println("/*!#M" + sf + "*/");
                progFile.println("/*!#F" + System.getProperty("file.encoding") + "*/");
                progFile.println("/*!#N" + (this.tm.pp.isDebugReplSrc() ? "1" : "0") + "*/");
            }
        }
        if (g) {
            String fn;
            progFile.print("/*!#C");
            for (Object desc : copyFiles) {
                progFile.print(((CopyBookDesc)desc).getParentName().replace('\\', '/') + "," + ((CopyBookDesc)desc).getParentLineNumber() + "," + ((CopyBookDesc)desc).getName().replace('\\', '/') + "," + ((CopyBookDesc)desc).getParentIndex() + "," + ((CopyBookDesc)desc).getIndex() + ";");
            }
            progFile.println("*/");
            progFile.print("/*!#S");
            Vector svrFiles = this.tm.getSvrFileNames();
            if (svrFiles != null) {
                for (String[] fns : svrFiles) {
                    String fn2 = fns[2];
                    if (File.separatorChar != '/') {
                        fn2 = fn2.replace(File.separatorChar, '/');
                    }
                    progFile.print(fn2 + ";");
                }
            } else {
                Vector allPreProcessors = this.tm.pp.getAllPreProcessors();
                for (PreProcessor pp : allPreProcessors) {
                    fn = pp.getFileName();
                    if (File.separatorChar != '/') {
                        fn = fn.replace(File.separatorChar, '/');
                    }
                    progFile.print(fn + ";");
                }
            }
            progFile.println("*/");
            progFile.print("/*!#E");
            Collection<File> copyRes = this.tm.getCopyResources();
            for (File f : copyRes) {
                fn = f.getPath();
                if (File.separatorChar != '/') {
                    fn = fn.replace(File.separatorChar, '/');
                }
                progFile.print(fn + ";");
            }
            progFile.println("*/");
        }
    }

    static void getConstants(VariableDeclaration vd, VariableDeclarationList result) {
        if (vd.getLevel() == 78) {
            result.addItem(vd);
        } else {
            VariableDeclarationList children = vd.getChildren();
            VariableDeclaration cd = children.getFirst();
            while (cd != null) {
                Pcc.getConstants(cd, result);
                cd = children.getNext();
            }
        }
    }

    @Override
    public String getPackageName() {
        if (this.packageName != null) {
            return this.packageName;
        }
        return "";
    }

    @Override
    public String getFullClassName() {
        if (this.packageName != null && this.packageName.length() > 0) {
            return this.packageName + "." + this.className;
        }
        return this.className;
    }

    public VariableDeclaration getSelfVarDecl() {
        if (this.self == null) {
            String clazz = this.getFullClassName();
            String name = clazz.length() > 0 ? clazz + ".this" : "this";
            this.self = VariableDeclaration.getObject(this, new Token(10009, name, 0, 0, ""), this.tm, clazz, false);
        }
        return this.self;
    }

    @Override
    public String getInheritsClass() {
        return this.gIdentification != null ? this.gIdentification.getInheritsClass() : null;
    }

    @Override
    public String[] getImplementsClass() {
        return this.gIdentification != null ? this.gIdentification.getImplementsClass() : null;
    }

    public boolean isConstructor() {
        return false;
    }

    @Override
    public IdentificationDivision getIdentificationDivision() {
        return this.gIdentification;
    }

    public Switch getSwitch(VariableName vn) {
        Switch Return2 = null;
        if (this.switches != null) {
            Return2 = this.switches.getFirst();
            while (Return2 != null && !vn.getName().equals(Return2.getName())) {
                Return2 = this.switches.getNext();
            }
        }
        return Return2;
    }

    public boolean addSqlCursor(SqlDeclareCursor scd) {
        if (this.checkCursor(scd.getName())) {
            return false;
        }
        this.sqlCursors.addItem(scd);
        return true;
    }

    public boolean checkCursor(String name) {
        return this.getCursor(name) != null;
    }

    public SqlDeclareCursor getCursor(String name) {
        Enumeration e = this.sqlCursors.elements();
        while (e.hasMoreElements()) {
            Object v = e.nextElement();
            if (!(v instanceof SqlDeclareCursor) || !name.equals(((SqlDeclareCursor)v).getName())) continue;
            return (SqlDeclareCursor)v;
        }
        if (this.parent != null) {
            return this.parent.getCursor(name);
        }
        return null;
    }

    public void addSqlDatabase(String name) {
        if (this.sqlDatabase == null) {
            this.sqlDatabase = new HashSet();
        }
        this.sqlDatabase.add(name);
    }

    public boolean hasAnySqlDatabase() {
        return this.sqlDatabase != null;
    }

    public boolean isValidDatabase(String name) {
        return this.sqlDatabase == null ? true : this.sqlDatabase.contains(name);
    }

    final int writeDeclaration(PrintWriter progFile, StringBuffer dynPart, StringBuffer fixedVarPart, boolean isFactory, int innerClassCount, String innerPrefix, boolean debug, boolean debugExt) {
        int LOCAL_LINE_BREAK;
        int n = LOCAL_LINE_BREAK = innerClassCount >= 0 ? 1000 : 500;
        if (dynPart.length() > 0 || innerClassCount >= 0) {
            LineNumberReader lnr = new LineNumberReader(new StringReader(dynPart.toString()));
            progFile.print("   ");
            if (isFactory) {
                progFile.print("static ");
            }
            if (innerClassCount >= 0) {
                progFile.print("    public class " + innerPrefix + innerClassCount);
                if (innerClassCount > 0) {
                    progFile.print(" extends " + innerPrefix + (innerClassCount - 1));
                }
                if (debug) {
                    progFile.print(" implements IscobolDebugger");
                }
                if (debugExt) {
                    progFile.print(", IscobolDebuggerExtension");
                }
                progFile.println(" {");
                progFile.println("   public " + innerPrefix + innerClassCount + "() {}");
                ++innerClassCount;
            }
            progFile.println("{");
            int inc = 0;
            try {
                String line;
                int i = 1;
                while ((line = lnr.readLine()) != null) {
                    if (line.length() > 160) {
                        inc = line.length() / 160;
                        while (++i % LOCAL_LINE_BREAK != 0 && --inc > 0) {
                        }
                    } else {
                        ++i;
                    }
                    if (i % LOCAL_LINE_BREAK == 0) {
                        if (innerClassCount <= 0) {
                            progFile.print("      ");
                            if (isFactory) {
                                progFile.print("factory$");
                            }
                            progFile.println("init$" + i + "();");
                        }
                        progFile.println("   }");
                        if (innerClassCount > 0) {
                            progFile.println("   }");
                        }
                        if (isFactory) {
                            progFile.print("static ");
                        }
                        if (innerClassCount > 0) {
                            progFile.print("    public class " + innerPrefix + innerClassCount + " extends " + innerPrefix + (innerClassCount - 1));
                            if (debug) {
                                progFile.print(" implements IscobolDebugger");
                            }
                            if (debugExt) {
                                progFile.print(", IscobolDebuggerExtension");
                            }
                            progFile.println(" {");
                            progFile.println("   public " + innerPrefix + innerClassCount + "() {}");
                            progFile.println("   {");
                            ++innerClassCount;
                        } else {
                            if (this instanceof CobolClass) {
                                progFile.print("   private void ");
                            } else {
                                progFile.print("   void ");
                            }
                            if (isFactory) {
                                progFile.print("factory$");
                            }
                            progFile.println("init$" + i + "() {");
                        }
                    }
                    progFile.println("      " + line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            progFile.println("   }");
        }
        if (fixedVarPart.length() > 0) {
            progFile.println("   {");
            progFile.print(fixedVarPart);
            progFile.println("   }");
        }
        if (innerClassCount > 0) {
            progFile.println("   }");
        }
        return innerClassCount;
    }

    public void setNumericSignTrailingSeparate(boolean b) {
        this.numericSignTrailSep = new Boolean(b);
    }

    public boolean getNumericSignTrailingSeparate() {
        if (this.numericSignTrailSep != null) {
            return this.numericSignTrailSep;
        }
        if (this.parent != null) {
            return this.parent.getNumericSignTrailingSeparate();
        }
        return false;
    }

    public Alphabet getProgramCollatingSeq() {
        return null;
    }

    Alphabet[] getAlphabets() {
        return null;
    }

    Alphabet getAlphabet(Token name) {
        return null;
    }

    public void setSNCrtStatus(VariableDeclaration vd) {
        if (this.snCrtStatus != null && vd != this.snCrtStatus) {
            Token tk = vd.getNameToken();
            this.error.print(155, 4, tk.getFLN(), tk.getOffset(), "CRT STATUS", null, tk.getFileName());
        } else {
            this.snCrtStatus = vd;
        }
    }

    public void setSNCursor(VariableDeclaration vd) {
        if (this.snCursor != null && vd != this.snCursor) {
            Token tk = vd.getNameToken();
            this.error.print(155, 4, tk.getFLN(), tk.getOffset(), "CURSOR ", null, tk.getFileName());
        } else {
            this.snCursor = vd;
        }
    }

    public void setSNScreenControl(VariableDeclaration vd) {
        if (this.snScreenControl != null && vd != this.snScreenControl) {
            Token tk = vd.getNameToken();
            this.error.print(155, 4, tk.getFLN(), tk.getOffset(), "SCREEN CONTROL ", null, tk.getFileName());
        } else {
            this.snScreenControl = vd;
        }
    }

    public void setSNEventStatus(VariableDeclaration vd) {
        if (this.snEventStatus != null && vd != this.snEventStatus) {
            Token tk = vd.getNameToken();
            this.error.print(155, 4, tk.getFLN(), tk.getOffset(), "EVENT STATUS ", null, tk.getFileName());
        } else {
            this.snEventStatus = vd;
        }
    }

    public void setSNEventObject(VariableDeclaration vd) {
        this.snEventObject = vd;
    }

    public void setSNEventSource(VariableDeclaration vd) {
        this.snEventSource = vd;
    }

    @Override
    public VariableDeclaration getSNCrtStatus() {
        if (this.snCrtStatus != null) {
            return this.snCrtStatus;
        }
        if (this.parent != null) {
            return this.parent.getSNCrtStatus();
        }
        return null;
    }

    @Override
    public VariableDeclaration getSNCursor() {
        if (this.snCursor != null) {
            return this.snCursor;
        }
        if (this.parent != null) {
            return this.parent.getSNCursor();
        }
        return null;
    }

    @Override
    public VariableDeclaration getSNScreenControl() {
        if (this.snScreenControl != null) {
            return this.snScreenControl;
        }
        if (this.parent != null) {
            return this.parent.getSNScreenControl();
        }
        return null;
    }

    @Override
    public VariableDeclaration getSNEventStatus() {
        if (this.snEventStatus != null) {
            return this.snEventStatus;
        }
        if (this.parent != null) {
            return this.parent.getSNEventStatus();
        }
        return null;
    }

    @Override
    public VariableDeclaration getSNEventObject() {
        if (this.snEventObject != null) {
            return this.snEventObject;
        }
        if (this.parent != null) {
            return this.parent.getSNEventObject();
        }
        return null;
    }

    @Override
    public VariableDeclaration getSNEventSource() {
        if (this.snEventSource != null) {
            return this.snEventSource;
        }
        if (this.parent != null) {
            return this.parent.getSNEventSource();
        }
        return null;
    }

    public String getCodeScreenEventStatusSpecialNames() {
        StringBuffer Return2 = new StringBuffer();
        if (this.getSNEventStatus() != null) {
            Return2.append(this.getSNEventStatus().getUnivoqueName());
        } else {
            Return2.append("(CobolVar)null");
        }
        return Return2.toString();
    }

    public String getCodeScreenSpecialNames() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.getCodeScreenCrtStatusSpecialNames());
        Return2.append(this.getCodeScreenScreenControlSpecialNames());
        Return2.append(this.getCodeScreenEventStatusSpecialNames());
        Return2.append(", ");
        if (this.getSNEventObject() != null || this.getSNEventSource() != null) {
            if (this.getSplitFlag()) {
                if (this instanceof CobolMethod) {
                    Return2.append(((CobolMethod)this).getLocalDataClass());
                } else {
                    Return2.append(this.getClassName());
                }
                Return2.append(".");
            }
            Return2.append("this, ");
        } else {
            Return2.append("null, ");
        }
        return Return2.toString();
    }

    public String getCodeScreenScreenControlSpecialNames() {
        StringBuffer Return2 = new StringBuffer();
        if (this.getSNScreenControl() != null) {
            Return2.append(this.getSNScreenControl().getUnivoqueName() + ", ");
        } else {
            Return2.append("(CobolVar)null, ");
        }
        return Return2.toString();
    }

    public String getCodeScreenCrtStatusSpecialNames() {
        StringBuffer Return2 = new StringBuffer();
        if (this.getSNCrtStatus() != null) {
            Return2.append(this.getSNCrtStatus().getUnivoqueName() + ", ");
        } else {
            Return2.append("(CobolVar)null, ");
        }
        return Return2.toString();
    }

    public String getCodeCursorSpecialNames() {
        if (this.getSNCursor() != null) {
            return this.getSNCursor().getUnivoqueName();
        }
        return null;
    }

    public boolean putSpecialNamesClass(SpecialNamesClass snc) {
        return this.specialNamesClasses.put(snc.getName(), snc) == null;
    }

    public SpecialNamesClass getSpecialNamesClass(String name) {
        return (SpecialNamesClass)this.specialNamesClasses.get(name);
    }

    public Hashtable getSpecialNamesClasses() {
        if (this.parent != null) {
            return this.parent.getSpecialNamesClasses();
        }
        return this.specialNamesClasses;
    }

    public void putMnemonicSystem(String mnem, String sys) {
        this.mnemonicSystem.put(mnem, sys);
    }

    public String getMnemonicSystem(String mnem) {
        String Return2 = (String)this.mnemonicSystem.get(mnem);
        if (Return2 == null) {
            Return2 = this.parent != null ? this.parent.getMnemonicSystem(mnem) : mnem;
        }
        return Return2;
    }

    public Entry[] getEntryPoints() {
        Entry[] Return2 = new Entry[this.entryPoints.size()];
        this.entryPoints.toArray(Return2);
        return Return2;
    }

    @Override
    public Token getFirstToken() {
        return null;
    }

    @Override
    public Token getLastToken() {
        return null;
    }

    public void putSession(Object key, Object value) {
        Pcc pc = this.getRoot();
        if (pc.session == null) {
            pc.session = new Hashtable();
        }
        pc.session.put(key, value);
    }

    public Object getSession(Object key) {
        Pcc pc = this.getRoot();
        if (pc.session == null) {
            pc.session = new Hashtable();
        }
        return pc.session.get(key);
    }

    public void addImport(String value) {
        Pcc pc = this.getRoot();
        if (pc.imports == null) {
            pc.imports = new HashSet();
        }
        pc.imports.add(value);
    }

    public boolean putDeclarative(Select s, String d) {
        if (this.selAndDecl.get(s) != null) {
            return false;
        }
        this.selAndDecl.put(s, d);
        return true;
    }

    public String getDeclarative(Select s) {
        return (String)this.selAndDecl.get(s);
    }

    public void putSNFunc(String key, String val) {
        if (this.parent != null) {
            this.parent.putSNFunc(key, val);
        } else {
            this.snFuncNames.put(key, val);
        }
    }

    @Override
    public String getSNFunc(String key) {
        if (this.parent != null) {
            return this.parent.getSNFunc(key);
        }
        return (String)this.snFuncNames.get(key);
    }

    public void setHasSort() {
        if (this.parent != null) {
            this.parent.setHasSort();
        } else {
            this.hasSort = true;
        }
    }

    public boolean getHasSort() {
        if (this.parent != null) {
            return this.parent.getHasSort();
        }
        return this.hasSort;
    }

    public Phases getPhases() {
        return this.phases;
    }

    public File getGeneratedSourceDirectory() {
        return new File(this.outDir).getAbsoluteFile();
    }

    @Override
    public TokenManager getTokenManager() {
        return this.tm;
    }

    @Override
    public OptionList getOptions() {
        return this.options;
    }

    public String getDeclInput() {
        return this.declInput;
    }

    public String getDeclOutput() {
        return this.declOutput;
    }

    public String getDeclIO() {
        return this.declIO;
    }

    public String getDeclExtend() {
        return this.declExtend;
    }

    public String getDeclTransaction() {
        return this.declTransaction;
    }

    @Override
    public Pcc getParent() {
        return this.parent;
    }

    int getNewProgClass() {
        if (this.parent != null) {
            return this.parent.getNewProgClass();
        }
        return ++this.progClass;
    }

    protected boolean getGenerateCode() {
        return this.generateCode;
    }

    protected void setGenerateCode(boolean gc) {
        this.generateCode = gc;
    }

    void addFinalizeCode(String s) {
        if (this.parent != null) {
            this.parent.addFinalizeCode(s);
        } else {
            this.finalizeCode.add(s);
        }
    }

    String getFinalizeCode() {
        if (this.parent != null) {
            return this.parent.getFinalizeCode();
        }
        return this.getFinalizeCode(this.finalizeCode);
    }

    private String getFinalizeCode(HashSet<String> set) {
        StringBuffer Return2 = new StringBuffer();
        for (String s : set) {
            Return2.append(s);
        }
        return Return2.toString();
    }

    void setUserDefinedFinalize(boolean b) {
        if (this.parent != null) {
            this.parent.setUserDefinedFinalize(b);
        } else {
            this.userDefinedFinalize = b;
        }
    }

    boolean isUserDefinedFinalize() {
        if (this.parent != null) {
            return this.parent.isUserDefinedFinalize();
        }
        return this.userDefinedFinalize;
    }

    static void checkEIS(Token tk, Errors error, boolean wrn) throws GeneralErrorException {
        if (eisCheck == null) {
            try {
                Pcc.getDate(Pcc.ctxs[0].d, Pcc.ctxs[0].m);
                Config.gn(6);
                eisCheck = "";
            }
            catch (Throwable t) {
                eisCheck = "EIS: " + t;
            }
        }
        if (eisCheck.length() > 0) {
            if (wrn) {
                error.print(61, 2, tk, eisCheck);
            } else {
                throw new GeneralErrorException(61, 4, tk, eisCheck, error);
            }
        }
    }

    private static boolean checkJJMS(boolean wrn) {
        if (wrn) {
            try {
                Pcc.getDate(Pcc.ctxs[3].d, Pcc.ctxs[3].m);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
        Pcc.getDate(Pcc.ctxs[3].d, Pcc.ctxs[3].m);
        return true;
    }

    void writeClassEEA() {
        if (Config.getProperty(RtsUtil.newUTFString(Pcc.ctxs[0].d), null) != null) {
            try {
                Pcc.getDate(Pcc.ctxs[0].d, Pcc.ctxs[0].m);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Config.gn(6);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                // empty catch block
            }
        }
        if (Config.getProperty(RtsUtil.newUTFString(Pcc.ctxs[2].d), null) != null) {
            try {
                Pcc.getDate(Pcc.ctxs[2].d, Pcc.ctxs[2].m);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Config.gn(7);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                // empty catch block
            }
        }
    }

    void writeClassUID(PrintWriter progFile) {
        progFile.print("   private static byte[] $classUID$ = new byte[] {");
        try {
            String hex = Integer.toHexString(this.getClassName().hashCode());
            int n = 8 - hex.length();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                sb.append('0');
            }
            sb.append(hex);
            sb.append(",");
            String d = null;
            try {
                d = Pcc.getDate(Pcc.ctxs[0].d, Pcc.ctxs[0].m);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sb.append(d != null ? d : "19700101");
            d = null;
            try {
                d = Pcc.getDate(Pcc.ctxs[1].d, Pcc.ctxs[1].m);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sb.append(",");
            sb.append(d != null ? d : "19700101");
            byte[] src = Pcc.encode(sb.toString().getBytes("UTF-8"));
            for (int i = 0; i < src.length; ++i) {
                if (i > 0) {
                    progFile.print(",");
                }
                if (i % 16 == 0) {
                    progFile.println();
                    progFile.print("   ");
                }
                progFile.print(src[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        progFile.println(" };");
    }

    private static byte[] encode(byte[] in) {
        byte[] out = new byte[in.length * 2];
        int i = 0;
        int j = 0;
        while (i < in.length) {
            out[j] = (byte)(112 + ((in[i] & 0xF0) >>> 4));
            out[j + 1] = (byte)(112 + (in[i] & 0xF));
            ++i;
            j += 2;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDate(byte[] d, byte[] m) {
        String d3s = RtsUtil.newUTFString(d3);
        String d4s = RtsUtil.newUTFString(d4);
        String s3 = Config.getProperty(d3s, null);
        String s4 = Config.getProperty(d4s, null);
        String Return2 = null;
        try {
            Config.putProperty(d, m);
            Return2 = Config.getProperty(d3s, null);
        }
        finally {
            Config.setProperty(d3s, s3);
            Config.setProperty(d4s, s4);
        }
        return Return2.substring(Return2.length() - 8);
    }

    protected int getNumEntry(String name) {
        int Return2 = 0;
        Entry[] entries = this.getEntryPoints();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return Return2;
    }

    public void addServiceBridgeElkNames(String n, Token t) {
        String name = n.replace('-', '_').toLowerCase();
        if (this.serviceBridgeElkNames.containsKey(name)) {
            TokenList tl = (TokenList)this.serviceBridgeElkNames.get(name);
            tl.addItem(t);
        } else {
            TokenList tl = new TokenList();
            tl.addItem(t);
            this.serviceBridgeElkNames.put(name, tl);
        }
    }

    public boolean isUniqueElkName(String n) {
        boolean unique = true;
        String name = n.replace('-', '_').toLowerCase();
        if (this.serviceBridgeElkNames.containsKey(name) && ((TokenList)this.serviceBridgeElkNames.get(name)).getItemNum() > 1) {
            unique = false;
        }
        return unique;
    }

    public String getNumElkName(String n, Token t) {
        String Return2 = "";
        String name = n.replace('-', '_').toLowerCase();
        if (this.serviceBridgeElkNames.containsKey(name)) {
            TokenList tl = (TokenList)this.serviceBridgeElkNames.get(name);
            int num = 0;
            Token tN = tl.getFirst();
            while (tN != null) {
                if (tN == t && ++num > 1) {
                    Return2 = "__" + (num - 2);
                }
                tN = tl.getNext();
            }
        }
        return Return2;
    }

    public void addServiceBridgeNames(Token t) {
        String name = t.getWord().replace('-', '_').toLowerCase();
        if (this.serviceBridgeNames.containsKey(name)) {
            TokenList tl = (TokenList)this.serviceBridgeNames.get(name);
            tl.addItem(t);
        } else {
            TokenList tl = new TokenList();
            tl.addItem(t);
            this.serviceBridgeNames.put(name, tl);
        }
    }

    public boolean isUniqueName(String n) {
        boolean unique = true;
        String name = n.replace('-', '_').toLowerCase();
        if (this.serviceBridgeNames.containsKey(name) && ((TokenList)this.serviceBridgeNames.get(name)).getItemNum() > 1) {
            unique = false;
        }
        return unique;
    }

    public String getNumName(Token t) {
        String Return2 = "";
        String name = t.getWord().replace('-', '_').toLowerCase();
        if (this.serviceBridgeNames.containsKey(name)) {
            TokenList tl = (TokenList)this.serviceBridgeNames.get(name);
            int num = 0;
            Token tN = tl.getFirst();
            while (tN != null) {
                if (tN == t && ++num > 1) {
                    Return2 = "__" + (num - 2);
                }
                tN = tl.getNext();
            }
        }
        return Return2;
    }

    @Override
    public String getSourceFileName() {
        return this.tm.pp.getFileName();
    }

    public FileFinder getFileFinder() {
        return this.tm.pp.getFileFinder();
    }

    public boolean isInterface() {
        return this.gIdentification != null && this.gIdentification.isInterface();
    }

    boolean isInterfaceChild() {
        return this.parent != null && this.parent.isInterface();
    }

    public static ReferencedPccNotifier getReferencedPccNotifier() {
        return referencedPccNotifier;
    }

    public static void setReferencedPccNotifier(ReferencedPccNotifier referencedPccNotifier) {
        Pcc.referencedPccNotifier = referencedPccNotifier;
    }

    static void loadFields(Vector<MyField> fields, DataDivision dd, boolean isFactory) {
        Pcc.loadFields(fields, dd, isFactory, false);
    }

    static void loadFields(Vector<MyField> fields, DataDivision dd, boolean isFactory, boolean all) {
        if (dd == null || dd.getWorkingStorageSection() == null) {
            return;
        }
        VariableDeclarationList vdl = dd.getWorkingStorageSection().getVariableDeclarationList();
        VariableDeclaration vd = vdl.getFirst();
        while (vd != null) {
            int mod = vd.getModifier();
            if (all || !Modifier.isPrivate(mod) || vd.isProperty()) {
                try {
                    if (isFactory) {
                        mod |= 8;
                    }
                    fields.addElement(new MyField(vd, mod));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            vd = vdl.getNext();
        }
    }

    public void addCounters(VariableDeclaration vd) {
        this.counters.addItem(vd);
    }

    public void mergeCounters(VariableDeclaration newVar) {
        String name = newVar.getName();
        VariableDeclaration vd = this.counters.getFirst();
        while (vd != null) {
            if (vd.getCountIn() != null && vd.getCountIn().getName().equalsIgnoreCase(name)) {
                vd.setCountIn(new VariableName(newVar));
                vd.setIsCountVar(false);
                this.counters.deleteCurrent();
                newVar.setUsed();
            }
            vd = this.counters.getNext();
        }
    }

    public void loadCounters() {
        VariableDeclaration vd = this.counters.getFirst();
        while (vd != null) {
            if (vd.getCountIn() != null && vd.getCountIn().getVarDecl() != null) {
                this.loadVariable(vd.getCountIn().getVarDecl());
            }
            vd = this.counters.getNext();
        }
    }

    public static String loadOutDir(String prop, String outD, boolean genSrc) {
        if (!genSrc && !Config.getProperty(".compiler.generate.keep_structure", false)) {
            if (outD == null) {
                return srcDirMain;
            }
            if (outD.length() == 0) {
                return "." + File.separator;
            }
            return outD;
        }
        String outDir = outD;
        if (genSrc) {
            outDir = Config.getProperty(".compiler.generate.root_dir", outD);
        } else if (outDir == null) {
            outDir = srcDirMain;
        } else if (outDir.length() == 0) {
            outDir = "." + File.separator;
        }
        if (outDir != null && outDir.length() > 0 && !outDir.endsWith(File.separator)) {
            outDir = outDir + File.separator;
        } else if (outDir == null) {
            outDir = "";
        }
        if (prop.equals("easydb")) {
            outDir = outDir + "easydb";
        } else if (prop.equals("servicebridge")) {
            outDir = outDir + "servicebridge";
        } else if (prop.equals("servicebridge.bean")) {
            outDir = outDir + "bean";
        } else if (prop.equals("easylinkage")) {
            outDir = outDir + "easylinkage";
        }
        File fil = new File(outDir);
        if (fil != null && !fil.exists() && !fil.mkdirs()) {
            System.err.println("Cannot create '" + outDir + "'");
        }
        return outDir + File.separator;
    }

    public String getOutNameBase() {
        return this.outName.toUpperCase().replace("-", "_");
    }

    public void setCallEasyStub(Call cl) {
        easyLinkStubs.put(cl.getName() + "," + cl.getUsings().getItemNum() + cl.getStubSignature(), cl);
    }

    void makeEasyLinkageStubRoutines() {
        String key;
        Call cl;
        boolean i = false;
        HashMap<String, Call> fittingStubs = new HashMap<String, Call>();
        HashMap<String, String> nameStubs = new HashMap<String, String>();
        for (Map.Entry<String, Call> entry : easyLinkStubs.entrySet()) {
            cl = entry.getValue();
            key = entry.getKey();
            fittingStubs.put(cl.getName(), cl);
            String st = key.substring(0, key.indexOf(","));
            boolean moreOccurs = false;
            for (String s : easyLinkStubs.keySet()) {
                if (!st.equals(s.substring(0, s.indexOf(","))) || s.equals(key)) continue;
                moreOccurs = true;
                break;
            }
            for (Map.Entry<String, String> names : cl.getCallStubCode(moreOccurs).entrySet()) {
                nameStubs.put(names.getKey(), cl.getName() + names.getValue());
            }
        }
        for (String s : nameStubs.keySet()) {
            if (!fittingStubs.containsKey(s)) continue;
            fittingStubs.remove(s);
        }
        for (Map.Entry<String, Call> entry : fittingStubs.entrySet()) {
            cl = entry.getValue();
            key = entry.getKey();
            cl.getCallFillingStubCode(nameStubs);
        }
        easyLinkStubs.clear();
    }

    static String declareFinalize(String spaces) {
        StringBuffer Return2 = new StringBuffer();
        Pcc.declareFinalize(Return2, spaces);
        return Return2.toString();
    }

    static void declareFinalize(StringBuffer Return2, String spaces) {
        Return2.append(spaces).append("@SuppressWarnings({ \"deprecation\", \"removal\" })").append(eol).append(spaces).append("public void finalize() {").append(eol);
    }

    static void declareFinalize(PrintWriter pw, String spaces) {
        pw.print(Pcc.declareFinalize(spaces));
    }

    void getLocalStorageCode(StringBuffer Return2) {
        String cmClass;
        Return2.append("   final ");
        String string = cmClass = this instanceof CobolMethod ? ((CobolMethod)this).getLocalDataClass() : null;
        if (cmClass != null) {
            Return2.append(cmClass);
        }
        String lsName = this.optionMS ? "LocalStorageSection" : LOCAL_STORAGE_CLASS_NAME;
        String lsFName = this.optionMS ? "$lss$" : LOCAL_STORAGE_FIELD_NAME;
        Return2.append(lsName);
        Return2.append(" ");
        Return2.append(lsFName);
        Return2.append(" = (");
        if (cmClass != null) {
            Return2.append(cmClass);
        }
        Return2.append(lsName);
        Return2.append(") Factory.");
        if (cmClass != null) {
            Return2.append("peekMethodLocalStorage();");
        } else {
            Return2.append("peekCallLocalStorage();");
        }
        Return2.append(eol);
    }

    void getThreadLocalStorageCode(StringBuffer Return2) {
        String cmClass;
        Return2.append("   final ");
        String string = cmClass = this instanceof CobolMethod ? ((CobolMethod)this).getLocalDataClass() : null;
        if (cmClass != null) {
            Return2.append(cmClass);
        }
        String tlsName = this.optionMS ? "ThreadLocalStorageSection" : THREAD_LOCAL_STORAGE_CLASS_NAME;
        String tlsFName = this.optionMS ? "$tlss$" : THREAD_LOCAL_STORAGE_FIELD_NAME;
        Return2.append(tlsName);
        Return2.append(" ");
        Return2.append(tlsFName);
        Return2.append(" = (");
        if (cmClass != null) {
            Return2.append(cmClass);
        }
        Return2.append(tlsName);
        Return2.append(") Factory.");
        if (cmClass != null) {
            Return2.append("peekMethodThreadLocalStorage();");
        } else {
            Return2.append("peekCallThreadLocalStorage();");
        }
        Return2.append(eol);
    }

    public boolean addUseForDebugging(Paragraph useForDebugSection, int debuggedParagraphNumber) {
        boolean duplicate;
        if (debuggedParagraphNumber == Integer.MAX_VALUE) {
            duplicate = !this.useForDebugging.isEmpty();
        } else {
            int n = this.useForDebugging.size();
            duplicate = false;
            for (int i = 0; i < n; ++i) {
                int dpn = this.useForDebugging.get((int)i).debuggedParagraphNumber;
                if (dpn != debuggedParagraphNumber && dpn != Integer.MAX_VALUE) continue;
                duplicate = true;
                break;
            }
        }
        if (!duplicate) {
            this.useForDebugging.add(new UseForDebugging(useForDebugSection, debuggedParagraphNumber));
            return true;
        }
        return false;
    }

    public int getUseForDebuggingCount() {
        return this.useForDebugging.size();
    }

    public int getDebuggedParagraphNumber(int idx) {
        return this.useForDebugging.get((int)idx).debuggedParagraphNumber;
    }

    public Paragraph getUseForDebugSection(int idx) {
        return this.useForDebugging.get((int)idx).useForDebugSection;
    }

    protected void createFixedVars(boolean cobolProgram, Pcc pc) {
        Token tk = new Token(10009, "RETURN-CODE", 0, 0, this.tm.getFileName());
        VariableDeclaration vd = VariableDeclaration.getPicDefaultNum(pc, this.tm, tk, true);
        this.fixedVars.addItem(vd);
        vd.setUsed();
        tk = new Token(10009, "RETURN-UNSIGNED", 0, 0, this.tm.getFileName());
        VariableDeclaration vu = VariableDeclaration.getPicDefaultNum(pc, this.tm, tk, false);
        this.fixedVars.addItem(vu);
        vu.setRedefines(vd);
        tk = new Token(10009, "TRANSACTION-STATUS", 0, 0, this.tm.getFileName());
        vd = VariableDeclaration.getPicX(pc, this.tm, tk, 2, null);
        this.fixedVars.addItem(vd);
        vd.setUsed();
        tk = new Token(10009, "EXCEPTION-OBJECT", 0, 0, this.tm.getFileName());
        vd = VariableDeclaration.getObject(pc, tk, this.tm, "java.lang.Throwable", false);
        this.fixedVars.addItem(vd);
        vd.setUsed();
        if (pc.getOption("-clk0") != null) {
            tk = LinkageSection.lnkNull;
            vd = VariableDeclaration.getPicX(pc, this.tm, tk, 1, null);
            this.fixedVars.addItem(vd);
            vd.setUsed();
        }
        if (pc.getOption("-cv") != null) {
            vd = VariableDeclaration.getTallyRegistryDecl(pc, this.tm);
            this.fixedVars.addItem(vd);
            vd.setUsed();
            tk = new Token(10009, "SORT-RETURN", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicDefaultNum(pc, this.tm, tk, true);
            this.fixedVars.addItem(vd);
            if (cobolProgram) {
                vd.setGlobal();
            }
            vd.setUsed();
            tk = new Token(10009, "SORT-MESSAGE", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicX(pc, this.tm, tk, 8, null);
            this.fixedVars.addItem(vd);
            if (cobolProgram) {
                vd.setGlobal();
            }
            vd.setUsed();
            tk = new Token(10009, "DEBUG-ITEM", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.get(pc, this.tm, tk, 86, 0, 0, 0, false, false, false, false, false, null, null, null, null);
            this.fixedVars.addItem(vd);
            vd.setUsed();
            tk = new Token(10009, "DEBUG-LINE", 0, 0, this.tm.getFileName());
            vu = VariableDeclaration.get(pc, this.tm, tk, 6, 0, 0, 0, false, false, false, false, false, null, null, null, vd);
            vu.setUsed();
            Token filler = new Token(486, "FILLER", 0, 0, this.tm.getFileName());
            Token space = new Token(10001, "\" \"", 0, 0, this.tm.getFileName());
            vu = VariableDeclaration.get(pc, this.tm, filler, 1, 6, 0, 0, false, false, false, false, false, null, null, space, vd);
            vu.isFiller = true;
            vu.setUsed();
            tk = new Token(10009, "DEBUG-NAME", 0, 0, this.tm.getFileName());
            vu = VariableDeclaration.get(pc, this.tm, tk, 30, 7, 0, 0, false, false, false, false, false, null, null, null, vd);
            vu.setUsed();
            vu = VariableDeclaration.get(pc, this.tm, filler, 1, 37, 0, 0, false, false, false, false, false, null, null, space, vd);
            vu.isFiller = true;
            vu.setUsed();
            tk = new Token(10009, "DEBUG-SUB-1", 0, 0, this.tm.getFileName());
            vu = VariableDeclaration.get(pc, this.tm, tk, 5, 38, 4, 0, true, true, true, true, false, null, null, null, vd);
            vu.setUsed();
            vu = VariableDeclaration.get(pc, this.tm, filler, 1, 43, 0, 0, false, false, false, false, false, null, null, space, vd);
            vu.isFiller = true;
            vu.setUsed();
            tk = new Token(10009, "DEBUG-SUB-2", 0, 0, this.tm.getFileName());
            vu = VariableDeclaration.get(pc, this.tm, tk, 5, 44, 4, 0, true, true, true, true, false, null, null, null, vd);
            vu.setUsed();
            vu = VariableDeclaration.get(pc, this.tm, filler, 1, 49, 0, 0, false, false, false, false, false, null, null, space, vd);
            vu.isFiller = true;
            vu.setUsed();
            tk = new Token(10009, "DEBUG-SUB-3", 0, 0, this.tm.getFileName());
            vu = VariableDeclaration.get(pc, this.tm, tk, 5, 50, 4, 0, true, true, true, true, false, null, null, null, vd);
            vu.setUsed();
            vu = VariableDeclaration.get(pc, this.tm, filler, 1, 55, 0, 0, false, false, false, false, false, null, null, space, vd);
            vu.isFiller = true;
            vu.setUsed();
            tk = new Token(10009, "DEBUG-CONTENTS", 0, 0, this.tm.getFileName());
            vu = VariableDeclaration.get(pc, this.tm, tk, 30, 56, 0, 0, false, false, false, false, false, null, null, null, vd);
            vu.setUsed();
        }
        if (pc.getOption("-cms") != null) {
            tk = new Token(10009, "LIN", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicDefaultNum(pc, this.tm, tk, true);
            this.fixedVars.addItem(vd);
            if (cobolProgram) {
                vd.setGlobal();
            }
            vd.setUsed();
            tk = new Token(10009, "COL", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicDefaultNum(pc, this.tm, tk, true);
            this.fixedVars.addItem(vd);
            if (cobolProgram) {
                vd.setGlobal();
            }
            vd.setUsed();
        }
        if (pc.getOption("-csdb2") != null) {
            tk = new Token(10009, "SQL-INIT-FLAG", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicDefaultNum(pc, this.tm, tk, true);
            this.fixedVars.addItem(vd);
            if (cobolProgram) {
                vd.setGlobal();
            }
            vd.setUsed();
        }
    }

    static String getCallBridgeMethodsCode() {
        StringBuffer sb = new StringBuffer();
        sb.append("   final static private Object _getVarAlphanum(int len, CobolVar value) {");
        sb.append(eol);
        sb.append("      return Factory.getVarAlphanum(Factory.getMem(len),0,len,false,value, null,null,null,false,false);");
        sb.append(eol);
        sb.append("   }");
        sb.append(eol);
        sb.append("   final static private Object _getVarNeg(NumericVar value) {");
        sb.append(eol);
        sb.append("      NumericVar nv = Factory.getVarBinary(Factory.getMem(4),0,4,false,null, null,null,null,false,9,0,true,false,false,false);");
        sb.append(eol);
        sb.append("      nv.set(value.num().getUnscaledLong());");
        sb.append(eol);
        sb.append("      return nv;");
        sb.append(eol);
        sb.append("   }");
        sb.append(eol);
        sb.append("   final static private Object _getVarNotNeg(NumericVar value) {");
        sb.append(eol);
        sb.append("      NumericVar nv = Factory.getVarCompX(Factory.getMem(4),0,4,false,null, null,null,null,false,9,0,false,false,false);");
        sb.append(eol);
        sb.append("      nv.set(value.num().getUnscaledLong());");
        sb.append(eol);
        sb.append("      return nv;");
        sb.append(eol);
        sb.append("   }");
        sb.append(eol);
        return sb.toString();
    }

    @Override
    public String[] getScriptFileNames() {
        if (this.scriptList != null) {
            return this.scriptList.toArray(new String[this.scriptList.size()]);
        }
        return null;
    }

    public void addIterator(String str) {
        String itername = str.substring(0, str.indexOf(40));
        if (!this.sqljIterDecl.containsKey(itername = itername.substring(itername.lastIndexOf(32)).trim())) {
            this.sqljIteratorDeclaration = this.sqljIteratorDeclaration + eol + str;
            this.sqljIterDecl.put(itername, str);
        } else if (this.sqljIterDecl.get(itername).length() < str.length()) {
            this.sqljIterDecl.replace(itername, str);
        }
    }

    public void addResultSet(String str) {
        if (!this.sqljResultSetDeclaration.contains(str)) {
            this.sqljResultSetDeclaration = this.sqljResultSetDeclaration + eol + "   " + str;
        }
    }

    public String getSqljResultSetDeclaration() {
        return this.sqljResultSetDeclaration;
    }

    public boolean addIterDeclaration(String str) {
        if (str.equals("qljIter$")) {
            return false;
        }
        if (this.sqljIteratorDeclaration.contains(str)) {
            return false;
        }
        this.sqljIteratorDeclaration = this.sqljIteratorDeclaration + eol + str;
        return true;
    }

    public boolean iterDeclContains(String str) {
        return this.sqljIterDecl.containsKey(str);
    }

    boolean hasSqlj() {
        return this.hasSqlj;
    }

    void setSqlj() {
        this.hasSqlj = true;
    }

    void pushLocalVariables() {
        HashMap<String, VariableDeclaration> map = new HashMap<String, VariableDeclaration>();
        if (!this.localVariables.isEmpty()) {
            map.putAll(this.localVariables.peek());
        }
        this.localVariables.push(map);
    }

    void popLocalVariables() {
        this.localVariables.pop();
    }

    void putLocalVariable(VariableDeclaration vd) throws GeneralErrorException {
        String name;
        Map<String, VariableDeclaration> map = this.localVariables.peek();
        if (map.containsKey(name = vd.getName())) {
            throw new AmbiguousException(vd.getNameToken(), this.error, null);
        }
        map.put(name, vd);
    }

    void doSqljCompilation() throws GeneralErrorException {
        if (this.getProgName() == null || this.getProgName().length() == 0) {
            return;
        }
        String sqlj = Config.getProperty("iscobol.compiler.sqlj", "sqlj");
        String sqljOption = Config.getProperty("iscobol.compiler.sqlj.options", "");
        sqljOption = this.isSqljJJ() ? sqljOption + " -compile=false" : sqljOption + " -compile=true";
        if (this.getOption("-od=") != null) {
            sqljOption = sqljOption + " -d=" + this.getOption("-od=");
        }
        String command = sqlj + " " + sqljOption + " " + this.getProgName();
        try {
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
        }
        catch (Exception e) {
            Token tk = new Token(10001, "", 1, 0, sqlj);
            throw new GeneralErrorException(61, 4, tk, e.getMessage(), this.error);
        }
    }

    boolean isSqljJJ() {
        return jjAndSqlj;
    }

    static {
        MAX_PARAGRAPHS = 300;
        MAX_CONSTANTS = 1000;
        hyphenRepl = (char)95;
        identifierSep = (char)36;
        easyLinkStubs = new HashMap<String, Call>();
        jjAndSqlj = false;
    }

    private static class Ctx {
        byte[] d;
        byte[] m;

        Ctx(byte[] d, byte[] m) {
            this.d = d;
            this.m = m;
        }
    }

    private static final class UseForDebugging {
        final int debuggedParagraphNumber;
        final Paragraph useForDebugSection;

        UseForDebugging(Paragraph p, int n) {
            this.debuggedParagraphNumber = n;
            this.useForDebugSection = p;
        }
    }
}

