/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class On
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Token onTk;
    private VariableName onVn;
    private Token everyTk;
    private VariableName everyVn;
    private Token untilTk;
    private VariableName untilVn;
    private Block onBlock;
    private Block elseBlock;
    private boolean hasElse;
    private NextSentence ns;
    private final String onCounter;

    public On(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        if (!(this.pc instanceof CobolProgram)) {
            throw new GeneralErrorException(19, 4, kw, kw.getWord(), this.error);
        }
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10002) {
            this.onTk = tk;
        } else if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.onVn = VariableName.get(this.tm, this.error, this.pc);
            if (!this.onVn.isInteger()) {
                throw new GeneralErrorException(46, 4, this.onVn.getNameToken(), this.onVn.getName(), this.error);
            }
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 274) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 469) {
                throw new ExpectedFoundException(tk, this.error, "'EVERY'");
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 10002) {
                this.everyTk = tk;
            } else if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.everyVn = VariableName.get(this.tm, this.error, this.pc);
                if (!this.everyVn.isInteger()) {
                    throw new GeneralErrorException(46, 4, this.everyVn.getNameToken(), this.everyVn.getName(), this.error);
                }
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 791) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 10002) {
                this.untilTk = tk;
            } else if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.untilVn = VariableName.get(this.tm, this.error, this.pc);
                if (!this.untilVn.isInteger()) {
                    throw new GeneralErrorException(46, 4, this.untilVn.getNameToken(), this.untilVn.getName(), this.error);
                }
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = this.tm.getToken();
        }
        boolean nextSentAllowed = this.pc.getOption("-cm") != null || this.pc.getOption("-cr") != null || this.pc.getOption("-ca") != null;
        Token nextSentence = null;
        if (nextSentAllowed || tk.getToknum() != 595) {
            this.tm.ungetToken();
            this.onBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        } else {
            nextSentence = tk;
            tk = this.tm.getToken();
            if (tk.getToknum() != 714) {
                throw new ExpectedFoundException(tk, this.error, "SENTENCE");
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 10006 && tk.getToknum() != 417 && tk.getToknum() != 622) {
                throw new ExpectedFoundException(tk, this.error, "ELSE|.");
            }
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 417 || tk.getToknum() == 622) {
            this.hasElse = true;
            tk = this.tm.getToken();
            if (nextSentAllowed || tk.getToknum() != 595) {
                this.tm.ungetToken();
                this.elseBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
            } else {
                nextSentence = tk;
                tk = this.tm.getToken();
                if (tk.getToknum() != 714) {
                    throw new ExpectedFoundException(tk, this.error, "SENTENCE");
                }
                tk = this.tm.getToken();
                if (tk.getToknum() != 10006) {
                    throw new ExpectedFoundException(tk, this.error, ".");
                }
            }
        } else {
            this.tm.ungetToken();
        }
        if (nextSentence != null) {
            this.ns = new NextSentence(nextSentence, par, this.pc, this.tm, this.error);
        }
        this.onCounter = "$onCounters$[" + (((CobolProgram)this.pc).addOnStatement() - 1) + "]";
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append(this.onCounter + "++;" + eol);
        Return2.append(this.parent.getIndent());
        String onEval = "onEval$" + On.getUniqueId();
        Return2.append("int " + onEval + " = ");
        if (this.onTk != null) {
            Return2.append(this.getCodeLiteral(this.onTk));
        } else {
            Return2.append(this.onVn.getCode());
        }
        Return2.append(".toint();");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        Return2.append("if (");
        Return2.append(onEval);
        if ((this.untilTk != null || this.untilVn != null) && this.everyTk == null && this.everyVn == null) {
            Return2.append(" > 0 && ");
            Return2.append(this.onCounter);
            Return2.append(" >= ");
            Return2.append(onEval);
            Return2.append(" && ");
            Return2.append(this.onCounter);
            Return2.append(" < ");
            if (this.untilTk != null) {
                Return2.append(this.getCodeLiteral(this.untilTk));
            } else {
                Return2.append(this.untilVn.getCode());
            }
            Return2.append(".toint()");
        } else {
            Return2.append(" == ");
            Return2.append(this.onCounter);
            if (this.everyTk != null || this.everyVn != null) {
                Return2.append(" || (");
                if (this.untilTk != null || this.untilVn != null) {
                    Return2.append(this.onCounter);
                    Return2.append(" < ");
                    if (this.untilTk != null) {
                        Return2.append(this.getCodeLiteral(this.untilTk));
                    } else {
                        Return2.append(this.untilVn.getCode());
                    }
                    Return2.append(".toint() && ");
                }
                Return2.append(onEval);
                Return2.append(" > 0 && ");
                Return2.append(onEval);
                Return2.append(" < ");
                Return2.append(this.onCounter);
                Return2.append(" && (");
                Return2.append(this.onCounter);
                Return2.append(" - ");
                Return2.append(onEval);
                Return2.append(") % ");
                if (this.everyTk != null) {
                    Return2.append(this.getCodeLiteral(this.everyTk));
                } else {
                    Return2.append(this.everyVn.getCode());
                }
                Return2.append(".toint() == 0)");
            }
        }
        Return2.append(")");
        if (this.onBlock != null) {
            Return2.append(this.onBlock.getCode());
        } else if (this.ns != null) {
            Return2.append("{");
            Return2.append(this.ns.getCode());
            Return2.append("}");
        } else {
            Return2.append("{ // NEXT SENTENCE" + eol + this.parent.getIndent() + "}");
        }
        if (this.hasElse) {
            if (this.elseBlock != null) {
                Return2.append(" else ");
                Return2.append(this.elseBlock.getCode());
            } else if (this.ns != null) {
                Return2.append(" else {" + this.ns.getCode());
                Return2.append("}");
            } else {
                Return2.append(" else { // NEXT SENTENCE" + eol + this.parent.getIndent() + "}");
            }
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }
}

