/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Multiply
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private Token num;
    private Token tokenBy;
    private VariableName var;
    private VariableNameList varByList;
    private VariableNameList varGiving;
    private boolean giving;
    private OnSizeError ose;

    public Multiply(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        VariableName varBy;
        block34: {
            super(kw, par, p, t, err);
            this.varByList = new VariableNameList();
            this.varGiving = new VariableNameList();
            varBy = null;
            tk = this.tm.getToken();
            switch (tk.getToknum()) {
                case 10001: {
                    if (tk.isNull()) {
                        tk.setZero();
                    } else {
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                }
                case 10002: 
                case 10017: {
                    this.num = tk;
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    this.var = VariableName.getAny(this.tm, this.error, this.pc);
                    if (this.var != null && this.var.isNumeric() && !this.var.isEdited()) break;
                    throw new GeneralErrorException(109, 4, tk, tk.getWord(), this.error);
                }
                default: {
                    throw new UnexpectedTokenException(tk, this.error);
                }
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 312) {
                block11: while (true) {
                    tk = this.tm.getToken();
                    switch (tk.getToknum()) {
                        case 702: {
                            if (varBy != null) {
                                varBy.rounded = true;
                                continue block11;
                            }
                            throw new UnexpectedTokenException(tk, this.error);
                        }
                        case 10001: {
                            if (!tk.isNull()) break block34;
                            tk.setZero();
                        }
                        case 10002: 
                        case 10017: {
                            if (this.tokenBy != null) {
                                throw new UnexpectedTokenException(tk, this.error);
                            }
                            this.tokenBy = tk;
                            varBy = null;
                            continue block11;
                        }
                        case 10009: {
                            this.tm.ungetToken();
                            varBy = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                            if (varBy != null && varBy.isNumeric() && !varBy.isEdited()) {
                                this.varByList.addItem(varBy);
                                continue block11;
                            }
                            throw new GeneralErrorException(109, 4, tk, tk.getWord(), this.error);
                        }
                    }
                    break;
                }
            } else {
                throw new ExpectedFoundException(tk, this.error, "BY");
            }
        }
        if (tk.getToknum() == 505) {
            this.giving = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                while (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    varBy = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
                    if (varBy == null || !varBy.isNumeric()) {
                        throw new GeneralErrorException(109, 4, tk, tk.getWord(), this.error);
                    }
                    this.varGiving.addItem(varBy);
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 702) continue;
                    varBy.rounded = true;
                    tk = this.tm.getToken();
                }
                if (this.varByList.getItemNum() > 1) {
                    throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            if (this.varByList.getItemNum() > 0) {
                this.varByList.getFirst().setPropTypeGet();
            }
        } else {
            if (this.tokenBy != null) {
                throw new GeneralErrorException(17, 4, this.tokenBy, this.tokenBy.getWord(), this.error);
            }
            VariableName v = this.varByList.getFirst();
            while (v != null) {
                v.checkPropTypeSetGet();
                v = this.varByList.getNext();
            }
        }
        if (!this.giving && varBy == null || this.varByList.getItemNum() == 0 && this.tokenBy == null) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.ose = new OnSizeError(kw, par, this, p, t, err);
        tk = this.tm.getToken();
        if (tk.getToknum() != 438) {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private String getInitialEvaluation(boolean couldBeNativeInt) {
        StringBuffer Return2 = new StringBuffer();
        if (couldBeNativeInt) {
            if (this.var != null) {
                Return2.append(this.var.getCode());
            } else {
                Return2.append(Expression.toNum(this.num));
            }
            if (this.giving) {
                Return2.append(" * ");
                if (this.tokenBy != null) {
                    Return2.append(Expression.toNum(this.tokenBy));
                } else {
                    Return2.append(this.varByList.getFirst().getCode());
                }
            }
        } else {
            if (this.var != null) {
                Return2.append(Compute.getCobolNumCode(this.var));
            } else {
                Return2.append(this.getCodeLiteral(this.num)).append(".num()");
            }
            if (this.giving) {
                Return2.append(".multiply(");
                if (this.tokenBy != null) {
                    Return2.append(this.getCodeLiteral(this.tokenBy)).append(".num()");
                } else {
                    Return2.append(Compute.getCobolNumCode(this.varByList.getFirst()));
                }
                Return2.append(")");
            }
        }
        return Return2.toString();
    }

    boolean isOptimizable() {
        VariableDeclaration vd;
        if (!this.ose.hasBlocks() && this.varGiving.getItemNum() == 0 && (this.num != null && this.num.getToknum() == 10002 || this.var != null && (vd = this.var.getVarDecl()).isInteger() && vd.getLogicLen() <= 18)) {
            VariableName vn = this.varByList.getFirst();
            while (vn != null) {
                vd = vn.getVarDecl();
                if (vn.rounded && vd.getPNumber() != 0 || !vd.isInteger() || vd.getLogicLen() > 18) {
                    return false;
                }
                vn = this.varByList.getNext();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getCode() {
        int i;
        VariableName vn;
        StringBuffer Return2 = new StringBuffer();
        if (this.isOptimizable()) {
            this.getCodeDebug(Return2);
            VariableName vn2 = this.varByList.getFirst();
            while (vn2 != null) {
                Return2.append(this.parent.getIndent());
                Return2.append(vn2.getCode());
                Return2.append(".multiplyByMe(");
                if (this.num != null) {
                    Return2.append(this.num.getAsLong());
                } else {
                    Return2.append(this.var.getCode());
                    Return2.append(".tolong()");
                }
                Return2.append(");");
                Return2.append(eol);
                vn2 = this.varByList.getNext();
            }
            this.getCodeDebugEnd(Return2);
            return Return2.toString();
        }
        VariableNameList vlDest = this.giving ? this.varGiving : this.varByList;
        boolean couldBeNativeInt = this.var != null ? Expression.couldBeNativeInt(this.var.getVarDecl()) : Expression.couldBeNativeInt(this.num);
        if (couldBeNativeInt && this.giving) {
            couldBeNativeInt = this.tokenBy != null ? (couldBeNativeInt &= Expression.couldBeNativeInt(this.tokenBy)) : (couldBeNativeInt &= Expression.couldBeNativeInt(this.varByList.getFirst().getVarDecl()));
        }
        String initEval = "";
        if (vlDest.getItemNum() > 1) {
            initEval = "mul$" + Multiply.getUniqueId();
            Return2.append(this.parent.getIndent());
            if (couldBeNativeInt) {
                Return2.append("long ");
            } else {
                Return2.append("CobolNum ");
            }
            Return2.append(initEval);
            Return2.append("=");
            Return2.append(this.getInitialEvaluation(couldBeNativeInt));
            Return2.append(";");
            Return2.append(eol);
        } else {
            initEval = this.getInitialEvaluation(couldBeNativeInt);
        }
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        VariableNameList vlDestPrim = new VariableNameList();
        int i2 = 0;
        while (i2 < vlDest.getItemNum()) {
            vn = vlDest.getAt(i2);
            if (vn.isPrimitive()) {
                vlDestPrim.addItem(vn);
                vlDest.deleteCurrent();
                continue;
            }
            ++i2;
        }
        int n = vlDestPrim.getItemNum();
        for (i = 0; i < n; ++i) {
            String val;
            vn = vlDestPrim.getAt(i);
            Return2.append(vn.getCode());
            String t = vn.getType().getName(true);
            Return2.append(" = ");
            if (this.giving) {
                if (couldBeNativeInt) {
                    Return2.append(Compute.addCast(t, initEval));
                } else {
                    Return2.append(Compute.getConversionMethod(t, initEval));
                }
            } else if (Expression.couldBeNativeInt(vn.getVarDecl())) {
                if (couldBeNativeInt) {
                    val = initEval + " * " + vn.getCode();
                    Return2.append(Compute.addCast(t, val));
                } else {
                    Return2.append(Compute.getConversionMethod(t, initEval + ".multiply(CobolNum.noo((long) " + vn.getCode() + ", 0))"));
                }
            } else if (couldBeNativeInt) {
                val = initEval + " * ";
                val = vn.isNumericVar() ? val + vn.getCode() + ".tolong()" : val + vn.getCode();
                Return2.append(Compute.addCast(t, val));
            } else {
                val = initEval + ".multiply(";
                val = vn.isNumericVar() ? val + vn.getCode() + ".num())" : val + "CobolNum.noo((double) " + vn.getCode() + "))";
                Return2.append(Compute.getConversionMethod(t, val));
            }
            Return2.append(";");
            if (i >= n - 1) continue;
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
        }
        n = vlDest.getItemNum();
        if (n > 0) {
            if (vlDestPrim.getItemNum() > 0) {
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
            Return2.append(this.ose.getCodeBefore());
            for (i = 0; i < n; ++i) {
                vn = vlDest.getAt(i);
                Return2.append(vn.getCode());
                Return2.append(".set(");
                if (this.giving) {
                    Return2.append(initEval);
                    if (couldBeNativeInt) {
                        Return2.append(",0");
                    }
                } else {
                    if (couldBeNativeInt) {
                        Return2.append("CobolNum.noo(");
                        Return2.append(initEval);
                        Return2.append(",0)");
                    } else {
                        Return2.append(initEval);
                    }
                    Return2.append(".multiply(");
                    Return2.append(vn.getCode());
                    Return2.append(".num())");
                }
                Return2.append(",");
                Return2.append(vn.rounded);
                Return2.append(",");
                Return2.append(this.ose.hasBlocks());
                Return2.append(")");
                if (i >= n - 1) break;
                Return2.append(this.ose.hasBlocks() ? "|" : ";");
            }
            Return2.append(this.ose.getCode());
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }

    public VariableNameList getVarByList() {
        return this.varByList;
    }

    public VariableNameList getVarGiving() {
        return this.varGiving;
    }

    public Token getNum() {
        return this.num;
    }

    public Token getTokenBy() {
        return this.tokenBy;
    }

    public VariableName getVar() {
        return this.var;
    }
}

