/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class LikeFlags
implements CobolToken,
ErrorsNumbers {
    private static final int CASE_SET = 1;
    private static final int CASE_SENSITIVE = 1;
    private static final int CASE_INSENSITIVE = 3;
    private static final int TRIMMED_LEFT = 4;
    private static final int TRIMMED_RIGHT = 8;
    private static final int TRIMMED = 12;
    private final Errors error;
    private int flags;
    private VariableName vApprox;
    private Token tApprox;

    public LikeFlags(TokenManager tm, Errors err, Pcc pc) throws GeneralErrorException, EndOfProgramException {
        this.error = err;
        Token tk = tm.getToken();
        String word = tk.getWord();
        while (true) {
            if ("TRIMMED".equals(word)) {
                tk.setToknum(10025);
                if ((this.flags & 0xC) != 0) {
                    throw new IllegalConditionException(tk, this.error);
                }
                tk = tm.getToken();
                word = tk.getWord();
                if (tk.getToknum() == 557) {
                    this.flags |= 4;
                    tk = tm.getToken();
                    word = tk.getWord();
                    continue;
                }
                if (tk.getToknum() == 700) {
                    this.flags |= 8;
                    tk = tm.getToken();
                    word = tk.getWord();
                    continue;
                }
                this.flags |= 0xC;
                continue;
            }
            if ("CASE-SENSITIVE".equals(word)) {
                tk.setToknum(10025);
                if ((this.flags & 1) != 0) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.flags |= 1;
                tk = tm.getToken();
                word = tk.getWord();
                continue;
            }
            if ("CASE-INSENSITIVE".equals(word)) {
                tk.setToknum(10025);
                if ((this.flags & 1) != 0) {
                    throw new IllegalConditionException(tk, this.error);
                }
                this.flags |= 3;
                tk = tm.getToken();
                word = tk.getWord();
                continue;
            }
            if (!"APPROX".equals(word)) break;
            tk.setToknum(10025);
            if (this.tApprox != null || this.vApprox != null) {
                throw new IllegalConditionException(tk, this.error);
            }
            tk = tm.getToken();
            if (Token.isIntLit(tk)) {
                this.tApprox = tk;
            } else if (tk.getToknum() == 10009) {
                tm.ungetToken();
                this.vApprox = VariableName.get(tm, this.error, pc);
                if (this.vApprox == null) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = tm.getToken();
            word = tk.getWord();
        }
        tm.ungetToken();
    }

    public void check(Token tk) throws GeneralErrorException {
        String str;
        if (tk != null && (str = tk.getWord()).length() > 2) {
            str = str.substring(1, str.length() - 1);
            try {
                Pattern.compile(str);
            }
            catch (PatternSyntaxException _ex) {
                throw new GeneralErrorException(208, 4, tk, _ex.getMessage(), this.error);
            }
        }
    }

    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if ((this.flags & 3) == 3) {
            Return2.append("CobolVar.LIKE_NOT_CS");
        }
        switch (this.flags & 0xC) {
            case 12: {
                if (Return2.length() > 0) {
                    Return2.append("|");
                }
                Return2.append("CobolVar.LIKE_TRIM");
                break;
            }
            case 4: {
                if (Return2.length() > 0) {
                    Return2.append("|");
                }
                Return2.append("CobolVar.LIKE_L_TRIM");
                break;
            }
            case 8: {
                if (Return2.length() > 0) {
                    Return2.append("|");
                }
                Return2.append("CobolVar.LIKE_R_TRIM");
                break;
            }
            default: {
                if (Return2.length() != 0) break;
                Return2.append("0");
            }
        }
        if (this.tApprox != null) {
            Return2.append(",");
            Return2.append(this.tApprox.longValue());
        } else if (this.vApprox != null) {
            Return2.append(",");
            Return2.append(this.vApprox.getCode());
            Return2.append(".toint()");
        }
        if (Return2.length() > 0) {
            return Return2.toString();
        }
        return "0";
    }
}

