/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.As;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Invoke;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IInlineInvoke;

public class InlineInvoke
extends VariableDeclaration
implements IInlineInvoke {
    private Invoke inlInvoke;
    private VariableName obj;
    private MyClass clazz;
    private As oas;
    private Token lastToken;

    private InlineInvoke(Pcc pr, Token n, TokenManager t) {
        super(pr, n, t);
        this.pc = pr;
        this.parent = null;
        this.name = n;
        this.level = 77;
        this.dimension = 0;
    }

    public InlineInvoke(VariableName o, Block blk, Pcc pr, Token tk, TokenManager t, Errors err) throws EndOfProgramException, GeneralErrorException {
        this(pr, tk, t);
        this.obj = o;
        this.error = err;
        Token kw = new Token(544, "::", tk.getFLN(), tk.getOffset(), tk.getFileName());
        kw.setFileIndex(tk.getFileIndex());
        this.inlInvoke = new Invoke(this.obj, kw, blk, this.pc, t, err);
        tk = this.tm.getToken();
        if (tk.getToknum() == 280) {
            if (o.isLambdaExpression()) {
                throw new GeneralErrorException(274, 4, kw, tk.getWord(), this.error);
            }
            this.oas = new As(kw, blk, pr, t, err, null);
        } else {
            this.tm.ungetToken();
        }
        this.preCheck();
        this.checkInvokeNotifier();
    }

    private void checkInvokeNotifier() throws GeneralErrorException, EndOfProgramException {
        if (Pcc.getInvokeNotifier() != null) {
            this.tm.ungetToken();
            this.lastToken = this.tm.getToken();
            if (!Pcc.getInvokeNotifier().foundInlineInvoke(this)) {
                throw new EndOfProgramException();
            }
        }
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }

    public void preCheck() throws GeneralErrorException {
        this.clazz = this.inlInvoke.getType();
        if (this.oas != null) {
            MyClass asClazz = this.oas.getType();
            if (asClazz == null) {
                throw new MissingClassException(this.oas.as, this.oas.keyWord, this.error);
            }
            if (this.clazz.isPrimitive() && asClazz.isPrimitive()) {
                if (this.clazz.isAssignableFrom(Boolean.TYPE) != asClazz.isAssignableFrom(Boolean.TYPE)) {
                    throw new GeneralErrorException(80, 4, this.inlInvoke.keyWord, asClazz.toString(), this.error);
                }
                this.clazz = asClazz;
                if (!this.isBoolean()) {
                    this.setNumeric(true);
                }
            } else if (!this.clazz.isAssignableFrom(asClazz, false)) {
                throw new GeneralErrorException(80, 4, this.inlInvoke.keyWord, asClazz.toString(), this.error);
            }
            this.clazz = asClazz;
        }
        if (this.clazz != null) {
            if (this.clazz.isAssignableTo(Pcc.TYPES_PACKAGE + ".NumericVar")) {
                this.setNumeric(true);
            } else if (!this.clazz.isAssignableTo(Pcc.TYPES_PACKAGE + ".PicX")) {
                this.setClassName(this.clazz.getName());
            }
        }
    }

    @Override
    public boolean isInteger() {
        return this.clazz.isClass(Byte.TYPE) || this.clazz.isClass(Short.TYPE) || this.clazz.isClass(Integer.TYPE) || this.clazz.isClass(Long.TYPE);
    }

    @Override
    boolean notElementary() {
        return false;
    }

    @Override
    public boolean isField() {
        return this.inlInvoke.isField();
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.clazz == null) {
            this.preCheck();
        }
        this.inlInvoke.check();
    }

    @Override
    public Invoke getInvoke() {
        return this.inlInvoke;
    }

    @Override
    public String getTypeName() {
        return this.clazz.getName();
    }

    @Override
    public boolean isObjectReference() {
        return !this.clazz.isCobolVar() && !this.clazz.isPrimitive();
    }

    @Override
    public boolean isBoolean() {
        return this.clazz.isClass(Boolean.TYPE);
    }

    @Override
    public String getUnivoqueName() {
        if (this.oas == null) {
            return this.inlInvoke.getCode();
        }
        try {
            MyClass clazz = this.inlInvoke.getType();
            if (clazz.isCobolVar() && this.oas.isPrimitiveOrString()) {
                return this.inlInvoke.getCode() + ".to" + this.oas.as + "()";
            }
        }
        catch (GeneralErrorException generalErrorException) {
            // empty catch block
        }
        return "(" + this.oas.getCode() + this.inlInvoke.getCode() + ")";
    }

    @Override
    public String toString() {
        return super.toString() + "::" + this.inlInvoke;
    }
}

