/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class Function
extends VariableDeclaration {
    private static final Set<String> functionNames;
    private Vector arguments;
    private Vector expArgs;
    private Token func;
    private boolean numericArgs;
    private String compileTime;
    private boolean hasArgsWithAll;

    public static boolean is(String name) {
        return functionNames.contains(name);
    }

    private Function(Pcc pr, Token n, TokenManager t) {
        super(pr, n, t);
        this.pc = pr;
        this.parent = null;
        this.name = n;
        this.level = 78;
        this.dimension = 0;
    }

    public Function(Pcc pr, Token n, TokenManager t, boolean numeric) {
        this(pr, n, t);
        this.setNumeric(numeric);
        this.isUsageNumeric = numeric;
    }

    public Function(Pcc pr, Token n, TokenManager t, Errors err) throws EndOfProgramException, GeneralErrorException {
        this(pr, n, t);
        this.error = err;
        this.func = this.tm.getToken();
        switch (this.func.getToknum()) {
            case 558: {
                this.getArguments();
                if (this.arguments == null || this.arguments.size() != 1) {
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                this.setNumeric(true);
                this.isUsageNumeric = true;
                break;
            }
            case 664: {
                this.getExpArgs();
                if (this.expArgs != null && this.expArgs.size() != 1 && this.expArgs.size() != 0) {
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                this.setNumeric(true);
                this.isUsageNumeric = true;
                break;
            }
            case 695: {
                this.getArguments();
                if (this.arguments != null && this.arguments.size() == 1) break;
                throw new GeneralErrorException(80, 4, this.func, "", this.error);
            }
            case 724: {
                this.getExpArgs();
                if (this.expArgs == null || this.expArgs.size() != 1) {
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                this.setNumeric(true);
                this.isUsageNumeric = true;
                break;
            }
            default: {
                String funcWord = this.func.getWord();
                if ("UPPER-CASE".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("LOWER-CASE".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("TRIM".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("TRIMR".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("TRIML".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments != null && this.arguments.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("INTEGER-OF-BOOLEAN".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    Object arg = this.arguments.elementAt(0);
                    if (arg instanceof Token) {
                        Token tk = (Token)arg;
                        if (tk.getToknum() != 10002) {
                            throw new GeneralErrorException(80, 4, this.func, tk.getWord(), this.error);
                        }
                    } else {
                        VariableName vn = (VariableName)arg;
                        if (!vn.getVarDecl().isInteger() && !vn.getVarDecl().isPic1()) {
                            throw new GeneralErrorException(80, 4, this.func, vn.getName(), this.error);
                        }
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("BOOLEAN-OF-INTEGER".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 2) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("INTEGER-OF-DATE".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("INTEGER-OF-DAY".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DATE-OF-INTEGER".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DAY-OF-INTEGER".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DATE-TO-YYYYMMDD".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() < 1 || this.expArgs.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DAY-TO-YYYYDDD".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() < 1 || this.expArgs.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("YEAR-TO-YYYY".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() < 1 || this.expArgs.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MIN".equals(funcWord)) {
                    int nArgs = this.getExpOrVarArgs(true);
                    if (nArgs < 1 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(this.numericArgs);
                    this.isUsageNumeric = this.numericArgs;
                    break;
                }
                if ("ORD-MIN".equals(funcWord)) {
                    int nArgs = this.getExpOrVarArgs(true);
                    if (nArgs < 2 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MAX".equals(funcWord)) {
                    int nArgs = this.getExpOrVarArgs(true);
                    if (nArgs < 1 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(this.numericArgs);
                    this.isUsageNumeric = this.numericArgs;
                    break;
                }
                if ("ORD-MAX".equals(funcWord)) {
                    int nArgs = this.getExpOrVarArgs(true);
                    if (nArgs < 2 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ANNUITY".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MEAN".equals(funcWord)) {
                    int nArgs = this.getExpArgs(true);
                    if (nArgs < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MEDIAN".equals(funcWord)) {
                    int nArgs = this.getExpArgs(true);
                    if (nArgs < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("RANGE".equals(funcWord)) {
                    int nArgs = this.getExpArgs(true);
                    if (nArgs < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MIDRANGE".equals(funcWord)) {
                    int nArgs = this.getExpArgs(true);
                    if (nArgs < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("PRESENT-VALUE".equals(funcWord)) {
                    int nArgs = this.getExpArgs(true);
                    if (nArgs < 2 && !this.hasArgsWithAll) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("STANDARD-DEVIATION".equals(funcWord)) {
                    int nArgs = this.getExpArgs(true);
                    if (nArgs < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("SUM".equals(funcWord)) {
                    int nArgs = this.getExpArgs(true);
                    if (nArgs < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("VARIANCE".equals(funcWord)) {
                    int nArgs = this.getExpArgs(true);
                    if (nArgs < 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("MOD".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("NUMVAL".equals(funcWord) || "NUMVAL-F".equals(funcWord) || "TEST-NUMVAL".equals(funcWord) || "TEST-NUMVAL-F".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("NUMVAL-C".equals(funcWord) || "TEST-NUMVAL-C".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1 && this.arguments.size() != 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("HANDLE-TYPE".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("CHAR".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("ORD".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1 || this.numericArgs) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DEC2HEX".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("HEX2DEC".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DEC2OCT".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("OCT2DEC".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DEC2BIN".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() == 1) break;
                    throw new GeneralErrorException(80, 4, this.func, "", this.error);
                }
                if ("BIN2DEC".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("INTEGER".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("INTEGER-PART".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ABS".equals(funcWord) || "ABSOLUTE-VALUE".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ACOS".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ASIN".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ATAN".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("COS".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("SIN".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("TAN".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("FACTORIAL".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("LOG".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("LOG10".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("SQRT".equals(funcWord)) {
                    int nArgs = this.getExpArgs();
                    if (nArgs != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("REM".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("CURRENT-DATE".equals(funcWord)) {
                    this.getArguments(true, false);
                    break;
                }
                if ("BYTE-LENGTH".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("LENGTH OF".equals(funcWord)) {
                    Token tk = this.tm.getToken();
                    if (tk.getToknum() == 10009) {
                        int dimUsed;
                        this.tm.ungetToken();
                        VariableName vn = VariableName.get(this.tm, this.error, this.pc, false);
                        int dimDecl = vn.getVarDecl().getDimension();
                        if (dimDecl > 0 && (dimUsed = vn.getDimension()) != dimDecl && dimUsed != 0) {
                            throw new GeneralErrorException(189, 4, vn.getNameToken(), vn.getNameToken().getWord(), this.error);
                        }
                        this.arguments = new Vector();
                        this.arguments.addElement(vn);
                    } else if (tk.getToknum() == 10001) {
                        this.arguments = new Vector();
                        this.arguments.addElement(tk);
                    } else {
                        throw new GeneralErrorException(24, 4, this.tm.getToken(), "", this.error);
                    }
                    this.numericArgs = false;
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("ADDRESS OF".equals(funcWord) || "ADDRESS".equals(funcWord)) {
                    Token tk = this.tm.getToken();
                    if (tk.getToknum() != 10009) {
                        throw new GeneralErrorException(24, 4, this.tm.getToken(), "", this.error);
                    }
                    this.tm.ungetToken();
                    VariableName vn = VariableName.get(this.tm, this.error, this.pc);
                    this.arguments = new Vector();
                    this.arguments.addElement(vn);
                    this.numericArgs = false;
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("WHEN-COMPILED".equals(funcWord)) {
                    this.getArguments(true, false);
                    this.setNumeric(false);
                    this.isUsageNumeric = false;
                    this.compileTime = this.whenCompiled();
                    break;
                }
                if ("COMPILED-INFO".equals(funcWord)) {
                    this.getArguments(true, false);
                    this.setNumeric(false);
                    this.isUsageNumeric = false;
                    break;
                }
                if ("E".equals(funcWord) || "PI".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs != null && this.expArgs.size() != 0) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    if (this.expArgs != null) break;
                    this.expArgs = new Vector();
                    break;
                }
                if ("EXP".equals(funcWord) || "EXP10".equals(funcWord) || "FRACTION-PART".equals(funcWord)) {
                    this.getExpArgs();
                    if (this.expArgs == null || this.expArgs.size() != 1) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("CAPACITY".equals(funcWord)) {
                    Token tk = this.tm.getToken();
                    if (tk.getToknum() != 40) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 10009) {
                        this.tm.ungetToken();
                        VariableName vn = VariableName.get(this.tm, err, null, this.pc, false, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
                        VariableDeclaration vd = vn.getVarDecl();
                        if (!vd.isInDynamic()) {
                            throw new GeneralErrorException(255, 4, vn.getNameToken(), vn.getName(), this.error);
                        }
                        if (vn.getDimension() != vd.getDyDimension() - 1) {
                            throw new GeneralErrorException(189, 4, vn.getNameToken(), vn.getName(), this.error);
                        }
                        this.arguments = new Vector();
                        this.arguments.addElement(vn);
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 41) {
                            throw new GeneralErrorException(80, 4, this.func, "", this.error);
                        }
                    } else {
                        throw new GeneralErrorException(24, 4, this.tm.getToken(), "", this.error);
                    }
                    this.numericArgs = false;
                    this.setNumeric(true);
                    this.isUsageNumeric = true;
                    break;
                }
                if ("DISPLAY-OF".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() == 0 || this.arguments.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.checkNational(0);
                    this.checkAlphanumericOrNumeric(1);
                    break;
                }
                if ("NATIONAL-OF".equals(funcWord)) {
                    this.getArguments();
                    if (this.arguments == null || this.arguments.size() == 0 || this.arguments.size() > 2) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.checkAlphanumeric(0);
                    this.checkNationalOrNumeric(1);
                    this.setNational(true);
                    break;
                }
                throw new GeneralErrorException(19, 4, this.func, "FUNCTION " + funcWord, this.error);
            }
        }
    }

    private void checkNational(int argIdx) throws GeneralErrorException {
        if (argIdx < this.arguments.size()) {
            VariableName vn;
            Object arg = this.arguments.elementAt(argIdx);
            if (arg instanceof Token) {
                Token tk = (Token)arg;
                if (!tk.isNational()) {
                    throw new GeneralErrorException(80, 4, tk, tk.getWord(), this.error);
                }
            } else if (arg instanceof VariableName && !(vn = (VariableName)arg).getVarDecl().isNational()) {
                throw new GeneralErrorException(80, 4, vn.getNameToken(), vn.getName(), this.error);
            }
        }
    }

    private void checkNationalOrNumeric(int argIdx) throws GeneralErrorException {
        if (argIdx < this.arguments.size()) {
            VariableName vn;
            Object arg = this.arguments.elementAt(argIdx);
            if (arg instanceof Token) {
                Token tk = (Token)arg;
                if (!(tk.isNational() || tk.getToknum() != 10001 && tk.getBitLen() == 0)) {
                    throw new GeneralErrorException(80, 4, tk, tk.getWord(), this.error);
                }
            } else if (arg instanceof VariableName && !(vn = (VariableName)arg).getVarDecl().isNational() && (!vn.isNumeric() || vn.isEdited() || vn.getVarDecl().isPic1())) {
                throw new GeneralErrorException(80, 4, vn.getNameToken(), vn.getName(), this.error);
            }
        }
    }

    private void checkAlphanumeric(int argIdx) throws GeneralErrorException {
        if (argIdx < this.arguments.size()) {
            VariableName vn;
            Object arg = this.arguments.elementAt(argIdx);
            if (arg instanceof Token) {
                Token tk = (Token)arg;
                if (tk.getToknum() != 10001) {
                    throw new GeneralErrorException(80, 4, tk, tk.getWord(), this.error);
                }
            } else if (arg instanceof VariableName && (vn = (VariableName)arg).isNumeric() && !vn.isEdited()) {
                throw new GeneralErrorException(80, 4, vn.getNameToken(), vn.getName(), this.error);
            }
        }
    }

    private void checkAlphanumericOrNumeric(int argIdx) throws GeneralErrorException {
        if (argIdx < this.arguments.size()) {
            VariableName vn;
            Object arg = this.arguments.elementAt(argIdx);
            if (arg instanceof Token) {
                Token tk = (Token)arg;
                if (tk.getBitLen() > 0) {
                    throw new GeneralErrorException(80, 4, tk, tk.getWord(), this.error);
                }
            } else if (arg instanceof VariableName && (vn = (VariableName)arg).getVarDecl().isPic1()) {
                throw new GeneralErrorException(80, 4, vn.getNameToken(), vn.getName(), this.error);
            }
        }
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    private int getExpArgs() throws EndOfProgramException, GeneralErrorException {
        return this.getExpArgs(false);
    }

    private int getExpArgs(boolean all) throws EndOfProgramException, GeneralErrorException {
        block6: {
            Token tk = this.tm.getToken();
            if (tk.getToknum() != 40) {
                this.tm.ungetToken();
                this.numericArgs = false;
                return 0;
            }
            this.numericArgs = true;
            Expression exp = null;
            VariableName vwall = null;
            this.expArgs = new Vector();
            do {
                if (all && (vwall = VariableName.getTableItemWithAll(this.tm, this.error, this.pc)) != null) {
                    this.numericArgs &= vwall.isNumeric();
                    this.expArgs.addElement(vwall);
                    this.hasArgsWithAll = true;
                } else {
                    exp = new Expression(new int[]{0}, null, null, this.pc, this.tm, this.error);
                    if (!exp.isVoid()) {
                        this.numericArgs &= exp.isNumeric();
                        this.expArgs.addElement(exp);
                    }
                }
                tk = this.tm.getToken();
                if (tk.getToknum() == 41) break block6;
                this.tm.ungetToken();
            } while (vwall != null || exp != null && !exp.isVoid());
            throw new GeneralErrorException(80, 4, this.func, "", this.error);
        }
        if (!this.numericArgs) {
            throw new GeneralErrorException(80, 4, this.func, "", this.error);
        }
        return this.expArgs.size();
    }

    private int getArgumentsAll() throws EndOfProgramException, GeneralErrorException {
        return this.getArguments(false, true);
    }

    private int getArguments() throws EndOfProgramException, GeneralErrorException {
        return this.getArguments(false, false);
    }

    private int getArguments(boolean noArgs, boolean all) throws EndOfProgramException, GeneralErrorException {
        if (noArgs) {
            Token tk = this.tm.getToken();
            if (tk.getToknum() == 40) {
                tk = this.tm.getToken();
                if (tk.getToknum() != 41) {
                    this.tm.ungetToken();
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
            }
            return 0;
        }
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 40) {
            this.tm.ungetToken();
            this.numericArgs = false;
            return 0;
        }
        if (!all) {
            this.numericArgs = true;
        }
        this.arguments = new Vector();
        while (true) {
            tk = this.tm.getToken();
            switch (tk.getToknum()) {
                case 10009: {
                    VariableName vn;
                    this.tm.ungetToken();
                    if (all && (vn = VariableName.getTableItemWithAll(this.tm, this.error, this.pc)) != null) {
                        this.hasArgsWithAll = true;
                    } else {
                        vn = VariableName.get(this.tm, this.error, this.pc);
                    }
                    if (vn == null) {
                        throw new GeneralErrorException(24, 4, tk, "", this.error);
                    }
                    this.arguments.addElement(vn);
                    if (vn.getVarDecl().isNumeric()) {
                        if (!all) break;
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.numericArgs = false;
                    break;
                }
                case 10002: 
                case 10017: {
                    if (all) {
                        throw new GeneralErrorException(80, 4, this.func, "", this.error);
                    }
                    this.arguments.addElement(tk);
                    break;
                }
                case 10001: {
                    this.numericArgs = false;
                    this.arguments.addElement(tk);
                    break;
                }
                case 41: {
                    this.tm.ungetToken();
                    break;
                }
                default: {
                    throw new GeneralErrorException(15, 4, tk, tk.getWord(), this.error);
                }
            }
            if ((tk = this.tm.getToken()).getToknum() == 41) break;
            this.tm.ungetToken();
        }
        return this.arguments.size();
    }

    private int getExpOrVarArgs(boolean all) throws EndOfProgramException, GeneralErrorException {
        TokenManager.Marker mk = this.tm.getMarker();
        this.tm.setMarker(mk);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 40) {
            this.tm.ungetToken();
            this.numericArgs = false;
            return 0;
        }
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10009: {
                VariableName vn;
                this.tm.ungetToken();
                if (all && (vn = VariableName.getTableItemWithAll(this.tm, this.error, this.pc)) != null) {
                    this.hasArgsWithAll = true;
                } else {
                    vn = VariableName.get(this.tm, this.error, this.pc);
                }
                if (vn == null) {
                    throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
                }
                this.numericArgs = vn.getVarDecl().isNumeric();
                break;
            }
            case 10001: {
                this.numericArgs = false;
                break;
            }
            case 10002: 
            case 10017: {
                this.numericArgs = true;
                break;
            }
            case 41: {
                this.numericArgs = false;
                return 0;
            }
            case 40: {
                this.numericArgs = true;
                break;
            }
            default: {
                throw new GeneralErrorException(15, 4, tk, tk.getWord(), this.error);
            }
        }
        this.tm.rewindToMarker(mk);
        if (this.numericArgs) {
            return this.getExpArgs(all);
        }
        if (all) {
            return this.getArgumentsAll();
        }
        return this.getArguments();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String args() {
        StringBuffer arg;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            arg = new StringBuffer();
                            if (this.expArgs == null) break block19;
                            if (this.expArgs.size() == 0) {
                                return "";
                            }
                            if (this.hasArgsWithAll) break block20;
                            break block21;
                        }
                        if (this.arguments == null) return "";
                        if (this.arguments.size() == 0) {
                            return "";
                        }
                        if (this.hasArgsWithAll) break block22;
                        break block23;
                    }
                    int i = 0;
                    do {
                        Object o = this.expArgs.elementAt(i);
                        arg.append(".put(");
                        if (o instanceof VariableName) {
                            arg.append(((VariableName)o).getCode());
                        } else {
                            arg.append(((Expression)o).getCode());
                        }
                        arg.append(")");
                    } while (++i != this.expArgs.size());
                    return arg.toString();
                }
                int i = 0;
                while (true) {
                    Object o;
                    if ((o = this.expArgs.elementAt(i)) instanceof VariableName) {
                        arg.append(((VariableName)o).getCode());
                    } else {
                        arg.append(((Expression)o).getCode());
                    }
                    if (++i == this.expArgs.size()) {
                        return arg.toString();
                    }
                    arg.append(",");
                }
            }
            int i = 0;
            do {
                Object o = this.arguments.elementAt(i);
                arg.append(".put(");
                if (o instanceof VariableName) {
                    arg.append(((VariableName)o).getCode());
                } else {
                    arg.append(this.tm.getCodeLiteral((Token)o));
                }
                arg.append(")");
            } while (++i != this.arguments.size());
            return arg.toString();
        }
        int i = 0;
        while (true) {
            Object o;
            if ((o = this.arguments.elementAt(i)) instanceof VariableName) {
                VariableName vn = (VariableName)o;
                if (vn.getVarDecl().isNational() && vn.hasIndexes()) {
                    arg.append("((PicN) ");
                    arg.append(vn.getCode());
                    arg.append(")");
                } else {
                    arg.append(vn.getCode());
                }
            } else {
                arg.append(this.tm.getCodeLiteral((Token)o));
            }
            if (++i == this.arguments.size()) {
                return arg.toString();
            }
            arg.append(",");
        }
    }

    private String displayOf() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("Functions.displayOf(");
        Return2.append(this.args());
        Return2.append(")");
        return Return2.toString();
    }

    private String integerOfBoolean() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("Functions.integerOfBoolean(");
        Return2.append(this.args());
        Return2.append(",");
        Return2.append(this.tm.getDecimalPointIsComma());
        Return2.append(")");
        return Return2.toString();
    }

    private String booleanOfInteger() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("Functions.booleanOfInteger(");
        Return2.append(this.args());
        Return2.append(")");
        return Return2.toString();
    }

    private String nationalOf() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("Functions.nationalOf(");
        Return2.append(this.args());
        Return2.append(")");
        return Return2.toString();
    }

    private String capacity() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("NumericVar.literal(");
        VariableName vn = (VariableName)this.arguments.elementAt(0);
        SubscriptList sl = vn.getIndexes();
        vn.setIndexes(null);
        Return2.append(vn.getCode());
        vn.setIndexes(sl);
        Return2.append(".getDynamicCapacity(new int[] { ");
        if (sl != null) {
            boolean firstSub = true;
            Subscript s = sl.getFirst();
            while (s != null) {
                if (firstSub) {
                    firstSub = false;
                } else {
                    Return2.append(",");
                }
                Return2.append(s.getCode());
                s = sl.getNext();
            }
        }
        Return2.append(" }, true), 10, 0, false)");
        return Return2.toString();
    }

    private String funcFixArgs(String name) {
        if (this.expArgs == null) {
            return "Functions." + name + "(" + this.args() + ")";
        }
        String arg = this.args();
        if (arg == null || arg.length() == 0) {
            return "Functions." + name + "(" + this.tm.getDecimalPointIsComma() + ")";
        }
        return "Functions." + name + "(" + arg + "," + this.tm.getDecimalPointIsComma() + ")";
    }

    private String funcVarArgs(String name, boolean numeric) {
        if (this.expArgs != null) {
            if (this.hasArgsWithAll) {
                return "Functions." + name + "(new FunctionArgs()" + this.args() + ".nums()," + this.tm.getDecimalPointIsComma() + ")";
            }
            return "Functions." + name + "(new CobolNum[] {" + this.args() + "}," + this.tm.getDecimalPointIsComma() + ")";
        }
        if (numeric) {
            return "Functions." + name + "(new NumericVar[] {" + this.args() + "})";
        }
        if (this.hasArgsWithAll) {
            return "Functions." + name + "(new FunctionArgs()" + this.args() + ".vars())";
        }
        return "Functions." + name + "(new CobolVar[] {" + this.args() + "})";
    }

    private String whenCompiled() {
        GregorianCalendar now = new GregorianCalendar();
        StringBuffer res = new StringBuffer("Factory.getStrLiteral(\"");
        long result = (long)now.get(1) * 1000000000000L;
        result += (long)(now.get(2) + 1) * 10000000000L;
        result += (long)now.get(5) * 100000000L;
        result += (long)(now.get(11) * 1000000);
        result += (long)(now.get(12) * 10000);
        result += (long)(now.get(13) * 100);
        res.append(result += (long)(now.get(14) / 10));
        res.append("00000\")");
        return res.toString();
    }

    @Override
    public String getUnivoqueName() {
        if (this.func == null) {
            return super.getUnivoqueName();
        }
        switch (this.func.getToknum()) {
            case 558: {
                return this.funcFixArgs(this.pc.getOption("-cm") != null ? "lengthComp_5" : "length");
            }
            case 664: {
                return this.funcFixArgs("random");
            }
            case 695: {
                return this.funcFixArgs("reverse");
            }
            case 724: {
                return this.funcFixArgs("sign");
            }
            case 259: 
            case 10009: {
                String funcWord = this.func.getWord();
                if ("UPPER-CASE".equals(funcWord)) {
                    return this.funcFixArgs("upperCase");
                }
                if ("LOWER-CASE".equals(funcWord)) {
                    return this.funcFixArgs("lowerCase");
                }
                if ("TRIM".equals(funcWord)) {
                    return this.funcFixArgs("trim");
                }
                if ("TRIMR".equals(funcWord)) {
                    return this.funcFixArgs("trimr");
                }
                if ("TRIML".equals(funcWord)) {
                    return this.funcFixArgs("triml");
                }
                if ("INTEGER-OF-DATE".equals(funcWord)) {
                    return this.funcFixArgs("integerOfDate");
                }
                if ("INTEGER-OF-DAY".equals(funcWord)) {
                    return this.funcFixArgs("integerOfDay");
                }
                if ("DATE-OF-INTEGER".equals(funcWord)) {
                    return this.funcFixArgs("dateOfInteger");
                }
                if ("DAY-OF-INTEGER".equals(funcWord)) {
                    return this.funcFixArgs("dayOfInteger");
                }
                if ("DATE-TO-YYYYMMDD".equals(funcWord)) {
                    return this.funcFixArgs("dateToYyyyMmDd");
                }
                if ("DAY-TO-YYYYDDD".equals(funcWord)) {
                    return this.funcFixArgs("dayToYyyyDdd");
                }
                if ("YEAR-TO-YYYY".equals(funcWord)) {
                    return this.funcFixArgs("yearToYyyy");
                }
                if ("MIN".equals(funcWord)) {
                    return this.funcVarArgs("min", this.numericArgs);
                }
                if ("MAX".equals(funcWord)) {
                    return this.funcVarArgs("max", this.numericArgs);
                }
                if ("ORD-MIN".equals(funcWord)) {
                    return this.funcVarArgs("ordMin", this.numericArgs);
                }
                if ("ORD-MAX".equals(funcWord)) {
                    return this.funcVarArgs("ordMax", this.numericArgs);
                }
                if ("ANNUITY".equals(funcWord)) {
                    return this.funcFixArgs("annuity");
                }
                if ("MEAN".equals(funcWord)) {
                    return this.funcVarArgs("mean", this.numericArgs);
                }
                if ("MEDIAN".equals(funcWord)) {
                    return this.funcVarArgs("median", this.numericArgs);
                }
                if ("RANGE".equals(funcWord)) {
                    return this.funcVarArgs("range", this.numericArgs);
                }
                if ("MIDRANGE".equals(funcWord)) {
                    return this.funcVarArgs("midrange", this.numericArgs);
                }
                if ("PRESENT-VALUE".equals(funcWord)) {
                    return this.funcVarArgs("presentValue", this.numericArgs);
                }
                if ("STANDARD-DEVIATION".equals(funcWord)) {
                    return this.funcVarArgs("standardDeviation", this.numericArgs);
                }
                if ("SUM".equals(funcWord)) {
                    return this.funcVarArgs("sum", this.numericArgs);
                }
                if ("VARIANCE".equals(funcWord)) {
                    return this.funcVarArgs("variance", this.numericArgs);
                }
                if ("MOD".equals(funcWord)) {
                    return this.funcFixArgs("mod");
                }
                if ("NUMVAL".equals(funcWord)) {
                    return this.funcFixArgs("numVal");
                }
                if ("NUMVAL-C".equals(funcWord)) {
                    return this.funcFixArgs("numValC");
                }
                if ("NUMVAL-F".equals(funcWord)) {
                    return this.funcFixArgs("numValF");
                }
                if ("TEST-NUMVAL".equals(funcWord)) {
                    return this.funcFixArgs("testNumVal");
                }
                if ("TEST-NUMVAL-C".equals(funcWord)) {
                    return this.funcFixArgs("testNumValC");
                }
                if ("TEST-NUMVAL-F".equals(funcWord)) {
                    return this.funcFixArgs("testNumValF");
                }
                if ("HANDLE-TYPE".equals(funcWord)) {
                    return this.funcFixArgs("handleType");
                }
                if ("CHAR".equals(funcWord)) {
                    return this.funcFixArgs("chr");
                }
                if ("ORD".equals(funcWord)) {
                    return this.funcFixArgs("ord");
                }
                if ("HEX2DEC".equals(funcWord)) {
                    return this.funcFixArgs("hex2Dec");
                }
                if ("DEC2HEX".equals(funcWord)) {
                    return this.funcFixArgs("dec2Hex");
                }
                if ("OCT2DEC".equals(funcWord)) {
                    return this.funcFixArgs("oct2Dec");
                }
                if ("DEC2OCT".equals(funcWord)) {
                    return this.funcFixArgs("dec2Oct");
                }
                if ("BIN2DEC".equals(funcWord)) {
                    return this.funcFixArgs("bin2Dec");
                }
                if ("DEC2BIN".equals(funcWord)) {
                    return this.funcFixArgs("dec2Bin");
                }
                if ("INTEGER".equals(funcWord)) {
                    return this.funcFixArgs("integer");
                }
                if ("INTEGER-PART".equals(funcWord)) {
                    return this.funcFixArgs("integerPart");
                }
                if ("ABS".equals(funcWord) || "ABSOLUTE-VALUE".equals(funcWord)) {
                    return this.funcFixArgs("abs");
                }
                if ("ACOS".equals(funcWord)) {
                    return this.funcFixArgs("acos");
                }
                if ("ASIN".equals(funcWord)) {
                    return this.funcFixArgs("asin");
                }
                if ("ATAN".equals(funcWord)) {
                    return this.funcFixArgs("atan");
                }
                if ("COS".equals(funcWord)) {
                    return this.funcFixArgs("cos");
                }
                if ("SIN".equals(funcWord)) {
                    return this.funcFixArgs("sin");
                }
                if ("TAN".equals(funcWord)) {
                    return this.funcFixArgs("tan");
                }
                if ("FACTORIAL".equals(funcWord)) {
                    return this.funcFixArgs("factorial");
                }
                if ("LOG".equals(funcWord)) {
                    return this.funcFixArgs("log");
                }
                if ("LOG10".equals(funcWord)) {
                    return this.funcFixArgs("log10");
                }
                if ("SQRT".equals(funcWord)) {
                    return this.funcFixArgs("sqrt");
                }
                if ("REM".equals(funcWord)) {
                    return this.funcFixArgs("rem");
                }
                if ("CURRENT-DATE".equals(funcWord)) {
                    return this.funcFixArgs("currentDate");
                }
                if ("BYTE-LENGTH".equals(funcWord)) {
                    return this.funcFixArgs("byteLength");
                }
                if ("LENGTH OF".equals(funcWord)) {
                    return this.funcFixArgs(this.pc.getOption("-cm") != null ? "lengthComp_5" : "length");
                }
                if ("WHEN-COMPILED".equals(funcWord)) {
                    return this.compileTime;
                }
                if ("COMPILED-INFO".equals(funcWord)) {
                    String func = "Functions.compiledInfo(";
                    if (this.pc instanceof CobolProgram) {
                        func = func + this.pc.getParent().getFullClassName();
                        func = func + ".this";
                    } else {
                        func = func + this.pc.getRoot().getFullClassName();
                        func = this.pc.isFactory() ? func + ".class" : func + ".this";
                    }
                    func = func + ")";
                    return func;
                }
                if ("ADDRESS OF".equals(funcWord) || "ADDRESS".equals(funcWord)) {
                    return "Factory.getNumLiteral(\"\"+" + this.args() + ".getAddressAsLong(),false)";
                }
                if ("E".equals(funcWord)) {
                    return this.funcFixArgs("e");
                }
                if ("EXP".equals(funcWord)) {
                    return this.funcFixArgs("exp");
                }
                if ("EXP10".equals(funcWord)) {
                    return this.funcFixArgs("exp10");
                }
                if ("FRACTION-PART".equals(funcWord)) {
                    return this.funcFixArgs("fractionPart");
                }
                if ("PI".equals(funcWord)) {
                    return this.funcFixArgs("pi");
                }
                if ("CAPACITY".equals(funcWord)) {
                    return this.capacity();
                }
                if ("DISPLAY-OF".equals(funcWord)) {
                    return this.displayOf();
                }
                if ("NATIONAL-OF".equals(funcWord)) {
                    return this.nationalOf();
                }
                if ("BOOLEAN-OF-INTEGER".equals(funcWord)) {
                    return this.booleanOfInteger();
                }
                if (!"INTEGER-OF-BOOLEAN".equals(funcWord)) break;
                return this.integerOfBoolean();
            }
        }
        return "### " + this.func + " UNKNOWN FUNCTION";
    }

    public Vector getArgumentList() {
        return this.arguments;
    }

    @Override
    boolean notElementary() {
        return false;
    }

    public Vector getExpArgList() {
        return this.expArgs;
    }

    public Token getFunc() {
        return this.func;
    }

    @Override
    boolean isNotXOptimizable(boolean onlyX) {
        return true;
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("ABS");
        s.add("ABSOLUTE-VALUE");
        s.add("ACOS");
        s.add("ADDRESS");
        s.add("ANNUITY");
        s.add("ASIN");
        s.add("ATAN");
        s.add("BIN2DEC");
        s.add("BOOLEAN-OF-INTEGER");
        s.add("BYTE-LENGTH");
        s.add("CAPACITY");
        s.add("CHAR");
        s.add("COMPILED-INFO");
        s.add("COS");
        s.add("CURRENT-DATE");
        s.add("DATE-OF-INTEGER");
        s.add("DATE-TO-YYYYMMDD");
        s.add("DAY-OF-INTEGER");
        s.add("DAY-TO-YYYYDDD");
        s.add("DEC2BIN");
        s.add("DEC2HEX");
        s.add("DEC2OCT");
        s.add("DISPLAY-OF");
        s.add("E");
        s.add("EXP");
        s.add("EXP10");
        s.add("FACTORIAL");
        s.add("FRACTION-PART");
        s.add("INTEGER");
        s.add("INTEGER-OF-BOOLEAN");
        s.add("INTEGER-OF-DATE");
        s.add("INTEGER-OF-DAY");
        s.add("INTEGER-PART");
        s.add("HANDLE-TYPE");
        s.add("HEX2DEC");
        s.add("LENGTH");
        s.add("LOG");
        s.add("LOG10");
        s.add("LOWER-CASE");
        s.add("MAX");
        s.add("MEAN");
        s.add("MEDIAN");
        s.add("MIDRANGE");
        s.add("MIN");
        s.add("MOD");
        s.add("NATIONAL-OF");
        s.add("NUMVAL");
        s.add("NUMVAL-C");
        s.add("NUMVAL-F");
        s.add("PRESENT-VALUE");
        s.add("OCT2DEC");
        s.add("ORD");
        s.add("ORD-MAX");
        s.add("ORD-MIN");
        s.add("RANDOM");
        s.add("RANGE");
        s.add("REM");
        s.add("REVERSE");
        s.add("SIGN");
        s.add("SIN");
        s.add("SQRT");
        s.add("STANDARD-DEVIATION");
        s.add("SUM");
        s.add("TAN");
        s.add("TEST-NUMVAL");
        s.add("TEST-NUMVAL-C");
        s.add("TEST-NUMVAL-F");
        s.add("TRIM");
        s.add("TRIML");
        s.add("TRIMR");
        s.add("UPPER-CASE");
        s.add("VARIANCE");
        s.add("WHEN-COMPILED");
        s.add("YEAR-TO-YYYY");
        functionNames = Collections.unmodifiableSet(s);
    }
}

