/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlAllocate;
import com.iscobol.compiler.SqlCall;
import com.iscobol.compiler.SqlClose;
import com.iscobol.compiler.SqlCommit;
import com.iscobol.compiler.SqlConnect;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlDeclareDatabase;
import com.iscobol.compiler.SqlDeclareVar;
import com.iscobol.compiler.SqlDelete;
import com.iscobol.compiler.SqlDescribe;
import com.iscobol.compiler.SqlDisconnect;
import com.iscobol.compiler.SqlExecute;
import com.iscobol.compiler.SqlFetch;
import com.iscobol.compiler.SqlFree;
import com.iscobol.compiler.SqlGeneric;
import com.iscobol.compiler.SqlInsert;
import com.iscobol.compiler.SqlOpen;
import com.iscobol.compiler.SqlPrepare;
import com.iscobol.compiler.SqlRelease;
import com.iscobol.compiler.SqlRollback;
import com.iscobol.compiler.SqlSavepoint;
import com.iscobol.compiler.SqlSelect;
import com.iscobol.compiler.SqlSet;
import com.iscobol.compiler.SqlUpdate;
import com.iscobol.compiler.SqlValue;
import com.iscobol.compiler.SqlVar;
import com.iscobol.compiler.SqlWhenever;
import com.iscobol.compiler.SqlWith;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import com.iscobol.rts.Config;
import java.util.Hashtable;
import java.util.Locale;

public class ExecSql
extends Verb
implements CobolToken,
ErrorsNumbers {
    static final int SQL_INCLUDE = 10101;
    static final int SQL_CONNECT = 10102;
    static final int SQL_DISCONNECT = 10103;
    static final int SQL_WHENEVER = 10104;
    static final int SQL_COMMIT = 10105;
    static final int SQL_ROLLBACK = 10106;
    static final int SQL_PREPARE = 10107;
    static final int SQL_DECLARE = 10108;
    static final int SQL_EXECUTE = 10109;
    static final int SQL_FETCH = 10110;
    static final int SQL_CLOSE = 10111;
    static final int SQL_OPEN = 10112;
    static final int SQL_ALLOCATE = 10113;
    static final int SQL_FREE = 10114;
    static final int SQL_ALTER = 10115;
    static final int SQL_CREATE = 10116;
    static final int SQL_DROP = 10117;
    static final int SQL_GRANT = 10118;
    static final int SQL_REVOKE = 10119;
    static final int SQL_DESCRIBE = 10120;
    static final int SQL_GET = 10121;
    static final int SQL_SET = 10122;
    static final int SQL_DELETE = 10123;
    static final int SQL_INSERT = 10124;
    static final int SQL_SELECT = 10125;
    static final int SQL_UPDATE = 10126;
    static final int SQL_CALL = 10127;
    static final int SQL_PL_EQ = 10128;
    static final int SQL_PL_CAT = 10129;
    static final int SQL_VAR = 10130;
    static final int SQL_DEALLOCATE = 10131;
    static final int SQL_TRUNCATE = 10132;
    static final int SQL_LOCK = 10133;
    static final int SQL_VALUES = 10134;
    static final int SQL_WITH = 10135;
    static final int SQL_SAVEPOINT = 10136;
    static final int SQL_RELEASE = 10137;
    static final int SQL_DB2_REGISTER = 10199;
    private final VerbList stats = new VerbList();
    private boolean isWhenever;
    private Pcc pcc;
    private static Hashtable sqlToken = new Hashtable();
    private static Pcc lastPcc;

    static int getSqlToken(String s) {
        Integer num = (Integer)sqlToken.get(s.toUpperCase(Locale.US));
        if (num != null) {
            return num;
        }
        return 0;
    }

    public ExecSql(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token dbTk;
        SqlSet set = null;
        VariableName forVar = null;
        int forVal = 0;
        this.pcc = p;
        this.init();
        t.inExecSql = true;
        TokenManager.Marker mk = this.tm.getMarker();
        this.tm.setMarker(mk);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 58) {
            VariableName intoVar = VariableName.get(this.tm, this.error, this.pc);
            if (intoVar == null) {
                throw new UnexpectedTokenException(this.tm.getToken(), this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 61) {
                tk = this.tm.getToken();
                if (!tk.getWord().equals("CALL")) {
                    this.tm.rewindToMarker(mk);
                    tk = this.tm.getToken();
                    mk = null;
                }
            } else {
                this.tm.rewindToMarker(mk);
                tk = this.tm.getToken();
                mk = null;
            }
        } else {
            mk = null;
        }
        if (tk.getWord().equals("AT")) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 58) {
                VariableName atVar = VariableName.get(this.tm, this.error, this.pc);
                if (atVar == null) {
                    throw new UnexpectedTokenException(this.tm.getToken(), this.error);
                }
                set = new SqlSet(this, tk, atVar, par, p, t, err);
                tk = this.tm.getToken();
            } else {
                dbTk = new Token(tk);
                dbTk.setToknum(10001);
                dbTk.setWord("'" + tk.getWord().replace('-', '_') + "'");
                set = new SqlSet(this, dbTk, null, par, p, t, err);
                tk = this.tm.getToken();
            }
        } else if (p.inProcedure && p.getOption("-xsqlc") != null || p.getOption("-xsqlc") == null && p.hasAnySqlDatabase()) {
            dbTk = new Token(tk);
            dbTk.setToknum(10001);
            dbTk.setWord("'DEFAULT'");
            set = new SqlSet(this, dbTk, null, par, p, t, err);
        }
        if (tk.getToknum() == 494) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 58) {
                forVar = VariableName.get(this.tm, this.error, this.pc);
                if (forVar == null) {
                    throw new UnexpectedTokenException(this.tm.getToken(), this.error);
                }
                tk = this.tm.getToken();
            } else if (tk.getToknum() == 10002) {
                forVal = Integer.parseInt(tk.getWord());
                tk = this.tm.getToken();
            } else {
                throw new UnexpectedTokenException(this.tm.getToken(), this.error);
            }
        }
        if (tk.getWord().equals("BEGIN") || tk.getWord().equals("END")) {
            while ((tk = this.tm.getToken()).getToknum() != 432) {
            }
        }
        this.tm.ungetToken();
        block34: while ((tk = this.tm.getToken()).getToknum() != 432) {
            if (tk.getToknum() == 10021) continue;
            try {
                int sqlTk = ExecSql.getSqlToken(tk.getWord());
                if (par == null && sqlTk != 10108 && sqlTk != 10130) {
                    throw new GeneralErrorException(136, 4, tk, tk.getWord(), this.error);
                }
                if (ExecSql.getSqlToken(tk.getWord()) != 10110 && ExecSql.getSqlToken(tk.getWord()) != 10123 && ExecSql.getSqlToken(tk.getWord()) != 10109 && ExecSql.getSqlToken(tk.getWord()) != 10124 && ExecSql.getSqlToken(tk.getWord()) != 10125 && ExecSql.getSqlToken(tk.getWord()) != 10126 && (forVar != null || forVal != 0)) {
                    throw new GeneralErrorException(115, 4, tk, "FOR in " + tk.getWord(), this.error);
                }
                switch (ExecSql.getSqlToken(tk.getWord())) {
                    case 10102: {
                        this.stats.addItem(new SqlConnect(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10103: {
                        this.stats.addItem(new SqlDisconnect(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10104: {
                        this.isWhenever = true;
                        SqlWhenever we = new SqlWhenever(this, tk, par, p, t, err);
                        this.stats.addItem(we);
                        if (we.isWarning()) {
                            this.pc.warning = we;
                            continue block34;
                        }
                        if (we.isNotFound()) {
                            this.pc.notFound = we;
                            continue block34;
                        }
                        this.pc.werror = we;
                        continue block34;
                    }
                    case 10105: {
                        if (set != null) {
                            this.stats.addItem(set);
                        }
                        this.stats.addItem(new SqlCommit(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10106: {
                        if (set != null) {
                            this.stats.addItem(set);
                        }
                        this.stats.addItem(new SqlRollback(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10125: {
                        if (set != null) {
                            this.stats.addItem(set);
                        }
                        this.stats.addItem(new SqlSelect(this, tk, par, p, t, forVar, forVal, err, true));
                        continue block34;
                    }
                    case 10124: {
                        if (set != null) {
                            this.stats.addItem(set);
                        }
                        this.stats.addItem(new SqlInsert(this, tk, par, p, t, forVar, forVal, err));
                        continue block34;
                    }
                    case 10108: {
                        Token sTk;
                        boolean dot = false;
                        int globalTemporary = 0;
                        int tokRead = 0;
                        ++tokRead;
                        while ((sTk = this.tm.getToken()) != null && sTk.getToknum() == 10021) {
                            ++tokRead;
                        }
                        if ((t.getOptionList().getOption("-csdb2") != null || Config.getProperty(".compiler.esql.db2", false)) && sTk.getToknum() == 58) {
                            this.stats.addItem(new SqlDeclareVar(this, tk, p, t, err));
                            continue block34;
                        }
                        if (sTk.getWord().equals("GLOBAL")) {
                            ++globalTemporary;
                        }
                        ++tokRead;
                        while ((sTk = this.tm.getToken()) != null && sTk.getToknum() == 10021) {
                            ++tokRead;
                        }
                        if (sTk.getWord().equals(".")) {
                            dot = true;
                            ++tokRead;
                            while ((sTk = this.tm.getToken()) != null && sTk.getToknum() == 10021) {
                                ++tokRead;
                            }
                            ++tokRead;
                            while ((sTk = this.tm.getToken()) != null && sTk.getToknum() == 10021) {
                                ++tokRead;
                            }
                        } else if (sTk.getWord().equals("TEMPORARY")) {
                            ++globalTemporary;
                            ++tokRead;
                            while ((sTk = this.tm.getToken()) != null && sTk.getToknum() == 10021) {
                                ++tokRead;
                            }
                        }
                        if (sTk.getWord().equals("SENSITIVE") || sTk.getWord().equals("INSENSITIVE")) {
                            ++tokRead;
                            while ((sTk = this.tm.getToken()) != null && sTk.getToknum() == 10021) {
                                ++tokRead;
                            }
                        }
                        if (sTk.getWord().equals("SCROLL")) {
                            ++tokRead;
                            while ((sTk = this.tm.getToken()) != null && sTk.getToknum() == 10021) {
                                ++tokRead;
                            }
                        }
                        while (tokRead > 0) {
                            this.tm.ungetToken();
                            --tokRead;
                        }
                        if (globalTemporary == 2) {
                            this.tm.getToken();
                        }
                        if (sTk.getWord().equals("CURSOR")) {
                            if (set != null) {
                                this.stats.addItem(set);
                            }
                            this.stats.addItem(new SqlDeclareCursor(this, tk, p, t, err));
                            continue block34;
                        }
                        if (sTk.getWord().equals("TABLE")) {
                            if (globalTemporary != 2) {
                                new SqlGeneric(this, tk, par, p, t, err);
                                continue block34;
                            }
                            if (set != null) {
                                this.stats.addItem(set);
                            }
                            this.tm.ungetToken();
                            this.stats.addItem(new SqlGeneric(this, tk, par, p, t, err));
                            continue block34;
                        }
                        if (sTk.getWord().equals("DATABASE")) {
                            new SqlDeclareDatabase(this, tk, p, t, err);
                            continue block34;
                        }
                        if (sTk.getWord().equals("STATEMENT")) {
                            new SqlDeclareCursor(this, tk, p, t, err);
                            continue block34;
                        }
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    case 10110: {
                        this.stats.addItem(new SqlFetch(this, tk, par, p, t, forVar, forVal, err));
                        continue block34;
                    }
                    case 10112: {
                        this.stats.addItem(new SqlOpen(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10123: {
                        if (set != null) {
                            this.stats.addItem(set);
                        }
                        this.stats.addItem(new SqlDelete(this, tk, par, p, t, forVar, forVal, err));
                        continue block34;
                    }
                    case 10126: {
                        if (set != null) {
                            this.stats.addItem(set);
                        }
                        this.stats.addItem(new SqlUpdate(this, tk, par, p, t, forVar, forVal, err));
                        continue block34;
                    }
                    case 10127: {
                        if (set != null) {
                            this.stats.addItem(set);
                        }
                        this.stats.addItem(new SqlCall(this, tk, par, p, t, err, mk));
                        continue block34;
                    }
                    case 10107: {
                        this.stats.addItem(new SqlPrepare(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10109: {
                        if (set != null) {
                            this.stats.addItem(set);
                        }
                        this.stats.addItem(new SqlExecute(this, tk, par, p, t, forVar, forVal, err));
                        continue block34;
                    }
                    case 10111: {
                        this.stats.addItem(new SqlClose(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10115: 
                    case 10116: 
                    case 10117: 
                    case 10118: 
                    case 10119: 
                    case 10132: 
                    case 10133: {
                        if (set != null) {
                            this.stats.addItem(set);
                        }
                        this.stats.addItem(new SqlGeneric(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10121: {
                        continue block34;
                    }
                    case 10122: {
                        Token tok;
                        Token sTk = this.tm.getToken();
                        this.tm.ungetToken();
                        while ((tok = this.tm.getToken()) != null && tok.getToknum() != 432) {
                            if (tok.getToknum() == 10021) continue;
                            this.tm.ungetToken();
                            this.stats.addItem(new SqlSet(this, tk, par, p, t, err));
                        }
                        this.tm.ungetToken();
                        continue block34;
                    }
                    case 10101: 
                    case 10131: {
                        while ((tk = this.tm.getToken()).getToknum() != 432) {
                        }
                        this.tm.ungetToken();
                        continue block34;
                    }
                    case 432: {
                        continue block34;
                    }
                    case 10113: {
                        this.stats.addItem(new SqlAllocate(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10114: {
                        this.stats.addItem(new SqlFree(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10130: {
                        this.stats.addItem(new SqlVar(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10120: {
                        this.stats.addItem(new SqlDescribe(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10134: {
                        if (t.getOptionList().getOption("-csdb2") != null || Config.getProperty(".compiler.esql.db2", false)) {
                            this.stats.addItem(new SqlValue(this, tk, par, p, t, null, 0, err, true));
                            continue block34;
                        }
                    }
                    case 10135: {
                        this.stats.addItem(new SqlWith(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10136: {
                        this.stats.addItem(new SqlSavepoint(this, tk, par, p, t, err));
                        continue block34;
                    }
                    case 10137: {
                        this.stats.addItem(new SqlRelease(this, tk, par, p, t, err));
                        continue block34;
                    }
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
            catch (GeneralErrorException e) {
                while (this.tm.getToken().getToknum() != 432) {
                }
                throw e;
            }
        }
        t.inExecSql = false;
    }

    private void init() {
        if (lastPcc != this.pc) {
            Pcc par = this.pc instanceof CobolMethod ? this.pc : this.pc.parent;
            Token tk = new Token(10009, "ESQL-CURS-HNDL", 0, 0, this.tm.getFileName());
            VariableDeclaration vd = VariableDeclaration.getHandle(par, this.tm, tk);
            this.pc.fixedVars.addItem(vd);
            this.pc.loadVariable(vd);
            vd.setUsed();
            tk = new Token(10009, "ESQL-BIND-IND", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicDefaultNum(par, this.tm, tk, true);
            this.pc.fixedVars.addItem(vd);
            this.pc.loadVariable(vd);
            vd.setUsed();
            tk = new Token(10009, "ESQL-BIND-TYPE", 0, 0, this.tm.getFileName());
            vd = VariableDeclaration.getPicDefaultNum(par, this.tm, tk, true);
            this.pc.fixedVars.addItem(vd);
            this.pc.loadVariable(vd);
            vd.setUsed();
            lastPcc = this.pc;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        Verb v = this.stats.getFirst();
        while (v != null) {
            v.check();
            v = this.stats.getNext();
        }
        if (this.pcc.getOption("-sqlj") != null) {
            this.pcc.setSqlj();
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (!this.isWhenever) {
            Verb v = this.stats.getFirst();
            while (v != null) {
                Return2.append(v.getCode());
                v = this.stats.getNext();
            }
        }
        return Return2.toString();
    }

    public VerbList getStatements() {
        return this.stats;
    }

    public SqlWhenever getWhenError() {
        return this.pc.werror;
    }

    public SqlWhenever getWhenWarn() {
        return this.pc.warning;
    }

    public SqlWhenever getWhenNotFound() {
        return this.pc.notFound;
    }

    static {
        sqlToken.put("INCLUDE", new Integer(10101));
        sqlToken.put("CONNECT", new Integer(10102));
        sqlToken.put("DISCONNECT", new Integer(10103));
        sqlToken.put("WHENEVER", new Integer(10104));
        sqlToken.put("COMMIT", new Integer(10105));
        sqlToken.put("ROLLBACK", new Integer(10106));
        sqlToken.put("PREPARE", new Integer(10107));
        sqlToken.put("DECLARE", new Integer(10108));
        sqlToken.put("EXECUTE", new Integer(10109));
        sqlToken.put("FETCH", new Integer(10110));
        sqlToken.put("CLOSE", new Integer(10111));
        sqlToken.put("OPEN", new Integer(10112));
        sqlToken.put("ALTER", new Integer(10115));
        sqlToken.put("CREATE", new Integer(10116));
        sqlToken.put("DROP", new Integer(10117));
        sqlToken.put("GRANT", new Integer(10118));
        sqlToken.put("REVOKE", new Integer(10119));
        sqlToken.put("ALLOCATE", new Integer(10113));
        sqlToken.put("FREE", new Integer(10114));
        sqlToken.put("DESCRIBE", new Integer(10120));
        sqlToken.put("GET", new Integer(10121));
        sqlToken.put("SET", new Integer(10122));
        sqlToken.put("DELETE", new Integer(10123));
        sqlToken.put("INSERT", new Integer(10124));
        sqlToken.put("SELECT", new Integer(10125));
        sqlToken.put("UPDATE", new Integer(10126));
        sqlToken.put("CALL", new Integer(10127));
        sqlToken.put("VAR", new Integer(10130));
        sqlToken.put("DEALLOCATE", new Integer(10131));
        sqlToken.put("TRUNCATE", new Integer(10132));
        sqlToken.put("LOCK", new Integer(10133));
        sqlToken.put("DESCRIBE", new Integer(10120));
        sqlToken.put("VALUES", new Integer(10134));
        sqlToken.put("WITH", new Integer(10135));
        sqlToken.put("SAVEPOINT", new Integer(10136));
        sqlToken.put("RELEASE", new Integer(10137));
    }
}

