/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExecHandlerIntf;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.NoExec;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Verb;
import java.util.StringTokenizer;

public class Exec
extends Verb
implements CobolToken,
ErrorsNumbers {
    Verb statement;
    private NoExec unknownExec;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Exec(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        String type = tk.getWord().toLowerCase();
        if (tk.getToknum() != 10009) throw new UnexpectedTokenException(tk, this.error);
        if (p.options.getOption("-noexec") != null) {
            this.unknownExec = new NoExec(kw, tk, par, p, t, err);
            this.statement = this.unknownExec;
            return;
        } else if ("sql".equals(type)) {
            this.statement = new ExecSql(kw, par, p, t, err);
            return;
        } else {
            String execs = p.options.getOption("-exec=");
            if (execs == null) throw new GeneralErrorException(19, 4, tk, "EXEC " + tk.getWord(), this.error);
            StringTokenizer st = new StringTokenizer(execs, ",");
            int j = 0;
            while (st.hasMoreTokens()) {
                ExecHandlerIntf eh;
                if (type.equals(st.nextToken()) && (eh = p.getExecHandler(tk.getWord().toLowerCase())) != null) {
                    this.statement = eh.parse(kw, par, p, t, err);
                    return;
                }
                ++j;
            }
            throw new GeneralErrorException(19, 4, tk, "EXEC " + tk.getWord(), this.error);
        }
    }

    public NoExec getUnknownExec() {
        return this.unknownExec;
    }

    public boolean isUnknown() {
        return this.unknownExec != null;
    }

    public Verb getStatement() {
        return this.statement;
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.statement != null) {
            this.statement.check();
        }
    }

    @Override
    public String getCode() {
        if (this.statement != null) {
            return this.statement.getCode();
        }
        return "";
    }

    public void getCode(StringBuffer dynPart) {
        if (this.statement != null) {
            dynPart.append(this.statement.getCode());
        }
    }
}

