/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ConfigurationSection;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InputOutputSection;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.interfaces.compiler.IEnvironmentDivision;

public class EnvironmentDivision
implements CobolToken,
ErrorsNumbers,
IEnvironmentDivision {
    TokenManager tm;
    Errors error;
    ConfigurationSection confSec;
    private InputOutputSection IOsec;
    Pcc pc;
    private Token firstToken;

    public EnvironmentDivision(Pcc p, TokenManager t, Errors err, Token firstToken) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        this.firstToken = firstToken;
        this.pc = p;
        boolean goOn = true;
        this.error = err;
        this.tm = t;
        block8: while (goOn && (tk = this.tm.getToken()).getToknum() != 388 && tk.getToknum() != 651 && tk.getToknum() != 521 && tk.getToknum() != 522) {
            switch (tk.getToknum()) {
                case 367: {
                    if (this.confSec != null) {
                        throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
                    }
                    try {
                        if (p instanceof CobolMethod) {
                            throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                        }
                        this.confSec = new ConfigurationSection(this.pc, this.tm, this.error, tk);
                    }
                    catch (GeneralErrorException e) {
                        this.tm.skipToDot();
                    }
                    continue block8;
                }
                case 535: {
                    if (this.IOsec != null) {
                        throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
                    }
                    try {
                        this.IOsec = new InputOutputSection(this.pc, this.tm, this.error, tk);
                    }
                    catch (GeneralErrorException e) {
                        this.tm.skipToDot();
                    }
                    continue block8;
                }
            }
            goOn = false;
        }
        this.tm.ungetToken();
    }

    public void check(Pcc pc) {
        if (this.confSec != null) {
            this.confSec.check(pc);
        }
        if (this.IOsec != null) {
            this.IOsec.check(pc);
        }
    }

    public SelectList getSelects() {
        if (this.IOsec != null) {
            return this.IOsec.selects;
        }
        return null;
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.confSec;
    }

    @Override
    public InputOutputSection getInputOutputSection() {
        return this.IOsec;
    }

    public String getCode(StringBuffer dynPart) throws GeneralErrorException {
        StringBuffer Return2 = new StringBuffer();
        if (this.confSec != null) {
            Return2.append(this.confSec.getCode(dynPart));
        }
        if (this.IOsec != null) {
            Return2.append(this.IOsec.getCode(dynPart));
            if (this.pc.options.getOption("-efd") != null || this.pc.options.getOption("-efa") != null || this.pc.options.getOption("-efc") != null || this.pc.options.getOption("-efo=") != null) {
                this.IOsec.makeEFD();
            }
        }
        return Return2.toString();
    }

    public void makeEFDFile() throws GeneralErrorException {
        if (this.IOsec != null && (this.pc.options.getOption("-efd") != null || this.pc.options.getOption("-efc") != null || this.pc.options.getOption("-efa") != null || this.pc.options.getOption("-efo=") != null)) {
            this.IOsec.makeEFD();
        }
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }
}

