/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;

class EfdHint {
    private String hintString = null;
    private int hintIdx;
    private int number = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    EfdHint(TokenList tl) {
        Token tk = tl.getNext();
        if (tk.getToknum() != 61) throw new NullPointerException();
        tk = tl.getNext();
        if (tk.getToknum() != 10002) throw new NullPointerException();
        this.hintIdx = tk.longValue();
        tk = tl.getNext();
        if (tk.getToknum() != 58) throw new NullPointerException();
        tk = tl.getNext();
        if (tk.getToknum() == 10001) {
            this.hintString = tk.getWord().substring(1, tk.getWord().length() - 1);
            return;
        } else {
            if (tk.getToknum() != 10002) throw new NullPointerException();
            this.number = tk.longValue();
        }
    }

    public String getString() {
        return this.hintString;
    }

    public int getIdx() {
        return this.hintIdx;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void getCode(StringBuffer buff, String eol, String indent) {
        indent = indent + " ";
        buff.append(indent);
        if (this.hintString.equals("")) {
            buff.append("<hint idx='");
            buff.append(this.number);
        } else {
            buff.append("<hint string='");
            buff.append(this.hintString);
        }
        buff.append("'/>");
        buff.append(eol);
    }
}

