/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ScreenAttribute;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.AcceptException;
import java.util.GregorianCalendar;

public class Accept
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int TYPE_OMITTED = 0;
    public static final int TYPE_FROMTIME = 1;
    public static final int TYPE_FROMDATE = 2;
    public static final int TYPE_FROMDAY = 3;
    public static final int TYPE_FROMDAYOFWEEK = 4;
    public static final int TYPE_FROM_CONSOLE = 5;
    public static final int TYPE_FROM_SYSTEMINFO = 6;
    public static final int TYPE_FROM_TERMINALINFO = 7;
    public static final int TYPE_FROM_ENVIRONM = 8;
    public static final int TYPE_FROM_COMMAND_LINE = 9;
    public static final int TYPE_STANDARD_OBJECT = 10;
    public static final int TYPE_FROM_SCREEN = 11;
    public static final int TYPE_FROM_ESCAPE = 12;
    public static final int TYPE_FROM_WINDOW_HDL = 13;
    public static final int TYPE_FROM_CENTURYDATE = 14;
    public static final int TYPE_FROM_CENTURYDAY = 15;
    public static final int TYPE_FROM_CONTROL_HDL = 16;
    public static final int TYPE_FROM_INPUT_STATUS = 17;
    public static final int TYPE_GUI_OR_CONSOLE = 18;
    public static final int TYPE_FROM_LINE_NUMBER = 19;
    public static final int TYPE_FROM_ENVIRONMENT_VALUE = 20;
    public static final int TYPE_FROM_ENVIRONMENT_NAME = 21;
    public static final int TYPE_FROMDATEANDTIME = 22;
    public static final int TYPE_CGI = 23;
    public static final int TYPE_FROM_WINDOW_OF_THREAD = 24;
    public static final int TYPE_FROM_EXCEPTION_STATUS = 25;
    public static final int TYPE_FROM_SYSIN = 26;
    public static final int TYPE_FROM_DATE_COMPILED = 27;
    int type;
    VariableName var;
    private boolean control = false;
    VariableName keyDest;
    BlockException onException;
    Block notOnException;
    Token envToken;
    VariableName envVar;
    Token standardObjectToken;
    VariableName standardObjectVar;
    private boolean not;
    private boolean isscreenname;
    private static int countAccept = 0;
    int currcountAccept = 0;
    ScreenAttribute sa;
    AcceptFromScreen afs;
    Token tk_timeout;
    VariableName vn_timeout;
    Token tk_mouseFlags;
    VariableName vn_mouseFlags;
    private boolean ishandle;
    private boolean beforeTime;
    private Condition untilCond;
    private String onexceptionexit = null;
    private boolean guiWd2UnsupportedLog = this.pc.getOption("-wd2") != null;
    private boolean httpUnsupportedLog = this.pc.getOption("-whttp") != null;
    VariableName threadvar;
    private boolean vansi;
    private boolean endacceptpermitted = true;
    private boolean optionCA = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Accept(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.currcountAccept = countAccept++;
        this.onexceptionexit = t.getOptionList().getOption("-vx");
        this.optionCA = t.getOptionList().getOption("-ca") != null;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 40 && this.pc.getOption("-cms") != null) {
            if (this.guiWd2UnsupportedLog) {
                this.error.print(179, 2, tk, "ACCEPT");
            }
            if (this.httpUnsupportedLog) {
                this.error.print(232, 2, kw, kw.getWord());
            }
            this.sa = new ScreenAttribute(kw, this.parent, null, this.pc, this.tm, this.error, 2);
            this.sa.msLocate();
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new UnexpectedTokenException(tk, this.error);
            }
            this.tm.ungetToken();
            this.var = VariableName.get(this.tm, this.error, null, this.pc, true, true, false, true);
            this.loadAcceptToken(this.sa);
            this.type = 18;
        } else if (tk.getToknum() == 10009) {
            Token tksave = tk;
            this.tm.ungetToken();
            this.var = VariableName.get(this.tm, this.error, null, this.pc, true, true, false, true, new GetVarOpts(this, 2));
            if (this.var.getVarDecl().isExternalForm()) {
                this.type = 23;
                return;
            }
            if (this.var.getVarDecl().isControlHandle() || this.var.getVarDecl().isGenericHandle()) {
                this.ishandle = true;
            }
            this.isscreenname = this.isScreenName(this.var);
            if (this.isscreenname && ((VariableDeclarationScreen)this.var.getVarDecl()).isdisplaygroupheader) {
                throw new GeneralErrorException(19, 4, this.var.getNameToken(), this.var.getNameToken().getWord() + " control is group of controls ", this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 498) {
                this.var.setPropTypeSet();
                tk = this.tm.getToken();
                String word = this.pc.getMnemonicSystem(tk.getWord());
                if (tk.getToknum() == 10009 && word.equalsIgnoreCase("SYSIN")) {
                    this.type = 26;
                } else if (tk.getToknum() == 368) {
                    this.type = 5;
                } else if (tk.getToknum() == 389) {
                    this.endacceptpermitted = false;
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 821) {
                        this.type = t.getOptionList().getOption("-zy") != null ? 14 : 2;
                        this.tm.ungetToken();
                    } else {
                        this.type = 14;
                    }
                } else if (tk.getToknum() == 390) {
                    this.type = 27;
                } else if (tk.getWord().equals("CENTURY-DATE")) {
                    this.endacceptpermitted = false;
                    this.type = 14;
                } else if (tk.getToknum() == 392) {
                    this.endacceptpermitted = false;
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 820) {
                        this.type = t.getOptionList().getOption("-zy") != null ? 15 : 3;
                        this.tm.ungetToken();
                    } else {
                        this.type = 15;
                    }
                } else if (tk.getWord().equals("CENTURY-DAY")) {
                    this.endacceptpermitted = false;
                    this.type = 15;
                } else if (tk.getWord().equals("DATE-AND-TIME")) {
                    this.endacceptpermitted = false;
                    this.type = 22;
                } else if (tk.getToknum() == 393) {
                    this.endacceptpermitted = false;
                    this.type = 4;
                } else if (tk.getToknum() == 769) {
                    this.endacceptpermitted = false;
                    this.type = 1;
                } else if (tk.getToknum() == 565) {
                    this.endacceptpermitted = false;
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 602) {
                        this.tm.ungetToken();
                    }
                    this.type = 19;
                } else if (tk.getToknum() == 758) {
                    this.endacceptpermitted = false;
                    this.type = 7;
                    this.pc.useScreen = true;
                } else if (tk.getToknum() == 466) {
                    this.endacceptpermitted = false;
                    this.type = 12;
                    this.pc.useScreen = true;
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 551) {
                        this.tm.ungetToken();
                    }
                } else {
                    if (tk.getToknum() == 705) {
                        this.endacceptpermitted = false;
                        this.type = 11;
                        this.afs = new AcceptFromScreen(this.keyWord, this.parent, this.pc, this.tm, this.error, tk);
                        return;
                    }
                    if (tk.getToknum() == 763) {
                        this.endacceptpermitted = false;
                        this.type = 763;
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 510) {
                            this.tm.ungetToken();
                        }
                        this.ishandle = false;
                    } else if (tk.getToknum() == 754) {
                        this.endacceptpermitted = false;
                        this.type = 6;
                    } else if (tk.getToknum() == 340) {
                        this.endacceptpermitted = false;
                        this.type = 9;
                    } else if (tk.getWord().equalsIgnoreCase("ENVIRONMENT-VALUE") || tk.getWord().equalsIgnoreCase(this.tm.getEnvValue())) {
                        this.endacceptpermitted = false;
                        this.type = 20;
                    } else if (tk.getWord().equalsIgnoreCase("ENVIRONMENT-NAME") || tk.getWord().equalsIgnoreCase(this.tm.getEnvName())) {
                        this.type = 21;
                    } else if (tk.getToknum() == 458 || tk.getToknum() == 367) {
                        this.type = 8;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 10001) {
                            this.envToken = tk;
                        } else {
                            if (tk.getToknum() != 10009) throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
                            this.envVar = this.localVariableNameGet();
                            if (this.envVar.getVarDecl().isNumeric()) {
                                throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
                            }
                        }
                    } else if (tk.getWord().toUpperCase().equalsIgnoreCase("STANDARD")) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 606) throw new GeneralErrorException(19, 4, tk, tk.getWord(), this.error);
                        this.endacceptpermitted = false;
                        this.acceptFromStandardObject(tk);
                    } else if (tk.getWord().toUpperCase().equalsIgnoreCase("OBJECT")) {
                        this.endacceptpermitted = false;
                        this.acceptFromStandardObject(tk);
                    } else if (tk.getToknum() == 812) {
                        this.endacceptpermitted = false;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 609) {
                            this.type = 24;
                            tk = this.tm.getToken();
                            if (tk.getToknum() == 763 || tk.getToknum() == 10009) {
                                if (tk.getToknum() == 10009) {
                                    this.tm.ungetToken();
                                }
                                this.threadvar = VariableName.get(this.tm, this.error, this.pc);
                                if (this.threadvar == null) {
                                    tk = this.tm.getToken();
                                    throw new UnexpectedTokenException(tk, this.error);
                                }
                                if (!this.threadvar.getVarDecl().isValidThreadHandle()) {
                                    throw new ClauseClashException(tk, this.error, this.threadvar.getName());
                                }
                            }
                            this.pc.useScreen = true;
                        } else {
                            this.type = 13;
                            this.pc.useScreen = true;
                            if (tk.getToknum() != 510) {
                                this.tm.ungetToken();
                            }
                        }
                    } else if (tk.getToknum() == 373) {
                        this.type = 16;
                        this.pc.useScreen = true;
                        if (this.tm.getToken().getToknum() != 510) {
                            this.tm.ungetToken();
                        }
                    } else if (tk.getToknum() == 534) {
                        this.endacceptpermitted = false;
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 742) {
                            throw new ExpectedFoundException(tk, this.error, "'STATUS'");
                        }
                        this.type = 17;
                    } else if (tk.getToknum() == 383) {
                        if (this.httpUnsupportedLog) {
                            this.error.print(232, 2, kw, kw.getWord());
                        }
                        this.type = 18;
                        this.sa = new ScreenAttribute(kw, par, null, this.pc, this.tm, err, 2);
                        this.pc.useScreen = true;
                    } else {
                        if (tk.getToknum() != 472) throw new GeneralErrorException(19, 4, tk, tk.getWord(), this.error);
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 742) {
                            this.tm.ungetToken();
                        }
                        this.type = 25;
                    }
                }
                if (this.type > 0) {
                    this.ishandle = false;
                }
            } else {
                if (this.httpUnsupportedLog) {
                    this.error.print(232, 2, kw, kw.getWord());
                }
                if (!this.isscreenname && this.guiWd2UnsupportedLog) {
                    this.error.print(179, 2, tksave, "character user interface: " + tksave.getWord().toUpperCase() + " in ACCEPT command");
                }
                this.tm.ungetToken();
                this.sa = new ScreenAttribute(kw, par, null, this.pc, this.tm, err, 2);
                this.loadAcceptToken(this.sa);
                this.type = 18;
            }
        } else if (tk.getToknum() == 612 || tk.getToknum() == 468) {
            if (this.httpUnsupportedLog) {
                this.error.print(232, 2, kw, kw.getWord());
            }
            if (tk.getToknum() == 612 && this.guiWd2UnsupportedLog) {
                this.error.print(179, 2, tk, tk.getWord().toUpperCase() + " in ACCEPT command");
            }
            this.type = 0;
            this.sa = new ScreenAttribute(kw, par, null, this.pc, this.tm, err, 2);
            this.loadAcceptToken(this.sa);
        } else {
            if (tk.getToknum() != 373) throw new GeneralErrorException(19, 4, kw, kw.getWord(), this.error);
            this.control = true;
            this.sa = new ScreenAttribute(kw, par, null, this.pc, this.tm, err, 2);
            this.loadAcceptToken(this.sa);
        }
        this.loadAcceptToken(this.sa);
        if (!this.optionCA) {
            this.endacceptpermitted = true;
        }
        if ((tk = this.tm.getToken()).getToknum() == 423 && this.endacceptpermitted) return;
        this.tm.ungetToken();
    }

    private void acceptFromStandardObject(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.ishandle = false;
        this.type = 10;
        this.pc.useScreen = true;
        tk = this.tm.getToken();
        if (tk.getToknum() == 10001) {
            this.standardObjectToken = tk;
        } else if (tk.getToknum() == 10009) {
            this.standardObjectVar = this.localVariableNameGet();
            if (this.standardObjectVar.getVarDecl().isNumeric()) {
                throw new GeneralErrorException(66, 4, this.standardObjectVar.getNameToken(), this.standardObjectVar.getName(), this.error);
            }
        } else {
            throw new GeneralErrorException(66, 4, tk, tk.getWord(), this.error);
        }
    }

    private void loadAcceptToken(ScreenAttribute sa) throws GeneralErrorException, EndOfProgramException {
        boolean go = true;
        Token tk = null;
        while (go && (tk = this.tm.getToken()) != null) {
            if (tk.getToknum() == 498) {
                tk = this.tm.getToken();
                if (tk.getToknum() != 383) {
                    this.tm.ungetToken();
                } else {
                    tk = this.tm.getToken();
                    if (tk == null) break;
                }
            }
            if (tk.getToknum() == 299 && (tk = this.tm.getToken()).getToknum() != 769) {
                throw new ExpectedFoundException(tk, this.error, "'TIME'");
            }
            if (tk.getToknum() == 769) {
                this.beforeTime = true;
                tk = this.tm.getToken();
                if (Token.isNumLit(tk)) {
                    this.tk_timeout = tk;
                } else if (tk.getToknum() == 10009) {
                    this.vn_timeout = this.localVariableNameGet();
                } else {
                    throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                }
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 10009 && tk.getWord().equalsIgnoreCase("MOUSE")) {
                tk = this.tm.getToken();
                if (tk.getToknum() != 10009 || !tk.getWord().equalsIgnoreCase("FLAGS")) {
                    throw new ExpectedFoundException(tk, this.error, "'FLAGS'");
                }
                tk = this.tm.getToken();
                switch (tk.getToknum()) {
                    case 10002: 
                    case 10017: {
                        this.tk_mouseFlags = tk;
                        break;
                    }
                    case 10009: {
                        this.tm.ungetToken();
                        this.vn_mouseFlags = VariableName.get(this.tm, this.error, this.pc);
                        break;
                    }
                    default: {
                        throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                    }
                }
                tk = this.tm.getToken();
            }
            if (sa != null) {
                while (tk.getToknum() == 813 || tk.getToknum() == 377 || tk.getToknum() == 376) {
                    tk = this.tm.getToken();
                }
                go = sa.tokenIsAttrScreen(tk, this.tm, this.keyWord, -1, this.isscreenname);
                this.tm.ungetToken();
            } else {
                this.tm.ungetToken();
                go = false;
            }
            if (go || (tk = this.tm.getToken()) == null) continue;
            if (tk.getToknum() == 373 && (tk = this.tm.getToken()).getToknum() != 551) {
                throw new ExpectedFoundException(tk, this.error, "'KEY'");
            }
            if (tk.getToknum() == 551) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 526) {
                    tk = this.tm.getToken();
                }
                this.keyDest = this.localVariableNameGet();
                if (this.keyDest == null || !this.keyDest.getVarDecl().isNumeric() || this.keyDest.getVarDecl().isEdited()) {
                    throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
                }
                tk = this.tm.getToken();
                go = true;
            }
            if (tk.getToknum() == 791) {
                this.untilCond = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
                if (!this.untilCond.isFullCondition()) {
                    throw new IllegalConditionException(this.keyWord, this.error);
                }
                tk = this.tm.getToken();
            }
            if (this.type != 22 && this.type != 2 && this.type != 3 && this.type != 14 && this.type != 15 && this.type != 1 && this.type != 7 && this.type != 6 && this.type != 17 && this.type != 12 && this.type != 19 && this.type != 9 && this.type != 10 && this.type != 763 && this.type != 13 && this.type != 24 && (tk.getToknum() == 598 || tk.getToknum() == 613 || tk.getToknum() == 472 || tk.getToknum() == 466)) {
                Token overExcp;
                this.pc.useScreen = true;
                boolean on = false;
                if (tk.getToknum() == 598) {
                    this.not = true;
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 613) {
                    on = true;
                    tk = this.tm.getToken();
                }
                if ((overExcp = tk).getToknum() == 472 || overExcp.getToknum() == 466) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 10009) {
                        this.keyDest = this.localVariableNameGet();
                    } else {
                        this.tm.ungetToken();
                    }
                    go = true;
                    if (this.not) {
                        this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                    } else {
                        this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(AcceptException.class));
                    }
                    tk = this.tm.getToken();
                    if (!this.not && tk.getToknum() == 598) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 613) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() != overExcp.getToknum()) {
                            throw new ExpectedFoundException(tk, this.error, "'" + overExcp.getWord() + "'");
                        }
                        this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                        continue;
                    }
                    this.tm.ungetToken();
                    continue;
                }
                this.tm.ungetToken();
                if (this.not) {
                    this.tm.ungetToken();
                }
                if (!on) continue;
                this.tm.ungetToken();
                continue;
            }
            if (tk.getToknum() == 596) {
                sa.setAttrNOADVANCING(true);
                go = true;
                continue;
            }
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.sa != null) {
            this.sa.check(this.parent.parent);
        }
    }

    boolean isScreenName(VariableName t) throws GeneralErrorException {
        VariableDeclaration vds = null;
        if (t == null) {
            return false;
        }
        vds = this.pc.getVar(t);
        return vds != null && vds instanceof VariableDeclarationScreen;
    }

    boolean isFontHandle(VariableName t) throws GeneralErrorException {
        VariableDeclaration vds = null;
        if (t == null) {
            return false;
        }
        vds = this.pc.getVar(t);
        if (vds != null && vds instanceof VariableDeclaration) {
            return vds.isFontHandle() || vds.isGenericHandle();
        }
        return false;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        this.getCodeDebug(Return2);
        if (this.type == 23) {
            Return2.append(this.parent.getIndent());
            Return2.append("HTTPHandler.cgiAccept (");
            Return2.append(this.var.getCode());
            Return2.append(");");
            Return2.append(eol);
            this.getCodeDebugEnd(Return2);
            return Return2.toString();
        }
        if (this.untilCond != null) {
            Return2.append(this.parent.getIndent() + "do {" + eol);
        }
        boolean debug = this.pc.getOption("-d") != null;
        boolean bl = this.vansi = this.pc.getOption("-vansi") != null && !this.isscreenname;
        if (this.vansi && (this.type == 18 || this.type == 0 || this.type == 11 || this.type == 18)) {
            this.type = 5;
        }
        if (!this.vansi && (this.isscreenname || this.ishandle && this.type != 13 && this.type != 24 && this.type != 16)) {
            Return2.append(this.getScreenCode(this.var));
        } else if (this.type == 0 && (this.pc.data != null && this.pc.data.screenSec != null || this.sa != null && this.sa.getOne() || this.pc.useScreen || this.keyDest != null)) {
            Return2.append(this.getScreenCode(null));
        } else if (!this.vansi && this.control && this.pc.data != null) {
            Return2.append(this.getScreenCode(null));
        } else if (this.type == 18) {
            if (this.sa != null && (this.sa.getOne() || this.keyDest != null || this.onexceptionexit != null)) {
                Return2.append(this.getScreenCode(this.var));
            } else {
                Return2.append(this.parent.getIndent());
                Return2.append("ScrFactory.getGUIEnviroment()");
                Return2.append(".setAcceptTimeout(");
                if (this.beforeTime) {
                    if (this.tk_timeout != null) {
                        Return2.append(this.getCodeLiteral(this.tk_timeout));
                    } else {
                        Return2.append(this.vn_timeout.getCode());
                    }
                } else {
                    Return2.append("null");
                }
                Return2.append(");" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("ScrFactory.getGUIEnviroment().accept (");
                Return2.append(this.pc.getCodeScreenSpecialNames());
                Return2.append(this.getSNCodeCursor());
                Return2.append(this.var.getCode());
                Return2.append(");");
                Return2.append(eol);
            }
        } else if (this.type == 25) {
            Return2.append(this.parent.getIndent());
            Return2.append(this.var.getCode());
            Return2.append(".set(0);");
            Return2.append(eol);
        } else {
            String myIndent = this.parent.getIndent();
            boolean optionCM = false;
            if (this.onException != null || this.notOnException != null || (optionCM = (this.type == 8 || this.type == 20) && this.pc.getOption("-cm") != null)) {
                Return2.append(this.parent.getIndent());
                Return2.append("try {");
                Return2.append(eol);
                myIndent = myIndent + "   ";
            }
            Return2.append(myIndent);
            if (this.type == 12) {
                Return2.append("ScrFactory.getGUIEnviroment()");
                Return2.append(".getEscapeKey(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 11) {
                Return2.append(this.afs.getCode());
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 0) {
                Return2.append("Factory.acceptOmitted(");
                Return2.append(Pcc.getInddProperty());
                Return2.append(");");
            } else if (this.type == 1) {
                Return2.append("Factory.acceptFromTime().moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 19) {
                Return2.append("Factory.acceptFromLineNumber(");
                Return2.append(this.tm.getDecimalPointIsComma());
                Return2.append(").moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 2) {
                Return2.append("Factory.acceptFromDate().moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 14) {
                Return2.append("Factory.acceptFromCenturyDate().moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 22) {
                Return2.append("Factory.acceptFromTimestamp().moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 3) {
                Return2.append("Factory.acceptFromDay().moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 15) {
                Return2.append("Factory.acceptFromCenturyDay().moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 4) {
                Return2.append("Factory.acceptFromDayOfWeek().moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 27) {
                Return2.append(this.var.getCode());
                Return2.append(".set(");
                GregorianCalendar now = new GregorianCalendar();
                int x = now.get(1);
                Return2.append(x);
                x = now.get(2) + 1;
                if (x < 10) {
                    Return2.append("0");
                }
                Return2.append(x);
                x = now.get(5);
                if (x < 10) {
                    Return2.append("0");
                }
                Return2.append(x);
                Return2.append(");");
            } else if (this.type == 763) {
                Return2.append(this.var.getCode());
                Return2.append(".set (Factory.getCurrentThreadId());");
            } else if (this.type == 5) {
                if (this.var == null) {
                    Return2.append("Factory.acceptOmitted(");
                    Return2.append(Pcc.getInddProperty());
                    Return2.append(");");
                } else if (!this.var.isNumeric() && this.var.isEdited()) {
                    Return2.append(this.var.getCode());
                    Return2.append(".setValue(Factory.acceptFromConsole());");
                } else {
                    Return2.append("Factory.acceptFromConsole().moveTo(");
                    Return2.append(this.var.getCode());
                    if (this.var.isNumeric()) {
                        Return2.append(".sub(1)");
                    }
                    Return2.append(");");
                }
            } else if (this.type == 26) {
                if (!this.var.isNumeric() && this.var.isEdited()) {
                    Return2.append(this.var.getCode());
                    Return2.append(".setValue(Factory.acceptFromConsole(");
                    Return2.append(Pcc.getInddProperty());
                    Return2.append("));");
                } else {
                    Return2.append("Factory.acceptFromConsole(");
                    Return2.append(Pcc.getInddProperty());
                    Return2.append(").moveTo(");
                    Return2.append(this.var.getCode());
                    if (this.var.isNumeric()) {
                        Return2.append(".sub(1)");
                    }
                    Return2.append(");");
                }
            } else if (this.type == 9) {
                if (debug) {
                    Return2.append("Factory.acceptFromCommandLine(Debugger.getCommandLineArgs(Factory.get().gArgs))");
                } else {
                    Return2.append("Factory.acceptFromCommandLine(Factory.get().gArgs)");
                }
                Return2.append(".moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 8) {
                Return2.append(this.var.getCode() + ".set(");
                Return2.append("Factory.acceptFromEnv(");
                if (this.envToken != null) {
                    Return2.append(this.getCodeLiteral(this.envToken));
                } else {
                    Return2.append(this.envVar.getCode());
                }
                Return2.append(".toString()");
                if (this.onException != null || this.notOnException != null || optionCM) {
                    Return2.append(", true");
                } else {
                    Return2.append(", false");
                }
                Return2.append("));");
            } else if (this.type == 20) {
                Return2.append(this.var.getCode() + ".set(");
                Return2.append("Factory.acceptFromEnvValue(");
                if (this.onException != null || this.notOnException != null || optionCM) {
                    Return2.append("true));");
                } else {
                    Return2.append("false));");
                }
            } else if (this.type == 21) {
                Return2.append(this.var.getCode() + ".set(");
                Return2.append("Factory.acceptFromEnvName(");
                if (this.onException != null || this.notOnException != null) {
                    Return2.append("true));");
                } else {
                    Return2.append("false));");
                }
            } else if (this.type == 10) {
                Return2.append(this.var.getCode() + ".setId(ScrFactory.acceptFromStandardObject(");
                if (this.standardObjectToken != null) {
                    Return2.append(this.getCodeLiteral(this.standardObjectToken));
                } else {
                    Return2.append(this.standardObjectVar.getCode());
                }
                Return2.append("));");
            } else if (this.type == 7) {
                Return2.append("ScrFactory.getGUIEnviroment().acceptFromTerminalInfo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 6) {
                Return2.append("Factory.acceptFromSystemInfo().moveTo(");
                Return2.append(this.var.getCode());
                Return2.append(");");
            } else if (this.type == 13) {
                Return2.append("ScrFactory.getGUIEnviroment().acceptFromWindowHandle(" + this.var.getCode() + ");");
            } else if (this.type == 16) {
                Return2.append("ScrFactory.getGUIEnviroment().acceptFromControlHandle(" + this.var.getCode() + ");");
            } else if (this.type == 17) {
                Return2.append("ScrFactory.getGUIEnviroment().acceptFromInputStatus(" + this.var.getCode() + ");");
            } else if (this.type == 24) {
                Return2.append(this.var.getCode());
                Return2.append(".set(ScrFactory.getGUIEnviroment().getActiveWindowHandleOfThread(");
                Return2.append(this.threadvar.getCode());
                Return2.append("));");
            }
            if (this.notOnException != null) {
                Return2.append(this.notOnException.getCode());
            }
            if (this.onException != null || this.notOnException != null) {
                Return2.append(this.parent.getIndent());
                Return2.append("} catch (AcceptException ");
                Return2.append(this.parent.getExceptName());
                Return2.append(")");
                if (this.onException != null) {
                    Return2.append(this.onException.getCode());
                } else {
                    Return2.append("{ }");
                }
            } else if (optionCM) {
                Return2.append("} catch (AcceptException ");
                Return2.append(this.parent.getExceptName());
                Return2.append(") { }");
            }
            Return2.append(eol);
        }
        if (this.untilCond != null) {
            Return2.append(eol + this.parent.getIndent() + "} while(!(");
            Return2.append(this.untilCond.getCode() + "));" + eol);
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public StringBuffer getScreenCode(VariableName varName) {
        StringBuffer Return2 = new StringBuffer();
        String myIndent = this.parent.getIndent();
        if ((varName == null || this.ishandle) && this.control && this.sa != null) {
            Return2.append(this.parent.getIndent());
            Return2.append("if (ScrFactory.getGUIEnviroment().getControl(");
            Return2.append(this.sa.getScreenAttributeLINEPOSITION());
            Return2.append(") != null) {" + eol);
        }
        if (this.onException != null || this.notOnException != null || this.onexceptionexit != null || this.keyDest != null) {
            Return2.append(this.parent.getIndent());
            Return2.append("try {");
            Return2.append(eol);
            myIndent = myIndent + "   ";
        }
        Return2.append(myIndent);
        Return2.append("CobolRecordAccept __cra_" + this.currcountAccept + " = null;" + eol);
        Return2.append(myIndent);
        Return2.append("ScrFactory.getGUIEnviroment()");
        Return2.append(".setAcceptTimeout(");
        if (this.beforeTime) {
            if (this.tk_timeout != null) {
                Return2.append(this.getCodeLiteral(this.tk_timeout));
            } else {
                Return2.append(this.vn_timeout.getCode());
            }
        } else {
            Return2.append("null");
        }
        Return2.append(");" + eol);
        if (this.tk_mouseFlags != null || this.vn_mouseFlags != null) {
            Return2.append(myIndent);
            Return2.append("ScrFactory.getGUIEnviroment()");
            Return2.append(".setMouseFlags(");
            if (this.tk_mouseFlags != null) {
                Return2.append(this.getCodeLiteral(this.tk_mouseFlags));
            } else {
                Return2.append(this.vn_mouseFlags.getCode());
            }
            Return2.append(");" + eol);
        }
        Return2.append(myIndent);
        Return2.append("do {" + eol);
        myIndent = myIndent + "   ";
        Return2.append(myIndent);
        Return2.append("__cra_" + this.currcountAccept + " = CobolGUIEnvironment.manageAccept(" + this.pc.getCodeScreenSpecialNames() + "ScrFactory.getGUIEnviroment()" + ", " + "ScrFactory.getGUIEnviroment()");
        if (this.sa != null) {
            if (this.sa.vThread != null) {
                Return2.append(".setThread (");
                Return2.append(this.sa.vThread.getCode());
                Return2.append(", false)");
            } else if (this.sa.attrLAST) {
                Return2.append(".setThread (null, true)");
            } else if (this.sa.attrANY) {
                Return2.append(".setThread (null, false)");
            }
        }
        if (varName == null || this.ishandle) {
            if (this.control && this.sa != null) {
                Return2.append(".accept(" + this.pc.getCodeScreenSpecialNames() + "ScrFactory.getGUIEnviroment()" + ".getControl(");
                Return2.append(this.sa.getScreenAttributeLINEPOSITION());
                Return2.append(")");
                Return2.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set"));
                Return2.append(",");
            } else if (this.ishandle && this.sa != null) {
                Return2.append(".accept(");
                Return2.append(this.pc.getCodeScreenSpecialNames());
                Return2.append("(");
                Return2.append(varName.getCode());
                Return2.append(".getId() != null ? (BaseGUIControl) ");
                Return2.append(varName.getCode());
                Return2.append(".getId() : ScrFactory.getControl(\"FOO\", null, null).setStyle(\"TEMPORARY\").setPrompt(true).endDeclaration())");
                Return2.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set"));
                Return2.append(",");
            } else if (this.sa != null && this.sa.getOne()) {
                Return2.append(".accept(" + this.pc.getCodeScreenSpecialNames());
                Return2.append(this.getSNCodeCursor());
                Return2.append("NullControl.getInstance()");
                Return2.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set"));
                Return2.append(",");
            } else {
                Return2.append(".accept(" + this.pc.getCodeScreenSpecialNames());
                Return2.append(this.getSNCodeCursor());
                Return2.append("(BaseGUIControl)null,");
            }
        } else {
            Return2.append(".accept(" + this.pc.getCodeScreenSpecialNames());
            Return2.append(this.getSNCodeCursor());
            if (this.sa != null) {
                if (!this.isscreenname) {
                    Return2.append("ScrFactory.getGUITerminalAccept(" + (this.tm.isRmCompFlag() ? "true, " : "") + varName.getCode() + ")");
                    Return2.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set"));
                } else if (this.sa != null && this.sa.getOne()) {
                    Return2.append("ScrFactory.getGUIEnviroment().getControl(");
                    Return2.append(varName.getCode());
                    Return2.append(")");
                    Return2.append(this.sa.getGraphicalScreenAttributeCode(this.keyWord, ".set", ".reloc", true));
                } else {
                    Return2.append(varName.getCode());
                }
            } else {
                Return2.append(varName.getCode());
            }
            Return2.append(",");
        }
        if (this.onException != null || this.notOnException != null || this.keyDest != null) {
            Return2.append("true");
        } else if (this.onexceptionexit != null) {
            Return2.append("true");
        } else {
            Return2.append("false");
        }
        Return2.append(",");
        if (this.keyDest != null) {
            Return2.append(this.keyDest.getCode());
        } else {
            Return2.append("null");
        }
        Return2.append(",__cra_" + this.currcountAccept);
        Return2.append("," + (this.ishandle && this.sa != null));
        if (this.sa != null && this.sa.getAcceptCursor() != null) {
            Return2.append(", " + this.sa.getAcceptCursor());
        }
        Return2.append("),");
        if (this.onException != null || this.notOnException != null || this.keyDest != null) {
            Return2.append("true");
        } else if (this.onexceptionexit != null) {
            Return2.append("true");
        } else {
            Return2.append("false");
        }
        Return2.append("," + (this.ishandle && this.sa != null));
        Return2.append(");" + eol);
        Return2.append(myIndent);
        Return2.append("if(ScrFactory.getGUIEnviroment().getEventActionOfEventStatus(");
        if (this.pc.getSNEventStatus() != null) {
            Return2.append(this.pc.getSNEventStatus().getUnivoqueName());
        } else {
            Return2.append("(CobolVar)null");
        }
        Return2.append(",__cra_" + this.currcountAccept);
        Return2.append(") != 2) {" + eol);
        Return2.append(myIndent + "   ");
        Return2.append("ScrFactory.getGUIEnviroment().responseAccept(" + this.pc.getCodeScreenSpecialNames() + "__cra_" + this.currcountAccept + ");" + eol);
        Return2.append(myIndent + "   ");
        Return2.append("ScrFactory.getGUIEnviroment().manageAcceptException(" + this.pc.getCodeScreenSpecialNames() + "__cra_" + this.currcountAccept + ", ");
        if (this.onException != null || this.notOnException != null || this.keyDest != null) {
            Return2.append("true");
        } else if (this.onexceptionexit != null) {
            Return2.append("true");
        } else {
            Return2.append("false");
        }
        Return2.append(");" + eol);
        Return2.append(myIndent + "}" + eol);
        myIndent = this.parent.getIndent();
        myIndent = myIndent + "   ";
        Return2.append(myIndent);
        Return2.append("} while ( ! ScrFactory.getGUIEnviroment().isAcceptTerminated(" + this.pc.getCodeScreenSpecialNames());
        Return2.append("__cra_" + this.currcountAccept + ", ");
        if (this.onException != null || this.notOnException != null || this.keyDest != null) {
            Return2.append("true");
        } else if (this.onexceptionexit != null) {
            Return2.append("true");
        } else {
            Return2.append("false");
        }
        Return2.append("));" + eol);
        if (this.notOnException != null) {
            Return2.append(this.notOnException.getCode());
        }
        if (this.onException != null || this.notOnException != null || this.onexceptionexit != null || this.keyDest != null) {
            Return2.append(this.parent.getIndent());
            Return2.append("} catch (AcceptException ");
            Return2.append(this.parent.getExceptName());
            Return2.append(")");
            if (this.onException != null) {
                Return2.append(this.onException.getCode());
            } else {
                Return2.append("{ }");
            }
        }
        if ((varName == null || this.ishandle) && this.control && this.sa != null) {
            Return2.append(eol + this.parent.getIndent());
            Return2.append("}" + eol);
        }
        return Return2;
    }

    private VariableName localVariableNameGet() throws GeneralErrorException, EndOfProgramException {
        this.tm.ungetToken();
        VariableName Return2 = VariableName.get(this.tm, this.error, null, this.pc, true, true, true, true);
        return Return2;
    }

    private String getSNCodeCursor() {
        String Return2 = this.pc.getCodeCursorSpecialNames();
        if (Return2 == null) {
            Return2 = "null";
        }
        Return2 = Return2 + ", ";
        return Return2;
    }

    public VariableName getVariableName() {
        return this.var;
    }

    public static void resetCounters() {
        countAccept = 0;
    }

    public int getType() {
        return this.type;
    }

    public VariableName getEnvironmentVariableName() {
        return this.envVar;
    }

    public Token getEnvironmentVariableToken() {
        return this.envToken;
    }

    public BlockException getOnException() {
        return this.onException;
    }

    public Block getNotOnException() {
        return this.notOnException;
    }

    private class AcceptFromScreen
    extends Verb
    implements CobolToken,
    ErrorsNumbers {
        VariableName vn_screen_loc;
        Token tk_screen_loc;
        boolean hasAtPhrase;
        boolean hasLinePhrase;
        boolean hasColumnPhrase;
        boolean hasSize;
        Expression line;
        Expression column;
        Expression length;

        public AcceptFromScreen(Token kw, Block par, Pcc p, TokenManager t, Errors err, Token tk) throws GeneralErrorException, EndOfProgramException {
            super(kw, par, p, t, err);
            tk = this.tm.getToken();
            if (tk.getToknum() == 284) {
                tk = this.tm.getToken();
                switch (tk.getToknum()) {
                    case 10001: 
                    case 10002: 
                    case 10017: {
                        this.tk_screen_loc = tk;
                        this.hasAtPhrase = true;
                        break;
                    }
                    case 10009: {
                        this.vn_screen_loc = Accept.this.localVariableNameGet();
                        this.hasAtPhrase = true;
                        break;
                    }
                    case 565: {
                        this.hasLinePhrase = true;
                        this.line = this.lineColumnPhrase(tk);
                        break;
                    }
                    case 334: 
                    case 338: 
                    case 640: 
                    case 641: {
                        this.hasColumnPhrase = true;
                        this.column = this.lineColumnPhrase(tk);
                        break;
                    }
                    default: {
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                }
                tk = this.tm.getToken();
            }
            while (tk.getToknum() == 498 || tk.getToknum() == 284 || tk.getToknum() == 565 || tk.getToknum() == 334 || tk.getToknum() == 338 || tk.getToknum() == 641 || tk.getToknum() == 640 || tk.getToknum() == 728) {
                if (this.hasAtPhrase && tk.getToknum() != 728) {
                    this.error.print(92, 2, tk, "");
                }
                if (tk.getToknum() == 284 || tk.getToknum() == 498) {
                    tk = this.tm.getToken();
                }
                switch (tk.getToknum()) {
                    case 565: {
                        if (this.hasLinePhrase) {
                            throw new UnexpectedTokenException(tk, this.error);
                        }
                        this.hasLinePhrase = true;
                        this.line = this.lineColumnPhrase(tk);
                        break;
                    }
                    case 334: 
                    case 338: 
                    case 640: 
                    case 641: {
                        if (this.hasColumnPhrase) {
                            throw new UnexpectedTokenException(tk, this.error);
                        }
                        this.hasColumnPhrase = true;
                        this.column = this.lineColumnPhrase(tk);
                        break;
                    }
                    case 728: {
                        if (this.hasSize) {
                            this.error.print(92, 2, tk, "");
                        }
                        this.hasSize = true;
                        tk = this.tm.getToken();
                        this.tm.ungetToken();
                        this.length = new Expression(new int[]{0}, this.keyWord, this.parent, this.pc, this.tm, this.error);
                        if (this.length.getType() == 3) break;
                        throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
                    }
                    default: {
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                }
                tk = this.tm.getToken();
            }
            this.tm.ungetToken();
        }

        Expression lineColumnPhrase(Token tk) throws GeneralErrorException, EndOfProgramException {
            Expression Return2;
            tk = this.tm.getToken();
            if (tk.getToknum() != 602) {
                this.tm.ungetToken();
            }
            if ((Return2 = new Expression(new int[]{0}, this.keyWord, this.parent, this.pc, this.tm, this.error)).getType() != 3) {
                throw new GeneralErrorException(23, 4, tk, tk.getWord(), this.error);
            }
            return Return2;
        }

        @Override
        public String getCode() {
            StringBuffer Return2 = new StringBuffer();
            Return2.append("ScrFactory.acceptFromScreen(ScrFactory.getGUIEnviroment(),");
            if (this.hasAtPhrase) {
                if (this.tk_screen_loc != null) {
                    Return2.append(this.getCodeLiteral(this.tk_screen_loc));
                } else {
                    Return2.append(this.vn_screen_loc.getCode());
                }
            } else {
                if (this.hasLinePhrase) {
                    Return2.append(this.line.getCode() + ".intValue()");
                } else {
                    Return2.append("0");
                }
                Return2.append(" , ");
                if (this.hasColumnPhrase) {
                    Return2.append(this.column.getCode() + ".intValue()");
                } else {
                    Return2.append("0");
                }
            }
            Return2.append(" , ");
            if (this.length != null) {
                Return2.append(this.length.getCode() + ".intValue()");
            } else {
                Return2.append(Accept.this.var.getCode() + ".getLength()");
            }
            Return2.append(",");
            return Return2.toString();
        }

        @Override
        public void check() throws GeneralErrorException {
            if (this.line != null) {
                this.line.check();
            }
            if (this.column != null) {
                this.column.check();
            }
            if (this.length != null) {
                this.length.check();
            }
        }
    }
}

