/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.interfaces.runtime.IIDESettings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;

public class IDESettings
implements IIDESettings,
Externalizable {
    private String name;
    private Map<String, Map<String, String>> modes;
    private Map<String, Map<String, String>> runtimeModes;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        this.writeMap(this.modes, out);
        this.writeMap(this.runtimeModes, out);
    }

    private void writeMap(Map<String, Map<String, String>> map, ObjectOutput out) throws IOException {
        if (map != null) {
            out.writeInt(map.size());
            for (String modeName : map.keySet()) {
                out.writeUTF(modeName);
                Map<String, String> props = map.get(modeName);
                out.writeInt(props.size());
                for (String propName : props.keySet()) {
                    out.writeUTF(propName);
                    out.writeUTF(props.get(propName));
                }
            }
        } else {
            out.writeInt(0);
        }
    }

    private void readMap(Map<String, Map<String, String>> map, int size, ObjectInput in) throws IOException {
        for (int i = 0; i < size; ++i) {
            String modeName = in.readUTF();
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            map.put(modeName, props);
            int propCount = in.readInt();
            for (int j = 0; j < propCount; ++j) {
                props.put(in.readUTF(), in.readUTF());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        int size = in.readInt();
        if (size > 0) {
            this.modes = new LinkedHashMap<String, Map<String, String>>();
            this.readMap(this.modes, size, in);
        }
        if ((size = in.readInt()) > 0) {
            this.runtimeModes = new LinkedHashMap<String, Map<String, String>>();
            this.readMap(this.runtimeModes, size, in);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, Map<String, String>> getModes() {
        return this.modes;
    }

    @Override
    public void setModes(Map<String, Map<String, String>> modes) {
        this.modes = modes;
    }

    @Override
    public Map<String, Map<String, String>> getRuntimeModes() {
        return this.runtimeModes;
    }

    @Override
    public void setRuntimeModes(Map<String, Map<String, String>> runtimeModes) {
        this.runtimeModes = runtimeModes;
    }
}

