/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.ant;

import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.phases.Phases;
import com.iscobol.compiler.phases.PhasesFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class iscc
extends Task {
    private File destDir;
    private boolean failOnError = true;
    private boolean nowarn = false;
    private boolean noerr = false;
    private boolean nosummary = true;
    private String javacOptions;
    private File javac;
    private String options;
    private boolean verbose = false;
    private int verboseFlag = 3;
    private boolean force = false;
    private List<FileSet> filesets = new LinkedList<FileSet>();

    public void setForce(boolean b) {
        this.force = b;
    }

    public void setNowarn(boolean b) {
        this.nowarn = b;
    }

    public void setNoerr(boolean b) {
        this.noerr = b;
    }

    public void setNosummary(boolean b) {
        this.nosummary = b;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setJavacOptions(String s) {
        this.javacOptions = s;
    }

    public void setJavac(File javac) {
        this.javac = javac;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    private void checkParameterConsistencyPhase() {
        if (this.filesets == null) {
            throw new BuildException("No files specified.");
        }
    }

    private boolean upToDate(File f1, File f2) {
        if (!f2.exists()) {
            return false;
        }
        if (!f1.exists()) {
            return false;
        }
        return f2.lastModified() > f1.lastModified();
    }

    private String getIntermediateFileSuffix(OptionList ol) {
        return "java";
    }

    private String getTargetFileSuffix(OptionList ol) {
        return "class";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        System.setProperty("iscobol.compiler.internal.error.stack", "true");
        this.configure();
        this.checkParameterConsistencyPhase();
        Properties props = new Properties();
        HashMap<String, String> oldProps = new HashMap<String, String>();
        OptionList ol = this.createOptionList(props);
        if (ol.hasErrors()) {
            throw new BuildException(Errors.getErrorDescription(ol.getErrorNum()) + ol.getErrors());
        }
        if (!props.isEmpty()) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String k = (String)en.nextElement();
                if (!k.startsWith("iscobol.")) continue;
                oldProps.put(k, Config.getProperty(k, null));
                Config.setProperty(k, props.getProperty(k));
            }
        }
        try {
            Phases phases = PhasesFactory.create(ol);
            String outDir = this.destDir.getAbsolutePath();
            if (outDir == null) {
                outDir = ol.getOption("-od=");
            }
            if (outDir != null && !outDir.endsWith(File.separator)) {
                outDir = outDir + File.separator;
            }
            Thread.currentThread().setContextClassLoader(iscc.class.getClassLoader());
            int nSources = 0;
            for (FileSet fs : this.filesets) {
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File basedir = ds.getBasedir();
                for (String file : ds.getIncludedFiles()) {
                    String msg;
                    AntErrors err = new AntErrors(this.nowarn);
                    try {
                        File sourceFile = new File(basedir, file);
                        String nn = sourceFile.getAbsolutePath();
                        String baseName = sourceFile.getName();
                        File intermediateFile = new File(nn.replace('-', '_').substring(0, nn.length() - "cbl".length()) + this.getIntermediateFileSuffix(ol));
                        File targetFile = new File(outDir, baseName.replace('-', '_').substring(0, baseName.length() - "cbl".length()) + this.getTargetFileSuffix(ol));
                        if (!this.force && this.upToDate(sourceFile, targetFile)) continue;
                        Pcc.run(sourceFile.getAbsolutePath(), outDir, (OptionList)ol.clone(), phases, err, null, true, null);
                        ++nSources;
                    }
                    catch (ErrorInCompilationException e) {
                        if (!this.failOnError) continue;
                        msg = e.getMessage() == null ? "Compile failed." : "Compile failed: " + e.getMessage();
                        throw new BuildException(msg, (Throwable)e, this.getLocation());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        if (!this.failOnError) continue;
                        msg = t.getMessage() == null ? "Compile failed." : "Compile failed: " + t.getMessage();
                        throw new BuildException(msg, t, this.getLocation());
                    }
                }
            }
            AntErrors err = new AntErrors(this.nowarn);
            if (nSources > 0) {
                this.log("Compiling " + nSources + " source files", 0);
                Pcc.generateBinaryCode(ol, err, phases, outDir);
            }
        }
        finally {
            if (!oldProps.isEmpty()) {
                for (String k : oldProps.keySet()) {
                    String v = (String)oldProps.get(k);
                    if (v != null) {
                        Config.setProperty(k, v);
                        continue;
                    }
                    Config.unsetProperty(k);
                }
            }
        }
    }

    protected String getPrefix() {
        return "iscobol.";
    }

    protected void configure() {
        Config.setPrefix(null, null, null);
    }

    private OptionList createOptionList(Properties props) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.javacOptions != null) {
            args.add("-D" + this.getPrefix() + "compiler.javac.options=" + this.javacOptions);
        }
        if (this.javac != null) {
            args.add("-D" + this.getPrefix() + "compiler.javac=" + this.javac);
        }
        boolean jj = false;
        boolean conly = false;
        String propFile = null;
        if (this.options != null) {
            StringTokenizer st = new StringTokenizer(this.options);
            while (st.hasMoreTokens()) {
                String flag = st.nextToken();
                if (flag.equals("-jj")) {
                    jj = true;
                    continue;
                }
                if (flag.startsWith("-conly=")) {
                    propFile = flag.substring(7);
                    conly = true;
                    continue;
                }
                if (flag.startsWith("-c=")) {
                    if (conly) continue;
                    propFile = flag.substring(3);
                    continue;
                }
                args.add(flag);
            }
        }
        if (propFile != null) {
            try {
                RtsUtil.loadProperties(props, propFile);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (jj) {
            args.add("-jc");
            args.add("-jj");
        }
        String[] argsArray = args.toArray(new String[0]);
        return new OptionList(argsArray);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.verboseFlag = verbose ? 2 : 3;
    }

    private static class StreamDrainer
    extends Thread {
        private final InputStream is;
        private final ByteArrayOutputStream baos;

        public StreamDrainer(InputStream is) {
            this.is = is;
            this.baos = new ByteArrayOutputStream();
        }

        @Override
        public void run() {
            try {
                int b;
                while ((b = this.is.read()) >= 0) {
                    this.baos.write(b);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public byte[] getBytes() {
            return this.baos.toByteArray();
        }
    }

    private class AntErrors
    extends Errors {
        private final boolean nowarn;

        public AntErrors(boolean nowarn) {
            this.nowarn = nowarn;
        }

        @Override
        public void print(int num, int s, int lineNum, int offset, String other, Exception syserr, String file) {
            String mess;
            if (this.ignoreErrors) {
                return;
            }
            if (s != 4) {
                s = Config.getProperty(".compiler.messagelevel." + num, s);
            }
            switch (s) {
                case 0: {
                    return;
                }
                case 1: {
                    mess = "--I: ";
                    ++this.info;
                    break;
                }
                case 2: {
                    if (this.nowarn) {
                        return;
                    }
                    mess = "--W: ";
                    ++this.warning;
                    break;
                }
                case 3: {
                    if (iscc.this.noerr) {
                        return;
                    }
                    mess = "--E: ";
                    ++this.rErrors;
                    break;
                }
                case 4: {
                    mess = "--S: ";
                    ++this.sErrors;
                    break;
                }
                default: {
                    mess = "--?: ";
                }
            }
            mess = mess + "#" + num + " ";
            mess = mess + (String)errorDesc.get(new Integer(num));
            if (other != null) {
                mess = mess + " " + other;
            }
            mess = mess + "; file = " + file;
            if (lineNum > 0) {
                mess = mess + ", line = " + lineNum;
            }
            if (offset > 0) {
                mess = mess + ", col " + offset;
            }
            if (syserr != null) {
                mess = mess + "( " + syserr + ")";
            }
            switch (s) {
                case 1: {
                    iscc.this.log(mess, 2);
                    break;
                }
                case 2: {
                    if (this.nowarn) {
                        iscc.this.log(mess, 2);
                        break;
                    }
                    iscc.this.log(mess, 0);
                    break;
                }
                case 3: {
                    if (iscc.this.noerr) {
                        iscc.this.log(mess, 2);
                    } else {
                        iscc.this.log(mess, 0);
                    }
                }
                case 4: {
                    iscc.this.log(mess, 0);
                    break;
                }
                default: {
                    iscc.this.log(mess, 2);
                }
            }
        }

        @Override
        public boolean printEndMessage() {
            int n;
            if (!iscc.this.nosummary && (n = super.getTotalErrorCount()) > 0) {
                return super.printEndMessage();
            }
            return this.sErrors > 0;
        }
    }
}

