/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo64;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamConst;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.KeyDesc64;
import IT.picosoft.isam.OSFile;
import IT.picosoft.isam.Util;

public class JCheck
implements IsamConst {
    static final String usage = "JCheck [-e<enckey>][-crfy] <file-names>\n    -e<enckey> key for encryption\n    -c         check\n    -r         rebuild\n    -f         force rebuild\n    -y         don't ask confirmation";

    public static String skpt(int t) {
        if ((t & 0x80) != 0) {
            return "char descending";
        }
        return "char ascending";
    }

    public static void exit(int code, String msg) throws ExitException {
        if (msg != null) {
            throw new ExitException(code, msg);
        }
        throw new ExitException(code, usage);
    }

    public static void exit(int code) {
        JCheck.exit(code, null);
    }

    public static void main(String[] argv) {
        try {
            JCheck.mainNoExit(argv);
        }
        catch (ExitException _ex) {
            System.err.println(_ex.msg);
            System.exit(_ex.code);
        }
    }

    public static int call(String[] argv) {
        try {
            JCheck.mainNoExit(argv);
        }
        catch (ExitException _ex) {
            System.err.println(_ex.msg);
            return _ex.code;
        }
        return 0;
    }

    public static void mainNoExit(String[] argv) throws ExitException {
        int i;
        Isam isfld = null;
        DictInfo64 info = new DictInfo64();
        KeyDesc64 key = new KeyDesc64();
        boolean check = false;
        boolean rebuild = false;
        boolean dontAskConfirm = false;
        boolean force = false;
        String ek = null;
        for (i = 0; i < argv.length && argv[i].length() > 0 && argv[i].charAt(0) == '-' && argv[i].length() > 1; ++i) {
            block10: for (int j = 1; j < argv[i].length(); ++j) {
                switch (argv[i].charAt(j)) {
                    case 'e': {
                        if (++j < argv[i].length()) {
                            ek = argv[i].substring(j);
                        } else {
                            JCheck.exit(40, "Missing encryption key");
                        }
                        j = argv[i].length();
                        continue block10;
                    }
                    case 'c': {
                        check = true;
                        continue block10;
                    }
                    case 'r': {
                        rebuild = true;
                        continue block10;
                    }
                    case 'y': {
                        dontAskConfirm = true;
                        continue block10;
                    }
                    case 'f': {
                        force = true;
                        continue block10;
                    }
                    default: {
                        JCheck.exit(1, null);
                    }
                }
            }
        }
        if (argv.length - i < 1) {
            JCheck.exit(1, null);
        }
        while (i < argv.length) {
            try {
                isfld = new Isam(argv[i], 1024, false, ek);
                isfld.indexInfo(info);
                System.out.println("file " + argv[i]);
                System.out.println("nkeys=" + info.di_nkeys + ",recsize=" + info.di_recsize64 + ",idxsize=" + info.di_idxsize + ",nrecords=" + info.di_nrecords64 + ",version=" + isfld.getVersion());
                for (int j = 1; j <= info.di_nkeys; ++j) {
                    isfld.indexInfo(key, j);
                    System.out.println("   key=" + j + ",flags=" + (key.k_flags == 1 ? "ISDUPS" : "ISNODUPS") + ",nparts=" + key.k_nparts);
                    for (int k = 0; k < key.k_nparts; ++k) {
                        System.out.println("      part=" + k + ",start=" + key.k_part[k].kp_start + ",leng=" + key.k_part[k].kp_leng + ",type=" + JCheck.skpt(key.k_part[k].kp_type));
                    }
                }
                if (check) {
                    Isam isfl2 = new Isam(argv[i], 1024, false, ek);
                    JCheck.check(isfld, isfl2, info);
                    isfl2.close();
                }
                isfld.close();
                if (rebuild) {
                    isfld = new Isam(argv[i], 2050, false, ek);
                    JCheck.rebuild(isfld, dontAskConfirm, force);
                    isfld.close();
                }
            }
            catch (IsamException _ex) {
                JCheck.exit(99, "" + _ex);
            }
            ++i;
        }
    }

    private static void checkNodes(Isam is1, DictInfo64 info) {
        boolean ok = true;
        OSFile f = is1.getFd();
        long seek = is1.getFirstNodeAddr();
        try {
            byte[] b = new byte[info.di_idxsize];
            long nNodes = (f.length() - seek) / (long)info.di_idxsize;
            System.out.println("Nodes count      ... " + nNodes);
            f.seek(seek);
            int branch = 0;
            int leaf = 0;
            int recdel = 0;
            int deleted = 0;
            int key = 0;
            for (long i = 0L; i < nNodes; ++i) {
                f.readBlk(b, 0, b.length);
                switch (b[0]) {
                    case -65: {
                        ++branch;
                        break;
                    }
                    case -1: {
                        ++leaf;
                        break;
                    }
                    case -33: {
                        ++deleted;
                        break;
                    }
                    case -17: {
                        ++recdel;
                        break;
                    }
                    case -49: {
                        ++key;
                        break;
                    }
                    default: {
                        System.out.println("Unknown node " + Integer.toHexString(b[0] & 0xFF) + ",pos=" + seek);
                        ok = false;
                    }
                }
                seek += (long)info.di_idxsize;
            }
        }
        catch (IsamException _ex) {
            JCheck.exit(30, "" + _ex);
        }
        if (!ok) {
            JCheck.exit(31, "Invalid node(s)");
        }
    }

    public static void check(Isam is1, Isam is2, DictInfo64 info) {
        KeyDesc64 key = new KeyDesc64();
        KeyDesc64 key0 = new KeyDesc64();
        long srec = 0L;
        long drec = 0L;
        long xrec = 0L;
        long dlen = 0L;
        JCheck.checkNodes(is1, info);
        byte[] recNew = new byte[info.di_recsize64];
        byte[] recOld = new byte[info.di_recsize64];
        key0.k_flags = 0;
        key0.k_nparts = 0;
        System.out.print("Sequential read  ...");
        try {
            is1.read(recNew, 0);
            ++srec;
            while (true) {
                is1.read(recNew, 2);
                ++srec;
            }
        }
        catch (IsamException _ex) {
            if (_ex.getIserrno() != 110 && _ex.getIserrno() != 111) {
                JCheck.exit(5, "Error on read next: " + _ex);
            } else if (srec > info.di_nrecords64) {
                JCheck.exit(14, "Corrupted tree: found " + srec + " record(s)");
            }
            System.out.println(" Ok (" + srec + " record(s) found)");
            for (int i = 1; i <= info.di_nkeys; ++i) {
                try {
                    long timeStart = System.currentTimeMillis();
                    is1.indexInfo(key, i);
                    Util.memset(recNew, (byte)0, info.di_recsize64);
                    Util.memset(recOld, (byte)0, info.di_recsize64);
                    long nrec = 0L;
                    long urec = 0L;
                    System.out.print("Checking index " + i + " phase1 ...");
                    if (srec > 0L) {
                        is1.start(key, 0, recNew, 0);
                        while (true) {
                            try {
                                is1.read(recNew, 2);
                            }
                            catch (IsamException _ex2) {
                                if (_ex2.getIserrno() == 110) break;
                                JCheck.exit(9, "Error on read next: " + _ex2);
                            }
                            if (++nrec > info.di_nrecords64) {
                                JCheck.exit(16, "Corrupted tree: found " + nrec + " record(s)");
                            }
                            if (!JCheck.notEqual(recNew, recOld, key)) continue;
                            ++urec;
                            Util.memcpy(recOld, 0, recNew, 0, info.di_recsize64);
                            try {
                                is2.read(recNew, 5);
                            }
                            catch (IsamException _ex3) {
                                JCheck.exit(9, "Error on read equal: " + _ex3);
                            }
                            if (Util.memcmp(recNew, 0, recOld, 0, info.di_recsize64) == 0) continue;
                            JCheck.exit(6, "Corrupted tree, recnum=" + is1.getRecNum());
                        }
                    }
                    if (nrec != srec) {
                        JCheck.exit(18, " Invalid record(s) count idx: expected " + srec + " found " + nrec);
                        continue;
                    }
                    System.out.println(" Ok (time=" + (System.currentTimeMillis() - timeStart) + " ms, " + urec + " unique key(s))");
                    continue;
                }
                catch (IsamException _ex4) {
                    JCheck.exit(11, "Error : " + _ex4);
                }
            }
            System.out.print("Checking del.rec.chain  ...");
            try {
                drec = is1.checkDeleteRecords();
            }
            catch (IsamException _ex5) {
                JCheck.exit(20, "Error " + _ex5);
            }
            System.out.println(" Ok (" + drec + " record(s))");
            if (srec != info.di_nrecords64) {
                JCheck.exit(21, "Tree inconsistency: rec=" + srec + "!= totrec=" + info.di_nrecords64);
            }
            System.out.print("Checking del.node.chain ...");
            try {
                xrec = is1.checkDeleteNodes();
            }
            catch (IsamException _ex6) {
                JCheck.exit(20, "Error " + _ex6);
            }
            System.out.println(" Ok (" + xrec + " node(s))");
            try {
                dlen = is1.getDataLength();
            }
            catch (IsamException _ex7) {
                JCheck.exit(20, "Error " + _ex7);
            }
            System.out.print("Checking datafile length...");
            long elen = (srec + drec) * (long)(info.di_recsize64 + 1);
            if (dlen != elen) {
                JCheck.exit(22, "Data file inconsistency: expected=" + elen + ", actual=" + dlen);
            }
            System.out.println(" Ok (" + dlen + ")");
            return;
        }
    }

    public static void rebuild(Isam is1) {
        JCheck.rebuild(is1, false, false);
    }

    public static void rebuild(Isam is1, boolean dontAskConfirm, boolean force) {
        int c = 0;
        if (dontAskConfirm) {
            c = 121;
        } else {
            System.out.println("WARNING!! This operation will delete and rebuild the index");
            System.out.println("Do you want to continue? (y/n)");
            try {
                c = System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (c == 121 || c == 89) {
            try {
                System.out.print("rebuilding ... ");
                if (force) {
                    is1.rebuild(force, System.out);
                } else {
                    is1.rebuild();
                }
                System.out.println("Ok");
            }
            catch (IsamException _ex) {
                JCheck.exit(9, "Error in rebuilding: " + _ex);
            }
        }
    }

    static boolean notEqual(byte[] rec1, byte[] rec2, KeyDesc key) {
        if (key.k_nparts > 0) {
            for (int i = 0; i < key.k_nparts; ++i) {
                if (Util.memcmp(rec1, key.k_part[i].kp_start, rec2, key.k_part[i].kp_start, key.k_part[i].kp_leng) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static class ExitException
    extends RuntimeException {
        public final int code;
        public final String msg;

        public ExitException(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }
    }
}

