/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo;
import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamConst;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.NodeItemDesc;
import IT.picosoft.isam.OSFile;
import IT.picosoft.isam.RecordLock;
import IT.picosoft.isam.SharedFile;
import IT.picosoft.isam.TreeManager;
import IT.picosoft.isam.Util;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class Isam
implements IsamConst {
    public static final String revision = "r2.42 ($Revision: 25561 $)";
    public static final short NULLSHORT = Short.MIN_VALUE;
    public static final int NULLLONG = Integer.MIN_VALUE;
    private static final int MASK_LOCK = 3840;
    private static final int MASK_OPEN = 3;
    private static final long MAXRECNUM = Long.MAX_VALUE;
    private static final short MAXNODESIZE = 1024;
    private static final short HEADERSIZE = 1024;
    private static String DEFAULT_INDEX_EXT = ".idx";
    private static String DEFAULT_DATA_EXT = ".dat";
    public static boolean LOCK_READ_ANYHOW;
    private long recNum;
    private final String indexName;
    private final String dataName;
    private TreeManager tree;
    private OSFile fdData;
    private int openMode;
    private int osMode;
    private byte[] irecord;
    private short currIndex;
    private NodeItemDesc curr;
    private boolean fileLock;
    private long lastRecordLock;
    private SharedFile dataShFile;
    private SharedFile indxShFile;
    boolean inWriteFlag;
    private boolean isOpen = false;
    private static Vector sharedFiles;
    private boolean strictLock;
    final String encrPasswd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setFileNameExtension(String dat, String idx) {
        Class<Isam> clazz = Isam.class;
        synchronized (Isam.class) {
            if (dat == null) {
                dat = DEFAULT_DATA_EXT;
            }
            if (idx == null) {
                idx = DEFAULT_INDEX_EXT;
            }
            if (dat.equals(idx)) {
                throw new IllegalArgumentException("Extensions data=" + dat + ",index=" + idx + " invalid");
            }
            DEFAULT_DATA_EXT = dat;
            DEFAULT_INDEX_EXT = idx;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Isam(String name, String passwd) throws IsamException {
        this.encrPasswd = passwd;
        Isam.checkFileName(name);
        Class<Isam> clazz = Isam.class;
        synchronized (Isam.class) {
            this.indexName = name + DEFAULT_INDEX_EXT;
            this.dataName = name + DEFAULT_DATA_EXT;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.fileLock = false;
            this.lastRecordLock = 0L;
            this.currIndex = 0;
            return;
        }
    }

    public Isam(String name, int mode, boolean sLock) throws IsamException {
        this(name, mode, sLock, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Isam(String name, int mode, boolean sLock, String passwd) throws IsamException {
        this(name, passwd);
        this.checkMode(mode);
        this.openMode = mode;
        this.strictLock = sLock;
        try {
            this.dataShFile = Isam.sharedOpen(this.dataName, this.osMode, 438, this.encrPasswd);
            this.fdData = this.dataShFile.fd;
            this.indxShFile = Isam.sharedOpen(this.indexName, this.osMode, 438, this.encrPasswd);
            String string = this.indxShFile.canonicalPath;
            synchronized (string) {
                boolean exlck = (mode & 0xF00) == 2048;
                this.tree = TreeManager.get(this.indxShFile.fd, exlck, 0, this);
                if (exlck) {
                    this.fileExLock();
                } else {
                    this.testFileLock();
                }
                this.tree.init();
                this.irecord = new byte[this.tree.getRecSize() + 1];
                this.curr = new NodeItemDesc(this.tree.getIndexSize());
                this.isOpen = true;
            }
        }
        catch (IsamException ex) {
            this.finalize();
            throw ex;
        }
    }

    public static Isam build(String filename, short recordlength, KeyDesc keyd, int mode) throws IsamException {
        return Isam.buildNodeSize(filename, recordlength, keyd, mode, null, (short)1024, (short)1024, 0);
    }

    public static Isam build(String filename, int recordlength, KeyDesc keyd, int mode) throws IsamException {
        return Isam.buildNodeSize(filename, recordlength, keyd, mode, null, (short)1024, (short)1024, 0);
    }

    public static Isam build(String filename, int recordlength, KeyDesc keyd, int mode, byte[] colSeq) throws IsamException {
        return Isam.buildNodeSize(filename, recordlength, keyd, mode, colSeq, (short)1024, (short)1024, 0);
    }

    public static Isam build(String filename, int recordlength, KeyDesc keyd, int mode, byte[] colSeq, String encrKey) throws IsamException {
        return Isam.buildNodeSize(filename, recordlength, keyd, mode, colSeq, encrKey, (short)1024, (short)1024, 0);
    }

    public static Isam buildNodeSize(String name, short reclength, KeyDesc keyd, int mode, short headersize, short nodesize) throws IsamException {
        return Isam.buildNodeSize(name, reclength, keyd, mode, null, headersize, nodesize, 0);
    }

    public static Isam buildNodeSize(String name, int reclength, KeyDesc keyd, int mode, short headersize, short nodesize, int rel) throws IsamException {
        return Isam.buildNodeSize(name, reclength, keyd, mode, null, headersize, nodesize, rel);
    }

    public static Isam buildNodeSize(String name, int reclength, KeyDesc keyd, int mode, byte[] colSeq, short headersize, short nodesize, int rel) throws IsamException {
        return Isam.buildNodeSize(name, reclength, keyd, mode, colSeq, null, headersize, nodesize, rel);
    }

    public static Isam buildNodeSize(String name, int reclength, KeyDesc keyd, int mode, byte[] colSeq, String encrPasswd, short headersize, short nodesize, int rel) throws IsamException {
        Isam Return2 = new Isam(name, encrPasswd);
        Return2.checkMode(mode);
        keyd.check();
        if (headersize == 0) {
            headersize = (short)1024;
        }
        if (nodesize == 0) {
            nodesize = (short)1024;
        }
        try {
            Return2.dataShFile = Isam.sharedOpen(Return2.dataName, Return2.osMode | 0x40 | 0x80, 438, encrPasswd);
            Return2.fdData = Return2.dataShFile.fd;
            Return2.indxShFile = Isam.sharedOpen(Return2.indexName, Return2.osMode | 0x40 | 0x80, 438, encrPasswd);
            Return2.openMode = mode;
            Return2.fileLock = (mode & 0xF00) == 2048;
            Return2.tree = TreeManager.get(Return2.indxShFile.fd, Return2.fileLock, rel, Return2);
            Return2.tree.newIndex(reclength, keyd, headersize, nodesize, colSeq);
            Return2.irecord = new byte[reclength + 1];
            Return2.curr = new NodeItemDesc(Return2.tree.getIndexSize());
            if (Return2.fileLock) {
                Return2.fileExLock();
            } else {
                Return2.testFileLock();
            }
            Return2.isOpen = true;
            return Return2;
        }
        catch (IsamException ex) {
            Return2.finalize();
            throw ex;
        }
    }

    public int getRecNum() {
        return (int)this.recNum;
    }

    public long getLRecNum() {
        return this.recNum;
    }

    public void setRecNum(int n) {
        this.recNum = n;
    }

    public short getIndexSize() {
        return this.tree.getIndexSize();
    }

    public int getRecSize() {
        return this.tree.getRecSize();
    }

    public static Isam open(String name, int mode) throws IsamException {
        return new Isam(name, mode, false);
    }

    public static Isam open(String name, int mode, String encPw) throws IsamException {
        return new Isam(name, mode, false, encPw);
    }

    public static Isam open(String name, int mode, boolean sLock) throws IsamException {
        return new Isam(name, mode, sLock, null);
    }

    public static Isam open(String name, int mode, boolean sLock, String encPw) throws IsamException {
        return new Isam(name, mode, sLock, encPw);
    }

    public void lock() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 0xF00) != 1024) {
            throw new IsamException(125);
        }
        this.fileLock();
    }

    public void unlock() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 0xF00) != 1024) {
            throw new IsamException(125);
        }
        this.fileUnlock();
    }

    public void release() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        this.allRecordUnlock();
    }

    public void close() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        this.tree.cacheClear();
        this.tree.headerUnlock();
        Isam.sharedClose(this.tree.getFd(), this);
        this.tree.finalize();
        if (this.fdData != null) {
            Isam.sharedClose(this.fdData, this);
        }
        this.dataShFile = null;
        this.indxShFile = null;
        this.fdData = null;
        this.tree = null;
        this.isOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexInfo(DictInfo dict) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            this.tree.indexInfo(dict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexInfo(KeyDesc key, int num) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            this.tree.indexInfo(key, num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeletedRecords() throws IsamException {
        long Return2 = 0L;
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(false);
                Return2 = this.tree.getDelRecNum();
            }
            finally {
                this.tree.headerUnlock();
            }
        }
        return Return2;
    }

    public byte[] getCollatingSequence() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        return this.tree.getCollatingSequence();
    }

    public void start(KeyDesc key, int length, byte[] record, int mode) throws IsamException {
        this.start(key, length, record, 0, mode);
    }

    public void start(KeyDesc key, int kLen, byte[] record, int offs, int mode) throws IsamException {
        if (key == null || key.k_nparts == 0) {
            this.start((short)-1, kLen, record, offs, mode);
        } else {
            this.start(this.tree.getKeyNum(key), kLen, record, offs, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start(short kNum, int kLen, byte[] record, int offs, int mode) throws IsamException {
        int flagCan = 0;
        mode &= 0xFF;
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 1) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        // MONITORENTER : string
        try {
            this.tree.readHeader(false);
            this.recNum = 0L;
            this.currIndex = kNum;
            if (this.currIndex == -1) {
                switch (mode) {
                    case 0: {
                        this.curr.numRec = 1L;
                        this.curr.positioned = true;
                        while (flagCan == 0 && this.curr.numRec <= this.tree.getNRecords()) {
                            flagCan = this.checkDeleted(this.curr.numRec);
                            if (flagCan != 0) continue;
                            ++this.curr.numRec;
                        }
                        if (flagCan != 10) {
                            this.curr.numRec = Long.MAX_VALUE;
                            throw new IsamException(110);
                        }
                        this.recNum = this.curr.numRec;
                        return;
                    }
                    case 1: {
                        this.curr.numRec = this.tree.getNRecords();
                        this.curr.positioned = true;
                        while (flagCan == 0 && this.curr.numRec > 0L) {
                            flagCan = this.checkDeleted(this.curr.numRec);
                            if (flagCan != 0) continue;
                            --this.curr.numRec;
                        }
                        if (flagCan != 10) {
                            this.curr.numRec = 0L;
                            throw new IsamException(110);
                        }
                        this.recNum = this.curr.numRec;
                        return;
                    }
                    case 5: {
                        if (this.recNum <= 0L) throw new IsamException(111);
                        if (this.recNum > this.tree.getNRecords()) throw new IsamException(111);
                        flagCan = this.checkDeleted(this.recNum);
                        if (flagCan != 10) {
                            throw new IsamException(111);
                        }
                        this.curr.numRec = this.recNum;
                        this.curr.positioned = true;
                        return;
                    }
                }
                throw new IsamException(102);
            }
            short k_len = this.tree.getKeyLen(this.currIndex);
            byte[] keySup = new byte[k_len];
            if (mode == 0) {
                Util.memset(keySup, (byte)0, k_len);
                kLen = k_len;
            } else if (mode == 1) {
                Util.memset(keySup, (byte)-1, k_len);
                kLen = k_len;
            } else {
                this.tree.buildKey(this.currIndex, record, offs, keySup);
                if (kLen <= 0 || kLen > k_len) {
                    kLen = k_len;
                }
            }
            NodeItemDesc found = this.tree.findKey(keySup, this.currIndex, kLen, mode);
            if (found != null) {
                this.curr.assign(found);
                this.curr.positioned = true;
                this.recNum = found.numRec;
                return;
            }
            this.curr.numRec = Long.MAX_VALUE;
            throw new IsamException(111);
        }
        finally {
            this.tree.headerUnlock();
        }
    }

    public void read(byte[] record, int mode) throws IsamException {
        this.read(record, 0, mode);
    }

    public void read(byte[] record, int offs, int mode) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 1) {
            throw new IsamException(125);
        }
        if ((mode & 0x1000) == 4096) {
            int lastErr;
            do {
                try {
                    this.pIread(record, offs, mode);
                    lastErr = 0;
                }
                catch (IsamException ex) {
                    lastErr = ex.getIserrno();
                    if (lastErr != 107) {
                        throw ex;
                    }
                    this.recordLock(this.recNum, true, true);
                    this.recordUnlock(this.recNum);
                }
            } while (lastErr == 107);
        } else {
            this.pIread(record, offs, mode);
        }
    }

    public void write(byte[] record) throws IsamException {
        this.write(record, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] record, int offs) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                byte[][] keySup = this.tree.buildAllKeys(record, offs, 0L);
                long numrec = this.tree.getNewRecNum();
                try {
                    this.tree.insertKeys(keySup, numrec);
                }
                catch (IsamException ex) {
                    this.tree.resetGetNewRecNum(numrec);
                    this.recordUnlock(numrec);
                    throw ex;
                }
                int recSize = this.tree.getRecSize();
                this.fdData.seek((numrec - 1L) * (long)(recSize + 1));
                if (recSize > record.length) {
                    System.arraycopy(record, 0, this.irecord, 0, record.length);
                    Arrays.fill(this.irecord, record.length, this.irecord.length, (byte)0);
                    this.writeData(this.irecord, offs);
                } else {
                    this.writeData(record, offs);
                }
                this.recNum = numrec;
                this.recordUnlock(numrec);
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    public void wrcurr(byte[] lrecord) throws IsamException {
        this.write(lrecord);
        this.currIndex = (short)-1;
        this.curr.numRec = this.recNum;
    }

    public void delrec(int nrec) throws IsamException {
        this.delrec((long)nrec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delrec(long nrec) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                if (nrec == 0L || nrec > this.tree.getNRecords()) {
                    throw new IsamException(102);
                }
                this.recNum = nrec;
                this.delByNumrec();
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delcurr() throws IsamException {
        NodeItemDesc found = new NodeItemDesc(this.tree.getIndexSize());
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                if (this.curr.numRec == 0L || this.curr.numRec > this.tree.getNRecords()) {
                    throw new IsamException(112);
                }
                this.recNum = this.curr.numRec;
                this.delByNumrec();
                this.curr.numRec = 0L;
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] erecord, int offs) throws IsamException {
        NodeItemDesc found = new NodeItemDesc(this.tree.getIndexSize());
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            block9: {
                try {
                    this.tree.readHeader(true);
                    byte[] keySup = new byte[255];
                    this.tree.buildKey((short)0, erecord, offs, keySup);
                    found = this.tree.findKey(keySup, (short)0, 0, 5);
                    if (found != null) {
                        this.recNum = found.numRec;
                        this.delByNumrec();
                        break block9;
                    }
                    throw new IsamException(111);
                }
                finally {
                    this.tree.headerUnlock();
                }
            }
        }
    }

    public void rewrec(int numRec, byte[] newRec, int offs) throws IsamException {
        this.rewrec((long)numRec, newRec, offs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewrec(long numRec, byte[] newRec, int offs) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        if (numRec <= 0L) {
            throw new IsamException(102);
        }
        if (numRec > this.tree.getNRecords()) {
            throw new IsamException(110);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                byte[][] keySup = this.tree.buildAllKeys(newRec, offs, numRec);
                this.recNum = numRec;
                boolean lckAdded = false;
                try {
                    lckAdded = this.recordLock(this.recNum, false, false);
                    this.fdData.seek((numRec - 1L) * (long)(this.tree.getRecSize() + 1));
                    byte flagcan = this.readData(this.irecord);
                    if (flagcan == 0) {
                        throw new IsamException(111);
                    }
                    if (flagcan != 10) {
                        throw new IsamException(105);
                    }
                    this.tree.rewriteAllKeys(this.irecord, newRec, offs, this.recNum, keySup);
                    int recSize = this.tree.getRecSize();
                    this.fdData.seek((numRec - 1L) * (long)(recSize + 1));
                    if (recSize > newRec.length) {
                        System.arraycopy(newRec, 0, this.irecord, 0, newRec.length);
                        Arrays.fill(this.irecord, newRec.length, this.irecord.length, (byte)0);
                        this.fdData.writeBlk(this.irecord, offs, recSize);
                    } else {
                        this.fdData.writeBlk(newRec, offs, recSize);
                    }
                }
                finally {
                    if ((this.openMode & 0xF00) != 1024) {
                        this.recordUnlock(this.recNum);
                    } else if (lckAdded) {
                        Isam.recordUnlockIsfd(this, this.recNum, this.dataShFile);
                    }
                }
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewrite(byte[] newRec, int offs) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            block9: {
                try {
                    this.tree.readHeader(true);
                    byte[] keySup = new byte[255];
                    this.tree.buildKey((short)0, newRec, offs, keySup);
                    NodeItemDesc found = this.tree.findKey(keySup, (short)0, 0, 5);
                    if (found != null) {
                        this.rewrec(found.numRec, newRec, offs);
                        break block9;
                    }
                    throw new IsamException(111);
                }
                finally {
                    this.tree.headerUnlock();
                }
            }
        }
    }

    public void rewcurr(byte[] newRec, int offs) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if (this.curr.numRec == 0L || this.curr.numRec > this.tree.getNRecords()) {
            throw new IsamException(112);
        }
        this.rewrec(this.curr.numRec, newRec, offs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addindex(KeyDesc keydesc) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                this.tree.addIndex(keydesc, this.fdData);
                this.tree.writeHeader(false);
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delindex(KeyDesc keydesc) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.tree.readHeader(true);
                short j = this.tree.getKeyNum(keydesc);
                if (j == 0) {
                    throw new IsamException(109);
                }
                this.tree.delTree(j);
                this.tree.writeHeader(false);
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void erase(String name) throws IsamException {
        IsamException Return2 = null;
        Class<Isam> clazz = Isam.class;
        synchronized (Isam.class) {
            try {
                OSFile.unlink(name + DEFAULT_INDEX_EXT);
            }
            catch (IsamException ex) {
                Return2 = ex;
            }
            try {
                OSFile.unlink(name + DEFAULT_DATA_EXT);
            }
            catch (IsamException ex) {
                Return2 = ex;
            }
            if (Return2 != null) {
                throw Return2;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(String src, String dst) throws IsamException {
        Class<Isam> clazz = Isam.class;
        synchronized (Isam.class) {
            OSFile.rename(src + DEFAULT_INDEX_EXT, dst + DEFAULT_INDEX_EXT);
            OSFile.rename(src + DEFAULT_DATA_EXT, dst + DEFAULT_DATA_EXT);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static String getTemporaryFile(String fn) throws IsamException {
        String Return2;
        int i = 1;
        try {
            File tmp;
            while (!(tmp = new File(Return2 = fn + i++)).createNewFile()) {
            }
        }
        catch (IOException _ex) {
            throw new IsamException(_ex);
        }
        return Return2;
    }

    public static String version() {
        return "JIsam; 2; r2.42 ($Revision: 25561 $)";
    }

    public int getVersion() {
        return this.tree.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkDeleteRecords() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            return this.tree.checkDeleteRecords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkDeleteNodes() throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            return this.tree.checkDeleteNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(boolean delDups, PrintStream log) throws IsamException {
        if (!this.isOpen) {
            throw new IsamException(101);
        }
        if ((this.openMode & 3) == 0) {
            throw new IsamException(125);
        }
        if ((this.openMode & 0xF00) != 2048) {
            throw new IsamException(106);
        }
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.indxShFile.fd = this.tree.rebuild(this.fdData, this.indexName, delDups, log);
            }
            finally {
                this.tree.headerUnlock();
            }
        }
    }

    public void rebuild() throws IsamException {
        this.rebuild(false, null);
    }

    public long getDataLength() throws IsamException {
        return this.fdData.length();
    }

    public synchronized void finalize() {
        try {
            this.tree.headerUnlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.indxShFile != null && this.indxShFile.fd != null) {
            try {
                Isam.sharedClose(this.indxShFile.fd, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fdData != null) {
            try {
                Isam.sharedClose(this.fdData, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataShFile = null;
        this.indxShFile = null;
        this.fdData = null;
        this.tree = null;
    }

    private static synchronized SharedFile sharedOpen(String fileName, int mode, int perm, String encPasswd) throws IsamException {
        SharedFile Return2;
        try {
            fileName = new File(fileName).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration e = sharedFiles.elements();
        while (e.hasMoreElements()) {
            Return2 = (SharedFile)e.nextElement();
            if (Return2 == null || !fileName.equals(Return2.canonicalPath)) continue;
            fileName = Return2.canonicalPath;
            if (Return2.mode != 2 && Return2.mode != mode) continue;
            ++Return2.cnt;
            return Return2;
        }
        Return2 = new SharedFile(fileName);
        Return2.fd = OSFile.get(encPasswd);
        if (encPasswd != null && encPasswd.length() > 0) {
            Return2.fd.setEncrypt();
        }
        int xattr = mode & 0xFFFFFFFC;
        mode &= 3;
        try {
            Return2.fd.open(fileName, 2 | xattr);
            Return2.mode = 2;
        }
        catch (IsamException ex) {
            if (mode != 2 && ex.getIserrno() == 131) {
                Return2.fd.open(fileName, mode | xattr);
                Return2.mode = mode;
            }
            throw ex;
        }
        Return2.cnt = 1;
        Return2.lckChain = null;
        sharedFiles.addElement(Return2);
        return Return2;
    }

    static synchronized void sharedClose(OSFile fd, Isam isfd) throws IsamException {
        Enumeration e = sharedFiles.elements();
        while (e.hasMoreElements()) {
            SharedFile shFile = (SharedFile)e.nextElement();
            if (shFile == null || shFile.fd != fd) continue;
            if (!isfd.fileLock) {
                RecordLock rl = shFile.lckChain;
                while (rl != null) {
                    if (rl.isfd == isfd) {
                        long curRec = rl.numRec;
                        Isam.recordUnlockIsfd(isfd, curRec, shFile);
                    }
                    rl = rl.next;
                }
            }
            if (--shFile.cnt != 0) break;
            fd.close();
            sharedFiles.remove(shFile);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delByNumrec() throws IsamException {
        String string = this.indxShFile.canonicalPath;
        synchronized (string) {
            try {
                this.fdData.seek((this.recNum - 1L) * (long)(this.tree.getRecSize() + 1));
                byte flagcan = this.readData(this.irecord);
                if (flagcan == 0) {
                    throw new IsamException(111);
                }
                if (flagcan != 10) {
                    throw new IsamException(105);
                }
                this.tree.deleteKeys(this.irecord, 0, this.recNum);
                this.deleteData(this.recNum);
            }
            finally {
                this.recordUnlock(this.recNum);
            }
        }
    }

    private void deleteData(long numrec) throws IsamException {
        byte[] can = new byte[]{0};
        this.fdData.seek(this.recNum * (long)(this.tree.getRecSize() + 1) - 1L);
        this.fdData.write(can, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void pIread(byte[] erecord, int offs, int mode) throws IsamException {
        flagcan = 0;
        this.recNum = 0L;
        var6_5 = this.indxShFile.canonicalPath;
        synchronized (var6_5) {
            block88: {
                try {
                    this.tree.readHeader(false);
                    if (this.currIndex == -1 || this.tree.getKeyParts(this.currIndex) == 0) {
                        this.currIndex = (short)-1;
                        switch (mode & 255) {
                            case 4: {
                                if (this.curr.numRec == 0L || this.curr.numRec > this.tree.getNRecords()) {
                                    throw new IsamException(112);
                                }
                                flagcan = this.lockAndReadData(mode, this.curr.numRec, erecord, offs);
                                if (flagcan == 10) {
                                    this.recNum = this.curr.numRec;
                                    this.curr.positioned = false;
                                    break block88;
                                }
                                this.unlockData(mode, this.curr.numRec);
                                throw new IsamException(112);
                            }
                            case 2: {
                                if (this.curr.numRec > this.tree.getNRecords()) {
                                    this.curr.positioned = false;
                                    throw new IsamException(112);
                                }
                                if (this.curr.numRec <= 0L) {
                                    this.curr.numRec = 1L;
                                    this.curr.positioned = true;
                                } else if (!this.curr.positioned) {
                                    ++this.curr.numRec;
                                }
                                while (flagcan == 0 && this.curr.numRec <= this.tree.getNRecords()) {
                                    flagcan = this.lockAndReadData(mode, this.curr.numRec, erecord, offs);
                                    if (flagcan == 10) {
                                        this.recNum = this.curr.numRec;
                                        this.curr.positioned = false;
                                        continue;
                                    }
                                    if (flagcan != 0) continue;
                                    this.unlockData(mode, this.curr.numRec);
                                    ++this.curr.numRec;
                                }
                                if (flagcan != 10) {
                                    this.curr.numRec = 0x7FFFFFFFFFFFFFFFL;
                                    this.curr.positioned = true;
                                    throw new IsamException(110);
                                }
                                break block88;
                            }
                            case 3: {
                                if (this.curr.numRec > this.tree.getNRecords()) {
                                    if (this.curr.positioned) {
                                        this.curr.numRec = this.tree.getNRecords();
                                    } else {
                                        throw new IsamException(112);
                                    }
                                }
                                if (!this.curr.positioned) {
                                    --this.curr.numRec;
                                    this.curr.positioned = true;
                                }
                                if (this.curr.numRec <= 0L) {
                                    if (this.curr.positioned) {
                                        this.curr.positioned = false;
                                        throw new IsamException(110);
                                    }
                                    throw new IsamException(112);
                                }
                                while (flagcan == 0 && this.curr.numRec > 0L) {
                                    flagcan = this.lockAndReadData(mode, this.curr.numRec, erecord, offs);
                                    if (flagcan == 10) {
                                        this.recNum = this.curr.numRec;
                                        continue;
                                    }
                                    if (flagcan != 0) continue;
                                    this.unlockData(mode, this.curr.numRec);
                                    --this.curr.numRec;
                                }
                                if (flagcan != 10) {
                                    this.curr.numRec = 0L;
                                    this.curr.positioned = true;
                                    throw new IsamException(110);
                                }
                                break block88;
                            }
                            case 0: {
                                this.curr.numRec = 1L;
                                while (flagcan == 0 && this.curr.numRec <= this.tree.getNRecords()) {
                                    flagcan = this.lockAndReadData(mode, this.curr.numRec, erecord, offs);
                                    if (flagcan != 0) continue;
                                    this.unlockData(mode, this.curr.numRec);
                                    ++this.curr.numRec;
                                }
                                if (flagcan != 10) {
                                    this.curr.positioned = false;
                                    throw new IsamException(110);
                                }
                                this.curr.positioned = false;
                                this.recNum = this.curr.numRec;
                                break block88;
                            }
                            case 1: {
                                this.curr.numRec = this.tree.getNRecords();
                                while (flagcan == 0 && this.curr.numRec > 0L) {
                                    flagcan = this.lockAndReadData(mode, this.curr.numRec, erecord, offs);
                                    if (flagcan != 0) continue;
                                    this.unlockData(mode, this.curr.numRec);
                                    --this.curr.numRec;
                                }
                                if (flagcan != 10) {
                                    this.curr.positioned = false;
                                    throw new IsamException(110);
                                }
                                this.curr.positioned = false;
                                this.recNum = this.curr.numRec;
                                break block88;
                            }
                            default: {
                                throw new IsamException(102);
                            }
                        }
                    }
                    switch (mode & 255) {
                        case 4: {
                            if (this.curr.numRec != 0L) ** GOTO lbl113
                            if (this.curr.positioned) {
                                this.start(this.currIndex, 0, erecord, offs, 0);
                                this.pIread(erecord, offs, mode);
                                ** break;
lbl111:
                                // 1 sources

                            } else {
                                throw new IsamException(112);
lbl113:
                                // 1 sources

                                if (this.curr.numRec > this.tree.getNRecords()) {
                                    this.curr.positioned = false;
                                    throw new IsamException(112);
                                }
                                if (this.tree.unchangedNode(this.currIndex, this.curr)) {
                                    flagcan = this.lockAndReadData(mode, this.curr.numRec, erecord, offs);
                                    if (flagcan != 10) {
                                        this.curr.positioned = false;
                                        throw new IsamException(112);
                                    }
                                } else {
                                    found = this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 7);
                                    if (found != null) {
                                        found = this.tree.next(this.currIndex, this.curr.keyVal, found.keyPos - 1, found.nodeAddr, this.curr.keyProg, true);
                                    }
                                    if (found != null) {
                                        flagcan = this.lockAndReadData(mode, found.numRec, erecord, offs);
                                        if (flagcan != 10) {
                                            this.curr.positioned = false;
                                            throw new IsamException(112);
                                        }
                                        this.curr.assign(found);
                                    } else {
                                        this.curr.positioned = false;
                                        throw new IsamException(112);
                                    }
                                }
                                this.recNum = this.curr.numRec;
                                ** break;
                            }
lbl136:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            if (this.curr.numRec > this.tree.getNRecords()) {
                                this.curr.positioned = false;
                                throw new IsamException(112);
                            }
                            if (this.curr.numRec <= 0L) {
                                try {
                                    this.start(this.currIndex, 0, erecord, offs, 0);
                                }
                                catch (IsamException ex) {
                                    if (ex.getIserrno() == 111) {
                                        throw new IsamException(110);
                                    }
                                    throw ex;
                                }
                                this.pIread(erecord, offs, mode);
                                ** break;
lbl151:
                                // 1 sources

                                break;
                            }
                            if (this.curr.positioned) {
                                if (this.tree.unchangedNode(this.currIndex, this.curr)) {
                                    found = this.curr;
                                } else {
                                    found = this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 7);
                                    if (found != null) {
                                        found = this.tree.next(this.currIndex, this.curr.keyVal, found.keyPos - 1, found.nodeAddr, this.curr.keyProg, true);
                                    }
                                }
                            } else {
                                found = this.tree.unchangedNode(this.currIndex, this.curr) != false ? this.curr : this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 7);
                                if (found != null) {
                                    found = this.tree.next(this.currIndex, this.curr.keyVal, found.keyPos - 1, found.nodeAddr, this.curr.keyProg, false);
                                }
                            }
                            if (found != null) {
                                flagcan = this.lockAndReadData(mode, found.numRec, erecord, offs);
                                if (flagcan != 10) {
                                    throw new IsamException(105);
                                }
                            } else {
                                this.curr.numRec = 0x7FFFFFFFFFFFFFFFL;
                                this.curr.positioned = true;
                                throw new IsamException(110);
                            }
                            this.curr.assign(found);
                            this.curr.positioned = false;
                            this.recNum = this.curr.numRec;
                            ** break;
lbl175:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            if (this.curr.numRec <= 0L) {
                                if (this.curr.positioned) {
                                    this.curr.positioned = false;
                                    throw new IsamException(110);
                                }
                                throw new IsamException(112);
                            }
                            if (this.curr.numRec > this.tree.getNRecords()) {
                                if (this.curr.positioned) {
                                    try {
                                        this.start(this.currIndex, 0, erecord, offs, 1);
                                    }
                                    catch (IsamException ex) {
                                        if (ex.getIserrno() == 111) {
                                            throw new IsamException(110);
                                        }
                                        throw ex;
                                    }
                                    this.pIread(erecord, offs, mode);
                                    ** break;
lbl193:
                                    // 1 sources

                                    break;
                                }
                                throw new IsamException(112);
                            }
                            if (this.curr.positioned) {
                                if (this.tree.unchangedNode(this.currIndex, this.curr)) {
                                    found = this.curr;
                                } else {
                                    found = this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 9);
                                    if (found != null) {
                                        found = this.tree.prev(this.currIndex, this.curr.keyVal, found.keyPos + 1, found.nodeAddr, this.curr.keyProg, true);
                                    }
                                }
                            } else {
                                found = this.tree.unchangedNode(this.currIndex, this.curr) != false ? this.curr : this.tree.findKey(this.curr.keyVal, this.currIndex, 0, 9);
                                if (found != null) {
                                    found = this.tree.prev(this.currIndex, this.curr.keyVal, found.keyPos + 1, found.nodeAddr, this.curr.keyProg, false);
                                }
                            }
                            if (found != null) {
                                flagcan = this.lockAndReadData(mode, found.numRec, erecord, offs);
                                if (flagcan != 10) {
                                    throw new IsamException(105);
                                }
                            } else {
                                this.curr.numRec = 0L;
                                this.curr.positioned = false;
                                throw new IsamException(110);
                            }
                            this.curr.assign(found);
                            this.curr.positioned = false;
                            this.recNum = this.curr.numRec;
                            ** break;
lbl218:
                            // 1 sources

                            break;
                        }
                        case 0: {
                            this.start(this.currIndex, 0, erecord, offs, 0);
                            this.read(erecord, offs, 2 | mode & 3840);
                            ** break;
lbl223:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            this.start(this.currIndex, 0, erecord, offs, 1);
                            this.read(erecord, offs, 3 | mode & 3840);
                            ** break;
lbl228:
                            // 1 sources

                            break;
                        }
                        case 5: {
                            this.start(this.currIndex, 0, erecord, offs, 5);
                            this.read(erecord, offs, 2 | mode & 3840);
                            ** break;
lbl233:
                            // 1 sources

                            break;
                        }
                        case 6: {
                            this.start(this.currIndex, 0, erecord, offs, 6);
                            this.read(erecord, offs, 2 | mode & 3840);
                            ** break;
lbl238:
                            // 1 sources

                            break;
                        }
                        case 7: {
                            this.start(this.currIndex, 0, erecord, offs, 7);
                            this.read(erecord, offs, 2 | mode & 3840);
                            ** break;
lbl243:
                            // 1 sources

                            break;
                        }
                        case 8: {
                            this.start(this.currIndex, 0, erecord, offs, 8);
                            this.read(erecord, offs, 3 | mode & 3840);
                            ** break;
lbl248:
                            // 1 sources

                            break;
                        }
                        case 9: {
                            this.start(this.currIndex, 0, erecord, offs, 9);
                            this.read(erecord, offs, 3 | mode & 3840);
                            ** break;
lbl253:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new IsamException(102);
                        }
                    }
                }
                finally {
                    this.tree.headerUnlock();
                }
            }
        }
    }

    private byte readData(byte[] rec) throws IsamException {
        int rs = this.tree.getRecSize();
        this.fdData.readBlk(rec, 0, rs);
        try {
            this.fdData.read(rec, rs, 1);
        }
        catch (IsamException ex) {
            rec[rs] = 10;
        }
        return rec[rs];
    }

    private byte _readData(byte[] rec, int offs) throws IsamException {
        int rs = this.tree.getRecSize();
        this.fdData.readBlk(this.irecord, 0, rs);
        try {
            this.fdData.read(this.irecord, rs, 1);
        }
        catch (IsamException ex) {
            this.irecord[rs] = 10;
        }
        if (this.irecord[rs] == 10) {
            Util.memcpy(rec, offs, this.irecord, 0, rs);
        }
        return this.irecord[rs];
    }

    private byte checkDeleted(long numRec) throws IsamException {
        byte[] Return2 = new byte[]{0};
        this.fdData.seek((numRec - 1L) * (long)(this.tree.getRecSize() + 1) + (long)this.tree.getRecSize());
        try {
            this.fdData.read(Return2, 0, 1);
        }
        catch (IsamException ex) {
            Return2[0] = 10;
        }
        return Return2[0];
    }

    private void writeData(byte[] s, int offs) throws IsamException {
        byte[] flagCan = new byte[]{10};
        this.fdData.writeBlk(s, offs, this.tree.getRecSize());
        this.fdData.write(flagCan, 0, 1);
    }

    private void checkMode(int mode) throws IsamException {
        switch (mode & 3) {
            case 0: {
                this.osMode = 0;
                break;
            }
            case 1: {
                this.osMode = 1;
                break;
            }
            case 2: {
                this.osMode = 2;
                break;
            }
            default: {
                throw new IsamException(102);
            }
        }
        switch (mode & 0xF00) {
            case 512: 
            case 1024: {
                break;
            }
            case 2048: {
                this.osMode = 2;
                break;
            }
            default: {
                throw new IsamException(102);
            }
        }
    }

    private static void checkFileName(String name) throws IsamException {
        if (name == null || name.length() == 0) {
            throw new IsamException(102);
        }
    }

    private short lockType() {
        return (short)((this.openMode & 3) != 0 ? 1 : 0);
    }

    private void fileExLock() throws IsamException {
        if (!this.fileLock) {
            if (this.indxShFile.cnt > 0 && this.indxShFile.fileLock != null) {
                throw new IsamException(113);
            }
            FLock lck = new FLock();
            this.tree.fileExLock(lck, this.lockType());
            this.indxShFile.fileLock = lck;
            this.fileLock = true;
        }
    }

    private void testFileLock() throws IsamException {
        if (this.indxShFile.cnt > 0 && this.indxShFile.fileLock != null) {
            if (this.indxShFile.fileLock.l_type != 0) {
                throw new IsamException(113);
            }
        } else {
            FLock lck = new FLock();
            this.tree.testFileLock(lck);
            this.indxShFile.fileLock = lck;
        }
    }

    static void recordUnlockIsfd(Isam isfd, long nrec, SharedFile shfile) throws IsamException {
        boolean locked = false;
        RecordLock irl = shfile.lckChain;
        RecordLock iprl = null;
        RecordLock rl = null;
        RecordLock prl = null;
        while (irl != null) {
            if (irl.numRec == nrec) {
                if (irl.isfd == isfd) {
                    prl = iprl;
                    rl = irl;
                } else {
                    locked = true;
                }
            }
            iprl = irl;
            irl = irl.next;
        }
        if (!locked) {
            FLock lck = new FLock();
            lck.l_whence = 0;
            lck.l_start = nrec * (long)(isfd.tree.getRecSize() + 1) - 1L;
            lck.l_len = 1;
            lck.l_type = (short)2;
            isfd.fdData.fcntl(6, lck);
        }
        if (prl == null) {
            shfile.lckChain = rl.next;
        } else {
            prl.next = rl.next;
        }
    }

    private void fileLock() throws IsamException {
        if (!this.fileLock) {
            FLock lck = new FLock();
            lck.l_whence = 0;
            lck.l_start = 0L;
            lck.l_len = 0;
            lck.l_type = this.lockType();
            this.fdData.fcntl(6, lck);
            this.fileLock = true;
        }
    }

    private void fileUnlock() throws IsamException {
        if (this.fileLock) {
            FLock lck = new FLock();
            lck.l_whence = 0;
            lck.l_start = 0L;
            lck.l_len = 0;
            lck.l_type = (short)2;
            this.fdData.fcntl(6, lck);
            this.fileLock = false;
        }
    }

    private void unlockData(int lmode, long nrec) throws IsamException {
        if ((this.openMode & 0xF00) == 512 || (lmode & 0xF00) == 256) {
            this.recordUnlock(nrec);
        }
    }

    private byte lockAndReadData(int lmode, long nrec, byte[] rec, int offs) throws IsamException {
        byte Return2;
        if (LOCK_READ_ANYHOW || (lmode & 0x2000) == 8192) {
            this.fdData.seek((nrec - 1L) * (long)(this.tree.getRecSize() + 1));
            Return2 = this._readData(rec, offs);
            this._lockData(lmode, nrec);
        } else {
            this._lockData(lmode, nrec);
            this.fdData.seek((nrec - 1L) * (long)(this.tree.getRecSize() + 1));
            Return2 = this._readData(rec, offs);
        }
        return Return2;
    }

    private void _lockData(int lmode, long nrec) throws IsamException {
        if ((this.openMode & 0xF00) == 512 || (lmode & 0xF00) == 256) {
            if ((this.openMode & 0xF00) == 512) {
                this.allRecordUnlock();
            }
            this.recNum = nrec;
            boolean lckAdded = this.recordLock(nrec, false, true);
            if ((lmode & 0x2000) == 8192 && lckAdded) {
                this.recordUnlock(nrec);
            }
        }
    }

    private boolean recordLock(long nrec, boolean isWait, boolean checkMe) throws IsamException {
        boolean Return2 = false;
        if (!this.fileLock) {
            SharedFile shFile = this.dataShFile;
            boolean locked = false;
            boolean addRdLck = false;
            RecordLock rl = shFile.lckChain;
            short lckType = this.lockType();
            while (rl != null) {
                if (rl.numRec == nrec) {
                    if (rl.isfd == this) {
                        locked = true;
                        addRdLck = false;
                        break;
                    }
                    if (rl.readLock && lckType == 0) {
                        locked = true;
                        addRdLck = true;
                    } else {
                        if (checkMe && this.strictLock) {
                            throw new IsamException(107);
                        }
                        locked = true;
                        if (rl.isfd == this) break;
                        if (this.strictLock) {
                            throw new IsamException(107);
                        }
                    }
                }
                rl = rl.next;
            }
            if (!locked) {
                FLock lck = new FLock();
                lck.l_whence = 0;
                lck.l_start = nrec * (long)(this.tree.getRecSize() + 1) - 1L;
                lck.l_len = 1;
                lck.l_type = lckType;
                try {
                    this.fdData.fcntl(isWait ? 7 : 6, lck);
                }
                catch (IsamException ex) {
                    if (ex.getIserrno() == 113) {
                        throw new IsamException(107);
                    }
                    throw ex;
                }
                this.lastRecordLock = nrec;
            }
            if (rl == null || addRdLck) {
                rl = new RecordLock(this, nrec, lckType == 0);
                rl.next = shFile.lckChain;
                shFile.lckChain = rl;
                this.lastRecordLock = nrec;
                Return2 = true;
            }
        }
        return Return2;
    }

    private void recordUnlock(long nrec) throws IsamException {
        if (!this.fileLock) {
            SharedFile shFile = this.dataShFile;
            boolean locked = false;
            RecordLock rl = shFile.lckChain;
            RecordLock prl = null;
            while (rl != null) {
                if (rl.numRec == nrec) {
                    locked = true;
                    RecordLock nrl = rl.next;
                    if (prl == null) {
                        shFile.lckChain = rl.next;
                    } else {
                        prl.next = rl.next;
                    }
                    rl = nrl;
                    continue;
                }
                prl = rl;
                rl = rl.next;
            }
            if (locked) {
                FLock lck = new FLock();
                lck.l_whence = 0;
                lck.l_start = nrec * (long)(this.tree.getRecSize() + 1) - 1L;
                lck.l_len = 1;
                lck.l_type = (short)2;
                this.fdData.fcntl(6, lck);
            }
        }
    }

    private void allRecordUnlock() throws IsamException {
        if (this.lastRecordLock != 0L) {
            SharedFile shFile = this.dataShFile;
            RecordLock rl = shFile.lckChain;
            while (rl != null && rl.isfd == this) {
                this.recordUnlock(rl.numRec);
                rl = shFile.lckChain;
            }
            this.lastRecordLock = 0L;
        }
    }

    NodeItemDesc getCurr() {
        return this.curr;
    }

    OSFile getFd() {
        return this.tree.getFd();
    }

    int getFirstNodeAddr() {
        return this.tree.getFirstNodeAddr();
    }

    static {
        sharedFiles = new Vector();
    }
}

