/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.ByteArrayCmp;

public class ByteArrayCmpCollating
implements ByteArrayCmp {
    private final int[] colSeq;

    public ByteArrayCmpCollating(byte[] cs) {
        if (cs == null || cs.length < 256) {
            throw new IllegalArgumentException(cs == null ? "Collating sequence missing" : "Collating sequence too short");
        }
        this.colSeq = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.colSeq[i] = cs[i] & 0xFF;
        }
    }

    @Override
    public final int memcmp(byte[] a, int sa, byte[] b, int sb, int len) {
        len += sa;
        while (sa < len) {
            int Return2 = this.colSeq[a[sa] & 0xFF] - this.colSeq[b[sb] & 0xFF];
            if (Return2 != 0) {
                return Return2;
            }
            ++sa;
            ++sb;
        }
        return 0;
    }

    @Override
    public byte[] getCollatingSequence() {
        byte[] Return2 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            Return2[i] = (byte)this.colSeq[i];
        }
        return Return2;
    }
}

